/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilKt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtilRt;
import com.intellij.util.io.NettyKt;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.nio.file.Path;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.builtInWebServer.BuiltInWebServerKt;
import org.jetbrains.builtInWebServer.DefaultWebServerPathHandlerKt;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.WebServerFileHandler;
import org.jetbrains.builtInWebServer.WebServerPathHandler;
import org.jetbrains.builtInWebServer.WebServerPathHandlerKt;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;
import org.jetbrains.builtInWebServer.WebServerPathToFileManagerKt;
import org.jetbrains.io.Responses;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J@\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0004H\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/builtInWebServer/DefaultWebServerPathHandler;", "Lorg/jetbrains/builtInWebServer/WebServerPathHandler;", "()V", "process", "", "path", "", "project", "Lcom/intellij/openapi/project/Project;", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "context", "Lio/netty/channel/ChannelHandlerContext;", "projectName", "decodedRawPath", "isCustomHost", "built-in-server"})
final class DefaultWebServerPathHandler
extends WebServerPathHandler {
    @Override
    public boolean process(@NotNull String path, @NotNull Project project2, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context, @NotNull String projectName, @NotNull String decodedRawPath, boolean isCustomHost) {
        Matcher matcher;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)projectName, (String)"projectName");
        Intrinsics.checkParameterIsNotNull((Object)decodedRawPath, (String)"decodedRawPath");
        Channel channel = context.channel();
        boolean isSignedRequest = BuiltInWebServerKt.isSignedRequest((HttpRequest)request);
        HttpRequest httpRequest = (HttpRequest)request;
        Channel channel2 = channel;
        Intrinsics.checkExpressionValueIsNotNull((Object)channel2, (String)"channel");
        HttpHeaders httpHeaders = BuiltInWebServerKt.validateToken(httpRequest, channel2, isSignedRequest);
        if (httpHeaders == null) {
            return true;
        }
        HttpHeaders extraHeaders = httpHeaders;
        WebServerPathToFileManager pathToFileManager = WebServerPathToFileManager.Companion.getInstance(project2);
        PathInfo pathInfo = (PathInfo)pathToFileManager.getPathToInfoCache().getIfPresent((Object)path);
        if (pathInfo == null || !pathInfo.isValid()) {
            pathInfo = pathToFileManager.doFindByRelativePath$built_in_server(path, WebServerPathToFileManagerKt.getDefaultPathQuery());
            if (pathInfo == null) {
                Responses.send$default(HttpResponseStatus.NOT_FOUND, channel, (HttpRequest)request, null, extraHeaders, 4, null);
                return true;
            }
            pathToFileManager.getPathToInfoCache().put((Object)path, (Object)pathInfo);
        }
        boolean indexUsed = false;
        if (pathInfo.isDirectory()) {
            VirtualFile indexVirtualFile = null;
            Path indexFile2 = null;
            if (pathInfo.getFile() == null) {
                Path path2 = pathInfo.getIoFile();
                if (path2 == null) {
                    Intrinsics.throwNpe();
                }
                indexFile2 = BuiltInWebServerKt.findIndexFile(path2);
            } else {
                VirtualFile virtualFile = pathInfo.getFile();
                if (virtualFile == null) {
                    Intrinsics.throwNpe();
                }
                indexVirtualFile = BuiltInWebServerKt.findIndexFile(virtualFile);
            }
            if (indexFile2 == null && indexVirtualFile == null) {
                Responses.send$default(HttpResponseStatus.NOT_FOUND, channel, (HttpRequest)request, null, extraHeaders, 4, null);
                return true;
            }
            if (!FileUtilKt.endsWithSlash(decodedRawPath)) {
                WebServerPathHandlerKt.redirectToDirectory((HttpRequest)request, channel, isCustomHost ? path : "" + projectName + '/' + path, extraHeaders);
                return true;
            }
            indexUsed = true;
            pathInfo = new PathInfo(indexFile2, indexVirtualFile, pathInfo.getRoot(), pathInfo.getModuleName(), pathInfo.isLibrary(), false, 32, null);
            pathToFileManager.getPathToInfoCache().put((Object)path, (Object)pathInfo);
        }
        String userAgent = NettyKt.getUserAgent((HttpRequest)request);
        if (!isSignedRequest && userAgent != null && NettyKt.isRegularBrowser((HttpRequest)request) && NettyKt.getOrigin((HttpRequest)request) == null && NettyKt.getReferrer((HttpRequest)request) == null && (matcher = DefaultWebServerPathHandlerKt.getChromeVersionFromUserAgent().matcher(userAgent)).find() && StringUtil.compareVersionNumbers((String)matcher.group(1), (String)"51") < 0 && !DefaultWebServerPathHandlerKt.access$canBeAccessedDirectly(pathInfo.getName())) {
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.NOT_FOUND;
            Intrinsics.checkExpressionValueIsNotNull((Object)httpResponseStatus, (String)"HttpResponseStatus.NOT_FOUND");
            Responses.send$default(Responses.orInSafeMode(HttpResponseStatus.FORBIDDEN, httpResponseStatus), channel, (HttpRequest)request, null, null, 12, null);
            return true;
        }
        if (!indexUsed && !FileUtilKt.endsWithName(path, pathInfo.getName())) {
            if (FileUtilKt.endsWithSlash(decodedRawPath)) {
                indexUsed = true;
            } else {
                String parentPath = FileUtilKt.getParentPath(pathInfo.getPath());
                if (parentPath != null) {
                    String string = PathUtilRt.getFileName((String)parentPath);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PathUtilRt.getFileName(parentPath)");
                    if (FileUtilKt.endsWithName(path, string)) {
                        WebServerPathHandlerKt.redirectToDirectory((HttpRequest)request, channel, isCustomHost ? path : "" + projectName + '/' + path, extraHeaders);
                        return true;
                    }
                }
            }
        }
        if (!DefaultWebServerPathHandlerKt.access$checkAccess(pathInfo, channel, (HttpRequest)request)) {
            return true;
        }
        String canonicalPath = indexUsed ? "" + path + '/' + pathInfo.getName() : path;
        WebServerFileHandler[] webServerFileHandlerArray = (WebServerFileHandler[])WebServerFileHandler.Companion.getEP_NAME$built_in_server().getExtensions();
        for (int i = 0; i < webServerFileHandlerArray.length; ++i) {
            WebServerFileHandler fileHandler = webServerFileHandlerArray[i];
            Logger $receiver$iv = BuiltInWebServerKt.getLOG();
            try {
                PathInfo pathInfo2 = pathInfo;
                if (pathInfo2 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)pathInfo2, (String)"pathInfo!!");
                if (!fileHandler.process(pathInfo2, canonicalPath, project2, request, channel, isCustomHost ? null : projectName, extraHeaders)) continue;
                return true;
            }
            catch (ProcessCanceledException e$iv) {
                continue;
            }
            catch (Throwable e$iv) {
                $receiver$iv.error(e$iv);
            }
        }
        Responses.send$default(HttpResponseStatus.NOT_FOUND, channel, (HttpRequest)request, null, extraHeaders, 4, null);
        return true;
    }
}

