/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.ModuleLibraryOrderEntryImpl;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.DefaultWebServerRootsProviderKt;
import org.jetbrains.builtInWebServer.FileResolver;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.PathQuery;
import org.jetbrains.builtInWebServer.RootProvider;
import org.jetbrains.builtInWebServer.SuitableRoot;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;
import org.jetbrains.builtInWebServer.WebServerRootsProvider;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\"\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/builtInWebServer/DefaultWebServerRootsProvider;", "Lorg/jetbrains/builtInWebServer/WebServerRootsProvider;", "()V", "getPathInfo", "Lorg/jetbrains/builtInWebServer/PathInfo;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "resolve", "path", "", "pathQuery", "Lorg/jetbrains/builtInWebServer/PathQuery;", "built-in-server"})
final class DefaultWebServerRootsProvider
extends WebServerRootsProvider {
    @Nullable
    public PathInfo resolve(@NotNull String path, @NotNull Project project2, @NotNull PathQuery pathQuery) {
        PathInfo pathInfo;
        int resolver2;
        Object it;
        int n;
        Object[] $receiver$iv;
        int index;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)pathQuery, (String)"pathQuery");
        WebServerPathToFileManager pathToFileManager = WebServerPathToFileManager.Companion.getInstance(project2);
        Object[] effectivePath = path;
        if (PlatformUtils.isIntelliJ() && (index = StringsKt.indexOf$default((CharSequence)((CharSequence)effectivePath), (char)'/', (int)0, (boolean)false, (int)6, null)) > 0) {
            String string = project2.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.name");
            if (!StringsKt.regionMatches((String)effectivePath, (int)0, (String)string, (int)0, (int)index, (!SystemInfo.isFileSystemCaseSensitive ? 1 : 0) != 0)) {
                Object[] objectArray = effectivePath;
                int n2 = 0;
                String string2 = objectArray.substring(n2, index);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String moduleName = string2;
                Module module2 = (Module)ApplicationManager.getApplication().runReadAction(new Computable<T>(project2, moduleName){
                    final /* synthetic */ Project $project$inlined;
                    final /* synthetic */ String $moduleName$inlined;
                    {
                        this.$project$inlined = project2;
                        this.$moduleName$inlined = string;
                    }

                    public final T compute() {
                        return (T)ModuleManager.getInstance((Project)this.$project$inlined).findModuleByName(this.$moduleName$inlined);
                    }
                });
                if (module2 != null && !module2.isDisposed()) {
                    PathInfo result2;
                    PathInfo pathInfo2;
                    PathInfo pathInfo3;
                    FileResolver resolver2;
                    block18: {
                        Object[] $i$f$runReadAction = effectivePath;
                        int n3 = index + 1;
                        String string3 = $i$f$runReadAction.substring(n3);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                        String string4 = string3;
                        effectivePath = string4;
                        resolver2 = pathToFileManager.getResolver((String)effectivePath);
                        $receiver$iv = (Object[])RootProvider.values();
                        for (n = 0; n < $receiver$iv.length; ++n) {
                            Object file$iv = $receiver$iv[n];
                            it = (RootProvider)((Object)file$iv);
                            PathInfo result$iv = DefaultWebServerRootsProviderKt.access$findByRelativePath((String)effectivePath, it.getRoots(ProjectUtil.getRootManager((Module)module2)), resolver2, moduleName, pathQuery);
                            if (result$iv == null) continue;
                            pathInfo3 = result$iv;
                            break block18;
                        }
                        pathInfo3 = pathInfo2 = null;
                    }
                    if (pathInfo3 == null) {
                        pathInfo2 = result2 = DefaultWebServerRootsProviderKt.access$findInModuleLibraries((String)effectivePath, module2, resolver2, pathQuery);
                    }
                    if (result2 != null) {
                        return result2;
                    }
                }
            }
        }
        FileResolver resolver3 = pathToFileManager.getResolver((String)effectivePath);
        Module[] modules = (Module[])ApplicationManager.getApplication().runReadAction(new Computable<T>(project2){
            final /* synthetic */ Project $project$inlined;
            {
                this.$project$inlined = project2;
            }

            public final T compute() {
                return (T)ModuleManager.getInstance((Project)this.$project$inlined).getModules();
            }
        });
        if (pathQuery.getUseVfs()) {
            String oldestParent;
            String string;
            resolver2 = StringsKt.indexOf$default((CharSequence)((CharSequence)path), (String)"/", (int)0, (boolean)false, (int)6, null);
            int it2 = resolver2;
            if (it2 > 0) {
                $receiver$iv = path;
                n = 0;
                String string5 = $receiver$iv.substring(n, it2);
                string = string5;
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            } else {
                string = oldestParent = null;
            }
            if (oldestParent == null && !((resolver2 = (CharSequence)path).length() == 0) && !StringsKt.contains$default((CharSequence)((CharSequence)path), (char)'.', (boolean)false, (int)2, null)) {
                oldestParent = path;
            }
            if (oldestParent != null) {
                for (SuitableRoot resolver2 : (List)pathToFileManager.getParentToSuitableRoot$built_in_server().get((Object)oldestParent)) {
                    VirtualFile file2 = resolver2.component1();
                    String moduleQualifier = resolver2.component2();
                    VirtualFile virtualFile = file2.findFileByRelativePath((String)path);
                    if (virtualFile == null) continue;
                    pathInfo = virtualFile;
                    it = pathInfo;
                    return new PathInfo(null, (VirtualFile)it, file2, moduleQualifier, false, false, 48, null);
                }
            }
        } else {
            RootProvider[] it2 = RootProvider.values();
            for (resolver2 = 0; resolver2 < it2.length; ++resolver2) {
                RootProvider rootProvider = it2[resolver2];
                for (n = 0; n < modules.length; ++n) {
                    Module module3 = modules[n];
                    if (module3.isDisposed()) continue;
                    PathInfo pathInfo4 = DefaultWebServerRootsProviderKt.access$findByRelativePath((String)path, rootProvider.getRoots(ProjectUtil.getRootManager((Module)module3)), resolver3, null, pathQuery);
                    if (pathInfo4 == null) continue;
                    pathInfo = pathInfo4;
                    it = pathInfo;
                    it.setModuleName(DefaultWebServerRootsProviderKt.getModuleNameQualifier(project2, module3));
                    return it;
                }
            }
        }
        if (!pathQuery.getSearchInLibs()) {
            return null;
        }
        Function0<PathInfo> findByConfigJson$ = new Function0<PathInfo>(modules, resolver3, pathQuery, project2){
            final /* synthetic */ Module[] $modules;
            final /* synthetic */ FileResolver $resolver;
            final /* synthetic */ PathQuery $pathQuery;
            final /* synthetic */ Project $project;

            @Nullable
            public final PathInfo invoke() {
                RootProvider[] rootProviderArray = RootProvider.values();
                for (int i = 0; i < rootProviderArray.length; ++i) {
                    RootProvider rootProvider = rootProviderArray[i];
                    Module[] moduleArray = this.$modules;
                    for (int j = 0; j < moduleArray.length; ++j) {
                        Module module2 = moduleArray[j];
                        if (module2.isDisposed()) continue;
                        VirtualFile[] virtualFileArray = rootProvider.getRoots(ProjectUtil.getRootManager((Module)module2));
                        for (int k = 0; k < virtualFileArray.length; ++k) {
                            PathInfo pathInfo;
                            VirtualFile root = virtualFileArray[k];
                            if (FileResolver.DefaultImpls.resolve$default(this.$resolver, "config.json", root, null, false, this.$pathQuery, 12, null) == null) continue;
                            PathInfo pathInfo2 = FileResolver.DefaultImpls.resolve$default(this.$resolver, "index.html", root, null, false, this.$pathQuery, 12, null);
                            if (pathInfo2 == null) continue;
                            PathInfo it = pathInfo = pathInfo2;
                            it.setModuleName(DefaultWebServerRootsProviderKt.getModuleNameQualifier(this.$project, module2));
                            return it;
                        }
                    }
                }
                return null;
            }
            {
                this.$modules = moduleArray;
                this.$resolver = fileResolver;
                this.$pathQuery = pathQuery;
                this.$project = project2;
                super(0);
            }
        };
        Boolean exists = (Boolean)pathToFileManager.getPathToExistShortTermCache$built_in_server().getIfPresent((Object)"config.json");
        if (exists == null || exists.booleanValue()) {
            PathInfo result3 = findByConfigJson$.invoke();
            pathToFileManager.getPathToExistShortTermCache$built_in_server().put((Object)"config.json", (Object)(result3 != null ? 1 : 0));
            if (result3 != null) {
                return result3;
            }
        }
        return DefaultWebServerRootsProviderKt.access$findInLibraries(project2, (String)effectivePath, resolver3, pathQuery);
    }

    @Nullable
    public PathInfo getPathInfo(@NotNull VirtualFile file2, @NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        return (PathInfo)ApplicationManager.getApplication().runReadAction(new Computable<T>(project2, file2){
            final /* synthetic */ Project $project$inlined;
            final /* synthetic */ VirtualFile $file$inlined;
            {
                this.$project$inlined = project2;
                this.$file$inlined = virtualFile;
            }

            public final T compute() {
                PathInfo pathInfo;
                block3: {
                    boolean isLibrary;
                    boolean isRootNameOptionalInPath;
                    VirtualFile root;
                    DirectoryInfo info;
                    DirectoryIndex directoryIndex;
                    block7: {
                        block4: {
                            block5: {
                                block6: {
                                    block2: {
                                        directoryIndex = DirectoryIndex.getInstance(this.$project$inlined);
                                        info = directoryIndex.getInfoForFile(this.$file$inlined);
                                        if (info.isExcluded(this.$file$inlined) || info.isInProject(this.$file$inlined)) break block2;
                                        pathInfo = Intrinsics.areEqual((Object)this.$file$inlined.getFileSystem(), (Object)JarFileSystem.getInstance()) ? DefaultWebServerRootsProviderKt.access$getInfoForDocJar(this.$file$inlined, this.$project$inlined) : null;
                                        break block3;
                                    }
                                    root = info.getSourceRoot();
                                    if (root != null) break block4;
                                    isRootNameOptionalInPath = false;
                                    root = info.getContentRoot();
                                    if (root != null) break block5;
                                    root = info.getLibraryClassRoot();
                                    if (root != null) break block6;
                                    pathInfo = null;
                                    break block3;
                                }
                                isLibrary = true;
                                break block7;
                            }
                            isLibrary = false;
                            break block7;
                        }
                        isLibrary = info.isInLibrarySource(this.$file$inlined);
                        isRootNameOptionalInPath = !isLibrary;
                    }
                    Module module2 = info.getModule();
                    if (isLibrary && module2 == null) {
                        for (OrderEntry entry : directoryIndex.getOrderEntries(info)) {
                            if (!(entry instanceof ModuleLibraryOrderEntryImpl)) continue;
                            module2 = ((ModuleLibraryOrderEntryImpl)entry).getOwnerModule();
                            break;
                        }
                    }
                    pathInfo = new PathInfo(null, this.$file$inlined, root, DefaultWebServerRootsProviderKt.getModuleNameQualifier(this.$project$inlined, module2), isLibrary, isRootNameOptionalInPath);
                }
                return (T)pathInfo;
            }
        });
    }
}

