/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.concurrency;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.util.Consumer;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public abstract class AsyncValueLoader<T> {
    private final AtomicReference<Promise<T>> ref = new AtomicReference();
    private volatile long modificationCount;
    private volatile long loadedModificationCount;
    private final Consumer<T> doneHandler = new Consumer<T>(){

        public void consume(T o) {
            AsyncValueLoader.this.loadedModificationCount = AsyncValueLoader.this.modificationCount;
        }
    };

    @NotNull
    public final Promise<T> get() {
        Promise<T> promise2 = this.get(true);
        if (promise2 == null) {
            AsyncValueLoader.$$$reportNull$$$0(0);
        }
        return promise2;
    }

    public final T getResult() {
        return (T)((Getter)this.get(true)).get();
    }

    public final void reset() {
        Promise oldValue = this.ref.getAndSet(null);
        if (oldValue instanceof AsyncPromise) {
            this.rejectAndDispose((AsyncPromise)oldValue);
        }
    }

    private void rejectAndDispose(@NotNull AsyncPromise<T> asyncResult) {
        if (asyncResult == null) {
            AsyncValueLoader.$$$reportNull$$$0(1);
        }
        try {
            asyncResult.setError("rejected");
        }
        finally {
            Object result2 = asyncResult.get();
            if (result2 != null) {
                this.disposeResult(result2);
            }
        }
    }

    protected void disposeResult(@NotNull T result2) {
        if (result2 == null) {
            AsyncValueLoader.$$$reportNull$$$0(2);
        }
        if (result2 instanceof Disposable) {
            Disposer.dispose((Disposable)((Disposable)result2), (boolean)false);
        }
    }

    public final boolean has() {
        Promise<T> result2 = this.ref.get();
        return result2 != null && result2.getState() == Promise.State.FULFILLED && ((Getter)result2).get() != null;
    }

    @NotNull
    public final Promise<T> get(boolean checkFreshness) {
        AsyncPromise promise2 = this.ref.get();
        if (promise2 == null) {
            promise2 = new AsyncPromise();
            if (!this.ref.compareAndSet((Promise<T>)null, (Promise<T>)promise2)) {
                Promise<T> promise3 = this.ref.get();
                if (promise3 == null) {
                    AsyncValueLoader.$$$reportNull$$$0(3);
                }
                return promise3;
            }
        } else {
            Promise.State state = promise2.getState();
            if (state == Promise.State.PENDING) {
                AsyncPromise asyncPromise = promise2;
                if (asyncPromise == null) {
                    AsyncValueLoader.$$$reportNull$$$0(4);
                }
                return asyncPromise;
            }
            if (state == Promise.State.FULFILLED) {
                if (!checkFreshness || this.isUpToDate(((Getter)promise2).get())) {
                    AsyncPromise asyncPromise = promise2;
                    if (asyncPromise == null) {
                        AsyncValueLoader.$$$reportNull$$$0(5);
                    }
                    return asyncPromise;
                }
                if (!this.ref.compareAndSet((Promise<T>)promise2, (Promise<T>)(promise2 = new AsyncPromise()))) {
                    Promise<T> valueFromAnotherThread = this.ref.get();
                    while (valueFromAnotherThread == null) {
                        if (this.ref.compareAndSet((Promise<T>)null, (Promise<T>)promise2)) {
                            Promise<T> promise4 = this.getPromise(promise2);
                            if (promise4 == null) {
                                AsyncValueLoader.$$$reportNull$$$0(6);
                            }
                            return promise4;
                        }
                        valueFromAnotherThread = this.ref.get();
                    }
                    Promise<T> promise5 = valueFromAnotherThread;
                    if (promise5 == null) {
                        AsyncValueLoader.$$$reportNull$$$0(7);
                    }
                    return promise5;
                }
            }
        }
        Promise<T> promise6 = this.getPromise(promise2);
        if (promise6 == null) {
            AsyncValueLoader.$$$reportNull$$$0(8);
        }
        return promise6;
    }

    protected boolean isCancelOnReject() {
        return false;
    }

    @NotNull
    private Promise<T> getPromise(@NotNull AsyncPromise<T> promise2) {
        Promise<T> effectivePromise;
        if (promise2 == null) {
            AsyncValueLoader.$$$reportNull$$$0(9);
        }
        try {
            effectivePromise = this.load(promise2);
            if (effectivePromise != promise2) {
                this.ref.compareAndSet((Promise<T>)promise2, effectivePromise);
            }
        }
        catch (Throwable e) {
            this.ref.compareAndSet((Promise<T>)promise2, (Promise<T>)null);
            this.rejectAndDispose(promise2);
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
        effectivePromise.done(this.doneHandler);
        if (this.isCancelOnReject()) {
            effectivePromise.rejected(throwable -> this.ref.compareAndSet(effectivePromise, null));
        }
        if (effectivePromise != promise2) {
            effectivePromise.notify(promise2);
        }
        Promise<T> promise3 = effectivePromise;
        if (promise3 == null) {
            AsyncValueLoader.$$$reportNull$$$0(10);
        }
        return promise3;
    }

    @NotNull
    protected abstract Promise<T> load(@NotNull AsyncPromise<T> var1) throws IOException;

    protected boolean isUpToDate(@Nullable T result2) {
        return this.loadedModificationCount == this.modificationCount;
    }

    public final void set(@NotNull T result2) {
        Promise oldValue;
        if (result2 == null) {
            AsyncValueLoader.$$$reportNull$$$0(11);
        }
        if ((oldValue = this.ref.getAndSet(Promise.resolve(result2))) != null && oldValue instanceof AsyncPromise) {
            this.rejectAndDispose((AsyncPromise)oldValue);
        }
    }

    public final void markDirty() {
        ++this.modificationCount;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/concurrency/AsyncValueLoader";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "asyncResult";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "promise";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/concurrency/AsyncValueLoader";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPromise";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "rejectAndDispose";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "disposeResult";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPromise";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "set";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

