/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Function;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.ExecutionStackView;
import org.jetbrains.debugger.InactiveAtBreakpointExecutionStackView;
import org.jetbrains.debugger.MultiVmDebugProcess;
import org.jetbrains.debugger.RunningThreadExecutionStackView;
import org.jetbrains.debugger.ScriptExecutionStack;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.SuspendContextView;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.frame.CallFrameView;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0014J&\u0010\u0012\u001a\u0010\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00140\u00140\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\n\u0010\u0019\u001a\u0004\u0018\u00010\u0011H\u0016J\u0015\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0\u001bH\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0005J\u000e\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020\u0007J\u0006\u0010%\u001a\u00020!J\u0010\u0010&\u001a\u00020\u001f2\b\u0010'\u001a\u0004\u0018\u00010(R\u001e\u0010\u0006\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/debugger/SuspendContextView;", "Lcom/intellij/xdebugger/frame/XSuspendContext;", "debugProcess", "Lorg/jetbrains/debugger/MultiVmDebugProcess;", "activeStack", "Lorg/jetbrains/debugger/ExecutionStackView;", "activeVm", "Lorg/jetbrains/debugger/Vm;", "(Lorg/jetbrains/debugger/MultiVmDebugProcess;Lorg/jetbrains/debugger/ExecutionStackView;Lorg/jetbrains/debugger/Vm;)V", "getActiveVm", "()Lorg/jetbrains/debugger/Vm;", "setActiveVm", "(Lorg/jetbrains/debugger/Vm;)V", "getDebugProcess", "()Lorg/jetbrains/debugger/MultiVmDebugProcess;", "stacks", "", "Lorg/jetbrains/debugger/ScriptExecutionStack;", "evaluateExpression", "Lorg/jetbrains/concurrency/Promise;", "", "expression", "kotlin.jvm.PlatformType", "evaluateContext", "Lorg/jetbrains/debugger/EvaluateContext;", "getActiveExecutionStack", "getExecutionStacks", "", "Lcom/intellij/xdebugger/frame/XExecutionStack;", "()[Lcom/intellij/xdebugger/frame/XExecutionStack;", "hasPausedThreads", "", "pauseInactiveThread", "", "inactiveThread", "resume", "vm", "resumeCurrentThread", "setActiveThread", "selectedStackFrame", "Lcom/intellij/xdebugger/frame/XStackFrame;", "script-debugger-ui"})
public abstract class SuspendContextView
extends XSuspendContext {
    private final Map<Vm, ScriptExecutionStack> stacks;
    @NotNull
    private final MultiVmDebugProcess debugProcess;
    @NotNull
    private volatile Vm activeVm;

    @Nullable
    public ScriptExecutionStack getActiveExecutionStack() {
        return this.stacks.get(this.activeVm);
    }

    @NotNull
    public XExecutionStack[] getExecutionStacks() {
        Collection<ScriptExecutionStack> $receiver$iv;
        Collection<ScriptExecutionStack> collection = $receiver$iv = this.stacks.values();
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection<ScriptExecutionStack> thisCollection$iv = collection;
        ScriptExecutionStack[] scriptExecutionStackArray = thisCollection$iv.toArray(new ScriptExecutionStack[thisCollection$iv.size()]);
        if (scriptExecutionStackArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return scriptExecutionStackArray;
    }

    @NotNull
    public final Promise<String> evaluateExpression(@NotNull String expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        ScriptExecutionStack scriptExecutionStack = this.stacks.get(this.activeVm);
        if (scriptExecutionStack == null) {
            Intrinsics.throwNpe();
        }
        ScriptExecutionStack activeStack = scriptExecutionStack;
        XStackFrame xStackFrame = activeStack.getTopFrame();
        if (xStackFrame == null) {
            return Promises.rejectedPromise((String)"Top frame is null");
        }
        XStackFrame frame = xStackFrame;
        if (!(frame instanceof CallFrameView)) {
            return Promises.rejectedPromise((String)"Can't evaluate on non-paused thread");
        }
        Promise<String> promise2 = this.evaluateExpression(((CallFrameView)frame).getCallFrame().getEvaluateContext(), expression2);
        Intrinsics.checkExpressionValueIsNotNull(promise2, (String)"evaluateExpression(frame\u2026luateContext, expression)");
        return promise2;
    }

    private final Promise<String> evaluateExpression(EvaluateContext evaluateContext2, String expression2) {
        return EvaluateContext.DefaultImpls.evaluate$default(evaluateContext2, expression2, null, false, 6, null).thenAsync((Function)evaluateExpression.1.INSTANCE);
    }

    public final void pauseInactiveThread(@NotNull ExecutionStackView inactiveThread) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)inactiveThread), (String)"inactiveThread");
        Map<Vm, ScriptExecutionStack> map = this.stacks;
        Vm vm = inactiveThread.getVm();
        ExecutionStackView executionStackView = inactiveThread;
        map.put(vm, executionStackView);
    }

    public final boolean hasPausedThreads() {
        boolean bl;
        block3: {
            Iterable $receiver$iv = this.stacks.values();
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    ScriptExecutionStack it = (ScriptExecutionStack)((Object)element$iv);
                    if (!(it instanceof ExecutionStackView)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void resume(@NotNull Vm vm) {
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        ScriptExecutionStack prevStack = this.stacks.get(vm);
        if (prevStack instanceof ExecutionStackView) {
            Map<Vm, ScriptExecutionStack> map = this.stacks;
            RunningThreadExecutionStackView runningThreadExecutionStackView = new RunningThreadExecutionStackView(prevStack.getVm());
            map.put(vm, runningThreadExecutionStackView);
        }
    }

    public final void resumeCurrentThread() {
        this.resume(this.activeVm);
    }

    public final boolean setActiveThread(@Nullable XStackFrame selectedStackFrame) {
        ScriptExecutionStack value2;
        if (!(selectedStackFrame instanceof CallFrameView)) {
            return false;
        }
        Vm selectedVm = null;
        Iterator iterator = this.stacks;
        Map<Vm, ScriptExecutionStack> map = iterator.entrySet().iterator();
        while (map.hasNext()) {
            Map.Entry<Vm, ScriptExecutionStack> entry;
            Map.Entry<Vm, ScriptExecutionStack> entry2 = entry = map.next();
            Vm key2 = entry2.getKey();
            entry2 = entry;
            value2 = entry2.getValue();
            if (!(value2 instanceof ExecutionStackView)) continue;
            CallFrameView callFrameView = ((ExecutionStackView)value2).getTopFrame();
            if (!Intrinsics.areEqual((Object)(callFrameView != null ? callFrameView.getVm() : null), (Object)((CallFrameView)selectedStackFrame).getVm())) continue;
            selectedVm = key2;
            break;
        }
        map = this.stacks;
        iterator = selectedVm;
        Map<Vm, ScriptExecutionStack> map2 = map;
        if (map2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, V>");
        }
        ScriptExecutionStack selectedVmStack = (ScriptExecutionStack)((Object)map2.get(iterator));
        if (selectedVm != null && selectedVmStack instanceof ExecutionStackView) {
            this.activeVm = selectedVm;
            map = this.stacks;
            iterator = selectedVm;
            value2 = ((ExecutionStackView)selectedVmStack).copyWithIsCurrent(true);
            map.put((Vm)((Object)iterator), value2);
            Iterable $receiver$iv = this.stacks.keySet();
            for (Object element$iv : $receiver$iv) {
                Vm it = (Vm)element$iv;
                ScriptExecutionStack stack = this.stacks.get(it);
                if (!(Intrinsics.areEqual((Object)it, (Object)selectedVm) ^ true) || !(stack instanceof ExecutionStackView)) continue;
                Map<Vm, ScriptExecutionStack> map3 = this.stacks;
                ExecutionStackView executionStackView = ((ExecutionStackView)stack).copyWithIsCurrent(false);
                map3.put(it, executionStackView);
            }
            return this.stacks.get(selectedVm) != selectedVmStack;
        }
        return false;
    }

    @NotNull
    protected final MultiVmDebugProcess getDebugProcess() {
        return this.debugProcess;
    }

    @NotNull
    public final Vm getActiveVm() {
        return this.activeVm;
    }

    public final void setActiveVm(@NotNull Vm vm) {
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"<set-?>");
        this.activeVm = vm;
    }

    public SuspendContextView(@NotNull MultiVmDebugProcess debugProcess, @NotNull ExecutionStackView activeStack, @NotNull Vm activeVm) {
        Intrinsics.checkParameterIsNotNull((Object)debugProcess, (String)"debugProcess");
        Intrinsics.checkParameterIsNotNull((Object)((Object)activeStack), (String)"activeStack");
        Intrinsics.checkParameterIsNotNull((Object)activeVm, (String)"activeVm");
        this.debugProcess = debugProcess;
        this.activeVm = activeVm;
        Map map = Collections.synchronizedMap(new LinkedHashMap());
        Intrinsics.checkExpressionValueIsNotNull(map, (String)"Collections.synchronized\u2026 ScriptExecutionStack>())");
        this.stacks = map;
        Vm mainVm = this.debugProcess.getMainVm();
        List<Vm> vmList = this.debugProcess.getCollectVMs();
        if (mainVm != null && !vmList.isEmpty()) {
            Iterable $receiver$iv = vmList;
            for (Object element$iv : $receiver$iv) {
                ScriptExecutionStack scriptExecutionStack;
                Vm it = (Vm)element$iv;
                SuspendContext<? extends CallFrame> context = it.getSuspendContextManager().getContext();
                if (context == null) {
                    scriptExecutionStack = new RunningThreadExecutionStackView(it);
                } else if (Intrinsics.areEqual(context, activeStack.getSuspendContext())) {
                    scriptExecutionStack = activeStack;
                } else {
                    Logger logger = Logger.getInstance(SuspendContextView.class);
                    Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
                    logger.error("Paused VM was lost.");
                    scriptExecutionStack = new InactiveAtBreakpointExecutionStackView(it);
                }
                ScriptExecutionStack stack = scriptExecutionStack;
                Map<Vm, ScriptExecutionStack> map2 = this.stacks;
                ScriptExecutionStack scriptExecutionStack2 = stack;
                map2.put(it, scriptExecutionStack2);
            }
        } else {
            Map<Vm, ScriptExecutionStack> map3 = this.stacks;
            Vm vm = this.activeVm;
            ExecutionStackView executionStackView = activeStack;
            map3.put(vm, executionStackView);
        }
    }
}

