/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.connection;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Condition;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.components.JBList;
import java.net.InetSocketAddress;
import java.util.Collection;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.RemoteVmConnection;
import org.jetbrains.debugger.connection.RemoteVmConnectionKt;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001aF\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u001c\u0010\u0007\u001a\u0018\u0012\u0004\u0012\u0002H\u0002\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0004\u0012\u00020\n0\b\u001a \u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0001*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"chooseDebuggee", "Lorg/jetbrains/concurrency/Promise;", "T", "targets", "", "selectedIndex", "", "renderer", "Lkotlin/Function2;", "Lcom/intellij/ui/ColoredListCellRenderer;", "", "open", "Lorg/jetbrains/debugger/Vm;", "Lorg/jetbrains/debugger/connection/RemoteVmConnection;", "address", "Ljava/net/InetSocketAddress;", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "script-debugger-ui"})
public final class RemoteVmConnectionKt {
    @NotNull
    public static final Promise<Vm> open(@NotNull RemoteVmConnection $receiver, @NotNull InetSocketAddress address, @NotNull ProcessHandler processHandler2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
        Intrinsics.checkParameterIsNotNull((Object)processHandler2, (String)"processHandler");
        return $receiver.open(address, (Condition<Void>)((Condition)new Condition<Void>(processHandler2){
            final /* synthetic */ ProcessHandler $processHandler;

            public final boolean value(Void it) {
                return this.$processHandler.isProcessTerminating() || this.$processHandler.isProcessTerminated();
            }
            {
                this.$processHandler = processHandler2;
            }
        }));
    }

    @NotNull
    public static final <T> Promise<T> chooseDebuggee(@NotNull Collection<? extends T> targets, int selectedIndex, @NotNull Function2<? super T, ? super ColoredListCellRenderer<?>, Unit> renderer) {
        Intrinsics.checkParameterIsNotNull(targets, (String)"targets");
        Intrinsics.checkParameterIsNotNull(renderer, (String)"renderer");
        if (targets.size() == 1) {
            return Promises.resolvedPromise((Object)CollectionsKt.first((Iterable)targets));
        }
        if (targets.isEmpty()) {
            return Promises.rejectedPromise((String)"No tabs to inspect");
        }
        AsyncPromise result2 = new AsyncPromise();
        ApplicationManager.getApplication().invokeLater(new Runnable(targets, renderer, selectedIndex, result2){
            final /* synthetic */ Collection $targets;
            final /* synthetic */ Function2 $renderer;
            final /* synthetic */ int $selectedIndex;
            final /* synthetic */ AsyncPromise $result;

            public final void run() {
                JBList list2 = new JBList(this.$targets);
                list2.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer<T>(this){
                    final /* synthetic */ chooseDebuggee.1 this$0;

                    protected void customizeCellRenderer(@NotNull JList<? extends T> list2, T value2, int index, boolean selected, boolean hasFocus) {
                        Intrinsics.checkParameterIsNotNull(list2, (String)"list");
                        this.this$0.$renderer.invoke(value2, (Object)((Object)this));
                    }
                    {
                        this.this$0 = $outer;
                    }
                });
                if (this.$selectedIndex != -1) {
                    list2.setSelectedIndex(this.$selectedIndex);
                }
                JBPopupFactory.getInstance().createListPopupBuilder((JList)list2).setTitle("Choose Page to Debug").setCancelOnWindowDeactivation(false).setItemChoosenCallback(new Runnable(this, list2){
                    final /* synthetic */ chooseDebuggee.1 this$0;
                    final /* synthetic */ JBList $list;

                    public final void run() {
                        Object value2 = this.$list.getSelectedValue();
                        if (value2 == null) {
                            this.this$0.$result.setError("No target to inspect");
                        } else {
                            this.this$0.$result.setResult(value2);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$list = jBList;
                    }
                }).createPopup().showInFocusCenter();
            }
            {
                this.$targets = collection;
                this.$renderer = function2;
                this.$selectedIndex = n;
                this.$result = asyncPromise;
            }
        });
        return (Promise)result2;
    }
}

