/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.sourcemap;

import com.intellij.openapi.editor.Document;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.Mappings;
import org.jetbrains.debugger.sourcemap.MappingsProcessorInLine;
import org.jetbrains.debugger.sourcemap.SourceMapDecoderKt;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u000bH\u0016J\u001e\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0017J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0016J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016J\u0016\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001fR\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006 "}, d2={"Lorg/jetbrains/debugger/sourcemap/MappingList;", "Lorg/jetbrains/debugger/sourcemap/Mappings;", "mappings", "", "Lorg/jetbrains/debugger/sourcemap/MappingEntry;", "(Ljava/util/List;)V", "comparator", "Ljava/util/Comparator;", "getComparator", "()Ljava/util/Comparator;", "size", "", "getSize", "()I", "get", "line", "column", "getByIndex", "index", "getEndOffset", "mapping", "lineStartOffset", "document", "Lcom/intellij/openapi/editor/Document;", "getNext", "getNextOnTheSameLine", "skipIfColumnEquals", "", "indexOf", "processMappingsInLine", "entryProcessor", "Lorg/jetbrains/debugger/sourcemap/MappingsProcessorInLine;", "script-debugger-backend"})
public abstract class MappingList
implements Mappings {
    private final List<MappingEntry> mappings;

    public final int getSize() {
        return this.mappings.size();
    }

    @NotNull
    protected abstract Comparator<MappingEntry> getComparator();

    @Override
    public int indexOf(int line, int column) {
        int low = 0;
        int high = this.mappings.size() - 1;
        if (this.getLine(this.mappings.get(low)) > line || this.getLine(this.mappings.get(high)) < line) {
            return -1;
        }
        while (low <= high) {
            int middle = low + high >>> 1;
            MappingEntry mapping = this.mappings.get(middle);
            int mappingLine = this.getLine(mapping);
            if (line == mappingLine) {
                if (column == this.getColumn(mapping)) {
                    MappingEntry prevMapping;
                    int firstIndex;
                    for (firstIndex = middle; firstIndex > 0 && this.getLine(prevMapping = this.mappings.get(firstIndex - 1)) == line && this.getColumn(prevMapping) == column; --firstIndex) {
                    }
                    return firstIndex;
                }
                if (column < this.getColumn(mapping)) {
                    if (column == 0 || column == -1) {
                        int firstIndex;
                        for (firstIndex = middle; firstIndex > 0 && this.getLine(this.mappings.get(firstIndex - 1)) == line; --firstIndex) {
                        }
                        return firstIndex;
                    }
                    if (middle == 0) {
                        return -1;
                    }
                    MappingEntry prevMapping = this.mappings.get(middle - 1);
                    if (line != this.getLine(prevMapping)) {
                        return -1;
                    }
                    if (column >= this.getColumn(prevMapping)) {
                        return middle - 1;
                    }
                    high = middle - 1;
                    continue;
                }
                MappingEntry nextMapping = Mappings.DefaultImpls.getNextOnTheSameLine$default(this, middle, false, 2, null);
                if (nextMapping == null) {
                    return middle;
                }
                low = middle + 1;
                continue;
            }
            if (line > mappingLine) {
                low = middle + 1;
                continue;
            }
            high = middle - 1;
        }
        return -1;
    }

    @Override
    @Nullable
    public MappingEntry get(int line, int column) {
        return (MappingEntry)CollectionsKt.getOrNull(this.mappings, (int)this.indexOf(line, column));
    }

    private final MappingEntry getNext(int index) {
        return (MappingEntry)CollectionsKt.getOrNull(this.mappings, (int)(index + 1));
    }

    @Override
    @Nullable
    public MappingEntry getNext(@NotNull MappingEntry mapping) {
        int n;
        MappingEntry result2;
        Intrinsics.checkParameterIsNotNull((Object)mapping, (String)"mapping");
        if (Intrinsics.areEqual(this.getComparator(), SourceMapDecoderKt.getMAPPING_COMPARATOR_BY_GENERATED_POSITION())) {
            return mapping.getNextGenerated();
        }
        int index = CollectionsKt.binarySearch$default(this.mappings, (Object)mapping, this.getComparator(), (int)0, (int)0, (int)12, null);
        if (index < 0) {
            return null;
        }
        do {
            n = ++index;
            ++index;
        } while (mapping == (result2 = (MappingEntry)CollectionsKt.getOrNull(this.mappings, (int)n)));
        return result2;
    }

    @Override
    @Nullable
    public MappingEntry getNextOnTheSameLine(int index, boolean skipIfColumnEquals) {
        MappingEntry mappingEntry = this.getNext(index);
        if (mappingEntry == null) {
            return null;
        }
        MappingEntry nextMapping = mappingEntry;
        MappingEntry mapping = this.getByIndex(index);
        if (this.getLine(nextMapping) != this.getLine(mapping)) {
            return null;
        }
        if (skipIfColumnEquals) {
            int i = index;
            while (this.getColumn(nextMapping) == this.getColumn(mapping)) {
                if (this.getNextOnTheSameLine(++i, false) != null) continue;
                return null;
            }
        }
        return nextMapping;
    }

    public final int getEndOffset(@NotNull MappingEntry mapping, int lineStartOffset, @NotNull Document document) {
        Intrinsics.checkParameterIsNotNull((Object)mapping, (String)"mapping");
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        MappingEntry nextMapping = Mappings.DefaultImpls.getNextOnTheSameLine$default(this, Collections.binarySearch(this.mappings, mapping, this.getComparator()), false, 2, null);
        return nextMapping == null ? document.getLineEndOffset(this.getLine(mapping)) : lineStartOffset + this.getColumn(nextMapping);
    }

    @Override
    @NotNull
    public MappingEntry getByIndex(int index) {
        return this.mappings.get(index);
    }

    public final boolean processMappingsInLine(int line, @NotNull MappingsProcessorInLine entryProcessor) {
        Intrinsics.checkParameterIsNotNull((Object)entryProcessor, (String)"entryProcessor");
        int low = 0;
        int high = this.mappings.size() - 1;
        while (low <= high) {
            int middle = low + high >>> 1;
            MappingEntry mapping = this.mappings.get(middle);
            int mappingLine = this.getLine(mapping);
            if (line == mappingLine) {
                MappingEntry nextEntry;
                int firstIndex;
                for (firstIndex = middle; firstIndex > 0 && this.getLine(this.mappings.get(firstIndex - 1)) == line; --firstIndex) {
                }
                MappingEntry entry = this.mappings.get(firstIndex);
                do {
                    if ((nextEntry = (MappingEntry)CollectionsKt.getOrNull(this.mappings, (int)(++firstIndex))) != null && this.getLine(nextEntry) != line) {
                        nextEntry = null;
                    }
                    MappingEntry mappingEntry = entry;
                    if (mappingEntry == null) {
                        Intrinsics.throwNpe();
                    }
                    if (entryProcessor.process(mappingEntry, nextEntry)) continue;
                    return true;
                } while ((entry = nextEntry) != null);
                return true;
            }
            if (line > mappingLine) {
                low = middle + 1;
                continue;
            }
            high = middle - 1;
        }
        return false;
    }

    public MappingList(@NotNull List<? extends MappingEntry> mappings) {
        Intrinsics.checkParameterIsNotNull(mappings, (String)"mappings");
        this.mappings = mappings;
    }

    @Override
    @Nullable
    public MappingEntry getNextOnTheSameLine(@NotNull MappingEntry mapping) {
        Intrinsics.checkParameterIsNotNull((Object)mapping, (String)"mapping");
        return Mappings.DefaultImpls.getNextOnTheSameLine(this, mapping);
    }
}

