/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.model.java.JpsJavaClasspathKind;
import org.jetbrains.jps.model.java.JpsJavaDependenciesEnumerator;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryRoot;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.util.JpsPathUtil;
import org.jetbrains.kotlin.config.TargetPlatformKind;
import org.jetbrains.kotlin.jps.JpsKotlinCompilerSettingsKt;
import org.jetbrains.kotlin.utils.LibraryUtils;

class JpsUtils {
    private static final Map<ModuleBuildTarget, Boolean> IS_KOTLIN_JS_MODULE_CACHE = new ConcurrentHashMap<ModuleBuildTarget, Boolean>();
    private static final Map<String, Boolean> IS_KOTLIN_JS_STDLIB_JAR_CACHE = new ConcurrentHashMap<String, Boolean>();

    private JpsUtils() {
    }

    @NotNull
    static JpsJavaDependenciesEnumerator getAllDependencies(@NotNull ModuleBuildTarget target) {
        return JpsJavaExtensionService.dependencies((JpsModule)target.getModule()).recursively().exportedOnly().includedIn(JpsJavaClasspathKind.compile((boolean)target.isTests()));
    }

    static boolean isJsKotlinModule(@NotNull ModuleBuildTarget target) {
        Boolean cachedValue = IS_KOTLIN_JS_MODULE_CACHE.get(target);
        if (cachedValue != null) {
            return cachedValue;
        }
        boolean isKotlinJsModule = JpsUtils.isJsKotlinModuleImpl(target);
        IS_KOTLIN_JS_MODULE_CACHE.put(target, isKotlinJsModule);
        return isKotlinJsModule;
    }

    private static boolean isJsKotlinModuleImpl(@NotNull ModuleBuildTarget target) {
        TargetPlatformKind<?> targetPlatform = JpsKotlinCompilerSettingsKt.getTargetPlatform(target.getModule());
        if (targetPlatform != null) {
            return targetPlatform == TargetPlatformKind.JavaScript.INSTANCE;
        }
        Set libraries = JpsUtils.getAllDependencies(target).getLibraries();
        for (JpsLibrary library : libraries) {
            for (JpsLibraryRoot root : library.getRoots(JpsOrderRootType.COMPILED)) {
                String url = root.getUrl();
                Boolean cachedValue = IS_KOTLIN_JS_STDLIB_JAR_CACHE.get(url);
                if (cachedValue != null) {
                    if (!cachedValue.booleanValue()) continue;
                    return true;
                }
                boolean isKotlinJavascriptStdLibrary = LibraryUtils.isKotlinJavascriptStdLibrary(JpsPathUtil.urlToFile((String)url));
                IS_KOTLIN_JS_STDLIB_JAR_CACHE.put(url, isKotlinJavascriptStdLibrary);
                if (!isKotlinJavascriptStdLibrary) continue;
                return true;
            }
        }
        return false;
    }

    static void resetCaches() {
        IS_KOTLIN_JS_MODULE_CACHE.clear();
        IS_KOTLIN_JS_STDLIB_JAR_CACHE.clear();
    }
}

