/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.client.api;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.klint.client.api.SdkInfo;
import com.google.common.annotations.Beta;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@Beta
class DefaultSdkInfo
extends SdkInfo {
    private static final int CLASS_COUNT = 59;
    private static final int LAYOUT_COUNT = 20;
    private static final Map<String, String> PARENTS = Maps.newHashMapWithExpectedSize((int)59);
    private static final Set<String> LAYOUTS = Sets.newHashSetWithExpectedSize((int)59);
    @NonNull
    private static final Map<String, String> INTERFACES;

    DefaultSdkInfo() {
    }

    @Override
    @Nullable
    public String getParentViewName(@NonNull String name) {
        name = DefaultSdkInfo.getRawType(name);
        return PARENTS.get(name);
    }

    @Override
    @Nullable
    public String getParentViewClass(@NonNull String fqcn) {
        String parent;
        int index = fqcn.lastIndexOf(46);
        if (index != -1) {
            fqcn = fqcn.substring(index + 1);
        }
        if ((parent = PARENTS.get(fqcn)) == null) {
            return null;
        }
        if (parent.equals("View") || parent.equals("ViewGroup") || parent.equals("SurfaceView")) {
            return "android.view." + parent;
        }
        return "android.widget." + parent;
    }

    @Override
    public boolean isSubViewOf(@NonNull String parentType, @NonNull String childType) {
        String parent = DefaultSdkInfo.getRawType(parentType);
        String child = DefaultSdkInfo.getRawType(childType);
        if (parent.indexOf(46) != -1) {
            parent = parent.substring(parent.lastIndexOf(46) + 1);
        }
        if (child.indexOf(46) != -1) {
            child = child.substring(child.lastIndexOf(46) + 1);
        }
        if (parent.equals("View")) {
            return true;
        }
        while (!child.equals("View")) {
            if (parent.equals(child)) {
                return true;
            }
            if (DefaultSdkInfo.implementsInterface(child, parent)) {
                return true;
            }
            if ((child = PARENTS.get(child)) != null) continue;
            return true;
        }
        return false;
    }

    private static boolean implementsInterface(String className, String interfaceName) {
        return interfaceName.equals(INTERFACES.get(className));
    }

    private static String getRawType(String type2) {
        int index;
        if (type2 != null && (index = type2.indexOf(60)) != -1) {
            type2 = type2.substring(0, index);
        }
        return type2;
    }

    @Override
    public boolean isLayout(@NonNull String tag) {
        if (super.isLayout(tag)) {
            return true;
        }
        return LAYOUTS.contains(tag);
    }

    static {
        PARENTS.put("CompoundButton", "Button");
        PARENTS.put("AbsSpinner", "AdapterView");
        PARENTS.put("AbsListView", "AdapterView");
        PARENTS.put("AbsSeekBar", "AdapterView");
        PARENTS.put("AdapterView", "ViewGroup");
        PARENTS.put("ViewGroup", "View");
        PARENTS.put("TextView", "View");
        PARENTS.put("CheckedTextView", "TextView");
        PARENTS.put("RadioButton", "CompoundButton");
        PARENTS.put("Spinner", "AbsSpinner");
        PARENTS.put("ImageButton", "ImageView");
        PARENTS.put("ImageView", "View");
        PARENTS.put("EditText", "TextView");
        PARENTS.put("ProgressBar", "View");
        PARENTS.put("ToggleButton", "CompoundButton");
        PARENTS.put("ViewStub", "View");
        PARENTS.put("Button", "TextView");
        PARENTS.put("SeekBar", "AbsSeekBar");
        PARENTS.put("CheckBox", "CompoundButton");
        PARENTS.put("Switch", "CompoundButton");
        PARENTS.put("Gallery", "AbsSpinner");
        PARENTS.put("SurfaceView", "View");
        PARENTS.put("AbsoluteLayout", "ViewGroup");
        PARENTS.put("LinearLayout", "ViewGroup");
        PARENTS.put("RelativeLayout", "ViewGroup");
        PARENTS.put("ListView", "AbsListView");
        PARENTS.put("ViewSwitcher", "ViewAnimator");
        PARENTS.put("FrameLayout", "ViewGroup");
        PARENTS.put("HorizontalScrollView", "FrameLayout");
        PARENTS.put("ViewAnimator", "FrameLayout");
        PARENTS.put("TabHost", "FrameLayout");
        PARENTS.put("TableRow", "LinearLayout");
        PARENTS.put("RadioGroup", "LinearLayout");
        PARENTS.put("TabWidget", "LinearLayout");
        PARENTS.put("ExpandableListView", "ListView");
        PARENTS.put("TableLayout", "LinearLayout");
        PARENTS.put("ScrollView", "FrameLayout");
        PARENTS.put("GridView", "AbsListView");
        PARENTS.put("WebView", "AbsoluteLayout");
        PARENTS.put("AutoCompleteTextView", "EditText");
        PARENTS.put("MultiAutoCompleteTextView", "AutoCompleteTextView");
        PARENTS.put("CheckedTextView", "TextView");
        PARENTS.put("MediaController", "FrameLayout");
        PARENTS.put("SlidingDrawer", "ViewGroup");
        PARENTS.put("DialerFilter", "RelativeLayout");
        PARENTS.put("DigitalClock", "TextView");
        PARENTS.put("Chronometer", "TextView");
        PARENTS.put("ImageSwitcher", "ViewSwitcher");
        PARENTS.put("TextSwitcher", "ViewSwitcher");
        PARENTS.put("AnalogClock", "View");
        PARENTS.put("TwoLineListItem", "RelativeLayout");
        PARENTS.put("ZoomControls", "LinearLayout");
        PARENTS.put("DatePicker", "FrameLayout");
        PARENTS.put("TimePicker", "FrameLayout");
        PARENTS.put("VideoView", "SurfaceView");
        PARENTS.put("ZoomButton", "ImageButton");
        PARENTS.put("RatingBar", "AbsSeekBar");
        PARENTS.put("ViewFlipper", "ViewAnimator");
        PARENTS.put("NumberPicker", "LinearLayout");
        assert (PARENTS.size() <= 59) : PARENTS.size();
        LAYOUTS.add("TabHost");
        LAYOUTS.add("HorizontalScrollView");
        LAYOUTS.add("ViewSwitcher");
        LAYOUTS.add("TabWidget");
        LAYOUTS.add("ViewAnimator");
        LAYOUTS.add("ScrollView");
        LAYOUTS.add("GridView");
        LAYOUTS.add("TableRow");
        LAYOUTS.add("RadioGroup");
        LAYOUTS.add("ListView");
        LAYOUTS.add("ExpandableListView");
        LAYOUTS.add("MediaController");
        LAYOUTS.add("DialerFilter");
        LAYOUTS.add("ViewFlipper");
        LAYOUTS.add("SlidingDrawer");
        LAYOUTS.add("StackView");
        LAYOUTS.add("SearchView");
        LAYOUTS.add("TextSwitcher");
        LAYOUTS.add("AdapterViewFlipper");
        LAYOUTS.add("ImageSwitcher");
        assert (LAYOUTS.size() <= 20) : LAYOUTS.size();
        INTERFACES = new HashMap<String, String>(2);
        INTERFACES.put("CheckedTextView", "Checkable");
        INTERFACES.put("CompoundButton", "Checkable");
    }
}

