/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.detector.api;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.klint.client.api.JavaParser;
import com.android.tools.klint.client.api.UastLintUtils;
import com.android.tools.klint.detector.api.JavaContext;
import com.google.common.collect.Lists;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.ListIterator;
import lombok.ast.ArrayCreation;
import lombok.ast.ArrayInitializer;
import lombok.ast.BinaryExpression;
import lombok.ast.BinaryOperator;
import lombok.ast.BooleanLiteral;
import lombok.ast.Cast;
import lombok.ast.CharLiteral;
import lombok.ast.Expression;
import lombok.ast.ExpressionStatement;
import lombok.ast.FloatingPointLiteral;
import lombok.ast.InlineIfExpression;
import lombok.ast.IntegralLiteral;
import lombok.ast.Node;
import lombok.ast.NullLiteral;
import lombok.ast.Select;
import lombok.ast.Statement;
import lombok.ast.StrictListAccessor;
import lombok.ast.StringLiteral;
import lombok.ast.TypeReference;
import lombok.ast.UnaryExpression;
import lombok.ast.UnaryOperator;
import lombok.ast.VariableDeclaration;
import lombok.ast.VariableDefinition;
import lombok.ast.VariableDefinitionEntry;
import lombok.ast.VariableReference;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBinaryExpressionWithType;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UDeclarationsExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UPrefixExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastBinaryExpressionWithTypeKind;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastPrefixOperator;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;

public class ConstantEvaluator {
    private final JavaContext mContext;
    private boolean mAllowUnknown;

    public ConstantEvaluator(@Nullable JavaContext context) {
        this.mContext = context;
    }

    public ConstantEvaluator allowUnknowns() {
        this.mAllowUnknown = true;
        return this;
    }

    @Deprecated
    @Nullable
    public Object evaluate(@NonNull Node node) {
        if (node instanceof NullLiteral) {
            return null;
        }
        if (node instanceof BooleanLiteral) {
            return ((BooleanLiteral)node).astValue();
        }
        if (node instanceof StringLiteral) {
            StringLiteral string = (StringLiteral)node;
            return string.astValue();
        }
        if (node instanceof CharLiteral) {
            return ((CharLiteral)node).astValue();
        }
        if (node instanceof IntegralLiteral) {
            IntegralLiteral literal = (IntegralLiteral)node;
            if (literal.astMarkedAsLong()) {
                return literal.astLongValue();
            }
            return literal.astIntValue();
        }
        if (node instanceof FloatingPointLiteral) {
            FloatingPointLiteral literal = (FloatingPointLiteral)node;
            if (literal.astMarkedAsFloat()) {
                return Float.valueOf(literal.astFloatValue());
            }
            return literal.astDoubleValue();
        }
        if (node instanceof UnaryExpression) {
            UnaryOperator operator = ((UnaryExpression)node).astOperator();
            Object operand2 = this.evaluate((Node)((UnaryExpression)node).astOperand());
            if (operand2 == null) {
                return null;
            }
            switch (operator) {
                case LOGICAL_NOT: {
                    if (!(operand2 instanceof Boolean)) break;
                    return (Boolean)operand2 == false;
                }
                case UNARY_PLUS: {
                    return operand2;
                }
                case BINARY_NOT: {
                    if (operand2 instanceof Integer) {
                        return ~((Integer)operand2).intValue();
                    }
                    if (operand2 instanceof Long) {
                        return (Long)operand2 ^ 0xFFFFFFFFFFFFFFFFL;
                    }
                    if (operand2 instanceof Short) {
                        return (int)(~((Short)operand2).shortValue());
                    }
                    if (operand2 instanceof Character) {
                        return (int)(~((Character)operand2).charValue());
                    }
                    if (!(operand2 instanceof Byte)) break;
                    return (int)(~((Byte)operand2).byteValue());
                }
                case UNARY_MINUS: {
                    if (operand2 instanceof Integer) {
                        return -((Integer)operand2).intValue();
                    }
                    if (operand2 instanceof Long) {
                        return -((Long)operand2).longValue();
                    }
                    if (operand2 instanceof Double) {
                        return -((Double)operand2).doubleValue();
                    }
                    if (operand2 instanceof Float) {
                        return Float.valueOf(-((Float)operand2).floatValue());
                    }
                    if (operand2 instanceof Short) {
                        return (int)(-((Short)operand2).shortValue());
                    }
                    if (operand2 instanceof Character) {
                        return (int)(-((Character)operand2).charValue());
                    }
                    if (!(operand2 instanceof Byte)) break;
                    return (int)(-((Byte)operand2).byteValue());
                }
            }
        } else if (node instanceof InlineIfExpression) {
            InlineIfExpression expression2 = (InlineIfExpression)node;
            Object known = this.evaluate((Node)expression2.astCondition());
            if (known == Boolean.TRUE && expression2.astIfTrue() != null) {
                return this.evaluate((Node)expression2.astIfTrue());
            }
            if (known == Boolean.FALSE && expression2.astIfFalse() != null) {
                return this.evaluate((Node)expression2.astIfFalse());
            }
        } else if (node instanceof BinaryExpression) {
            BinaryOperator operator = ((BinaryExpression)node).astOperator();
            Object operandLeft = this.evaluate((Node)((BinaryExpression)node).astLeft());
            Object operandRight = this.evaluate((Node)((BinaryExpression)node).astRight());
            if (operandLeft == null || operandRight == null) {
                if (this.mAllowUnknown) {
                    if (operandLeft == null) {
                        return operandRight;
                    }
                    return operandLeft;
                }
                return null;
            }
            if (operandLeft instanceof String && operandRight instanceof String) {
                if (operator == BinaryOperator.PLUS) {
                    return operandLeft.toString() + operandRight.toString();
                }
                return null;
            }
            if (operandLeft instanceof Boolean && operandRight instanceof Boolean) {
                boolean left = (Boolean)operandLeft;
                boolean right = (Boolean)operandRight;
                switch (operator) {
                    case LOGICAL_OR: {
                        return left || right;
                    }
                    case LOGICAL_AND: {
                        return left && right;
                    }
                    case BITWISE_OR: {
                        return left | right;
                    }
                    case BITWISE_XOR: {
                        return left ^ right;
                    }
                    case BITWISE_AND: {
                        return left & right;
                    }
                    case EQUALS: {
                        return left == right;
                    }
                    case NOT_EQUALS: {
                        return left != right;
                    }
                }
            } else if (operandLeft instanceof Number && operandRight instanceof Number) {
                boolean isInteger;
                Number left = (Number)operandLeft;
                Number right = (Number)operandRight;
                boolean bl = isInteger = !(left instanceof Float) && !(left instanceof Double) && !(right instanceof Float) && !(right instanceof Double);
                boolean isWide = isInteger ? left instanceof Long || right instanceof Long : left instanceof Double || right instanceof Double;
                switch (operator) {
                    case BITWISE_OR: {
                        if (isWide) {
                            return left.longValue() | right.longValue();
                        }
                        return left.intValue() | right.intValue();
                    }
                    case BITWISE_XOR: {
                        if (isWide) {
                            return left.longValue() ^ right.longValue();
                        }
                        return left.intValue() ^ right.intValue();
                    }
                    case BITWISE_AND: {
                        if (isWide) {
                            return left.longValue() & right.longValue();
                        }
                        return left.intValue() & right.intValue();
                    }
                    case EQUALS: {
                        if (isInteger) {
                            return left.longValue() == right.longValue();
                        }
                        return left.doubleValue() == right.doubleValue();
                    }
                    case NOT_EQUALS: {
                        if (isInteger) {
                            return left.longValue() != right.longValue();
                        }
                        return left.doubleValue() != right.doubleValue();
                    }
                    case GREATER: {
                        if (isInteger) {
                            return left.longValue() > right.longValue();
                        }
                        return left.doubleValue() > right.doubleValue();
                    }
                    case GREATER_OR_EQUAL: {
                        if (isInteger) {
                            return left.longValue() >= right.longValue();
                        }
                        return left.doubleValue() >= right.doubleValue();
                    }
                    case LESS: {
                        if (isInteger) {
                            return left.longValue() < right.longValue();
                        }
                        return left.doubleValue() < right.doubleValue();
                    }
                    case LESS_OR_EQUAL: {
                        if (isInteger) {
                            return left.longValue() <= right.longValue();
                        }
                        return left.doubleValue() <= right.doubleValue();
                    }
                    case SHIFT_LEFT: {
                        if (isWide) {
                            return left.longValue() << right.intValue();
                        }
                        return left.intValue() << right.intValue();
                    }
                    case SHIFT_RIGHT: {
                        if (isWide) {
                            return left.longValue() >> right.intValue();
                        }
                        return left.intValue() >> right.intValue();
                    }
                    case BITWISE_SHIFT_RIGHT: {
                        if (isWide) {
                            return left.longValue() >>> right.intValue();
                        }
                        return left.intValue() >>> right.intValue();
                    }
                    case PLUS: {
                        if (isInteger) {
                            if (isWide) {
                                return left.longValue() + right.longValue();
                            }
                            return left.intValue() + right.intValue();
                        }
                        if (isWide) {
                            return left.doubleValue() + right.doubleValue();
                        }
                        return Float.valueOf(left.floatValue() + right.floatValue());
                    }
                    case MINUS: {
                        if (isInteger) {
                            if (isWide) {
                                return left.longValue() - right.longValue();
                            }
                            return left.intValue() - right.intValue();
                        }
                        if (isWide) {
                            return left.doubleValue() - right.doubleValue();
                        }
                        return Float.valueOf(left.floatValue() - right.floatValue());
                    }
                    case MULTIPLY: {
                        if (isInteger) {
                            if (isWide) {
                                return left.longValue() * right.longValue();
                            }
                            return left.intValue() * right.intValue();
                        }
                        if (isWide) {
                            return left.doubleValue() * right.doubleValue();
                        }
                        return Float.valueOf(left.floatValue() * right.floatValue());
                    }
                    case DIVIDE: {
                        if (isInteger) {
                            if (isWide) {
                                return left.longValue() / right.longValue();
                            }
                            return left.intValue() / right.intValue();
                        }
                        if (isWide) {
                            return left.doubleValue() / right.doubleValue();
                        }
                        return Float.valueOf(left.floatValue() / right.floatValue());
                    }
                    case REMAINDER: {
                        if (isInteger) {
                            if (isWide) {
                                return left.longValue() % right.longValue();
                            }
                            return left.intValue() % right.intValue();
                        }
                        if (isWide) {
                            return left.doubleValue() % right.doubleValue();
                        }
                        return Float.valueOf(left.floatValue() % right.floatValue());
                    }
                }
                return null;
            }
        } else {
            if (node instanceof Cast) {
                Cast cast = (Cast)node;
                Object operandValue = this.evaluate((Node)cast.astOperand());
                if (operandValue instanceof Number) {
                    Number number = (Number)operandValue;
                    String typeName = cast.astTypeReference().getTypeName();
                    if (typeName.equals("float")) {
                        return Float.valueOf(number.floatValue());
                    }
                    if (typeName.equals("double")) {
                        return number.doubleValue();
                    }
                    if (typeName.equals("int")) {
                        return number.intValue();
                    }
                    if (typeName.equals("long")) {
                        return number.longValue();
                    }
                    if (typeName.equals("short")) {
                        return number.shortValue();
                    }
                    if (typeName.equals("byte")) {
                        return number.byteValue();
                    }
                }
                return operandValue;
            }
            if (this.mContext != null && (node instanceof VariableReference || node instanceof Select)) {
                Statement statement;
                JavaParser.ResolvedNode resolved = this.mContext.resolve(node);
                if (resolved instanceof JavaParser.ResolvedField) {
                    VariableDefinitionEntry first;
                    StrictListAccessor variables;
                    VariableDeclaration declaration2;
                    VariableDefinition definition;
                    JavaParser.ResolvedField field = (JavaParser.ResolvedField)resolved;
                    Object value2 = field.getValue();
                    if (value2 != null) {
                        return value2;
                    }
                    Node astNode = field.findAstNode();
                    if (astNode instanceof VariableDeclaration && (definition = (declaration2 = (VariableDeclaration)astNode).astDefinition()) != null && definition.astModifiers().isFinal() && (variables = definition.astVariables()).size() == 1 && (first = (VariableDefinitionEntry)variables.first()).astInitializer() != null) {
                        return this.evaluate((Node)first.astInitializer());
                    }
                    return null;
                }
                if (node instanceof VariableReference && (statement = JavaContext.getParentOfType(node, Statement.class, false)) != null) {
                    ListIterator iterator = statement.getParent().getChildren().listIterator();
                    while (iterator.hasNext()) {
                        if (iterator.next() != statement) continue;
                        if (!iterator.hasPrevious()) break;
                        iterator.previous();
                        break;
                    }
                    String targetName = ((VariableReference)node).astIdentifier().astValue();
                    while (iterator.hasPrevious()) {
                        BinaryExpression binaryExpression;
                        ExpressionStatement expressionStatement;
                        Expression expression3;
                        Node previous = (Node)iterator.previous();
                        if (previous instanceof VariableDeclaration) {
                            VariableDeclaration declaration3 = (VariableDeclaration)previous;
                            VariableDefinition definition = declaration3.astDefinition();
                            for (VariableDefinitionEntry entry : definition.astVariables()) {
                                if (entry.astInitializer() == null || !entry.astName().astValue().equals(targetName)) continue;
                                return this.evaluate((Node)entry.astInitializer());
                            }
                            continue;
                        }
                        if (!(previous instanceof ExpressionStatement) || !((expression3 = (expressionStatement = (ExpressionStatement)previous).astExpression()) instanceof BinaryExpression) || ((BinaryExpression)expression3).astOperator() != BinaryOperator.ASSIGN || !targetName.equals((binaryExpression = (BinaryExpression)expression3).astLeft().toString())) continue;
                        return this.evaluate((Node)binaryExpression.astRight());
                    }
                }
            } else if (node instanceof ArrayCreation) {
                ArrayCreation creation = (ArrayCreation)node;
                ArrayInitializer initializer = creation.astInitializer();
                if (initializer != null) {
                    TypeReference typeReference2 = creation.astComponentTypeReference();
                    StrictListAccessor expressions2 = initializer.astExpressions();
                    ArrayList values = Lists.newArrayListWithExpectedSize((int)expressions2.size());
                    Class<?> commonType = null;
                    for (Expression expression4 : expressions2) {
                        Object value3 = this.evaluate((Node)expression4);
                        if (value3 != null) {
                            values.add(value3);
                            if (commonType == null) {
                                commonType = value3.getClass();
                                continue;
                            }
                            while (!commonType.isAssignableFrom(value3.getClass())) {
                                commonType = commonType.getSuperclass();
                            }
                            continue;
                        }
                        if (this.mAllowUnknown) continue;
                        return null;
                    }
                    if (!values.isEmpty()) {
                        Object o = Array.newInstance(commonType, values.size());
                        return values.toArray((Object[])o);
                    }
                    if (this.mContext != null) {
                        JavaParser.ResolvedNode type2 = this.mContext.resolve((Node)typeReference2);
                        System.out.println(type2);
                    }
                } else {
                    String type3 = creation.astComponentTypeReference().toString();
                    int size = 0;
                    if ("byte".equals(type3)) {
                        return new byte[size];
                    }
                    if ("boolean".equals(type3)) {
                        return new boolean[size];
                    }
                    if ("int".equals(type3)) {
                        return new int[size];
                    }
                    if ("long".equals(type3)) {
                        return new long[size];
                    }
                    if ("char".equals(type3)) {
                        return new char[size];
                    }
                    if ("float".equals(type3)) {
                        return new float[size];
                    }
                    if ("double".equals(type3)) {
                        return new double[size];
                    }
                    if ("java.lang.String".equals(type3)) {
                        return new String[size];
                    }
                    if ("short".equals(type3)) {
                        return new short[size];
                    }
                    if ("java.lang.Object".equals(type3)) {
                        return new Object[size];
                    }
                }
            }
        }
        return null;
    }

    @Nullable
    public Object evaluate(@Nullable UElement node) {
        Object evaluated;
        UastPrefixOperator operator;
        if (node == null) {
            return null;
        }
        if (node instanceof ULiteralExpression) {
            return ((ULiteralExpression)node).getValue();
        }
        if (node instanceof UPrefixExpression) {
            operator = ((UPrefixExpression)node).getOperator();
            Object operand2 = this.evaluate((UElement)((UPrefixExpression)node).getOperand());
            if (operand2 == null) {
                return null;
            }
            if (operator == UastPrefixOperator.LOGICAL_NOT) {
                if (operand2 instanceof Boolean) {
                    return (Boolean)operand2 == false;
                }
            } else {
                if (operator == UastPrefixOperator.UNARY_PLUS) {
                    return operand2;
                }
                if (operator == UastPrefixOperator.BITWISE_NOT) {
                    if (operand2 instanceof Integer) {
                        return ~((Integer)operand2).intValue();
                    }
                    if (operand2 instanceof Long) {
                        return (Long)operand2 ^ 0xFFFFFFFFFFFFFFFFL;
                    }
                    if (operand2 instanceof Short) {
                        return (int)(~((Short)operand2).shortValue());
                    }
                    if (operand2 instanceof Character) {
                        return (int)(~((Character)operand2).charValue());
                    }
                    if (operand2 instanceof Byte) {
                        return (int)(~((Byte)operand2).byteValue());
                    }
                } else if (operator == UastPrefixOperator.UNARY_MINUS) {
                    if (operand2 instanceof Integer) {
                        return -((Integer)operand2).intValue();
                    }
                    if (operand2 instanceof Long) {
                        return -((Long)operand2).longValue();
                    }
                    if (operand2 instanceof Double) {
                        return -((Double)operand2).doubleValue();
                    }
                    if (operand2 instanceof Float) {
                        return Float.valueOf(-((Float)operand2).floatValue());
                    }
                    if (operand2 instanceof Short) {
                        return (int)(-((Short)operand2).shortValue());
                    }
                    if (operand2 instanceof Character) {
                        return (int)(-((Character)operand2).charValue());
                    }
                    if (operand2 instanceof Byte) {
                        return (int)(-((Byte)operand2).byteValue());
                    }
                }
            }
        } else if (node instanceof UIfExpression && ((UIfExpression)node).getExpressionType() != null) {
            UIfExpression expression2 = (UIfExpression)node;
            Object known = this.evaluate((UElement)expression2.getCondition());
            if (known == Boolean.TRUE && expression2.getThenExpression() != null) {
                return this.evaluate((UElement)expression2.getThenExpression());
            }
            if (known == Boolean.FALSE && expression2.getElseExpression() != null) {
                return this.evaluate((UElement)expression2.getElseExpression());
            }
        } else {
            if (node instanceof UParenthesizedExpression) {
                UParenthesizedExpression parenthesizedExpression = (UParenthesizedExpression)node;
                UExpression expression3 = parenthesizedExpression.getExpression();
                return this.evaluate((UElement)expression3);
            }
            if (node instanceof UBinaryExpression) {
                operator = ((UBinaryExpression)node).getOperator();
                Object operandLeft = this.evaluate((UElement)((UBinaryExpression)node).getLeftOperand());
                Object operandRight = this.evaluate((UElement)((UBinaryExpression)node).getRightOperand());
                if (operandLeft == null || operandRight == null) {
                    if (this.mAllowUnknown) {
                        if (operandLeft == null) {
                            return operandRight;
                        }
                        return operandLeft;
                    }
                    return null;
                }
                if (operandLeft instanceof String && operandRight instanceof String) {
                    if (operator == UastBinaryOperator.PLUS) {
                        return operandLeft.toString() + operandRight.toString();
                    }
                    return null;
                }
                if (operandLeft instanceof Boolean && operandRight instanceof Boolean) {
                    boolean left = (Boolean)operandLeft;
                    boolean right = (Boolean)operandRight;
                    if (operator == UastBinaryOperator.LOGICAL_OR) {
                        return left || right;
                    }
                    if (operator == UastBinaryOperator.LOGICAL_AND) {
                        return left && right;
                    }
                    if (operator == UastBinaryOperator.BITWISE_OR) {
                        return left | right;
                    }
                    if (operator == UastBinaryOperator.BITWISE_XOR) {
                        return left ^ right;
                    }
                    if (operator == UastBinaryOperator.BITWISE_AND) {
                        return left & right;
                    }
                    if (operator == UastBinaryOperator.IDENTITY_EQUALS || operator == UastBinaryOperator.EQUALS) {
                        return left == right;
                    }
                    if (operator == UastBinaryOperator.IDENTITY_NOT_EQUALS || operator == UastBinaryOperator.NOT_EQUALS) {
                        return left != right;
                    }
                } else if (operandLeft instanceof Number && operandRight instanceof Number) {
                    boolean isWide;
                    boolean isInteger;
                    Number left = (Number)operandLeft;
                    Number right = (Number)operandRight;
                    boolean bl = isInteger = !(left instanceof Float) && !(left instanceof Double) && !(right instanceof Float) && !(right instanceof Double);
                    boolean bl2 = isInteger ? left instanceof Long || right instanceof Long : (isWide = left instanceof Double || right instanceof Double);
                    if (operator == UastBinaryOperator.BITWISE_OR) {
                        if (isWide) {
                            return left.longValue() | right.longValue();
                        }
                        return left.intValue() | right.intValue();
                    }
                    if (operator == UastBinaryOperator.BITWISE_XOR) {
                        if (isWide) {
                            return left.longValue() ^ right.longValue();
                        }
                        return left.intValue() ^ right.intValue();
                    }
                    if (operator == UastBinaryOperator.BITWISE_AND) {
                        if (isWide) {
                            return left.longValue() & right.longValue();
                        }
                        return left.intValue() & right.intValue();
                    }
                    if (operator == UastBinaryOperator.EQUALS || operator == UastBinaryOperator.IDENTITY_EQUALS) {
                        if (isInteger) {
                            return left.longValue() == right.longValue();
                        }
                        return left.doubleValue() == right.doubleValue();
                    }
                    if (operator == UastBinaryOperator.NOT_EQUALS || operator == UastBinaryOperator.IDENTITY_NOT_EQUALS) {
                        if (isInteger) {
                            return left.longValue() != right.longValue();
                        }
                        return left.doubleValue() != right.doubleValue();
                    }
                    if (operator == UastBinaryOperator.GREATER) {
                        if (isInteger) {
                            return left.longValue() > right.longValue();
                        }
                        return left.doubleValue() > right.doubleValue();
                    }
                    if (operator == UastBinaryOperator.GREATER_OR_EQUALS) {
                        if (isInteger) {
                            return left.longValue() >= right.longValue();
                        }
                        return left.doubleValue() >= right.doubleValue();
                    }
                    if (operator == UastBinaryOperator.LESS) {
                        if (isInteger) {
                            return left.longValue() < right.longValue();
                        }
                        return left.doubleValue() < right.doubleValue();
                    }
                    if (operator == UastBinaryOperator.LESS_OR_EQUALS) {
                        if (isInteger) {
                            return left.longValue() <= right.longValue();
                        }
                        return left.doubleValue() <= right.doubleValue();
                    }
                    if (operator == UastBinaryOperator.SHIFT_LEFT) {
                        if (isWide) {
                            return left.longValue() << right.intValue();
                        }
                        return left.intValue() << right.intValue();
                    }
                    if (operator == UastBinaryOperator.SHIFT_RIGHT) {
                        if (isWide) {
                            return left.longValue() >> right.intValue();
                        }
                        return left.intValue() >> right.intValue();
                    }
                    if (operator == UastBinaryOperator.UNSIGNED_SHIFT_RIGHT) {
                        if (isWide) {
                            return left.longValue() >>> right.intValue();
                        }
                        return left.intValue() >>> right.intValue();
                    }
                    if (operator == UastBinaryOperator.PLUS) {
                        if (isInteger) {
                            if (isWide) {
                                return left.longValue() + right.longValue();
                            }
                            return left.intValue() + right.intValue();
                        }
                        if (isWide) {
                            return left.doubleValue() + right.doubleValue();
                        }
                        return Float.valueOf(left.floatValue() + right.floatValue());
                    }
                    if (operator == UastBinaryOperator.MINUS) {
                        if (isInteger) {
                            if (isWide) {
                                return left.longValue() - right.longValue();
                            }
                            return left.intValue() - right.intValue();
                        }
                        if (isWide) {
                            return left.doubleValue() - right.doubleValue();
                        }
                        return Float.valueOf(left.floatValue() - right.floatValue());
                    }
                    if (operator == UastBinaryOperator.MULTIPLY) {
                        if (isInteger) {
                            if (isWide) {
                                return left.longValue() * right.longValue();
                            }
                            return left.intValue() * right.intValue();
                        }
                        if (isWide) {
                            return left.doubleValue() * right.doubleValue();
                        }
                        return Float.valueOf(left.floatValue() * right.floatValue());
                    }
                    if (operator == UastBinaryOperator.DIV) {
                        if (isInteger) {
                            if (isWide) {
                                return left.longValue() / right.longValue();
                            }
                            return left.intValue() / right.intValue();
                        }
                        if (isWide) {
                            return left.doubleValue() / right.doubleValue();
                        }
                        return Float.valueOf(left.floatValue() / right.floatValue());
                    }
                    if (operator == UastBinaryOperator.MOD) {
                        if (isInteger) {
                            if (isWide) {
                                return left.longValue() % right.longValue();
                            }
                            return left.intValue() % right.intValue();
                        }
                        if (isWide) {
                            return left.doubleValue() % right.doubleValue();
                        }
                        return Float.valueOf(left.floatValue() % right.floatValue());
                    }
                    return null;
                }
            } else {
                PsiType componentType;
                PsiType arrayType;
                UCallExpression call;
                if (node instanceof UBinaryExpressionWithType && ((UBinaryExpressionWithType)node).getOperationKind() == UastBinaryExpressionWithTypeKind.TYPE_CAST) {
                    UBinaryExpressionWithType cast = (UBinaryExpressionWithType)node;
                    Object operandValue = this.evaluate((UElement)cast.getOperand());
                    if (operandValue instanceof Number) {
                        Number number = (Number)operandValue;
                        PsiType type2 = cast.getType();
                        if (PsiType.FLOAT.equals((Object)type2)) {
                            return Float.valueOf(number.floatValue());
                        }
                        if (PsiType.DOUBLE.equals((Object)type2)) {
                            return number.doubleValue();
                        }
                        if (PsiType.INT.equals((Object)type2)) {
                            return number.intValue();
                        }
                        if (PsiType.LONG.equals((Object)type2)) {
                            return number.longValue();
                        }
                        if (PsiType.SHORT.equals((Object)type2)) {
                            return number.shortValue();
                        }
                        if (PsiType.BYTE.equals((Object)type2)) {
                            return number.byteValue();
                        }
                    }
                    return operandValue;
                }
                if (this.mContext != null && node instanceof UReferenceExpression) {
                    PsiElement resolved = ((UReferenceExpression)node).resolve();
                    if (resolved instanceof PsiVariable) {
                        PsiVariable variable2 = (PsiVariable)resolved;
                        Object value2 = UastLintUtils.findLastValue(variable2, node, this.mContext, this);
                        if (value2 != null) {
                            return value2;
                        }
                        if (variable2.getInitializer() != null) {
                            return this.evaluate((PsiElement)variable2.getInitializer());
                        }
                        return null;
                    }
                } else if (UastExpressionUtils.isNewArrayWithDimensions((UElement)((UExpression)node))) {
                    Object lengthObj;
                    PsiType componentType2;
                    call = (UCallExpression)node;
                    PsiType arrayType2 = call.getExpressionType();
                    if (arrayType2 instanceof PsiArrayType && !((componentType2 = ((PsiArrayType)arrayType2).getComponentType()) instanceof PsiArrayType) && call.getValueArgumentCount() == 1 && (lengthObj = this.evaluate((UElement)call.getValueArguments().get(0))) instanceof Number) {
                        int length = ((Number)lengthObj).intValue();
                        if (length > 30) {
                            length = 30;
                        }
                        if (componentType2 == PsiType.BOOLEAN) {
                            return new boolean[length];
                        }
                        if (ConstantEvaluator.isObjectType(componentType2)) {
                            return new Object[length];
                        }
                        if (componentType2 == PsiType.CHAR) {
                            return new char[length];
                        }
                        if (componentType2 == PsiType.BYTE) {
                            return new byte[length];
                        }
                        if (componentType2 == PsiType.DOUBLE) {
                            return new double[length];
                        }
                        if (componentType2 == PsiType.FLOAT) {
                            return new float[length];
                        }
                        if (componentType2 == PsiType.INT) {
                            return new int[length];
                        }
                        if (componentType2 == PsiType.SHORT) {
                            return new short[length];
                        }
                        if (componentType2 == PsiType.LONG) {
                            return new long[length];
                        }
                        if (ConstantEvaluator.isStringType(componentType2)) {
                            return new String[length];
                        }
                    }
                } else if (UastExpressionUtils.isNewArrayWithInitializer((UElement)node) && (arrayType = (call = (UCallExpression)node).getExpressionType()) instanceof PsiArrayType && !((componentType = ((PsiArrayType)arrayType).getComponentType()) instanceof PsiArrayType)) {
                    Object o;
                    Object[] arr;
                    int length = call.getValueArgumentCount();
                    ArrayList<Object> evaluatedArgs = new ArrayList<Object>(length);
                    for (UExpression arg : call.getValueArguments()) {
                        Object evaluatedArg = this.evaluate((UElement)arg);
                        if (!this.mAllowUnknown && evaluatedArg == null) {
                            return null;
                        }
                        evaluatedArgs.add(evaluatedArg);
                    }
                    if (componentType == PsiType.BOOLEAN) {
                        arr = new boolean[length];
                        for (int i = 0; i < length; ++i) {
                            o = evaluatedArgs.get(i);
                            if (!(o instanceof Boolean)) continue;
                            arr[i] = (Boolean)o;
                        }
                        return arr;
                    }
                    if (ConstantEvaluator.isObjectType(componentType)) {
                        arr = new Object[length];
                        for (int i = 0; i < length; ++i) {
                            arr[i] = evaluatedArgs.get(i);
                        }
                        return arr;
                    }
                    if (componentType.equals(PsiType.CHAR)) {
                        arr = new char[length];
                        for (int i = 0; i < length; ++i) {
                            o = evaluatedArgs.get(i);
                            if (!(o instanceof Character)) continue;
                            arr[i] = ((Character)o).charValue();
                        }
                        return arr;
                    }
                    if (componentType.equals(PsiType.BYTE)) {
                        arr = new byte[length];
                        for (int i = 0; i < length; ++i) {
                            o = evaluatedArgs.get(i);
                            if (!(o instanceof Byte)) continue;
                            arr[i] = (Byte)o;
                        }
                        return arr;
                    }
                    if (componentType.equals(PsiType.DOUBLE)) {
                        arr = new double[length];
                        for (int i = 0; i < length; ++i) {
                            o = evaluatedArgs.get(i);
                            if (!(o instanceof Double)) continue;
                            arr[i] = ((Double)o).doubleValue();
                        }
                        return arr;
                    }
                    if (componentType.equals(PsiType.FLOAT)) {
                        arr = new float[length];
                        for (int i = 0; i < length; ++i) {
                            o = evaluatedArgs.get(i);
                            if (!(o instanceof Float)) continue;
                            arr[i] = ((Float)o).floatValue();
                        }
                        return arr;
                    }
                    if (componentType.equals(PsiType.INT)) {
                        arr = new int[length];
                        for (int i = 0; i < length; ++i) {
                            o = evaluatedArgs.get(i);
                            if (!(o instanceof Integer)) continue;
                            arr[i] = (Integer)o;
                        }
                        return arr;
                    }
                    if (componentType.equals(PsiType.SHORT)) {
                        arr = new short[length];
                        for (int i = 0; i < length; ++i) {
                            o = evaluatedArgs.get(i);
                            if (!(o instanceof Short)) continue;
                            arr[i] = (Short)o;
                        }
                        return arr;
                    }
                    if (componentType.equals(PsiType.LONG)) {
                        arr = new long[length];
                        for (int i = 0; i < length; ++i) {
                            o = evaluatedArgs.get(i);
                            if (!(o instanceof Long)) continue;
                            arr[i] = ((Long)o).longValue();
                        }
                        return arr;
                    }
                    if (ConstantEvaluator.isStringType(componentType)) {
                        arr = new String[length];
                        for (int i = 0; i < length; ++i) {
                            o = evaluatedArgs.get(i);
                            if (!(o instanceof String)) continue;
                            arr[i] = (String)o;
                        }
                        return arr;
                    }
                }
            }
        }
        if (node instanceof UExpression && (evaluated = ((UExpression)node).evaluate()) != null) {
            return evaluated;
        }
        return null;
    }

    private static boolean isStringType(PsiType type2) {
        if (!(type2 instanceof PsiClassType)) {
            return false;
        }
        PsiClass resolvedClass = ((PsiClassType)type2).resolve();
        return resolvedClass != null && "java.lang.String".equals(resolvedClass.getQualifiedName());
    }

    private static boolean isObjectType(PsiType type2) {
        if (!(type2 instanceof PsiClassType)) {
            return false;
        }
        PsiClass resolvedClass = ((PsiClassType)type2).resolve();
        return resolvedClass != null && "java.lang.Object".equals(resolvedClass.getQualifiedName());
    }

    @Nullable
    public Object evaluate(@Nullable PsiElement node) {
        if (node == null) {
            return null;
        }
        if (node instanceof PsiLiteral) {
            return ((PsiLiteral)node).getValue();
        }
        if (node instanceof PsiPrefixExpression) {
            IElementType operator = ((PsiPrefixExpression)node).getOperationTokenType();
            Object operand2 = this.evaluate((PsiElement)((PsiPrefixExpression)node).getOperand());
            if (operand2 == null) {
                return null;
            }
            if (operator == JavaTokenType.EXCL) {
                if (operand2 instanceof Boolean) {
                    return (Boolean)operand2 == false;
                }
            } else {
                if (operator == JavaTokenType.PLUS) {
                    return operand2;
                }
                if (operator == JavaTokenType.TILDE) {
                    if (operand2 instanceof Integer) {
                        return ~((Integer)operand2).intValue();
                    }
                    if (operand2 instanceof Long) {
                        return (Long)operand2 ^ 0xFFFFFFFFFFFFFFFFL;
                    }
                    if (operand2 instanceof Short) {
                        return (int)(~((Short)operand2).shortValue());
                    }
                    if (operand2 instanceof Character) {
                        return (int)(~((Character)operand2).charValue());
                    }
                    if (operand2 instanceof Byte) {
                        return (int)(~((Byte)operand2).byteValue());
                    }
                } else if (operator == JavaTokenType.MINUS) {
                    if (operand2 instanceof Integer) {
                        return -((Integer)operand2).intValue();
                    }
                    if (operand2 instanceof Long) {
                        return -((Long)operand2).longValue();
                    }
                    if (operand2 instanceof Double) {
                        return -((Double)operand2).doubleValue();
                    }
                    if (operand2 instanceof Float) {
                        return Float.valueOf(-((Float)operand2).floatValue());
                    }
                    if (operand2 instanceof Short) {
                        return (int)(-((Short)operand2).shortValue());
                    }
                    if (operand2 instanceof Character) {
                        return (int)(-((Character)operand2).charValue());
                    }
                    if (operand2 instanceof Byte) {
                        return (int)(-((Byte)operand2).byteValue());
                    }
                }
            }
        } else if (node instanceof PsiConditionalExpression) {
            PsiConditionalExpression expression2 = (PsiConditionalExpression)node;
            Object known = this.evaluate((PsiElement)expression2.getCondition());
            if (known == Boolean.TRUE && expression2.getThenExpression() != null) {
                return this.evaluate((PsiElement)expression2.getThenExpression());
            }
            if (known == Boolean.FALSE && expression2.getElseExpression() != null) {
                return this.evaluate((PsiElement)expression2.getElseExpression());
            }
        } else if (node instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)node;
            PsiExpression expression3 = parenthesizedExpression.getExpression();
            if (expression3 != null) {
                return this.evaluate((PsiElement)expression3);
            }
        } else if (node instanceof PsiBinaryExpression) {
            IElementType operator = ((PsiBinaryExpression)node).getOperationTokenType();
            Object operandLeft = this.evaluate((PsiElement)((PsiBinaryExpression)node).getLOperand());
            Object operandRight = this.evaluate((PsiElement)((PsiBinaryExpression)node).getROperand());
            if (operandLeft == null || operandRight == null) {
                if (this.mAllowUnknown) {
                    if (operandLeft == null) {
                        return operandRight;
                    }
                    return operandLeft;
                }
                return null;
            }
            if (operandLeft instanceof String && operandRight instanceof String) {
                if (operator == JavaTokenType.PLUS) {
                    return operandLeft.toString() + operandRight.toString();
                }
                return null;
            }
            if (operandLeft instanceof Boolean && operandRight instanceof Boolean) {
                boolean left = (Boolean)operandLeft;
                boolean right = (Boolean)operandRight;
                if (operator == JavaTokenType.OROR) {
                    return left || right;
                }
                if (operator == JavaTokenType.ANDAND) {
                    return left && right;
                }
                if (operator == JavaTokenType.OR) {
                    return left | right;
                }
                if (operator == JavaTokenType.XOR) {
                    return left ^ right;
                }
                if (operator == JavaTokenType.AND) {
                    return left & right;
                }
                if (operator == JavaTokenType.EQEQ) {
                    return left == right;
                }
                if (operator == JavaTokenType.NE) {
                    return left != right;
                }
            } else if (operandLeft instanceof Number && operandRight instanceof Number) {
                boolean isWide;
                boolean isInteger;
                Number left = (Number)operandLeft;
                Number right = (Number)operandRight;
                boolean bl = isInteger = !(left instanceof Float) && !(left instanceof Double) && !(right instanceof Float) && !(right instanceof Double);
                boolean bl2 = isInteger ? left instanceof Long || right instanceof Long : (isWide = left instanceof Double || right instanceof Double);
                if (operator == JavaTokenType.OR) {
                    if (isWide) {
                        return left.longValue() | right.longValue();
                    }
                    return left.intValue() | right.intValue();
                }
                if (operator == JavaTokenType.XOR) {
                    if (isWide) {
                        return left.longValue() ^ right.longValue();
                    }
                    return left.intValue() ^ right.intValue();
                }
                if (operator == JavaTokenType.AND) {
                    if (isWide) {
                        return left.longValue() & right.longValue();
                    }
                    return left.intValue() & right.intValue();
                }
                if (operator == JavaTokenType.EQEQ) {
                    if (isInteger) {
                        return left.longValue() == right.longValue();
                    }
                    return left.doubleValue() == right.doubleValue();
                }
                if (operator == JavaTokenType.NE) {
                    if (isInteger) {
                        return left.longValue() != right.longValue();
                    }
                    return left.doubleValue() != right.doubleValue();
                }
                if (operator == JavaTokenType.GT) {
                    if (isInteger) {
                        return left.longValue() > right.longValue();
                    }
                    return left.doubleValue() > right.doubleValue();
                }
                if (operator == JavaTokenType.GE) {
                    if (isInteger) {
                        return left.longValue() >= right.longValue();
                    }
                    return left.doubleValue() >= right.doubleValue();
                }
                if (operator == JavaTokenType.LT) {
                    if (isInteger) {
                        return left.longValue() < right.longValue();
                    }
                    return left.doubleValue() < right.doubleValue();
                }
                if (operator == JavaTokenType.LE) {
                    if (isInteger) {
                        return left.longValue() <= right.longValue();
                    }
                    return left.doubleValue() <= right.doubleValue();
                }
                if (operator == JavaTokenType.LTLT) {
                    if (isWide) {
                        return left.longValue() << right.intValue();
                    }
                    return left.intValue() << right.intValue();
                }
                if (operator == JavaTokenType.GTGT) {
                    if (isWide) {
                        return left.longValue() >> right.intValue();
                    }
                    return left.intValue() >> right.intValue();
                }
                if (operator == JavaTokenType.GTGTGT) {
                    if (isWide) {
                        return left.longValue() >>> right.intValue();
                    }
                    return left.intValue() >>> right.intValue();
                }
                if (operator == JavaTokenType.PLUS) {
                    if (isInteger) {
                        if (isWide) {
                            return left.longValue() + right.longValue();
                        }
                        return left.intValue() + right.intValue();
                    }
                    if (isWide) {
                        return left.doubleValue() + right.doubleValue();
                    }
                    return Float.valueOf(left.floatValue() + right.floatValue());
                }
                if (operator == JavaTokenType.MINUS) {
                    if (isInteger) {
                        if (isWide) {
                            return left.longValue() - right.longValue();
                        }
                        return left.intValue() - right.intValue();
                    }
                    if (isWide) {
                        return left.doubleValue() - right.doubleValue();
                    }
                    return Float.valueOf(left.floatValue() - right.floatValue());
                }
                if (operator == JavaTokenType.ASTERISK) {
                    if (isInteger) {
                        if (isWide) {
                            return left.longValue() * right.longValue();
                        }
                        return left.intValue() * right.intValue();
                    }
                    if (isWide) {
                        return left.doubleValue() * right.doubleValue();
                    }
                    return Float.valueOf(left.floatValue() * right.floatValue());
                }
                if (operator == JavaTokenType.DIV) {
                    if (isInteger) {
                        if (isWide) {
                            return left.longValue() / right.longValue();
                        }
                        return left.intValue() / right.intValue();
                    }
                    if (isWide) {
                        return left.doubleValue() / right.doubleValue();
                    }
                    return Float.valueOf(left.floatValue() / right.floatValue());
                }
                if (operator == JavaTokenType.PERC) {
                    if (isInteger) {
                        if (isWide) {
                            return left.longValue() % right.longValue();
                        }
                        return left.intValue() % right.intValue();
                    }
                    if (isWide) {
                        return left.doubleValue() % right.doubleValue();
                    }
                    return Float.valueOf(left.floatValue() % right.floatValue());
                }
                return null;
            }
        } else {
            if (node instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression cast = (PsiTypeCastExpression)node;
                Object operandValue = this.evaluate((PsiElement)cast.getOperand());
                if (operandValue instanceof Number) {
                    Number number = (Number)operandValue;
                    PsiTypeElement typeElement = cast.getCastType();
                    if (typeElement != null) {
                        PsiType type2 = typeElement.getType();
                        if (PsiType.FLOAT.equals((Object)type2)) {
                            return Float.valueOf(number.floatValue());
                        }
                        if (PsiType.DOUBLE.equals((Object)type2)) {
                            return number.doubleValue();
                        }
                        if (PsiType.INT.equals((Object)type2)) {
                            return number.intValue();
                        }
                        if (PsiType.LONG.equals((Object)type2)) {
                            return number.longValue();
                        }
                        if (PsiType.SHORT.equals((Object)type2)) {
                            return number.shortValue();
                        }
                        if (PsiType.BYTE.equals((Object)type2)) {
                            return number.byteValue();
                        }
                    }
                }
                return operandValue;
            }
            if (node instanceof PsiReference) {
                PsiElement resolved = ((PsiReference)node).resolve();
                if (resolved instanceof PsiField) {
                    PsiField field = (PsiField)resolved;
                    Object value2 = field.computeConstantValue();
                    if (value2 != null) {
                        return value2;
                    }
                    if (field.getInitializer() != null) {
                        return this.evaluate((PsiElement)field.getInitializer());
                    }
                    return null;
                }
                if (resolved instanceof PsiLocalVariable) {
                    PsiLocalVariable variable2 = (PsiLocalVariable)resolved;
                    PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)node, PsiStatement.class, (boolean)false);
                    if (statement != null) {
                        PsiStatement prev = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)statement, PsiStatement.class);
                        String targetName = variable2.getName();
                        if (targetName == null) {
                            return null;
                        }
                        while (prev != null) {
                            PsiReferenceExpression reference;
                            PsiAssignmentExpression assign;
                            PsiExpression lhs;
                            PsiExpression expression4;
                            if (prev instanceof PsiDeclarationStatement) {
                                for (PsiElement element : ((PsiDeclarationStatement)prev).getDeclaredElements()) {
                                    if (!variable2.equals(element)) continue;
                                    return this.evaluate((PsiElement)variable2.getInitializer());
                                }
                            } else if (prev instanceof PsiExpressionStatement && (expression4 = ((PsiExpressionStatement)prev).getExpression()) instanceof PsiAssignmentExpression && (lhs = (assign = (PsiAssignmentExpression)expression4).getLExpression()) instanceof PsiReferenceExpression && targetName.equals((reference = (PsiReferenceExpression)lhs).getReferenceName()) && reference.getQualifier() == null) {
                                return this.evaluate((PsiElement)assign.getRExpression());
                            }
                            prev = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)prev, PsiStatement.class);
                        }
                    }
                }
            } else if (node instanceof PsiNewExpression) {
                PsiNewExpression creation = (PsiNewExpression)node;
                PsiArrayInitializerExpression initializer = creation.getArrayInitializer();
                PsiType type3 = creation.getType();
                if (type3 instanceof PsiArrayType) {
                    Object fixedSize;
                    if (initializer != null) {
                        int i;
                        Object[] array;
                        PsiExpression[] initializers = initializer.getInitializers();
                        Class<?> commonType = null;
                        ArrayList values = Lists.newArrayListWithExpectedSize((int)initializers.length);
                        int count = 0;
                        for (PsiExpression expression5 : initializers) {
                            Object value3 = this.evaluate((PsiElement)expression5);
                            if (value3 != null) {
                                values.add(value3);
                                if (commonType == null) {
                                    commonType = value3.getClass();
                                } else {
                                    while (!commonType.isAssignableFrom(value3.getClass())) {
                                        commonType = commonType.getSuperclass();
                                    }
                                }
                            } else if (!this.mAllowUnknown) {
                                return null;
                            }
                            if (++count == 20) break;
                        }
                        if ((type3 = type3.getDeepComponentType()) == PsiType.INT) {
                            if (!values.isEmpty()) {
                                array = new int[values.size()];
                                for (i = 0; i < values.size(); ++i) {
                                    Object o = values.get(i);
                                    if (!(o instanceof Integer)) continue;
                                    array[i] = (Integer)o;
                                }
                                return array;
                            }
                            return new int[0];
                        }
                        if (type3 == PsiType.BOOLEAN) {
                            if (!values.isEmpty()) {
                                array = new boolean[values.size()];
                                for (i = 0; i < values.size(); ++i) {
                                    Object o = values.get(i);
                                    if (!(o instanceof Boolean)) continue;
                                    array[i] = ((Boolean)o).booleanValue() ? 1 : 0;
                                }
                                return array;
                            }
                            return new boolean[0];
                        }
                        if (type3 == PsiType.DOUBLE) {
                            if (!values.isEmpty()) {
                                array = new double[values.size()];
                                for (i = 0; i < values.size(); ++i) {
                                    Object o = values.get(i);
                                    if (!(o instanceof Double)) continue;
                                    array[i] = (int)((Double)o).doubleValue();
                                }
                                return array;
                            }
                            return new double[0];
                        }
                        if (type3 == PsiType.LONG) {
                            if (!values.isEmpty()) {
                                array = new long[values.size()];
                                for (i = 0; i < values.size(); ++i) {
                                    Object o = values.get(i);
                                    if (!(o instanceof Long)) continue;
                                    array[i] = (int)((Long)o).longValue();
                                }
                                return array;
                            }
                            return new long[0];
                        }
                        if (type3 == PsiType.FLOAT) {
                            if (!values.isEmpty()) {
                                array = new float[values.size()];
                                for (i = 0; i < values.size(); ++i) {
                                    Object o = values.get(i);
                                    if (!(o instanceof Float)) continue;
                                    array[i] = (int)((Float)o).floatValue();
                                }
                                return array;
                            }
                            return new float[0];
                        }
                        if (type3 == PsiType.CHAR) {
                            if (!values.isEmpty()) {
                                array = new char[values.size()];
                                for (i = 0; i < values.size(); ++i) {
                                    Object o = values.get(i);
                                    if (!(o instanceof Character)) continue;
                                    array[i] = ((Character)o).charValue();
                                }
                                return array;
                            }
                            return new char[0];
                        }
                        if (type3 == PsiType.BYTE) {
                            if (!values.isEmpty()) {
                                array = new byte[values.size()];
                                for (i = 0; i < values.size(); ++i) {
                                    Object o = values.get(i);
                                    if (!(o instanceof Byte)) continue;
                                    array[i] = ((Byte)o).byteValue();
                                }
                                return array;
                            }
                            return new byte[0];
                        }
                        if (type3 == PsiType.SHORT) {
                            if (!values.isEmpty()) {
                                array = new short[values.size()];
                                for (i = 0; i < values.size(); ++i) {
                                    Object o = values.get(i);
                                    if (!(o instanceof Short)) continue;
                                    array[i] = ((Short)o).shortValue();
                                }
                                return array;
                            }
                            return new short[0];
                        }
                        if (!values.isEmpty()) {
                            Object o = Array.newInstance(commonType, values.size());
                            return values.toArray((Object[])o);
                        }
                        return null;
                    }
                    PsiExpression[] arrayDimensions = creation.getArrayDimensions();
                    int size = 0;
                    if (arrayDimensions.length == 1 && (fixedSize = this.evaluate((PsiElement)arrayDimensions[0])) instanceof Number && (size = ((Number)fixedSize).intValue()) > 30) {
                        size = 30;
                    }
                    if ((type3 = type3.getDeepComponentType()) instanceof PsiPrimitiveType) {
                        if (PsiType.BYTE.equals((Object)type3)) {
                            return new byte[size];
                        }
                        if (PsiType.BOOLEAN.equals((Object)type3)) {
                            return new boolean[size];
                        }
                        if (PsiType.INT.equals((Object)type3)) {
                            return new int[size];
                        }
                        if (PsiType.LONG.equals((Object)type3)) {
                            return new long[size];
                        }
                        if (PsiType.CHAR.equals((Object)type3)) {
                            return new char[size];
                        }
                        if (PsiType.FLOAT.equals((Object)type3)) {
                            return new float[size];
                        }
                        if (PsiType.DOUBLE.equals((Object)type3)) {
                            return new double[size];
                        }
                        if (PsiType.SHORT.equals((Object)type3)) {
                            return new short[size];
                        }
                    } else if (type3 instanceof PsiClassType) {
                        String className = type3.getCanonicalText();
                        if ("java.lang.String".equals(className)) {
                            return new String[size];
                        }
                        if ("java.lang.Object".equals(className)) {
                            return new Object[size];
                        }
                    }
                }
            }
        }
        return null;
    }

    public static boolean isArrayLiteral(@Nullable UElement node, @NonNull JavaContext context) {
        if (node instanceof UReferenceExpression) {
            PsiVariable variable2;
            UExpression lastAssignment;
            PsiElement resolved = ((UReferenceExpression)node).resolve();
            if (resolved instanceof PsiVariable && (lastAssignment = UastLintUtils.findLastAssignment(variable2 = (PsiVariable)resolved, node, context)) != null) {
                return ConstantEvaluator.isArrayLiteral((UElement)lastAssignment, context);
            }
        } else {
            if (UastExpressionUtils.isNewArrayWithDimensions((UElement)node)) {
                return true;
            }
            if (UastExpressionUtils.isNewArrayWithInitializer((UElement)node)) {
                return true;
            }
            if (node instanceof UParenthesizedExpression) {
                UParenthesizedExpression parenthesizedExpression = (UParenthesizedExpression)node;
                UExpression expression2 = parenthesizedExpression.getExpression();
                return ConstantEvaluator.isArrayLiteral((UElement)expression2, context);
            }
            if (UastExpressionUtils.isTypeCast((UElement)node)) {
                UBinaryExpressionWithType castExpression = (UBinaryExpressionWithType)node;
                assert (castExpression != null);
                UExpression operand2 = castExpression.getOperand();
                return ConstantEvaluator.isArrayLiteral((UElement)operand2, context);
            }
        }
        return false;
    }

    public static boolean isArrayLiteral(@Nullable PsiElement node) {
        PsiTypeCastExpression castExpression;
        PsiExpression operand2;
        if (node instanceof PsiReference) {
            PsiElement resolved = ((PsiReference)node).resolve();
            if (resolved instanceof PsiField) {
                PsiField field = (PsiField)resolved;
                if (field.getInitializer() != null) {
                    return ConstantEvaluator.isArrayLiteral((PsiElement)field.getInitializer());
                }
            } else if (resolved instanceof PsiLocalVariable) {
                PsiLocalVariable variable2 = (PsiLocalVariable)resolved;
                PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)node, PsiStatement.class, (boolean)false);
                if (statement != null) {
                    PsiStatement prev = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)statement, PsiStatement.class);
                    String targetName = variable2.getName();
                    if (targetName == null) {
                        return false;
                    }
                    while (prev != null) {
                        PsiReferenceExpression reference;
                        PsiAssignmentExpression assign;
                        PsiExpression lhs;
                        PsiExpression expression2;
                        if (prev instanceof PsiDeclarationStatement) {
                            for (PsiElement element : ((PsiDeclarationStatement)prev).getDeclaredElements()) {
                                if (!variable2.equals(element)) continue;
                                return ConstantEvaluator.isArrayLiteral((PsiElement)variable2.getInitializer());
                            }
                        } else if (prev instanceof PsiExpressionStatement && (expression2 = ((PsiExpressionStatement)prev).getExpression()) instanceof PsiAssignmentExpression && (lhs = (assign = (PsiAssignmentExpression)expression2).getLExpression()) instanceof PsiReferenceExpression && targetName.equals((reference = (PsiReferenceExpression)lhs).getReferenceName()) && reference.getQualifier() == null) {
                            return ConstantEvaluator.isArrayLiteral((PsiElement)assign.getRExpression());
                        }
                        prev = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)prev, PsiStatement.class);
                    }
                }
            }
        } else if (node instanceof PsiNewExpression) {
            PsiNewExpression creation = (PsiNewExpression)node;
            if (creation.getArrayInitializer() != null) {
                return true;
            }
            PsiType type2 = creation.getType();
            if (type2 instanceof PsiArrayType) {
                return true;
            }
        } else if (node instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)node;
            PsiExpression expression3 = parenthesizedExpression.getExpression();
            if (expression3 != null) {
                return ConstantEvaluator.isArrayLiteral((PsiElement)expression3);
            }
        } else if (node instanceof PsiTypeCastExpression && (operand2 = (castExpression = (PsiTypeCastExpression)node).getOperand()) != null) {
            return ConstantEvaluator.isArrayLiteral((PsiElement)operand2);
        }
        return false;
    }

    @Deprecated
    @Nullable
    public static Object evaluate(@NonNull JavaContext context, @NonNull Node node) {
        return new ConstantEvaluator(context).evaluate(node);
    }

    @Deprecated
    @Nullable
    public static String evaluateString(@NonNull JavaContext context, @NonNull Node node, boolean allowUnknown) {
        Object value2;
        ConstantEvaluator evaluator = new ConstantEvaluator(context);
        if (allowUnknown) {
            evaluator.allowUnknowns();
        }
        return (value2 = evaluator.evaluate(node)) instanceof String ? (String)value2 : null;
    }

    @Nullable
    public static Object evaluate(@Nullable JavaContext context, @NonNull PsiElement node) {
        return new ConstantEvaluator(context).evaluate(node);
    }

    @Nullable
    public static Object evaluate(@Nullable JavaContext context, @NonNull UElement node) {
        return new ConstantEvaluator(context).evaluate(node);
    }

    @Nullable
    public static String evaluateString(@Nullable JavaContext context, @NonNull PsiElement node, boolean allowUnknown) {
        Object value2;
        ConstantEvaluator evaluator = new ConstantEvaluator(context);
        if (allowUnknown) {
            evaluator.allowUnknowns();
        }
        return (value2 = evaluator.evaluate(node)) instanceof String ? (String)value2 : null;
    }

    @Nullable
    public static String evaluateString(@Nullable JavaContext context, @NonNull UElement node, boolean allowUnknown) {
        Object value2;
        ConstantEvaluator evaluator = new ConstantEvaluator(context);
        if (allowUnknown) {
            evaluator.allowUnknowns();
        }
        return (value2 = evaluator.evaluate(node)) instanceof String ? (String)value2 : null;
    }

    public static class LastAssignmentFinder
    extends AbstractUastVisitor {
        private final PsiVariable mVariable;
        private final UElement mEndAt;
        private final ConstantEvaluator mConstantEvaluator;
        private boolean mDone = false;
        private int mCurrentLevel = 0;
        private int mVariableLevel = -1;
        private Object mCurrentValue;
        private UElement mLastAssignment;

        public LastAssignmentFinder(@NonNull PsiVariable variable2, @NonNull UElement endAt, @NonNull JavaContext context, @Nullable ConstantEvaluator constantEvaluator, int variableLevel) {
            this.mVariable = variable2;
            this.mEndAt = endAt;
            UExpression initializer = context.getUastContext().getInitializerBody(variable2);
            this.mLastAssignment = initializer;
            this.mConstantEvaluator = constantEvaluator;
            if (initializer != null && constantEvaluator != null) {
                this.mCurrentValue = constantEvaluator.evaluate((UElement)initializer);
            }
            this.mVariableLevel = variableLevel;
        }

        @Nullable
        public Object getCurrentValue() {
            return this.mCurrentValue;
        }

        @Nullable
        public UElement getLastAssignment() {
            return this.mLastAssignment;
        }

        public boolean visitElement(UElement node) {
            if (LastAssignmentFinder.elementHasLevel(node)) {
                ++this.mCurrentLevel;
            }
            if (node.equals(this.mEndAt)) {
                this.mDone = true;
            }
            return this.mDone || super.visitElement(node);
        }

        public boolean visitVariable(UVariable node) {
            if (this.mVariableLevel < 0 && node.getPsi().isEquivalentTo((PsiElement)this.mVariable)) {
                this.mVariableLevel = this.mCurrentLevel;
            }
            return super.visitVariable(node);
        }

        public void afterVisitBinaryExpression(UBinaryExpression node) {
            if (!this.mDone && node.getOperator() instanceof UastBinaryOperator.AssignOperator && this.mVariableLevel >= 0) {
                UExpression leftOperand2 = node.getLeftOperand();
                UastBinaryOperator operator = node.getOperator();
                if (!(operator instanceof UastBinaryOperator.AssignOperator) || !(leftOperand2 instanceof UResolvable)) {
                    return;
                }
                PsiElement resolved = ((UResolvable)leftOperand2).resolve();
                if (!this.mVariable.equals(resolved)) {
                    return;
                }
                if (this.mCurrentLevel > this.mVariableLevel + 1) {
                    this.mLastAssignment = null;
                    this.mCurrentValue = null;
                    return;
                }
                UExpression rightOperand2 = node.getRightOperand();
                ConstantEvaluator constantEvaluator = this.mConstantEvaluator;
                this.mCurrentValue = constantEvaluator != null ? constantEvaluator.evaluate((UElement)rightOperand2) : null;
                this.mLastAssignment = rightOperand2;
            }
            super.afterVisitBinaryExpression(node);
        }

        public void afterVisitElement(UElement node) {
            if (LastAssignmentFinder.elementHasLevel(node)) {
                --this.mCurrentLevel;
            }
            super.afterVisitElement(node);
        }

        private static boolean elementHasLevel(UElement node) {
            return !(node instanceof UBlockExpression) && !(node instanceof UDeclarationsExpression);
        }
    }
}

