/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.awt.AWT;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.Robot;
import org.fest.swing.core.Settings;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.timing.Pause;
import org.fest.swing.util.Platform;
import org.fest.swing.util.TimeoutWatch;
import org.fest.util.Preconditions;

public class ComponentDragAndDrop {
    private final Robot robot;
    public static final int DRAG_THRESHOLD = Platform.isWindows() || Platform.isMacintosh() ? 10 : 16;

    public ComponentDragAndDrop(@Nonnull Robot robot) {
        if (robot == null) {
            ComponentDragAndDrop.$$$reportNull$$$0(0);
        }
        this.robot = robot;
    }

    @RunsInEDT
    public void drag(@Nonnull Component target, @Nonnull Point where) {
        if (target == null) {
            ComponentDragAndDrop.$$$reportNull$$$0(1);
        }
        if (where == null) {
            ComponentDragAndDrop.$$$reportNull$$$0(2);
        }
        this.robot.pressMouse(target, where, MouseButton.LEFT_BUTTON);
        int dragDelay = this.settings().dragDelay();
        if (dragDelay > this.delayBetweenEvents()) {
            Pause.pause(dragDelay);
        }
        this.mouseMove(target, where.x, where.y);
        this.robot.waitForIdle();
    }

    private void mouseMove(@Nonnull Component target, int x, int y) {
        if (target == null) {
            ComponentDragAndDrop.$$$reportNull$$$0(3);
        }
        if (Platform.isWindows() || Platform.isMacintosh()) {
            this.mouseMoveOnWindowsAndMacintosh(target, x, y);
            return;
        }
        this.mouseMove(target, ComponentDragAndDrop.point(x + DRAG_THRESHOLD / 2, y + DRAG_THRESHOLD / 2), ComponentDragAndDrop.point(x + DRAG_THRESHOLD, y + DRAG_THRESHOLD), ComponentDragAndDrop.point(x + DRAG_THRESHOLD / 2, y + DRAG_THRESHOLD / 2), ComponentDragAndDrop.point(x, y));
    }

    @RunsInEDT
    private void mouseMoveOnWindowsAndMacintosh(@Nonnull Component target, int x, int y) {
        if (target == null) {
            ComponentDragAndDrop.$$$reportNull$$$0(4);
        }
        Dimension size = target.getSize();
        int dx = ComponentDragAndDrop.distance(x, size.width);
        int dy = ComponentDragAndDrop.distance(y, size.height);
        if (dx == 0 && dy == 0) {
            dx = DRAG_THRESHOLD;
        }
        this.mouseMove(target, ComponentDragAndDrop.point(x + dx / 4, y + dy / 4), ComponentDragAndDrop.point(x + dx / 2, y + dy / 2), ComponentDragAndDrop.point(x + dx, y + dy), ComponentDragAndDrop.point(x + dx + 1, y + dy));
    }

    private static int distance(int coordinate, int dimension) {
        return coordinate + DRAG_THRESHOLD < dimension ? DRAG_THRESHOLD : 0;
    }

    @Nonnull
    private static Point point(int x, int y) {
        Point point = new Point(x, y);
        if (point == null) {
            ComponentDragAndDrop.$$$reportNull$$$0(5);
        }
        return point;
    }

    @RunsInEDT
    public void drop(@Nonnull Component target, @Nonnull Point where) {
        int delayBetweenEvents;
        if (target == null) {
            ComponentDragAndDrop.$$$reportNull$$$0(6);
        }
        if (where == null) {
            ComponentDragAndDrop.$$$reportNull$$$0(7);
        }
        this.dragOver(target, where);
        TimeoutWatch watch = TimeoutWatch.startWatchWithTimeoutOf(this.settings().eventPostingDelay() * 4);
        while (!this.robot.isDragging()) {
            if (watch.isTimeOut()) {
                throw ActionFailedException.actionFailure("There is no drag in effect");
            }
            Pause.pause();
        }
        int dropDelay = this.settings().dropDelay();
        if (dropDelay > (delayBetweenEvents = this.delayBetweenEvents())) {
            Pause.pause(dropDelay - delayBetweenEvents);
        }
        this.robot.releaseMouseButtons();
        this.robot.waitForIdle();
    }

    private int delayBetweenEvents() {
        return this.settings().delayBetweenEvents();
    }

    @Nonnull
    private Settings settings() {
        Settings settings = this.robot.settings();
        if (settings == null) {
            ComponentDragAndDrop.$$$reportNull$$$0(8);
        }
        return settings;
    }

    public void dragOver(@Nonnull Component target, @Nonnull Point where) {
        if (target == null) {
            ComponentDragAndDrop.$$$reportNull$$$0(9);
        }
        if (where == null) {
            ComponentDragAndDrop.$$$reportNull$$$0(10);
        }
        this.dragOver(target, where.x, where.y);
    }

    private void dragOver(@Nonnull Component target, int x, int y) {
        if (target == null) {
            ComponentDragAndDrop.$$$reportNull$$$0(11);
        }
        this.robot.moveMouse(target, x - 4, y);
        this.robot.moveMouse(target, x, y);
    }

    private void mouseMove(@Nonnull Component target, Point ... points) {
        if (target == null) {
            ComponentDragAndDrop.$$$reportNull$$$0(12);
        }
        if (points == null) {
            ComponentDragAndDrop.$$$reportNull$$$0(13);
        }
        ArrayList<Point> translatedPoints = new ArrayList<Point>(points.length);
        for (Point point : points) {
            Point newPoint = (Point)Preconditions.checkNotNull((Object)AWT.locationOnScreenOf(target));
            newPoint.translate(point.x, point.y);
            translatedPoints.add(newPoint);
        }
        for (Point point : translatedPoints) {
            this.robot.moveMouse(point.x, point.y);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "robot";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "where";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/core/ComponentDragAndDrop";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "points";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/core/ComponentDragAndDrop";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "point";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "drag";
                break;
            }
            case 3: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "mouseMove";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "mouseMoveOnWindowsAndMacintosh";
                break;
            }
            case 5: 
            case 8: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "drop";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "dragOver";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

