/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.Component;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.ComponentMatcher;
import org.fest.swing.core.GenericTypeMatcher;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.hierarchy.ComponentHierarchy;
import org.fest.util.Preconditions;
import org.fest.util.Sets;

final class FinderDelegate {
    FinderDelegate() {
    }

    @Nonnull
    @RunsInEDT
    Collection<Component> find(@Nonnull ComponentHierarchy h, @Nonnull ComponentMatcher m) {
        if (h == null) {
            FinderDelegate.$$$reportNull$$$0(0);
        }
        if (m == null) {
            FinderDelegate.$$$reportNull$$$0(1);
        }
        LinkedHashSet found = Sets.newLinkedHashSet();
        for (Component component : FinderDelegate.rootsOf(h)) {
            this.find(h, m, (Component)Preconditions.checkNotNull((Object)component), found);
        }
        LinkedHashSet linkedHashSet = found;
        if (linkedHashSet == null) {
            FinderDelegate.$$$reportNull$$$0(2);
        }
        return linkedHashSet;
    }

    @RunsInEDT
    private void find(@Nonnull ComponentHierarchy h, @Nonnull ComponentMatcher m, @Nonnull Component root, @Nonnull Set<Component> found) {
        if (h == null) {
            FinderDelegate.$$$reportNull$$$0(3);
        }
        if (m == null) {
            FinderDelegate.$$$reportNull$$$0(4);
        }
        if (root == null) {
            FinderDelegate.$$$reportNull$$$0(5);
        }
        if (found == null) {
            FinderDelegate.$$$reportNull$$$0(6);
        }
        for (Component c : FinderDelegate.childrenOfComponent(root, h)) {
            this.find(h, m, (Component)Preconditions.checkNotNull((Object)c), found);
        }
        if (FinderDelegate.isMatching(root, m)) {
            found.add(root);
        }
    }

    @Nonnull
    @RunsInEDT
    private static Collection<Component> childrenOfComponent(final @Nonnull Component c, final @Nonnull ComponentHierarchy h) {
        if (c == null) {
            FinderDelegate.$$$reportNull$$$0(7);
        }
        if (h == null) {
            FinderDelegate.$$$reportNull$$$0(8);
        }
        Collection<Component> children = GuiActionRunner.execute(new GuiQuery<Collection<Component>>(){

            @Override
            protected Collection<Component> executeInEDT() {
                return h.childrenOf(c);
            }
        });
        Collection collection = (Collection)Preconditions.checkNotNull(children);
        if (collection == null) {
            FinderDelegate.$$$reportNull$$$0(9);
        }
        return collection;
    }

    @RunsInEDT
    private static boolean isMatching(final @Nonnull Component c, final @Nonnull ComponentMatcher m) {
        if (c == null) {
            FinderDelegate.$$$reportNull$$$0(10);
        }
        if (m == null) {
            FinderDelegate.$$$reportNull$$$0(11);
        }
        Boolean matching = GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() {
                return m.matches(c);
            }
        });
        return (Boolean)Preconditions.checkNotNull((Object)matching);
    }

    @Nonnull
    @RunsInEDT
    <T extends Component> Collection<T> find(@Nonnull ComponentHierarchy h, @Nonnull GenericTypeMatcher<T> m) {
        if (h == null) {
            FinderDelegate.$$$reportNull$$$0(12);
        }
        if (m == null) {
            FinderDelegate.$$$reportNull$$$0(13);
        }
        LinkedHashSet found = Sets.newLinkedHashSet();
        for (Component component : FinderDelegate.rootsOf(h)) {
            this.find(h, m, (Component)Preconditions.checkNotNull((Object)component), found);
        }
        LinkedHashSet linkedHashSet = found;
        if (linkedHashSet == null) {
            FinderDelegate.$$$reportNull$$$0(14);
        }
        return linkedHashSet;
    }

    @Nonnull
    @RunsInEDT
    private static Collection<? extends Component> rootsOf(final @Nonnull ComponentHierarchy h) {
        if (h == null) {
            FinderDelegate.$$$reportNull$$$0(15);
        }
        Collection<? extends Component> roots = GuiActionRunner.execute(new GuiQuery<Collection<? extends Component>>(){

            @Override
            protected Collection<? extends Component> executeInEDT() {
                return h.roots();
            }
        });
        Collection collection = (Collection)Preconditions.checkNotNull(roots);
        if (collection == null) {
            FinderDelegate.$$$reportNull$$$0(16);
        }
        return collection;
    }

    @RunsInEDT
    private <T extends Component> void find(@Nonnull ComponentHierarchy h, @Nonnull GenericTypeMatcher<T> m, @Nonnull Component root, Set<T> found) {
        if (h == null) {
            FinderDelegate.$$$reportNull$$$0(17);
        }
        if (m == null) {
            FinderDelegate.$$$reportNull$$$0(18);
        }
        if (root == null) {
            FinderDelegate.$$$reportNull$$$0(19);
        }
        for (Component c : FinderDelegate.childrenOfComponent(root, h)) {
            this.find(h, m, (Component)Preconditions.checkNotNull((Object)c), found);
        }
        if (FinderDelegate.isMatching(root, m)) {
            found.add(m.supportedType().cast(root));
        }
    }

    @RunsInEDT
    private static <T extends Component> boolean isMatching(final @Nonnull Component c, final @Nonnull GenericTypeMatcher<T> m) {
        if (c == null) {
            FinderDelegate.$$$reportNull$$$0(20);
        }
        if (m == null) {
            FinderDelegate.$$$reportNull$$$0(21);
        }
        Boolean matching = GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() {
                return m.matches(c);
            }
        });
        return (Boolean)Preconditions.checkNotNull((Object)matching);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 9: 
            case 14: 
            case 16: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 9: 
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "h";
                break;
            }
            case 1: 
            case 4: 
            case 11: 
            case 13: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 2: 
            case 9: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/core/FinderDelegate";
                break;
            }
            case 5: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "found";
                break;
            }
            case 7: 
            case 10: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/core/FinderDelegate";
                break;
            }
            case 2: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "find";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "childrenOfComponent";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "rootsOf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 2: 
            case 9: 
            case 14: 
            case 16: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "childrenOfComponent";
                break;
            }
            case 10: 
            case 11: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isMatching";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "rootsOf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 9: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

