/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.Component;
import java.util.List;
import javax.annotation.Nonnull;
import javax.swing.JOptionPane;
import org.fest.assertions.Fail;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.ComponentFinder;
import org.fest.swing.core.ComponentMatcher;
import org.fest.swing.core.TypeMatcher;
import org.fest.swing.format.Formatting;
import org.fest.util.Lists;

class UnexpectedJOptionPaneFinder {
    static final ComponentMatcher OPTION_PANE_MATCHER = new TypeMatcher(JOptionPane.class, true);
    private final ComponentFinder finder;

    UnexpectedJOptionPaneFinder(@Nonnull ComponentFinder finder) {
        if (finder == null) {
            UnexpectedJOptionPaneFinder.$$$reportNull$$$0(0);
        }
        this.finder = finder;
    }

    @RunsInEDT
    void requireNoJOptionPaneIsShowing() {
        List<Component> found = this.findAll(OPTION_PANE_MATCHER);
        if (!found.isEmpty()) {
            throw this.unexpectedJOptionPanesFound(found);
        }
    }

    private List<Component> findAll(@Nonnull ComponentMatcher m) {
        if (m == null) {
            UnexpectedJOptionPaneFinder.$$$reportNull$$$0(1);
        }
        return Lists.newArrayList(this.finder.findAll(m));
    }

    @Nonnull
    private AssertionError unexpectedJOptionPanesFound(@Nonnull List<Component> found) {
        if (found == null) {
            UnexpectedJOptionPaneFinder.$$$reportNull$$$0(2);
        }
        StringBuilder message = new StringBuilder();
        message.append("Expecting no JOptionPane to be showing, but found:<[");
        int size = found.size();
        for (int i = 0; i < size; ++i) {
            message.append(Formatting.format(found.get(i)));
            if (i == size - 1) continue;
            message.append(", ");
        }
        message.append("]>");
        throw Fail.fail((String)message.toString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "found";
                break;
            }
        }
        objectArray2[1] = "org/fest/swing/core/UnexpectedJOptionPaneFinder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findAll";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "unexpectedJOptionPanesFound";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

