/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.cell.JTableCellWriter;
import org.fest.swing.core.ComponentFoundCondition;
import org.fest.swing.core.ComponentMatcher;
import org.fest.swing.core.Robot;
import org.fest.swing.core.TypeMatcher;
import org.fest.swing.driver.ComponentPreconditions;
import org.fest.swing.driver.JTableCancelCellEditingTask;
import org.fest.swing.driver.JTableCellEditorQuery;
import org.fest.swing.driver.JTableCellPreconditions;
import org.fest.swing.driver.JTableLocation;
import org.fest.swing.driver.JTableStopCellEditingTask;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.exception.WaitTimedOutError;
import org.fest.swing.timing.Condition;
import org.fest.swing.timing.Pause;
import org.fest.util.Preconditions;
import org.fest.util.Strings;

public abstract class AbstractJTableCellWriter
implements JTableCellWriter {
    protected final Robot robot;
    private final JTableLocation location;
    private TableCellEditor cellEditor;
    private static final long EDITOR_LOOKUP_TIMEOUT = 5000L;

    public AbstractJTableCellWriter(@Nonnull Robot robot) {
        if (robot == null) {
            AbstractJTableCellWriter.$$$reportNull$$$0(0);
        }
        this.location = new JTableLocation();
        this.robot = robot;
    }

    @Override
    @RunsInEDT
    public void cancelCellEditing(@Nonnull JTable table, int row, int column) {
        if (table == null) {
            AbstractJTableCellWriter.$$$reportNull$$$0(1);
        }
        if (this.cellEditor == null) {
            this.doCancelCellEditing(table, row, column);
            return;
        }
        this.doCancelCellEditing();
    }

    @RunsInEDT
    private void doCancelCellEditing(@Nonnull JTable table, int row, int column) {
        if (table == null) {
            AbstractJTableCellWriter.$$$reportNull$$$0(2);
        }
        JTableCancelCellEditingTask.cancelEditing(table, row, column);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private void doCancelCellEditing() {
        JTableCancelCellEditingTask.cancelEditing(this.cellEditor);
        this.robot.waitForIdle();
    }

    @Override
    @RunsInEDT
    public void stopCellEditing(@Nonnull JTable table, int row, int column) {
        if (table == null) {
            AbstractJTableCellWriter.$$$reportNull$$$0(3);
        }
        if (this.cellEditor == null) {
            this.doStopCellEditing(table, row, column);
            return;
        }
        this.doStopCellEditing();
    }

    @RunsInEDT
    private void doStopCellEditing(@Nonnull JTable table, int row, int column) {
        if (table == null) {
            AbstractJTableCellWriter.$$$reportNull$$$0(4);
        }
        JTableStopCellEditingTask.checkStateAndStopEditing(table, row, column);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private void doStopCellEditing() {
        JTableStopCellEditingTask.stopEditing(this.cellEditor);
        this.robot.waitForIdle();
    }

    @Nullable
    @RunsInEDT
    protected static TableCellEditor cellEditor(final @Nonnull JTable table, final int row, final int column) {
        if (table == null) {
            AbstractJTableCellWriter.$$$reportNull$$$0(5);
        }
        return GuiActionRunner.execute(new GuiQuery<TableCellEditor>(){

            @Override
            @Nullable
            protected TableCellEditor executeInEDT() throws Throwable {
                return table.getCellEditor(row, column);
            }
        });
    }

    @RunsInCurrentThread
    protected static void scrollToCell(JTable table, int row, int column, JTableLocation location) {
        table.scrollRectToVisible(location.cellBounds(table, row, column));
    }

    @Override
    @Nullable
    @RunsInEDT
    public Component editorForCell(@Nonnull JTable table, int row, int column) {
        if (table == null) {
            AbstractJTableCellWriter.$$$reportNull$$$0(6);
        }
        return AbstractJTableCellWriter.cellEditorComponent(table, row, column);
    }

    @Nullable
    @RunsInEDT
    private static Component cellEditorComponent(final @Nonnull JTable table, final int row, final int column) {
        if (table == null) {
            AbstractJTableCellWriter.$$$reportNull$$$0(7);
        }
        return GuiActionRunner.execute(new GuiQuery<Component>(){

            @Override
            @Nullable
            protected Component executeInEDT() {
                JTableCellPreconditions.checkCellIndicesInBounds(table, row, column);
                return JTableCellEditorQuery.cellEditorIn(table, row, column);
            }
        });
    }

    @Nonnull
    @RunsInCurrentThread
    protected static <T extends Component> T editor(@Nonnull JTable table, int row, int column, @Nonnull Class<T> supportedType) {
        if (table == null) {
            AbstractJTableCellWriter.$$$reportNull$$$0(8);
        }
        if (supportedType == null) {
            AbstractJTableCellWriter.$$$reportNull$$$0(9);
        }
        AbstractJTableCellWriter.validate(table, row, column);
        Component editor = JTableCellEditorQuery.cellEditorIn(table, row, column);
        if (supportedType.isInstance(editor)) {
            Component component = (Component)supportedType.cast(editor);
            if (component == null) {
                AbstractJTableCellWriter.$$$reportNull$$$0(10);
            }
            return (T)component;
        }
        throw AbstractJTableCellWriter.cannotFindOrActivateEditor(row, column);
    }

    @Nonnull
    @RunsInEDT
    protected static Point cellLocation(final @Nonnull JTable table, final int row, final int column, final @Nonnull JTableLocation location) {
        if (table == null) {
            AbstractJTableCellWriter.$$$reportNull$$$0(11);
        }
        if (location == null) {
            AbstractJTableCellWriter.$$$reportNull$$$0(12);
        }
        Point result = GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            @Nullable
            protected Point executeInEDT() {
                AbstractJTableCellWriter.validate(table, row, column);
                AbstractJTableCellWriter.scrollToCell(table, row, column, location);
                return location.pointAt(table, row, column);
            }
        });
        Point point = (Point)Preconditions.checkNotNull((Object)result);
        if (point == null) {
            AbstractJTableCellWriter.$$$reportNull$$$0(13);
        }
        return point;
    }

    @RunsInCurrentThread
    protected static void validate(@Nonnull JTable table, int row, int column) {
        if (table == null) {
            AbstractJTableCellWriter.$$$reportNull$$$0(14);
        }
        JTableCellPreconditions.checkCellIndicesInBounds(table, row, column);
        ComponentPreconditions.checkEnabledAndShowing(table);
        JTableCellPreconditions.validateCellIsEditable(table, row, column);
    }

    @Nullable
    @RunsInEDT
    protected final <T extends Component> T waitForEditorActivation(@Nonnull JTable table, int row, int column, @Nonnull Class<T> supportedType) {
        if (table == null) {
            AbstractJTableCellWriter.$$$reportNull$$$0(15);
        }
        if (supportedType == null) {
            AbstractJTableCellWriter.$$$reportNull$$$0(16);
        }
        return this.waitForEditorActivation(new TypeMatcher(supportedType, true), table, row, column, supportedType);
    }

    @Nullable
    @RunsInEDT
    protected final <T extends Component> T waitForEditorActivation(@Nonnull ComponentMatcher matcher, @Nonnull JTable table, int row, int column, @Nonnull Class<T> supportedType) {
        if (matcher == null) {
            AbstractJTableCellWriter.$$$reportNull$$$0(17);
        }
        if (table == null) {
            AbstractJTableCellWriter.$$$reportNull$$$0(18);
        }
        if (supportedType == null) {
            AbstractJTableCellWriter.$$$reportNull$$$0(19);
        }
        ComponentFoundCondition condition = new ComponentFoundCondition("", this.robot.finder(), matcher, (Container)table);
        try {
            Pause.pause((Condition)condition, 5000L);
        }
        catch (WaitTimedOutError e) {
            throw AbstractJTableCellWriter.cannotFindOrActivateEditor(row, column);
        }
        return (T)((Component)supportedType.cast(condition.found()));
    }

    @Nonnull
    protected static ActionFailedException cannotFindOrActivateEditor(int row, int column) {
        String msg = Strings.concat((Object[])new Object[]{"Unable to find or activate editor for cell [", String.valueOf(row), ",", String.valueOf(column), "]"});
        throw ActionFailedException.actionFailure(msg);
    }

    @Nullable
    protected final TableCellEditor cellEditor() {
        return this.cellEditor;
    }

    protected final void cellEditor(@Nullable TableCellEditor newCellEditor) {
        this.cellEditor = newCellEditor;
    }

    @Nonnull
    protected final JTableLocation location() {
        JTableLocation jTableLocation = this.location;
        if (jTableLocation == null) {
            AbstractJTableCellWriter.$$$reportNull$$$0(20);
        }
        return jTableLocation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 13: 
            case 20: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 13: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "robot";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 9: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supportedType";
                break;
            }
            case 10: 
            case 13: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/driver/AbstractJTableCellWriter";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/driver/AbstractJTableCellWriter";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "editor";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "cellLocation";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "cancelCellEditing";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doCancelCellEditing";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "stopCellEditing";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doStopCellEditing";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "cellEditor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "editorForCell";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "cellEditorComponent";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "editor";
                break;
            }
            case 10: 
            case 13: 
            case 20: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "cellLocation";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "waitForEditorActivation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 13: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

