/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JTabbedPane;
import org.fest.assertions.Assertions;
import org.fest.assertions.Description;
import org.fest.assertions.ObjectArrayAssert;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.data.Index;
import org.fest.swing.driver.ComponentPreconditions;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JTabbedPaneLocation;
import org.fest.swing.driver.JTabbedPaneSelectTabTask;
import org.fest.swing.driver.JTabbedPaneTabTitlesQuery;
import org.fest.swing.driver.TextAssert;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.exception.LocationUnavailableException;
import org.fest.swing.util.Pair;
import org.fest.swing.util.PatternTextMatcher;
import org.fest.swing.util.StringTextMatcher;
import org.fest.swing.util.TextMatcher;
import org.fest.util.InternalApi;
import org.fest.util.Lists;
import org.fest.util.Preconditions;
import org.fest.util.VisibleForTesting;

@InternalApi
public class JTabbedPaneDriver
extends JComponentDriver {
    private final JTabbedPaneLocation location;

    public JTabbedPaneDriver(@Nonnull Robot robot) {
        if (robot == null) {
            JTabbedPaneDriver.$$$reportNull$$$0(0);
        }
        this(robot, new JTabbedPaneLocation());
    }

    @VisibleForTesting
    JTabbedPaneDriver(@Nonnull Robot robot, @Nonnull JTabbedPaneLocation location) {
        if (robot == null) {
            JTabbedPaneDriver.$$$reportNull$$$0(1);
        }
        if (location == null) {
            JTabbedPaneDriver.$$$reportNull$$$0(2);
        }
        super(robot);
        this.location = location;
    }

    @Nonnull
    @RunsInEDT
    public String[] tabTitles(@Nonnull JTabbedPane tabbedPane) {
        if (tabbedPane == null) {
            JTabbedPaneDriver.$$$reportNull$$$0(3);
        }
        String[] stringArray = JTabbedPaneTabTitlesQuery.tabTitlesOf(tabbedPane);
        if (stringArray == null) {
            JTabbedPaneDriver.$$$reportNull$$$0(4);
        }
        return stringArray;
    }

    @RunsInEDT
    public void selectTab(@Nonnull JTabbedPane tabbedPane, @Nullable String title) {
        if (tabbedPane == null) {
            JTabbedPaneDriver.$$$reportNull$$$0(5);
        }
        this.selectTab(tabbedPane, new StringTextMatcher(title));
    }

    @RunsInEDT
    public void selectTab(@Nonnull JTabbedPane tabbedPane, @Nonnull Pattern pattern) {
        if (tabbedPane == null) {
            JTabbedPaneDriver.$$$reportNull$$$0(6);
        }
        if (pattern == null) {
            JTabbedPaneDriver.$$$reportNull$$$0(7);
        }
        this.selectTab(tabbedPane, new PatternTextMatcher(pattern));
    }

    @RunsInEDT
    private void selectTab(@Nonnull JTabbedPane tabbedPane, @Nonnull TextMatcher matcher) {
        if (tabbedPane == null) {
            JTabbedPaneDriver.$$$reportNull$$$0(8);
        }
        if (matcher == null) {
            JTabbedPaneDriver.$$$reportNull$$$0(9);
        }
        Pair<Integer, Point> tabToSelectInfo = JTabbedPaneDriver.tabToSelectInfo(this.location(), tabbedPane, matcher);
        Point target = (Point)tabToSelectInfo.second;
        if (target != null) {
            try {
                this.click((Component)tabbedPane, target);
            }
            catch (ActionFailedException e) {
                this.setTabDirectly(tabbedPane, (Integer)tabToSelectInfo.first);
            }
            return;
        }
        this.setTabDirectly(tabbedPane, (Integer)tabToSelectInfo.first);
    }

    @Nonnull
    @RunsInEDT
    private static Pair<Integer, Point> tabToSelectInfo(final @Nonnull JTabbedPaneLocation location, final @Nonnull JTabbedPane tabbedPane, final @Nonnull TextMatcher matcher) {
        if (location == null) {
            JTabbedPaneDriver.$$$reportNull$$$0(10);
        }
        if (tabbedPane == null) {
            JTabbedPaneDriver.$$$reportNull$$$0(11);
        }
        if (matcher == null) {
            JTabbedPaneDriver.$$$reportNull$$$0(12);
        }
        Pair<Integer, Point> result = GuiActionRunner.execute(new GuiQuery<Pair<Integer, Point>>(){

            @Override
            protected Pair<Integer, Point> executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(tabbedPane);
                int index = location.indexOf(tabbedPane, matcher);
                location.checkIndexInBounds(tabbedPane, index);
                Point point = null;
                try {
                    point = location.pointAt(tabbedPane, index);
                }
                catch (LocationUnavailableException locationUnavailableException) {
                    // empty catch block
                }
                return Pair.of(index, point);
            }
        });
        Pair pair = (Pair)Preconditions.checkNotNull(result);
        if (pair == null) {
            JTabbedPaneDriver.$$$reportNull$$$0(13);
        }
        return pair;
    }

    public void selectTab(@Nonnull JTabbedPane tabbedPane, int index) {
        if (tabbedPane == null) {
            JTabbedPaneDriver.$$$reportNull$$$0(14);
        }
        try {
            Point p = JTabbedPaneDriver.pointAtTabWhenShowing(this.location(), tabbedPane, index);
            this.click((Component)tabbedPane, p);
        }
        catch (LocationUnavailableException e) {
            this.setTabDirectly(tabbedPane, index);
        }
        catch (ActionFailedException e) {
            this.setTabDirectly(tabbedPane, index);
        }
    }

    @Nonnull
    @RunsInEDT
    private static Point pointAtTabWhenShowing(final @Nonnull JTabbedPaneLocation location, final @Nonnull JTabbedPane tabbedPane, final int index) {
        if (location == null) {
            JTabbedPaneDriver.$$$reportNull$$$0(15);
        }
        if (tabbedPane == null) {
            JTabbedPaneDriver.$$$reportNull$$$0(16);
        }
        Point result = GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            protected Point executeInEDT() {
                location.checkIndexInBounds(tabbedPane, index);
                ComponentPreconditions.checkEnabledAndShowing(tabbedPane);
                return location.pointAt(tabbedPane, index);
            }
        });
        Point point = (Point)Preconditions.checkNotNull((Object)result);
        if (point == null) {
            JTabbedPaneDriver.$$$reportNull$$$0(17);
        }
        return point;
    }

    @RunsInEDT
    @VisibleForTesting
    void setTabDirectly(@Nonnull JTabbedPane tabbedPane, int index) {
        if (tabbedPane == null) {
            JTabbedPaneDriver.$$$reportNull$$$0(18);
        }
        JTabbedPaneSelectTabTask.setSelectedTab(tabbedPane, index);
        this.robot.waitForIdle();
        this.moveMouseToTab(tabbedPane, index);
    }

    private void moveMouseToTab(@Nonnull JTabbedPane tabbedPane, int index) {
        if (tabbedPane == null) {
            JTabbedPaneDriver.$$$reportNull$$$0(19);
        }
        try {
            Point p = JTabbedPaneDriver.pointAtTab(this.location(), tabbedPane, index);
            this.robot.moveMouse(tabbedPane, p);
            this.robot.waitForIdle();
        }
        catch (LocationUnavailableException locationUnavailableException) {
            // empty catch block
        }
    }

    @Nonnull
    @RunsInEDT
    private static Point pointAtTab(final @Nonnull JTabbedPaneLocation location, final @Nonnull JTabbedPane tabbedPane, final int index) {
        if (location == null) {
            JTabbedPaneDriver.$$$reportNull$$$0(20);
        }
        if (tabbedPane == null) {
            JTabbedPaneDriver.$$$reportNull$$$0(21);
        }
        Point result = GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            protected Point executeInEDT() {
                return location.pointAt(tabbedPane, index);
            }
        });
        Point point = (Point)Preconditions.checkNotNull((Object)result);
        if (point == null) {
            JTabbedPaneDriver.$$$reportNull$$$0(22);
        }
        return point;
    }

    @Nullable
    @RunsInEDT
    public Component selectedComponentOf(@Nonnull JTabbedPane tabbedPane) {
        if (tabbedPane == null) {
            JTabbedPaneDriver.$$$reportNull$$$0(23);
        }
        return JTabbedPaneDriver.selectedComponent(tabbedPane);
    }

    @Nullable
    @RunsInEDT
    private static Component selectedComponent(final JTabbedPane tabbedPane) {
        return GuiActionRunner.execute(new GuiQuery<Component>(){

            @Override
            protected Component executeInEDT() {
                return tabbedPane.getSelectedComponent();
            }
        });
    }

    @RunsInEDT
    public void requireTabTitle(@Nonnull JTabbedPane tabbedPane, @Nullable String title, @Nonnull Index index) {
        if (tabbedPane == null) {
            JTabbedPaneDriver.$$$reportNull$$$0(24);
        }
        if (index == null) {
            JTabbedPaneDriver.$$$reportNull$$$0(25);
        }
        String actualTitle = JTabbedPaneDriver.titleAt(tabbedPane, index);
        TextAssert.verifyThat(actualTitle).as(this.titleAtProperty(tabbedPane)).isEqualOrMatches(title);
    }

    @RunsInEDT
    public void requireTabTitle(@Nonnull JTabbedPane tabbedPane, @Nonnull Pattern pattern, @Nonnull Index index) {
        if (tabbedPane == null) {
            JTabbedPaneDriver.$$$reportNull$$$0(26);
        }
        if (pattern == null) {
            JTabbedPaneDriver.$$$reportNull$$$0(27);
        }
        if (index == null) {
            JTabbedPaneDriver.$$$reportNull$$$0(28);
        }
        String actualTitle = JTabbedPaneDriver.titleAt(tabbedPane, index);
        TextAssert.verifyThat(actualTitle).as(this.titleAtProperty(tabbedPane)).matches(pattern);
    }

    @RunsInEDT
    private Description titleAtProperty(@Nonnull JTabbedPane tabbedPane) {
        if (tabbedPane == null) {
            JTabbedPaneDriver.$$$reportNull$$$0(29);
        }
        return JTabbedPaneDriver.propertyName(tabbedPane, "titleAt");
    }

    @Nullable
    @RunsInEDT
    private static String titleAt(final @Nonnull JTabbedPane tabbedPane, final @Nonnull Index index) {
        if (tabbedPane == null) {
            JTabbedPaneDriver.$$$reportNull$$$0(30);
        }
        if (index == null) {
            JTabbedPaneDriver.$$$reportNull$$$0(31);
        }
        return GuiActionRunner.execute(new GuiQuery<String>(){

            @Override
            protected String executeInEDT() {
                return tabbedPane.getTitleAt(index.value);
            }
        });
    }

    @RunsInEDT
    public void requireTabTitles(@Nonnull JTabbedPane tabbedPane, @Nonnull String[] titles) {
        if (tabbedPane == null) {
            JTabbedPaneDriver.$$$reportNull$$$0(32);
        }
        if (titles == null) {
            JTabbedPaneDriver.$$$reportNull$$$0(33);
        }
        Object[] actualTitles = JTabbedPaneDriver.allTabTitlesIn(tabbedPane);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])actualTitles).as(JTabbedPaneDriver.propertyName(tabbedPane, "tabTitles"))).isEqualTo((Object[])titles);
    }

    @Nonnull
    @RunsInEDT
    private static String[] allTabTitlesIn(final @Nonnull JTabbedPane tabbedPane) {
        if (tabbedPane == null) {
            JTabbedPaneDriver.$$$reportNull$$$0(34);
        }
        String[] result = GuiActionRunner.execute(new GuiQuery<String[]>(){

            @Override
            protected String[] executeInEDT() {
                ArrayList allTitles = Lists.newArrayList();
                int tabCount = tabbedPane.getTabCount();
                for (int i = 0; i < tabCount; ++i) {
                    allTitles.add(tabbedPane.getTitleAt(i));
                }
                return allTitles.toArray(new String[allTitles.size()]);
            }
        });
        String[] stringArray = (String[])Preconditions.checkNotNull((Object)result);
        if (stringArray == null) {
            JTabbedPaneDriver.$$$reportNull$$$0(35);
        }
        return stringArray;
    }

    @Nonnull
    private JTabbedPaneLocation location() {
        JTabbedPaneLocation jTabbedPaneLocation = this.location;
        if (jTabbedPaneLocation == null) {
            JTabbedPaneDriver.$$$reportNull$$$0(36);
        }
        return jTabbedPaneLocation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 13: 
            case 17: 
            case 22: 
            case 35: 
            case 36: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 13: 
            case 17: 
            case 22: 
            case 35: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "robot";
                break;
            }
            case 2: 
            case 10: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 29: 
            case 30: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabbedPane";
                break;
            }
            case 4: 
            case 13: 
            case 17: 
            case 22: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/driver/JTabbedPaneDriver";
                break;
            }
            case 7: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 25: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "titles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/driver/JTabbedPaneDriver";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "tabTitles";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "tabToSelectInfo";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "pointAtTabWhenShowing";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "pointAtTab";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "allTabTitlesIn";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "tabTitles";
                break;
            }
            case 4: 
            case 13: 
            case 17: 
            case 22: 
            case 35: 
            case 36: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "selectTab";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "tabToSelectInfo";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "pointAtTabWhenShowing";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setTabDirectly";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "moveMouseToTab";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "pointAtTab";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "selectedComponentOf";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "requireTabTitle";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "titleAtProperty";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "titleAt";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "requireTabTitles";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "allTabTitlesIn";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 13: 
            case 17: 
            case 22: 
            case 35: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

