/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.util.regex.Pattern;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import org.fest.assertions.Assertions;
import org.fest.assertions.BooleanAssert;
import org.fest.assertions.Description;
import org.fest.assertions.Fail;
import org.fest.assertions.IntArrayAssert;
import org.fest.assertions.IntAssert;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.cell.JTableCellReader;
import org.fest.swing.cell.JTableCellWriter;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.Robot;
import org.fest.swing.data.TableCell;
import org.fest.swing.data.TableCellFinder;
import org.fest.swing.driver.BasicJTableCellReader;
import org.fest.swing.driver.BasicJTableCellWriter;
import org.fest.swing.driver.ComponentDriver;
import org.fest.swing.driver.ComponentPreconditions;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JTableCellEditableQuery;
import org.fest.swing.driver.JTableCellPreconditions;
import org.fest.swing.driver.JTableColumnCountQuery;
import org.fest.swing.driver.JTableContentsQuery;
import org.fest.swing.driver.JTableHasSelectionQuery;
import org.fest.swing.driver.JTableHeaderQuery;
import org.fest.swing.driver.JTableLocation;
import org.fest.swing.driver.JTableMatchingCellQuery;
import org.fest.swing.driver.JTableRowCountQuery;
import org.fest.swing.driver.JTableSingleRowCellSelectedQuery;
import org.fest.swing.driver.MultipleSelectionTemplate;
import org.fest.swing.driver.TextAssert;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.query.JTableColumnByIdentifierQuery;
import org.fest.swing.util.ArrayPreconditions;
import org.fest.swing.util.Arrays;
import org.fest.swing.util.Pair;
import org.fest.swing.util.PatternTextMatcher;
import org.fest.swing.util.StringTextMatcher;
import org.fest.util.InternalApi;
import org.fest.util.Preconditions;
import org.fest.util.Strings;
import org.fest.util.VisibleForTesting;

@InternalApi
public class JTableDriver
extends JComponentDriver {
    private static final String CONTENTS_PROPERTY = "contents";
    private static final String EDITABLE_PROPERTY = "editable";
    private static final String SELECTED_ROWS_PROPERTY = "selectedRows";
    private static final String SELECTION_PROPERTY = "selection";
    private static final String VALUE_PROPERTY = "value";
    private final JTableLocation location;
    private JTableCellReader cellReader;
    private JTableCellWriter cellWriter;

    public JTableDriver(@Nonnull Robot robot) {
        if (robot == null) {
            JTableDriver.$$$reportNull$$$0(0);
        }
        super(robot);
        this.location = new JTableLocation();
        this.replaceCellReader(new BasicJTableCellReader());
        this.replaceCellWriter(new BasicJTableCellWriter(robot));
    }

    @Nullable
    @RunsInEDT
    public JTableHeader tableHeaderOf(@Nonnull JTable table) {
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(1);
        }
        return JTableHeaderQuery.tableHeader(table);
    }

    @Nullable
    @RunsInEDT
    public String selectionValue(@Nonnull JTable table) {
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(2);
        }
        return JTableDriver.selectionValue(table, this.cellReader());
    }

    @Nullable
    @RunsInEDT
    private static String selectionValue(final @Nonnull JTable table, final @Nonnull JTableCellReader cellReader) {
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(3);
        }
        if (cellReader == null) {
            JTableDriver.$$$reportNull$$$0(4);
        }
        return GuiActionRunner.execute(new GuiQuery<String>(){

            @Override
            protected String executeInEDT() {
                if (table.getSelectedRowCount() == 0) {
                    return null;
                }
                return cellReader.valueAt(table, table.getSelectedRow(), table.getSelectedColumn());
            }
        });
    }

    @Nonnull
    @RunsInEDT
    public TableCell cell(@Nonnull JTable table, @Nonnull TableCellFinder cellFinder) {
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(5);
        }
        if (cellFinder == null) {
            JTableDriver.$$$reportNull$$$0(6);
        }
        Preconditions.checkNotNull((Object)cellFinder);
        TableCell cell = cellFinder.findCell(table, this.cellReader());
        this.checkCellIndicesInBounds(table, cell);
        TableCell tableCell = cell;
        if (tableCell == null) {
            JTableDriver.$$$reportNull$$$0(7);
        }
        return tableCell;
    }

    @Nonnull
    @RunsInEDT
    public TableCell cell(@Nonnull JTable table, @Nullable String value) {
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(8);
        }
        TableCell tableCell = JTableMatchingCellQuery.cellWithValue(table, new StringTextMatcher(value), this.cellReader());
        if (tableCell == null) {
            JTableDriver.$$$reportNull$$$0(9);
        }
        return tableCell;
    }

    @Nonnull
    @RunsInEDT
    public TableCell cell(@Nonnull JTable table, @Nonnull Pattern pattern) {
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(10);
        }
        if (pattern == null) {
            JTableDriver.$$$reportNull$$$0(11);
        }
        TableCell tableCell = JTableMatchingCellQuery.cellWithValue(table, new PatternTextMatcher(pattern), this.cellReader());
        if (tableCell == null) {
            JTableDriver.$$$reportNull$$$0(12);
        }
        return tableCell;
    }

    @Nullable
    @RunsInEDT
    public String value(@Nonnull JTable table, @Nonnull TableCell cell) {
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(13);
        }
        if (cell == null) {
            JTableDriver.$$$reportNull$$$0(14);
        }
        Preconditions.checkNotNull((Object)cell);
        return JTableDriver.cellValue(table, cell, this.cellReader());
    }

    @Nullable
    @RunsInEDT
    private static String cellValue(final @Nonnull JTable table, final @Nonnull TableCell cell, final @Nonnull JTableCellReader cellReader) {
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(15);
        }
        if (cell == null) {
            JTableDriver.$$$reportNull$$$0(16);
        }
        if (cellReader == null) {
            JTableDriver.$$$reportNull$$$0(17);
        }
        return GuiActionRunner.execute(new GuiQuery<String>(){

            @Override
            protected String executeInEDT() {
                JTableCellPreconditions.checkCellIndicesInBounds(table, cell);
                return cellReader.valueAt(table, cell.row, cell.column);
            }
        });
    }

    @Nullable
    @RunsInEDT
    public String value(@Nonnull JTable table, int row, int column) {
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(18);
        }
        return JTableDriver.cellValue(table, row, column, this.cellReader());
    }

    @Nullable
    @RunsInEDT
    private static String cellValue(final @Nonnull JTable table, final int row, final int column, final @Nonnull JTableCellReader cellReader) {
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(19);
        }
        if (cellReader == null) {
            JTableDriver.$$$reportNull$$$0(20);
        }
        return GuiActionRunner.execute(new GuiQuery<String>(){

            @Override
            protected String executeInEDT() {
                JTableCellPreconditions.checkCellIndicesInBounds(table, row, column);
                return cellReader.valueAt(table, row, column);
            }
        });
    }

    @Nullable
    @RunsInEDT
    public Font font(@Nonnull JTable table, @Nonnull TableCell cell) {
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(21);
        }
        if (cell == null) {
            JTableDriver.$$$reportNull$$$0(22);
        }
        Preconditions.checkNotNull((Object)cell);
        return JTableDriver.cellFont(table, cell, this.cellReader());
    }

    @Nullable
    @RunsInEDT
    private static Font cellFont(final @Nonnull JTable table, final @Nonnull TableCell cell, final @Nonnull JTableCellReader cellReader) {
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(23);
        }
        if (cell == null) {
            JTableDriver.$$$reportNull$$$0(24);
        }
        if (cellReader == null) {
            JTableDriver.$$$reportNull$$$0(25);
        }
        return GuiActionRunner.execute(new GuiQuery<Font>(){

            @Override
            protected Font executeInEDT() {
                JTableCellPreconditions.checkCellIndicesInBounds(table, cell);
                return cellReader.fontAt(table, cell.row, cell.column);
            }
        });
    }

    @RunsInEDT
    public Color background(@Nonnull JTable table, @Nonnull TableCell cell) {
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(26);
        }
        if (cell == null) {
            JTableDriver.$$$reportNull$$$0(27);
        }
        Preconditions.checkNotNull((Object)cell);
        return JTableDriver.cellBackground(table, cell, this.cellReader());
    }

    @Nullable
    @RunsInEDT
    private static Color cellBackground(final @Nonnull JTable table, final @Nonnull TableCell cell, final @Nonnull JTableCellReader cellReader) {
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(28);
        }
        if (cell == null) {
            JTableDriver.$$$reportNull$$$0(29);
        }
        if (cellReader == null) {
            JTableDriver.$$$reportNull$$$0(30);
        }
        return GuiActionRunner.execute(new GuiQuery<Color>(){

            @Override
            protected Color executeInEDT() {
                JTableCellPreconditions.checkCellIndicesInBounds(table, cell);
                return cellReader.backgroundAt(table, cell.row, cell.column);
            }
        });
    }

    @Nullable
    @RunsInEDT
    public Color foreground(@Nonnull JTable table, @Nonnull TableCell cell) {
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(31);
        }
        if (cell == null) {
            JTableDriver.$$$reportNull$$$0(32);
        }
        Preconditions.checkNotNull((Object)cell);
        return JTableDriver.cellForeground(table, cell, this.cellReader());
    }

    @Nullable
    @RunsInEDT
    private static Color cellForeground(final @Nonnull JTable table, final @Nonnull TableCell cell, final @Nonnull JTableCellReader cellReader) {
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(33);
        }
        if (cell == null) {
            JTableDriver.$$$reportNull$$$0(34);
        }
        if (cellReader == null) {
            JTableDriver.$$$reportNull$$$0(35);
        }
        return GuiActionRunner.execute(new GuiQuery<Color>(){

            @Override
            protected Color executeInEDT() {
                JTableCellPreconditions.checkCellIndicesInBounds(table, cell);
                return cellReader.foregroundAt(table, cell.row, cell.column);
            }
        });
    }

    public void selectCells(final @Nonnull JTable table, final @Nonnull TableCell[] cells) {
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(36);
        }
        if (cells == null) {
            JTableDriver.$$$reportNull$$$0(37);
        }
        Preconditions.checkNotNullOrEmpty((Object[])cells);
        new MultipleSelectionTemplate(this.robot){

            @Override
            int elementCount() {
                return cells.length;
            }

            @Override
            void selectElement(int index) {
                JTableDriver.this.selectCell(table, (TableCell)Preconditions.checkNotNull((Object)cells[index]));
            }
        }.multiSelect();
    }

    @RunsInEDT
    public void requireNoSelection(@Nonnull JTable table) {
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(38);
        }
        JTableDriver.assertNoSelection(table);
    }

    @RunsInEDT
    private static void assertNoSelection(final @Nonnull JTable table) {
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(39);
        }
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                if (!JTableHasSelectionQuery.hasSelection(table)) {
                    return;
                }
                String format = "[%s] expected no selection but was:<rows=%s, columns=%s>";
                String msg = String.format(format, ComponentDriver.propertyName(table, JTableDriver.SELECTION_PROPERTY).value(), org.fest.util.Arrays.format((Object)JTableDriver.selectedRowsOf(table)), org.fest.util.Arrays.format((Object)table.getSelectedColumns()));
                Fail.fail((String)msg);
            }
        });
    }

    @RunsInEDT
    public void selectCell(@Nonnull JTable table, @Nonnull TableCell cell) {
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(40);
        }
        if (cell == null) {
            JTableDriver.$$$reportNull$$$0(41);
        }
        Preconditions.checkNotNull((Object)cell);
        this.selectCell(table, cell.row, cell.column);
    }

    @RunsInEDT
    public void click(@Nonnull JTable table, @Nonnull TableCell cell, @Nonnull MouseButton mouseButton, @Nonnegative int times) {
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(42);
        }
        if (cell == null) {
            JTableDriver.$$$reportNull$$$0(43);
        }
        if (mouseButton == null) {
            JTableDriver.$$$reportNull$$$0(44);
        }
        if (times <= 0) {
            throw new IllegalArgumentException("The number of times to click a cell should be greater than zero");
        }
        Point pointAtCell = JTableDriver.scrollToPointAtCell(table, cell, this.location());
        this.robot.click(table, pointAtCell, mouseButton, times);
    }

    @RunsInEDT
    public void drag(@Nonnull JTable table, @Nonnull TableCell cell) {
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(45);
        }
        if (cell == null) {
            JTableDriver.$$$reportNull$$$0(46);
        }
        Point pointAtCell = JTableDriver.scrollToPointAtCell(table, cell, this.location());
        this.drag((Component)table, pointAtCell);
    }

    @RunsInEDT
    public void drop(@Nonnull JTable table, @Nonnull TableCell cell) {
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(47);
        }
        if (cell == null) {
            JTableDriver.$$$reportNull$$$0(48);
        }
        Point pointAtCell = JTableDriver.scrollToPointAtCell(table, cell, this.location());
        this.drop((Component)table, pointAtCell);
    }

    @Nonnull
    @RunsInEDT
    public JPopupMenu showPopupMenuAt(@Nonnull JTable table, @Nonnull TableCell cell) {
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(49);
        }
        if (cell == null) {
            JTableDriver.$$$reportNull$$$0(50);
        }
        Point pointAtCell = JTableDriver.scrollToPointAtCell(table, cell, this.location());
        JPopupMenu jPopupMenu = this.robot.showPopupMenu(table, pointAtCell);
        if (jPopupMenu == null) {
            JTableDriver.$$$reportNull$$$0(51);
        }
        return jPopupMenu;
    }

    @Nonnull
    @RunsInEDT
    private static Point scrollToPointAtCell(final @Nonnull JTable table, final @Nonnull TableCell cell, final @Nonnull JTableLocation location) {
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(52);
        }
        if (cell == null) {
            JTableDriver.$$$reportNull$$$0(53);
        }
        if (location == null) {
            JTableDriver.$$$reportNull$$$0(54);
        }
        Preconditions.checkNotNull((Object)cell);
        Point result = GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            protected Point executeInEDT() {
                JTableDriver.scrollToCell(table, cell, location);
                return location.pointAt(table, cell.row, cell.column);
            }
        });
        Point point = (Point)Preconditions.checkNotNull((Object)result);
        if (point == null) {
            JTableDriver.$$$reportNull$$$0(55);
        }
        return point;
    }

    @RunsInCurrentThread
    private static void scrollToCell(@Nonnull JTable table, @Nonnull TableCell cell, @Nonnull JTableLocation location) {
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(56);
        }
        if (cell == null) {
            JTableDriver.$$$reportNull$$$0(57);
        }
        if (location == null) {
            JTableDriver.$$$reportNull$$$0(58);
        }
        ComponentPreconditions.checkEnabledAndShowing(table);
        JTableCellPreconditions.checkCellIndicesInBounds(table, cell);
        table.scrollRectToVisible(location.cellBounds(table, cell));
    }

    @Nonnull
    @RunsInEDT
    public Point pointAt(@Nonnull JTable table, @Nonnull TableCell cell) {
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(59);
        }
        if (cell == null) {
            JTableDriver.$$$reportNull$$$0(60);
        }
        Point point = JTableDriver.pointAtCell(table, cell, this.location());
        if (point == null) {
            JTableDriver.$$$reportNull$$$0(61);
        }
        return point;
    }

    @Nonnull
    @RunsInEDT
    private static Point pointAtCell(final @Nonnull JTable table, final @Nonnull TableCell cell, final @Nonnull JTableLocation location) {
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(62);
        }
        if (cell == null) {
            JTableDriver.$$$reportNull$$$0(63);
        }
        if (location == null) {
            JTableDriver.$$$reportNull$$$0(64);
        }
        Point result = GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            protected Point executeInEDT() {
                JTableCellPreconditions.checkCellIndicesInBounds(table, cell);
                return location.pointAt(table, cell.row, cell.column);
            }
        });
        Point point = (Point)Preconditions.checkNotNull((Object)result);
        if (point == null) {
            JTableDriver.$$$reportNull$$$0(65);
        }
        return point;
    }

    @RunsInEDT
    public void requireContents(@Nonnull JTable table, @Nonnull String[][] contents) {
        String[][] actual;
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(66);
        }
        if (contents == null) {
            JTableDriver.$$$reportNull$$$0(67);
        }
        if (!Arrays.equal(actual = this.contents(table), contents)) {
            JTableDriver.failNotEqual(actual, contents, JTableDriver.propertyName(table, CONTENTS_PROPERTY));
        }
    }

    private static void failNotEqual(@Nonnull String[][] actual, @Nonnull String[][] expected, @Nullable Description description) {
        if (actual == null) {
            JTableDriver.$$$reportNull$$$0(68);
        }
        if (expected == null) {
            JTableDriver.$$$reportNull$$$0(69);
        }
        String descriptionValue = description != null ? description.value() : null;
        String message = descriptionValue == null ? "" : String.format("[%s] ", descriptionValue);
        Fail.fail((String)(message + String.format("expected:<%s> but was<%s>", Arrays.format(expected), Arrays.format(actual))));
    }

    @Nonnull
    @RunsInEDT
    public String[][] contents(@Nonnull JTable table) {
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(70);
        }
        String[][] stringArray = JTableContentsQuery.tableContents(table, this.cellReader());
        if (stringArray == null) {
            JTableDriver.$$$reportNull$$$0(71);
        }
        return stringArray;
    }

    @RunsInEDT
    public void requireCellValue(@Nonnull JTable table, @Nonnull TableCell cell, @Nullable String value) {
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(72);
        }
        if (cell == null) {
            JTableDriver.$$$reportNull$$$0(73);
        }
        TextAssert.verifyThat(this.value(table, cell)).as(this.cellValueProperty(table, cell)).isEqualOrMatches(value);
    }

    @RunsInEDT
    public void requireCellValue(@Nonnull JTable table, @Nonnull TableCell cell, @Nonnull Pattern pattern) {
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(74);
        }
        if (cell == null) {
            JTableDriver.$$$reportNull$$$0(75);
        }
        if (pattern == null) {
            JTableDriver.$$$reportNull$$$0(76);
        }
        TextAssert.verifyThat(this.value(table, cell)).as(this.cellValueProperty(table, cell)).matches(pattern);
    }

    @Nonnull
    @RunsInEDT
    private Description cellValueProperty(@Nonnull JTable table, @Nonnull TableCell cell) {
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(77);
        }
        if (cell == null) {
            JTableDriver.$$$reportNull$$$0(78);
        }
        Description description = JTableDriver.cellProperty(table, Strings.concat((Object[])new Object[]{VALUE_PROPERTY, " ", cell}));
        if (description == null) {
            JTableDriver.$$$reportNull$$$0(79);
        }
        return description;
    }

    @RunsInEDT
    public void enterValueInCell(@Nonnull JTable table, @Nonnull TableCell cell, @Nonnull String value) {
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(80);
        }
        if (cell == null) {
            JTableDriver.$$$reportNull$$$0(81);
        }
        if (value == null) {
            JTableDriver.$$$reportNull$$$0(82);
        }
        Preconditions.checkNotNull((Object)cell);
        this.cellWriter.enterValue(table, cell.row, cell.column, value);
    }

    @RunsInEDT
    public void requireEditable(@Nonnull JTable table, @Nonnull TableCell cell) {
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(83);
        }
        if (cell == null) {
            JTableDriver.$$$reportNull$$$0(84);
        }
        JTableDriver.requireEditableEqualTo(table, cell, true);
    }

    @RunsInEDT
    public void requireNotEditable(@Nonnull JTable table, @Nonnull TableCell cell) {
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(85);
        }
        if (cell == null) {
            JTableDriver.$$$reportNull$$$0(86);
        }
        JTableDriver.requireEditableEqualTo(table, cell, false);
    }

    @RunsInEDT
    private static void requireEditableEqualTo(final @Nonnull JTable table, final @Nonnull TableCell cell, boolean editable) {
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(87);
        }
        if (cell == null) {
            JTableDriver.$$$reportNull$$$0(88);
        }
        Preconditions.checkNotNull((Object)cell);
        boolean cellEditable = (Boolean)Preconditions.checkNotNull((Object)GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() {
                return JTableCellEditableQuery.isCellEditable(table, cell);
            }
        }));
        ((BooleanAssert)Assertions.assertThat((boolean)cellEditable).as(JTableDriver.cellProperty(table, Strings.concat((Object[])new Object[]{EDITABLE_PROPERTY, " ", cell})))).isEqualTo(editable);
    }

    @Nonnull
    @RunsInEDT
    private static Description cellProperty(@Nonnull JTable table, @Nonnull String propertyName) {
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(89);
        }
        if (propertyName == null) {
            JTableDriver.$$$reportNull$$$0(90);
        }
        Description description = JTableDriver.propertyName(table, propertyName);
        if (description == null) {
            JTableDriver.$$$reportNull$$$0(91);
        }
        return description;
    }

    @RunsInEDT
    public Component cellEditor(@Nonnull JTable table, @Nonnull TableCell cell) {
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(92);
        }
        if (cell == null) {
            JTableDriver.$$$reportNull$$$0(93);
        }
        Preconditions.checkNotNull((Object)cell);
        return this.cellWriter.editorForCell(table, cell.row, cell.column);
    }

    @RunsInEDT
    public void startCellEditing(@Nonnull JTable table, @Nonnull TableCell cell) {
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(94);
        }
        if (cell == null) {
            JTableDriver.$$$reportNull$$$0(95);
        }
        Preconditions.checkNotNull((Object)cell);
        this.cellWriter.startCellEditing(table, cell.row, cell.column);
    }

    @RunsInEDT
    public void stopCellEditing(@Nonnull JTable table, @Nonnull TableCell cell) {
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(96);
        }
        if (cell == null) {
            JTableDriver.$$$reportNull$$$0(97);
        }
        Preconditions.checkNotNull((Object)cell);
        this.cellWriter.stopCellEditing(table, cell.row, cell.column);
    }

    @RunsInEDT
    public void cancelCellEditing(@Nonnull JTable table, @Nonnull TableCell cell) {
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(98);
        }
        if (cell == null) {
            JTableDriver.$$$reportNull$$$0(99);
        }
        Preconditions.checkNotNull((Object)cell);
        this.cellWriter.cancelCellEditing(table, cell.row, cell.column);
    }

    @RunsInEDT
    public void checkCellIndicesInBounds(final @Nonnull JTable table, final @Nonnull TableCell cell) {
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(100);
        }
        if (cell == null) {
            JTableDriver.$$$reportNull$$$0(101);
        }
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                JTableCellPreconditions.checkCellIndicesInBounds(table, cell);
            }
        });
    }

    public void replaceCellReader(@Nonnull JTableCellReader newCellReader) {
        if (newCellReader == null) {
            JTableDriver.$$$reportNull$$$0(102);
        }
        this.cellReader = (JTableCellReader)Preconditions.checkNotNull((Object)newCellReader);
    }

    public void replaceCellWriter(JTableCellWriter newCellWriter) {
        this.cellWriter = (JTableCellWriter)Preconditions.checkNotNull((Object)newCellWriter);
    }

    @RunsInEDT
    public int rowCountOf(@Nonnull JTable table) {
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(103);
        }
        return JTableRowCountQuery.rowCountOf(table);
    }

    @RunsInEDT
    public int columnIndex(@Nonnull JTable table, @Nonnull Object columnId) {
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(104);
        }
        if (columnId == null) {
            JTableDriver.$$$reportNull$$$0(105);
        }
        return JTableDriver.findColumnIndex(table, columnId);
    }

    @RunsInEDT
    private static int findColumnIndex(final @Nonnull JTable table, final @Nonnull Object columnId) {
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(106);
        }
        if (columnId == null) {
            JTableDriver.$$$reportNull$$$0(107);
        }
        Integer result = GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() {
                int index = JTableColumnByIdentifierQuery.columnIndexByIdentifier(table, columnId);
                if (index < 0) {
                    JTableDriver.failColumnIndexNotFound(columnId);
                }
                return index;
            }
        });
        return (Integer)Preconditions.checkNotNull((Object)result);
    }

    @Nonnull
    private static ActionFailedException failColumnIndexNotFound(@Nonnull Object columnId) {
        if (columnId == null) {
            JTableDriver.$$$reportNull$$$0(108);
        }
        throw ActionFailedException.actionFailure(String.format("Unable to find a column with id '%s'", columnId.toString()));
    }

    @RunsInEDT
    public void requireRowCount(@Nonnull JTable table, int rowCount) {
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(109);
        }
        ((IntAssert)Assertions.assertThat((int)this.rowCountOf(table)).as(JTableDriver.propertyName(table, "rowCount"))).isEqualTo(rowCount);
    }

    @RunsInEDT
    public void requireColumnCount(@Nonnull JTable table, int columnCount) {
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(110);
        }
        ((IntAssert)Assertions.assertThat((int)JTableColumnCountQuery.columnCountOf(table)).as(JTableDriver.propertyName(table, "columnCount"))).isEqualTo(columnCount);
    }

    @RunsInEDT
    public void selectRows(final @Nonnull JTable table, final int ... rows) {
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(111);
        }
        if (rows == null) {
            JTableDriver.$$$reportNull$$$0(112);
        }
        ArrayPreconditions.checkNotNullOrEmpty(rows);
        new MultipleSelectionTemplate(this.robot){

            @Override
            int elementCount() {
                return rows.length;
            }

            @Override
            void selectElement(int index) {
                JTableDriver.this.selectCell(table, rows[index], 0);
            }
        }.multiSelect();
    }

    @RunsInEDT
    private void selectCell(@Nonnull JTable table, int row, int column) {
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(113);
        }
        Pair<Boolean, Point> cellSelectionInfo = JTableDriver.cellSelectionInfo(table, row, column, this.location);
        if (((Boolean)cellSelectionInfo.first).booleanValue()) {
            return;
        }
        this.robot.click(table, (Point)Preconditions.checkNotNull(cellSelectionInfo.second), MouseButton.LEFT_BUTTON, 1);
    }

    @Nonnull
    @RunsInEDT
    private static Pair<Boolean, Point> cellSelectionInfo(final @Nonnull JTable table, final int row, final int column, final @Nonnull JTableLocation location) {
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(114);
        }
        if (location == null) {
            JTableDriver.$$$reportNull$$$0(115);
        }
        Pair<Boolean, Point> result = GuiActionRunner.execute(new GuiQuery<Pair<Boolean, Point>>(){

            @Override
            protected Pair<Boolean, Point> executeInEDT() {
                if (JTableSingleRowCellSelectedQuery.isCellSelected(table, row, column)) {
                    return Pair.of(true, null);
                }
                JTableDriver.scrollToCell(table, row, column, location);
                Point pointAtCell = location.pointAt(table, row, column);
                return Pair.of(false, pointAtCell);
            }
        });
        Pair pair = (Pair)Preconditions.checkNotNull(result);
        if (pair == null) {
            JTableDriver.$$$reportNull$$$0(116);
        }
        return pair;
    }

    @RunsInCurrentThread
    private static void scrollToCell(@Nonnull JTable table, int row, int column, @Nonnull JTableLocation location) {
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(117);
        }
        if (location == null) {
            JTableDriver.$$$reportNull$$$0(118);
        }
        ComponentPreconditions.checkEnabledAndShowing(table);
        JTableCellPreconditions.checkCellIndicesInBounds(table, row, column);
        table.scrollRectToVisible(location.cellBounds(table, row, column));
    }

    @RunsInEDT
    public void requireSelectedRows(@Nonnull JTable table, int ... rows) {
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(119);
        }
        if (rows == null) {
            JTableDriver.$$$reportNull$$$0(120);
        }
        int[] selectedRows = JTableDriver.selectedRowsOf(table);
        ((IntArrayAssert)Assertions.assertThat((int[])selectedRows).as(JTableDriver.propertyName(table, SELECTED_ROWS_PROPERTY))).contains(rows);
    }

    @Nonnull
    @RunsInEDT
    private static int[] selectedRowsOf(final @Nonnull JTable table) {
        if (table == null) {
            JTableDriver.$$$reportNull$$$0(121);
        }
        int[] result = GuiActionRunner.execute(new GuiQuery<int[]>(){

            @Override
            protected int[] executeInEDT() {
                return table.getSelectedRows();
            }
        });
        int[] nArray = (int[])Preconditions.checkNotNull((Object)result);
        if (nArray == null) {
            JTableDriver.$$$reportNull$$$0(122);
        }
        return nArray;
    }

    @Nonnull
    @VisibleForTesting
    JTableCellReader cellReader() {
        JTableCellReader jTableCellReader = this.cellReader;
        if (jTableCellReader == null) {
            JTableDriver.$$$reportNull$$$0(123);
        }
        return jTableCellReader;
    }

    @Nonnull
    private JTableLocation location() {
        JTableLocation jTableLocation = this.location;
        if (jTableLocation == null) {
            JTableDriver.$$$reportNull$$$0(124);
        }
        return jTableLocation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 51: 
            case 55: 
            case 61: 
            case 65: 
            case 71: 
            case 79: 
            case 91: 
            case 116: 
            case 122: 
            case 123: 
            case 124: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 51: 
            case 55: 
            case 61: 
            case 65: 
            case 71: 
            case 79: 
            case 91: 
            case 116: 
            case 122: 
            case 123: 
            case 124: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "robot";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 13: 
            case 15: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 26: 
            case 28: 
            case 31: 
            case 33: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 45: 
            case 47: 
            case 49: 
            case 52: 
            case 56: 
            case 59: 
            case 62: 
            case 66: 
            case 70: 
            case 72: 
            case 74: 
            case 77: 
            case 80: 
            case 83: 
            case 85: 
            case 87: 
            case 89: 
            case 92: 
            case 94: 
            case 96: 
            case 98: 
            case 100: 
            case 103: 
            case 104: 
            case 106: 
            case 109: 
            case 110: 
            case 111: 
            case 113: 
            case 114: 
            case 117: 
            case 119: 
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 4: 
            case 17: 
            case 20: 
            case 25: 
            case 30: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cellReader";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cellFinder";
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 51: 
            case 55: 
            case 61: 
            case 65: 
            case 71: 
            case 79: 
            case 91: 
            case 116: 
            case 122: 
            case 123: 
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/driver/JTableDriver";
                break;
            }
            case 11: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 14: 
            case 16: 
            case 22: 
            case 24: 
            case 27: 
            case 29: 
            case 32: 
            case 34: 
            case 41: 
            case 43: 
            case 46: 
            case 48: 
            case 50: 
            case 53: 
            case 57: 
            case 60: 
            case 63: 
            case 73: 
            case 75: 
            case 78: 
            case 81: 
            case 84: 
            case 86: 
            case 88: 
            case 93: 
            case 95: 
            case 97: 
            case 99: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cell";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cells";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mouseButton";
                break;
            }
            case 54: 
            case 58: 
            case 64: 
            case 115: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = CONTENTS_PROPERTY;
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actual";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expected";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = VALUE_PROPERTY;
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newCellReader";
                break;
            }
            case 105: 
            case 107: 
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnId";
                break;
            }
            case 112: 
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/driver/JTableDriver";
                break;
            }
            case 7: 
            case 9: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "cell";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "showPopupMenuAt";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "scrollToPointAtCell";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "pointAt";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "pointAtCell";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = CONTENTS_PROPERTY;
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "cellValueProperty";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "cellProperty";
                break;
            }
            case 116: {
                objectArray = objectArray2;
                objectArray2[1] = "cellSelectionInfo";
                break;
            }
            case 122: {
                objectArray = objectArray2;
                objectArray2[1] = "selectedRowsOf";
                break;
            }
            case 123: {
                objectArray = objectArray2;
                objectArray2[1] = "cellReader";
                break;
            }
            case 124: {
                objectArray = objectArray2;
                objectArray2[1] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "tableHeaderOf";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "selectionValue";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "cell";
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 51: 
            case 55: 
            case 61: 
            case 65: 
            case 71: 
            case 79: 
            case 91: 
            case 116: 
            case 122: 
            case 123: 
            case 124: {
                break;
            }
            case 13: 
            case 14: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = VALUE_PROPERTY;
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "cellValue";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "font";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "cellFont";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "background";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "cellBackground";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "foreground";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "cellForeground";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "selectCells";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "requireNoSelection";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "assertNoSelection";
                break;
            }
            case 40: 
            case 41: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "selectCell";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "click";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "drag";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "drop";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "showPopupMenuAt";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "scrollToPointAtCell";
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 117: 
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "scrollToCell";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "pointAt";
                break;
            }
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "pointAtCell";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "requireContents";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "failNotEqual";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = CONTENTS_PROPERTY;
                break;
            }
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "requireCellValue";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "cellValueProperty";
                break;
            }
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "enterValueInCell";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "requireEditable";
                break;
            }
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "requireNotEditable";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "requireEditableEqualTo";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "cellProperty";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "cellEditor";
                break;
            }
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "startCellEditing";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "stopCellEditing";
                break;
            }
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "cancelCellEditing";
                break;
            }
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "checkCellIndicesInBounds";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "replaceCellReader";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "rowCountOf";
                break;
            }
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "columnIndex";
                break;
            }
            case 106: 
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "findColumnIndex";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "failColumnIndexNotFound";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "requireRowCount";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "requireColumnCount";
                break;
            }
            case 111: 
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "selectRows";
                break;
            }
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "cellSelectionInfo";
                break;
            }
            case 119: 
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "requireSelectedRows";
                break;
            }
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "selectedRowsOf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 51: 
            case 55: 
            case 61: 
            case 65: 
            case 71: 
            case 79: 
            case 91: 
            case 116: 
            case 122: 
            case 123: 
            case 124: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

