/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import java.awt.Component;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JTable;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.MouseClickInfo;
import org.fest.swing.data.TableCell;
import org.fest.swing.driver.JTableDriver;
import org.fest.swing.fixture.ColorFixture;
import org.fest.swing.fixture.FontFixture;
import org.fest.swing.fixture.ItemFixture;
import org.fest.swing.fixture.JPopupMenuFixture;
import org.fest.swing.fixture.JTableFixture;
import org.fest.util.Preconditions;
import org.fest.util.VisibleForTesting;

public class JTableCellFixture
implements ItemFixture<JTableCellFixture> {
    private final JTableFixture table;
    private final TableCell cell;
    private final JTable target;
    private final JTableDriver driver;

    protected JTableCellFixture(@Nonnull JTableFixture table, @Nonnull TableCell cell) {
        if (table == null) {
            JTableCellFixture.$$$reportNull$$$0(0);
        }
        if (cell == null) {
            JTableCellFixture.$$$reportNull$$$0(1);
        }
        this(table, cell, (JTable)table.target(), (JTableDriver)table.driver());
    }

    @VisibleForTesting
    JTableCellFixture(@Nonnull JTableFixture table, @Nonnull TableCell cell, @Nonnull JTable target, @Nonnull JTableDriver driver) {
        if (table == null) {
            JTableCellFixture.$$$reportNull$$$0(2);
        }
        if (cell == null) {
            JTableCellFixture.$$$reportNull$$$0(3);
        }
        if (target == null) {
            JTableCellFixture.$$$reportNull$$$0(4);
        }
        if (driver == null) {
            JTableCellFixture.$$$reportNull$$$0(5);
        }
        this.table = (JTableFixture)Preconditions.checkNotNull((Object)table);
        this.cell = (TableCell)Preconditions.checkNotNull((Object)cell);
        this.target = target;
        this.driver = driver;
    }

    @Override
    @Nonnull
    public JTableCellFixture select() {
        this.table.selectCell(this.cell());
        JTableCellFixture jTableCellFixture = this;
        if (jTableCellFixture == null) {
            JTableCellFixture.$$$reportNull$$$0(6);
        }
        return jTableCellFixture;
    }

    @Override
    @Nonnull
    public JTableCellFixture click() {
        this.table.click(this.cell(), MouseButton.LEFT_BUTTON);
        JTableCellFixture jTableCellFixture = this;
        if (jTableCellFixture == null) {
            JTableCellFixture.$$$reportNull$$$0(7);
        }
        return jTableCellFixture;
    }

    @Override
    @Nonnull
    public JTableCellFixture click(@Nonnull MouseClickInfo mouseClickInfo) {
        if (mouseClickInfo == null) {
            JTableCellFixture.$$$reportNull$$$0(8);
        }
        this.table.click(this.cell(), mouseClickInfo);
        JTableCellFixture jTableCellFixture = this;
        if (jTableCellFixture == null) {
            JTableCellFixture.$$$reportNull$$$0(9);
        }
        return jTableCellFixture;
    }

    @Override
    @Nonnull
    public JTableCellFixture doubleClick() {
        this.table.click(this.cell(), MouseButton.LEFT_BUTTON, 2);
        JTableCellFixture jTableCellFixture = this;
        if (jTableCellFixture == null) {
            JTableCellFixture.$$$reportNull$$$0(10);
        }
        return jTableCellFixture;
    }

    @Override
    @Nonnull
    public JTableCellFixture rightClick() {
        JTableCellFixture jTableCellFixture = this.click(MouseButton.RIGHT_BUTTON);
        if (jTableCellFixture == null) {
            JTableCellFixture.$$$reportNull$$$0(11);
        }
        return jTableCellFixture;
    }

    @Override
    @Nonnull
    public JTableCellFixture click(@Nonnull MouseButton button) {
        if (button == null) {
            JTableCellFixture.$$$reportNull$$$0(12);
        }
        this.table.click(this.cell(), button);
        JTableCellFixture jTableCellFixture = this;
        if (jTableCellFixture == null) {
            JTableCellFixture.$$$reportNull$$$0(13);
        }
        return jTableCellFixture;
    }

    @Nonnull
    public JTableCellFixture startEditing() {
        this.driver.startCellEditing(this.target, this.cell());
        JTableCellFixture jTableCellFixture = this;
        if (jTableCellFixture == null) {
            JTableCellFixture.$$$reportNull$$$0(14);
        }
        return jTableCellFixture;
    }

    @Nonnull
    public JTableCellFixture stopEditing() {
        this.driver.stopCellEditing(this.target, this.cell());
        JTableCellFixture jTableCellFixture = this;
        if (jTableCellFixture == null) {
            JTableCellFixture.$$$reportNull$$$0(15);
        }
        return jTableCellFixture;
    }

    @Nonnull
    public JTableCellFixture cancelEditing() {
        this.driver.cancelCellEditing(this.target, this.cell());
        JTableCellFixture jTableCellFixture = this;
        if (jTableCellFixture == null) {
            JTableCellFixture.$$$reportNull$$$0(16);
        }
        return jTableCellFixture;
    }

    public Component editor() {
        return this.driver.cellEditor(this.target, this.cell());
    }

    @Nonnull
    public JTableCellFixture enterValue(@Nonnull String value) {
        if (value == null) {
            JTableCellFixture.$$$reportNull$$$0(17);
        }
        this.driver.enterValueInCell(this.target, this.cell(), value);
        JTableCellFixture jTableCellFixture = this;
        if (jTableCellFixture == null) {
            JTableCellFixture.$$$reportNull$$$0(18);
        }
        return jTableCellFixture;
    }

    @Nonnull
    public JTableCellFixture requireValue(@Nullable String value) {
        this.table.requireCellValue(this.cell(), value);
        JTableCellFixture jTableCellFixture = this;
        if (jTableCellFixture == null) {
            JTableCellFixture.$$$reportNull$$$0(19);
        }
        return jTableCellFixture;
    }

    @Nonnull
    public JTableCellFixture requireValue(@Nonnull Pattern pattern) {
        if (pattern == null) {
            JTableCellFixture.$$$reportNull$$$0(20);
        }
        this.table.requireCellValue(this.cell(), pattern);
        JTableCellFixture jTableCellFixture = this;
        if (jTableCellFixture == null) {
            JTableCellFixture.$$$reportNull$$$0(21);
        }
        return jTableCellFixture;
    }

    public FontFixture font() {
        return this.table.fontAt(this.cell());
    }

    @Nonnull
    public ColorFixture background() {
        ColorFixture colorFixture = this.table.backgroundAt(this.cell());
        if (colorFixture == null) {
            JTableCellFixture.$$$reportNull$$$0(22);
        }
        return colorFixture;
    }

    @Nonnull
    public ColorFixture foreground() {
        ColorFixture colorFixture = this.table.foregroundAt(this.cell());
        if (colorFixture == null) {
            JTableCellFixture.$$$reportNull$$$0(23);
        }
        return colorFixture;
    }

    @Override
    @Nullable
    public String value() {
        return this.table.valueAt(this.cell());
    }

    @Override
    @Nonnull
    public JTableCellFixture drag() {
        this.table.drag(this.cell());
        JTableCellFixture jTableCellFixture = this;
        if (jTableCellFixture == null) {
            JTableCellFixture.$$$reportNull$$$0(24);
        }
        return jTableCellFixture;
    }

    @Override
    @Nonnull
    public JTableCellFixture drop() {
        this.table.drop(this.cell());
        JTableCellFixture jTableCellFixture = this;
        if (jTableCellFixture == null) {
            JTableCellFixture.$$$reportNull$$$0(25);
        }
        return jTableCellFixture;
    }

    @Override
    @Nonnull
    public JPopupMenuFixture showPopupMenu() {
        JPopupMenuFixture jPopupMenuFixture = this.table.showPopupMenuAt(this.cell());
        if (jPopupMenuFixture == null) {
            JTableCellFixture.$$$reportNull$$$0(26);
        }
        return jPopupMenuFixture;
    }

    @Nonnull
    public JTableCellFixture requireEditable() {
        this.table.requireEditable(this.cell());
        JTableCellFixture jTableCellFixture = this;
        if (jTableCellFixture == null) {
            JTableCellFixture.$$$reportNull$$$0(27);
        }
        return jTableCellFixture;
    }

    @Nonnull
    public JTableCellFixture requireNotEditable() {
        this.table.requireNotEditable(this.cell());
        JTableCellFixture jTableCellFixture = this;
        if (jTableCellFixture == null) {
            JTableCellFixture.$$$reportNull$$$0(28);
        }
        return jTableCellFixture;
    }

    public int row() {
        return this.cell.row;
    }

    public int column() {
        return this.cell.column;
    }

    @Nonnull
    @VisibleForTesting
    JTableFixture tableFixture() {
        JTableFixture jTableFixture = this.table;
        if (jTableFixture == null) {
            JTableCellFixture.$$$reportNull$$$0(29);
        }
        return jTableFixture;
    }

    @Nonnull
    @VisibleForTesting
    TableCell cell() {
        TableCell tableCell = this.cell;
        if (tableCell == null) {
            JTableCellFixture.$$$reportNull$$$0(30);
        }
        return tableCell;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cell";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/fixture/JTableCellFixture";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mouseClickInfo";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/fixture/JTableCellFixture";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "select";
                break;
            }
            case 7: 
            case 9: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "click";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "doubleClick";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "rightClick";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "startEditing";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "stopEditing";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "cancelEditing";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "enterValue";
                break;
            }
            case 19: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "requireValue";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "background";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "foreground";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "drag";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "drop";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "showPopupMenu";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "requireEditable";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "requireNotEditable";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "tableFixture";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "cell";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                break;
            }
            case 8: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "click";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "enterValue";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "requireValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

