/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.format;

import java.awt.Component;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.swing.JList;
import javax.swing.ListModel;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.format.ComponentFormatterTemplate;
import org.fest.swing.format.SwingIntEnums;
import org.fest.util.Arrays;
import org.fest.util.Lists;
import org.fest.util.Strings;

public class JListFormatter
extends ComponentFormatterTemplate {
    @Override
    @Nonnull
    @RunsInCurrentThread
    protected String doFormat(@Nonnull Component c) {
        if (c == null) {
            JListFormatter.$$$reportNull$$$0(0);
        }
        JList list = (JList)c;
        String format = "%s[name=%s, selectedValues=%s, contents=%s, selectionMode=%s, enabled=%b, visible=%b, showing=%b]";
        String string = String.format(format, list.getClass().getName(), Strings.quote((String)list.getName()), Arrays.format((Object)list.getSelectedValues()), Arrays.format((Object)this.contentsOf(list)), SwingIntEnums.SELECTION_MODES.get(list.getSelectionMode()), list.isEnabled(), list.isVisible(), list.isShowing());
        if (string == null) {
            JListFormatter.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nonnull
    private Object[] contentsOf(JList list) {
        ArrayList contents = Lists.newArrayList();
        ListModel model = list.getModel();
        int size = model.getSize();
        for (int i = 0; i < size; ++i) {
            contents.add(model.getElementAt(i));
        }
        Object[] objectArray = contents.toArray();
        if (objectArray == null) {
            JListFormatter.$$$reportNull$$$0(2);
        }
        return objectArray;
    }

    @Override
    @Nonnull
    public Class<? extends Component> targetType() {
        if (JList.class == null) {
            JListFormatter.$$$reportNull$$$0(3);
        }
        return JList.class;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/format/JListFormatter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/format/JListFormatter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "doFormat";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsOf";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "targetType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doFormat";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

