/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.monitor;

import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Robot;
import java.awt.Window;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.monitor.WindowMetrics;
import org.fest.swing.monitor.Windows;
import org.fest.swing.query.ComponentSizeQuery;
import org.fest.swing.util.RobotFactory;

class WindowStatus {
    private static final Dimension MINIMUM_WINDOW_SIZE = new Dimension(50, 30);
    private static Logger logger = Logger.getLogger(WindowStatus.class.getCanonicalName());
    private static int sign = 1;
    private final Windows windows;
    final Robot robot;

    WindowStatus(@Nonnull Windows windows) {
        if (windows == null) {
            WindowStatus.$$$reportNull$$$0(0);
        }
        this(windows, new RobotFactory());
    }

    WindowStatus(@Nonnull Windows windows, @Nonnull RobotFactory robotFactory) {
        if (windows == null) {
            WindowStatus.$$$reportNull$$$0(1);
        }
        if (robotFactory == null) {
            WindowStatus.$$$reportNull$$$0(2);
        }
        this.windows = windows;
        Robot r = null;
        try {
            r = robotFactory.newRobotInPrimaryScreen();
        }
        catch (AWTException ignored) {
            logger.log(Level.WARNING, "Error ocurred when creating a new Robot", ignored);
        }
        this.robot = r;
    }

    @Nonnull
    Windows windows() {
        Windows windows = this.windows;
        if (windows == null) {
            WindowStatus.$$$reportNull$$$0(3);
        }
        return windows;
    }

    @RunsInEDT
    void checkIfReady(@Nonnull Window w) {
        if (w == null) {
            WindowStatus.$$$reportNull$$$0(4);
        }
        if (this.robot == null) {
            return;
        }
        try {
            this.checkSafelyIfReady(w);
        }
        catch (Exception ignored) {
            logger.log(Level.WARNING, "Error ocurred when checking if window is ready", ignored);
        }
    }

    @RunsInEDT
    private void checkSafelyIfReady(final @Nonnull Window w) {
        if (w == null) {
            WindowStatus.$$$reportNull$$$0(5);
        }
        if (!this.windows.isShowingButNotReady(w)) {
            return;
        }
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                WindowStatus.this.makeLargeEnoughToReceiveEvents(w);
            }
        });
        this.mouseMove(w, WindowStatus.centerOf(w));
    }

    @RunsInEDT
    private static Point centerOf(final @Nonnull Window w) {
        if (w == null) {
            WindowStatus.$$$reportNull$$$0(6);
        }
        return GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            protected Point executeInEDT() {
                return WindowMetrics.absoluteCenterOf(w);
            }
        });
    }

    @RunsInEDT
    private void mouseMove(@Nonnull Window w, @Nonnull Point point) {
        if (w == null) {
            WindowStatus.$$$reportNull$$$0(7);
        }
        if (point == null) {
            WindowStatus.$$$reportNull$$$0(8);
        }
        int x = point.x;
        int y = point.y;
        if (x == 0 || y == 0) {
            return;
        }
        this.robot.mouseMove(x, y);
        Dimension windowSize = ComponentSizeQuery.sizeOf(w);
        if (windowSize.width > windowSize.height) {
            this.robot.mouseMove(x + sign, y);
        } else {
            this.robot.mouseMove(x, y + sign);
        }
        sign = -sign;
    }

    @RunsInCurrentThread
    private void makeLargeEnoughToReceiveEvents(@Nonnull Window window) {
        if (window == null) {
            WindowStatus.$$$reportNull$$$0(9);
        }
        if (!this.shouldResize(window)) {
            return;
        }
        window.setSize(MINIMUM_WINDOW_SIZE);
    }

    @RunsInCurrentThread
    private boolean shouldResize(@Nonnull Window window) {
        if (window == null) {
            WindowStatus.$$$reportNull$$$0(10);
        }
        Insets insets = window.getInsets();
        int w = window.getWidth() - (insets.left + insets.right);
        if (w < WindowStatus.MINIMUM_WINDOW_SIZE.width) {
            return true;
        }
        int h = window.getHeight() - (insets.top + insets.bottom);
        return h < WindowStatus.MINIMUM_WINDOW_SIZE.height;
    }

    static int sign() {
        return sign;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "windows";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "robotFactory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/monitor/WindowStatus";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "w";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/monitor/WindowStatus";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "windows";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkIfReady";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkSafelyIfReady";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "centerOf";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "mouseMove";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "makeLargeEnoughToReceiveEvents";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "shouldResize";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

