/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.monitor;

import java.awt.Component;
import java.awt.Window;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.monitor.ProtectingTimerTask;
import org.fest.swing.monitor.WindowVisibilityMonitor;
import org.fest.util.Maps;
import org.fest.util.VisibleForTesting;

@ThreadSafe
class Windows {
    @VisibleForTesting
    static int WINDOW_READY_DELAY = 10000;
    @GuardedBy(value="lock")
    final Map<Window, TimerTask> pending = Maps.newWeakHashMap();
    @GuardedBy(value="lock")
    final Map<Window, Boolean> open = Maps.newWeakHashMap();
    @GuardedBy(value="lock")
    final Map<Window, Boolean> closed = Maps.newWeakHashMap();
    @GuardedBy(value="lock")
    final Map<Window, Boolean> hidden = Maps.newWeakHashMap();
    private final Timer windowReadyTimer;
    private final Object lock = new Object();

    Windows() {
        this.windowReadyTimer = new Timer("Window Ready Timer", true);
    }

    void attachNewWindowVisibilityMonitor(Window target) {
        WindowVisibilityMonitor monitor = new WindowVisibilityMonitor(this);
        target.addWindowListener(monitor);
        target.addComponentListener(monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RunsInCurrentThread
    void markExisting(@Nonnull Window w) {
        if (w == null) {
            Windows.$$$reportNull$$$0(0);
        }
        Object object = this.lock;
        synchronized (object) {
            this.open.put(w, true);
            if (!w.isShowing()) {
                this.hidden.put(w, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markAsHidden(@Nonnull Window w) {
        if (w == null) {
            Windows.$$$reportNull$$$0(1);
        }
        Object object = this.lock;
        synchronized (object) {
            this.hidden.put(w, true);
            this.removeWindowFrom(w, this.pending);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markAsShowing(final @Nonnull Window w) {
        if (w == null) {
            Windows.$$$reportNull$$$0(2);
        }
        Object object = this.lock;
        synchronized (object) {
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    Windows.this.markAsReady(w);
                }
            };
            this.windowReadyTimer.schedule((TimerTask)new ProtectingTimerTask(task), WINDOW_READY_DELAY);
            this.pending.put(w, task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markAsReady(@Nonnull Window w) {
        if (w == null) {
            Windows.$$$reportNull$$$0(3);
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.pending.containsKey(w)) {
                return;
            }
            this.removeWindowFrom(w, this.closed, this.hidden, this.pending);
            this.open.put(w, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markAsClosed(@Nonnull Window w) {
        if (w == null) {
            Windows.$$$reportNull$$$0(4);
        }
        Object object = this.lock;
        synchronized (object) {
            this.removeWindowFrom(w, this.open, this.hidden, this.pending);
            this.closed.put(w, true);
        }
    }

    private void removeWindowFrom(Window w, Map<?, ?> ... maps) {
        for (Map<?, ?> map : maps) {
            map.remove(w);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isClosed(@Nonnull Component c) {
        if (c == null) {
            Windows.$$$reportNull$$$0(5);
        }
        Object object = this.lock;
        synchronized (object) {
            return this.closed.containsKey(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isReady(@Nonnull Window w) {
        if (w == null) {
            Windows.$$$reportNull$$$0(6);
        }
        Object object = this.lock;
        synchronized (object) {
            return this.open.containsKey(w) && !this.hidden.containsKey(w);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isHidden(@Nonnull Window w) {
        if (w == null) {
            Windows.$$$reportNull$$$0(7);
        }
        Object object = this.lock;
        synchronized (object) {
            return this.hidden.containsKey(w);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isShowingButNotReady(@Nonnull Window w) {
        if (w == null) {
            Windows.$$$reportNull$$$0(8);
        }
        Object object = this.lock;
        synchronized (object) {
            return this.pending.containsKey(w);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "w";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
        }
        objectArray2[1] = "org/fest/swing/monitor/Windows";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "markExisting";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "markAsHidden";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "markAsShowing";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "markAsReady";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "markAsClosed";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isClosed";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isReady";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isHidden";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isShowingButNotReady";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

