/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.util;

import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.swing.util.Patterns;
import org.fest.swing.util.Strings;
import org.fest.swing.util.TextMatcher;
import org.fest.util.Preconditions;

public class PatternTextMatcher
implements TextMatcher {
    private final Pattern[] patterns;

    public PatternTextMatcher(Pattern ... patterns) {
        if (patterns == null) {
            PatternTextMatcher.$$$reportNull$$$0(0);
        }
        this.patterns = (Pattern[])Preconditions.checkNotNullOrEmpty((Object[])patterns);
    }

    @Override
    public boolean isMatching(@Nullable String text) {
        for (Pattern pattern : this.patterns) {
            if (!Strings.match(pattern, text)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public String description() {
        String string = this.patterns.length == 1 ? "pattern" : "patterns";
        if (string == null) {
            PatternTextMatcher.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nonnull
    public String formattedValues() {
        if (this.patterns.length == 1) {
            String string = (String)Preconditions.checkNotNull((Object)org.fest.util.Strings.quote((String)this.patterns[0].pattern()));
            if (string == null) {
                PatternTextMatcher.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = Patterns.format(this.patterns);
        if (string == null) {
            PatternTextMatcher.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/util/PatternTextMatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/util/PatternTextMatcher";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "description";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "formattedValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

