/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.util;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.swing.util.Strings;
import org.fest.swing.util.TextMatcher;
import org.fest.util.Arrays;
import org.fest.util.Preconditions;

public class StringTextMatcher
implements TextMatcher {
    private final String[] values;

    public StringTextMatcher(String ... values) {
        if (values == null) {
            StringTextMatcher.$$$reportNull$$$0(0);
        }
        this.values = (String[])Preconditions.checkNotNullOrEmpty((Object[])values);
    }

    @Override
    public boolean isMatching(@Nullable String text) {
        for (String value : this.values) {
            if (!Strings.areEqualOrMatch(value, text)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public String description() {
        String string = this.onlyOneValue() ? "value" : "values";
        if (string == null) {
            StringTextMatcher.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nonnull
    public String formattedValues() {
        String s = this.onlyOneValue() ? org.fest.util.Strings.quote((String)this.values[0]) : Arrays.format((Object)this.values);
        String string = (String)Preconditions.checkNotNull((Object)s);
        if (string == null) {
            StringTextMatcher.$$$reportNull$$$0(2);
        }
        return string;
    }

    private boolean onlyOneValue() {
        return this.values.length == 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/util/StringTextMatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/util/StringTextMatcher";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "description";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "formattedValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

