/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.indices;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.WildcardQuery;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.indices.MavenArtifactSearchResult;
import org.jetbrains.idea.maven.indices.MavenProjectIndicesManager;
import org.jetbrains.idea.maven.indices.MavenSearcher;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;

public class MavenArtifactSearcher
extends MavenSearcher<MavenArtifactSearchResult> {
    public static final String TERM = "u";
    private final boolean myUseLuceneIndexes;

    public MavenArtifactSearcher() {
        this(false);
    }

    public MavenArtifactSearcher(boolean useLuceneIndexes) {
        this.myUseLuceneIndexes = useLuceneIndexes;
    }

    @Override
    public List<MavenArtifactSearchResult> search(Project project, String pattern, int maxResult) {
        return this.myUseLuceneIndexes ? super.search(project, pattern, maxResult) : MavenArtifactSearcher.getResultsFromIdeaCache(project, pattern, maxResult);
    }

    @NotNull
    private static List<MavenArtifactSearchResult> getResultsFromIdeaCache(Project project, String pattern, int maxResult) {
        ArrayList<String> parts = new ArrayList<String>();
        for (String each : StringUtil.tokenize((String)pattern, (String)" :")) {
            parts.add(each);
        }
        List searchResults = ContainerUtil.newSmartList();
        MavenProjectIndicesManager m = MavenProjectIndicesManager.getInstance(project);
        int count = 0;
        block1: for (String groupId : m.getGroupIds()) {
            if (count >= maxResult) break;
            if (parts.size() >= 1 && !StringUtil.contains((CharSequence)groupId, (CharSequence)((CharSequence)parts.get(0)))) continue;
            for (String artifactId : m.getArtifactIds(groupId)) {
                if (parts.size() < 2 || StringUtil.contains((CharSequence)artifactId, (CharSequence)((CharSequence)parts.get(1)))) {
                    List versions = ContainerUtil.newSmartList();
                    for (String version : m.getVersions(groupId, artifactId)) {
                        if (parts.size() >= 3 && !StringUtil.contains((CharSequence)version, (CharSequence)((CharSequence)parts.get(2)))) continue;
                        versions.add(new MavenArtifactInfo(groupId, artifactId, version, "jar", null));
                        if (++count < maxResult) continue;
                        break;
                    }
                    if (!versions.isEmpty()) {
                        MavenArtifactSearchResult searchResult = new MavenArtifactSearchResult();
                        searchResult.versions.addAll(versions);
                        searchResults.add(searchResult);
                    }
                }
                if (count < maxResult) continue;
                continue block1;
            }
        }
        List list = searchResults;
        if (list == null) {
            MavenArtifactSearcher.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    protected Pair<String, Query> preparePatternAndQuery(String pattern) {
        if ((pattern = StringUtil.toLowerCase((String)pattern)).trim().length() == 0) {
            return Pair.create((Object)pattern, (Object)new MatchAllDocsQuery());
        }
        ArrayList<String> parts = new ArrayList<String>();
        for (String each : StringUtil.tokenize((String)pattern, (String)" :")) {
            parts.add(each);
        }
        BooleanQuery query = new BooleanQuery();
        if (parts.size() == 1) {
            query.add((Query)new WildcardQuery(new Term(TERM, "*" + (String)parts.get(0) + "*|*|*|*")), BooleanClause.Occur.SHOULD);
            query.add((Query)new WildcardQuery(new Term(TERM, "*|*" + (String)parts.get(0) + "*|*|*")), BooleanClause.Occur.SHOULD);
        }
        if (parts.size() == 2) {
            query.add((Query)new WildcardQuery(new Term(TERM, "*" + (String)parts.get(0) + "*|*" + (String)parts.get(1) + "*|*|*")), BooleanClause.Occur.SHOULD);
            query.add((Query)new WildcardQuery(new Term(TERM, "*" + (String)parts.get(0) + "*|*|" + (String)parts.get(1) + "*|*")), BooleanClause.Occur.SHOULD);
            query.add((Query)new WildcardQuery(new Term(TERM, "*|*" + (String)parts.get(0) + "*|" + (String)parts.get(1) + "*|*")), BooleanClause.Occur.SHOULD);
        }
        if (parts.size() >= 3) {
            String s = "*" + (String)parts.get(0) + "*|*" + (String)parts.get(1) + "*|" + (String)parts.get(2) + "*|*";
            query.add((Query)new WildcardQuery(new Term(TERM, s)), BooleanClause.Occur.MUST);
        }
        return Pair.create((Object)pattern, (Object)query);
    }

    @Override
    protected Collection<MavenArtifactSearchResult> processResults(Set<MavenArtifactInfo> infos, String pattern, int maxResult) {
        THashMap result = new THashMap();
        for (MavenArtifactInfo each : infos) {
            if (!StringUtil.isEmptyOrSpaces((String)each.getClassifier())) continue;
            String key = this.makeKey(each);
            MavenArtifactSearchResult searchResult = (MavenArtifactSearchResult)result.get(key);
            if (searchResult == null) {
                searchResult = new MavenArtifactSearchResult();
                result.put(key, searchResult);
            }
            searchResult.versions.add(each);
        }
        return result.values();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/indices/MavenArtifactSearcher", "getResultsFromIdeaCache"));
    }
}

