/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.chart.hchart;

import com.android.tools.adtui.chart.hchart.HRenderer;
import com.android.tools.adtui.chart.hchart.Method;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.geom.Rectangle2D;

public class NativeMethodHRenderer
extends HRenderer<Method> {
    @Override
    protected String generateFittingText(Method method, Rectangle2D rect, FontMetrics fontMetrics) {
        String fullyQualified = method.getNameSpace() + "::" + method.getName();
        if ((double)fontMetrics.stringWidth(fullyQualified) < rect.getWidth()) {
            return fullyQualified;
        }
        if ((double)fontMetrics.stringWidth(method.getName()) < rect.getWidth()) {
            return method.getName();
        }
        return "";
    }

    protected boolean isMethodPlatform(Method method) {
        return method.getNameSpace().contains("android") || method.getNameSpace().contains("Android");
    }

    protected boolean isMethodVendor(Method method) {
        return method.getNameSpace().length() == 0 || method.getName().contains("std");
    }

    @Override
    protected Color getFillColor(Method m) {
        if (this.isMethodVendor(m)) {
            return fillVendorColor;
        }
        if (this.isMethodPlatform(m)) {
            return fillPlatformColor;
        }
        return fillAppColor;
    }

    @Override
    protected Color getBordColor(Method m) {
        if (this.isMethodVendor(m)) {
            return bordVendorColor;
        }
        if (this.isMethodPlatform(m)) {
            return bordPlatformColor;
        }
        return bordAppColor;
    }
}

