/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser;

import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0018\u00010\bR\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Lorg/intellij/markdown/parser/LookaheadText;", "", "text", "", "(Ljava/lang/String;)V", "lines", "", "startPosition", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "getStartPosition", "()Lorg/intellij/markdown/parser/LookaheadText$Position;", "getText", "()Ljava/lang/String;", "Position", "intellij-markdown"})
public final class LookaheadText {
    private final List<String> lines;
    @Nullable
    private final Position startPosition;
    @NotNull
    private final String text;

    @Nullable
    public final Position getStartPosition() {
        return this.startPosition;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    public LookaheadText(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        this.text = text;
        this.lines = StringsKt.split$default((CharSequence)this.text, (char[])new char[]{'\n'}, (boolean)false, (int)0, (int)6, null);
        CharSequence charSequence = this.text;
        LookaheadText lookaheadText = this;
        boolean bl = charSequence.length() > 0;
        lookaheadText.startPosition = bl ? Position.nextPosition$default(new Position(0, -1, -1), 0, 1, null) : (Position)null;
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\r\u0010#\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0017J\f\u0010$\u001a\b\u0018\u00010\u0000R\u00020%J\u0016\u0010&\u001a\b\u0018\u00010\u0000R\u00020%2\b\b\u0002\u0010'\u001a\u00020\u0003J\b\u0010(\u001a\u00020\fH\u0016R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000eR\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001aR\u0011\u0010\u001d\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001aR\u0013\u0010\u001f\u001a\u0004\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u000eR\u0011\u0010!\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0012\u00a8\u0006)"}, d2={"Lorg/intellij/markdown/parser/LookaheadText$Position;", "", "lineN", "", "localPos", "globalPos", "(Lorg/intellij/markdown/parser/LookaheadText;III)V", "char", "", "getChar", "()C", "currentLine", "", "getCurrentLine", "()Ljava/lang/String;", "currentLineFromPosition", "", "getCurrentLineFromPosition", "()Ljava/lang/CharSequence;", "nextLine", "getNextLine", "nextLineOffset", "getNextLineOffset", "()Ljava/lang/Integer;", "nextLineOrEofOffset", "getNextLineOrEofOffset", "()I", "offset", "getOffset", "offsetInCurrentLine", "getOffsetInCurrentLine", "prevLine", "getPrevLine", "textFromPosition", "getTextFromPosition", "charsToNonWhitespace", "nextLinePosition", "Lorg/intellij/markdown/parser/LookaheadText;", "nextPosition", "delta", "toString", "intellij-markdown"})
    public final class Position {
        private final int lineN;
        private final int localPos;
        private final int globalPos;

        @NotNull
        public String toString() {
            String string;
            StringBuilder stringBuilder = new StringBuilder().append("Position: '");
            if (this.localPos == -1) {
                string = "\\n" + this.getCurrentLine();
            } else {
                String string2 = this.getCurrentLine();
                int n = this.localPos;
                StringBuilder stringBuilder2 = stringBuilder;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
                String string5 = string4;
                stringBuilder = stringBuilder2;
                string = string5;
            }
            return stringBuilder.append(string).append("'").toString();
        }

        public final int getOffset() {
            return this.globalPos;
        }

        public final int getOffsetInCurrentLine() {
            return this.localPos;
        }

        @Nullable
        public final Integer getNextLineOffset() {
            return this.lineN + 1 < LookaheadText.this.lines.size() ? Integer.valueOf(this.globalPos + (this.getCurrentLine().length() - this.localPos)) : (Integer)null;
        }

        public final int getNextLineOrEofOffset() {
            return this.globalPos + (this.getCurrentLine().length() - this.localPos);
        }

        @NotNull
        public final CharSequence getTextFromPosition() {
            return LookaheadText.this.getText().subSequence(this.globalPos, LookaheadText.this.getText().length());
        }

        @NotNull
        public final String getCurrentLine() {
            return (String)LookaheadText.this.lines.get(this.lineN);
        }

        @NotNull
        public final CharSequence getCurrentLineFromPosition() {
            return this.getCurrentLine().subSequence(this.getOffsetInCurrentLine(), this.getCurrentLine().length());
        }

        @Nullable
        public final String getNextLine() {
            return this.lineN + 1 < LookaheadText.this.lines.size() ? (String)LookaheadText.this.lines.get(this.lineN + 1) : (String)null;
        }

        @Nullable
        public final String getPrevLine() {
            return this.lineN > 0 ? (String)LookaheadText.this.lines.get(this.lineN - 1) : (String)null;
        }

        public final char getChar() {
            return LookaheadText.this.getText().charAt(this.globalPos);
        }

        @Nullable
        public final Position nextPosition(int delta) {
            int remaining = delta;
            Position currentPosition = this;
            while (currentPosition.localPos + remaining >= currentPosition.getCurrentLine().length()) {
                Integer nextLine = currentPosition.getNextLineOffset();
                if (nextLine == null) {
                    return null;
                }
                int payload = currentPosition.getCurrentLine().length() - currentPosition.localPos;
                currentPosition = new Position(currentPosition.lineN + 1, -1, currentPosition.globalPos + payload);
                remaining -= payload;
            }
            return new Position(currentPosition.lineN, currentPosition.localPos + remaining, currentPosition.globalPos + remaining);
        }

        @Nullable
        public static /* bridge */ /* synthetic */ Position nextPosition$default(Position position, int n, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: nextPosition");
            }
            if ((n2 & 1) != 0) {
                n = 1;
            }
            return position.nextPosition(n);
        }

        @Nullable
        public final Position nextLinePosition() {
            Integer n = this.getNextLineOffset();
            if (n == null) {
                return null;
            }
            int nextLine = ((Number)n).intValue();
            return this.nextPosition(nextLine - this.getOffset());
        }

        @Nullable
        public final Integer charsToNonWhitespace() {
            String line = this.getCurrentLine();
            for (int offset = this.localPos; offset < line.length(); ++offset) {
                char c;
                if (offset < 0 || (c = line.charAt(offset)) == ' ' || c == '\t') continue;
                return offset - this.localPos;
            }
            return null;
        }

        public Position(int lineN, int localPos, int globalPos) {
            Unit unit;
            Unit unit2;
            this.lineN = lineN;
            this.localPos = localPos;
            this.globalPos = globalPos;
            boolean bl = this.lineN < LookaheadText.this.lines.size();
            if (_Assertions.ENABLED) {
                if (!bl) {
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                unit2 = Unit.INSTANCE;
            } else {
                unit2 = Unit.INSTANCE;
            }
            bl = this.localPos >= -1 && this.localPos < ((String)LookaheadText.this.lines.get(this.lineN)).length();
            if (_Assertions.ENABLED) {
                if (!bl) {
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
        }
    }
}

