/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import icons.UIDesignerIcons;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseLocaleAction
extends ComboBoxAction {
    private GuiEditor myLastEditor;
    private Presentation myPresentation;

    public ChooseLocaleAction() {
        this.getTemplatePresentation().setText("");
        this.getTemplatePresentation().setDescription(UIDesignerBundle.message("choose.locale.description", new Object[0]));
        this.getTemplatePresentation().setIcon(UIDesignerIcons.ChooseLocale);
    }

    public JComponent createCustomComponent(Presentation presentation) {
        this.myPresentation = presentation;
        return super.createCustomComponent(presentation);
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent button) {
        DefaultActionGroup group = new DefaultActionGroup();
        GuiEditor editor = this.myLastEditor;
        if (editor != null) {
            Locale[] locales = FormEditingUtil.collectUsedLocales(editor.getModule(), editor.getRootContainer());
            if (locales.length > 1 || locales.length == 1 && locales[0].getDisplayName().length() > 0) {
                Arrays.sort(locales, (o1, o2) -> o1.getDisplayName().compareTo(o2.getDisplayName()));
                for (Locale locale : locales) {
                    group.add((AnAction)new SetLocaleAction(editor, locale, true));
                }
            } else {
                group.add((AnAction)new SetLocaleAction(editor, new Locale(""), false));
            }
        }
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            ChooseLocaleAction.$$$reportNull$$$0(0);
        }
        return defaultActionGroup;
    }

    @Nullable
    private GuiEditor getEditor(AnActionEvent e) {
        this.myLastEditor = FormEditingUtil.getActiveEditor(e.getDataContext());
        return this.myLastEditor;
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setVisible(this.getEditor(e) != null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/actions/ChooseLocaleAction", "createPopupActionGroup"));
    }

    private class SetLocaleAction
    extends AnAction {
        private final GuiEditor myEditor;
        private final Locale myLocale;
        private final boolean myUpdateText;

        public SetLocaleAction(GuiEditor editor, Locale locale, boolean updateText) {
            super(locale.getDisplayName().length() == 0 ? UIDesignerBundle.message("choose.locale.default", new Object[0]) : locale.getDisplayName());
            this.myUpdateText = updateText;
            this.myEditor = editor;
            this.myLocale = locale;
        }

        public void actionPerformed(AnActionEvent e) {
            this.myEditor.setStringDescriptorLocale(this.myLocale);
            if (this.myUpdateText) {
                ChooseLocaleAction.this.myPresentation.setText(this.getTemplatePresentation().getText());
            }
        }
    }
}

