/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.i18n;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.i18n.I18nInspection;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.i18n.I18nizeFormBorderQuickFix;
import com.intellij.uiDesigner.i18n.I18nizeFormPropertyQuickFix;
import com.intellij.uiDesigner.i18n.I18nizeTabTitleQuickFix;
import com.intellij.uiDesigner.inspections.EditorQuickFixProvider;
import com.intellij.uiDesigner.inspections.FormErrorCollector;
import com.intellij.uiDesigner.inspections.StringDescriptorInspection;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.lw.IProperty;
import com.intellij.uiDesigner.lw.StringDescriptor;
import com.intellij.uiDesigner.propertyInspector.IntrospectedProperty;
import com.intellij.uiDesigner.radComponents.RadContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class I18nFormInspection
extends StringDescriptorInspection {
    public I18nFormInspection() {
        super("I18nForm");
    }

    @Nullable
    public String getAlternativeID() {
        return "HardCodedStringLiteral";
    }

    @Override
    protected void checkStringDescriptor(Module module, IComponent component, IProperty prop, StringDescriptor descriptor, FormErrorCollector collector) {
        if (I18nFormInspection.isHardCodedStringDescriptor(descriptor)) {
            if (I18nFormInspection.isPropertyDescriptor(prop) && I18nFormInspection.isSetterNonNls(module.getProject(), GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module), component.getComponentClassName(), prop.getName())) {
                return;
            }
            EditorQuickFixProvider provider = prop.getName().equals("border") ? (editor, component12) -> new I18nizeFormBorderQuickFix(editor, UIDesignerBundle.message("i18n.quickfix.border.title", new Object[0]), (RadContainer)component12) : (prop.getName().equals("Tab Title") || prop.getName().equals("Tab Tooltip") ? (editor, component1) -> new I18nizeTabTitleQuickFix(editor, UIDesignerBundle.message("i18n.quickfix.tab.title", prop.getName()), component1, prop.getName()) : (editor, component13) -> new I18nizeFormPropertyQuickFix(editor, UIDesignerBundle.message("i18n.quickfix.property", prop.getName()), component13, (IntrospectedProperty)prop));
            collector.addError(this.getID(), component, prop, UIDesignerBundle.message("inspection.i18n.message.in.form", descriptor.getValue()), provider);
        }
    }

    private static boolean isPropertyDescriptor(IProperty prop) {
        return !prop.getName().equals("border") && !prop.getName().equals("Tab Title") && !prop.getName().equals("Tab Tooltip");
    }

    private static boolean isHardCodedStringDescriptor(StringDescriptor descriptor) {
        return !descriptor.isNoI18n() && descriptor.getBundleName() == null && descriptor.getKey() == null && StringUtil.containsAlphaCharacters((String)descriptor.getValue());
    }

    private static boolean isSetterNonNls(Project project, GlobalSearchScope searchScope, String componentClassName, String propertyName) {
        PsiParameter[] parameters;
        PsiClass componentClass = JavaPsiFacade.getInstance((Project)project).findClass(componentClassName, searchScope);
        if (componentClass == null) {
            return false;
        }
        PsiMethod setter = PropertyUtilBase.findPropertySetter((PsiClass)componentClass, (String)propertyName, (boolean)false, (boolean)true);
        return setter != null && (parameters = setter.getParameterList().getParameters()).length == 1 && "java.lang.String".equals(parameters[0].getType().getCanonicalText()) && AnnotationUtil.isAnnotated((PsiModifierListOwner)parameters[0], (String)"org.jetbrains.annotations.NonNls", (boolean)false, (boolean)true);
    }

    @Override
    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiDirectory directory;
        if (file == null) {
            I18nFormInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            I18nFormInspection.$$$reportNull$$$0(1);
        }
        if (file.getFileType().equals(StdFileTypes.GUI_DESIGNER_FORM) && (directory = file.getContainingDirectory()) != null && I18nInspection.isPackageNonNls((PsiPackage)JavaDirectoryService.getInstance().getPackage(directory))) {
            return null;
        }
        return super.checkFile(file, manager, isOnTheFly);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
        }
        objectArray[1] = "com/intellij/uiDesigner/i18n/I18nFormInspection";
        objectArray[2] = "checkFile";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

