/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.componentTree.ComponentSelectionListener;
import com.intellij.uiDesigner.componentTree.ComponentTree;
import com.intellij.uiDesigner.designSurface.GridCaptionPanel;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.propertyInspector.PropertyInspectorTable;
import com.intellij.uiDesigner.propertyInspector.QuickFixManagerImpl;
import com.intellij.uiDesigner.quickFixes.QuickFixManager;
import com.intellij.uiDesigner.radComponents.ButtonGroupPropertiesPanel;
import com.intellij.uiDesigner.radComponents.CustomPropertiesPanel;
import com.intellij.uiDesigner.radComponents.RadButtonGroup;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.util.IJSwingUtilities;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class PropertyInspector
extends JPanel {
    private final PropertyInspectorTable myInspectorTable;
    private final ComponentTree myComponentTree;
    private final QuickFixManager myQuickFixManager;
    private GuiEditor myEditor;
    private final MyComponentSelectionListener myComponentSelectionListener;
    @NonNls
    private static final String INSPECTOR_CARD = "inspector";
    @NonNls
    private static final String EMPTY_CARD = "empty";
    @NonNls
    private static final String CUSTOM_CARD = "column";
    private final JScrollPane myCustomPropertiesScrollPane;
    private CustomPropertiesPanel myCustomPropertiesPanel;
    private final ChangeListener myCustomPropertiesChangeListener;
    private RadContainer myPropertiesPanelContainer;

    public PropertyInspector(Project project, @NotNull ComponentTree componentTree) {
        if (componentTree == null) {
            PropertyInspector.$$$reportNull$$$0(0);
        }
        super(new CardLayout());
        this.myCustomPropertiesScrollPane = ScrollPaneFactory.createScrollPane();
        this.myInspectorTable = new PropertyInspectorTable(project, componentTree);
        this.myComponentTree = componentTree;
        JPanel inspectorCard = new JPanel(new GridBagLayout());
        JScrollPane inspectorScrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)this.myInspectorTable));
        inspectorScrollPane.setBorder(IdeBorderFactory.createBorder((int)8));
        inspectorCard.add((Component)inspectorScrollPane, new GridBagConstraints(0, 0, 0, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        final JCheckBox chkShowExpertProperties = new JCheckBox(UIDesignerBundle.message("chk.show.expert.properties", new Object[0]));
        inspectorCard.add((Component)chkShowExpertProperties, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        chkShowExpertProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertyInspector.this.myInspectorTable.setShowExpertProperties(chkShowExpertProperties.isSelected());
            }
        });
        this.add((Component)inspectorCard, INSPECTOR_CARD);
        MultiLineLabel label = new MultiLineLabel(UIDesignerBundle.message("label.select.single.component.to.edit.its.properties", new Object[0])){

            public void updateUI() {
                super.updateUI();
                this.setBackground(PropertyInspector.this.myInspectorTable.getBackground());
            }
        };
        label.setOpaque(true);
        label.setHorizontalAlignment(0);
        this.add((Component)label, EMPTY_CARD);
        this.add((Component)this.myCustomPropertiesScrollPane, CUSTOM_CARD);
        this.myComponentSelectionListener = new MyComponentSelectionListener();
        this.synchWithTree(false);
        this.myQuickFixManager = new QuickFixManagerImpl(null, this.myInspectorTable, inspectorScrollPane.getViewport());
        this.myCustomPropertiesChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (PropertyInspector.this.myPropertiesPanelContainer != null) {
                    PropertyInspector.this.myPropertiesPanelContainer.revalidate();
                }
                if (PropertyInspector.this.myEditor.ensureEditable()) {
                    PropertyInspector.this.myEditor.refreshAndSave(true);
                }
            }
        };
    }

    public void setEditor(GuiEditor editor) {
        if (this.myEditor != editor) {
            if (this.myEditor != null) {
                this.myEditor.removeComponentSelectionListener(this.myComponentSelectionListener);
            }
            this.myEditor = editor;
            this.myInspectorTable.setEditor(this.myEditor);
            this.myQuickFixManager.setEditor(this.myEditor);
            if (this.myEditor != null) {
                this.myEditor.addComponentSelectionListener(this.myComponentSelectionListener);
            } else if (this.myCustomPropertiesPanel != null) {
                this.myCustomPropertiesPanel.removeChangeListener(this.myCustomPropertiesChangeListener);
            }
        }
    }

    public void refreshIntentionHint() {
        this.myQuickFixManager.refreshIntentionHint();
    }

    public void synchWithTree(boolean forceSynch) {
        CardLayout cardLayout = (CardLayout)this.getLayout();
        if (!this.showSelectedColumnProperties()) {
            RadComponent[] selectedComponents = this.myComponentTree.getSelectedComponents();
            if (selectedComponents.length >= 1) {
                cardLayout.show(this, INSPECTOR_CARD);
                this.myInspectorTable.synchWithTree(forceSynch);
            } else {
                List<RadButtonGroup> buttonGroups = this.myComponentTree.getSelectedElements(RadButtonGroup.class);
                if (buttonGroups.size() > 0) {
                    this.showButtonGroupProperties(buttonGroups.get(0));
                } else {
                    cardLayout.show(this, EMPTY_CARD);
                }
            }
        }
    }

    private void showButtonGroupProperties(RadButtonGroup group) {
        ButtonGroupPropertiesPanel props = new ButtonGroupPropertiesPanel(this.myEditor.getRootContainer(), group);
        this.myPropertiesPanelContainer = null;
        this.showCustomPropertiesPanel(props);
    }

    private boolean showSelectedColumnProperties() {
        if (this.myCustomPropertiesPanel != null && this.myPropertiesPanelContainer != null && IJSwingUtilities.hasFocus((Component)this.myCustomPropertiesPanel.getComponent())) {
            return true;
        }
        if (this.myEditor == null) {
            return false;
        }
        GridCaptionPanel panel = this.myEditor.getFocusedCaptionPanel();
        if (panel == null) {
            return false;
        }
        RadContainer container = panel.getSelectedContainer();
        if (container == null) {
            return false;
        }
        int[] selection = panel.getSelectedCells(null);
        this.myPropertiesPanelContainer = container;
        CustomPropertiesPanel propertiesPanel = container.getGridLayoutManager().getRowColumnPropertiesPanel(container, panel.isRow(), selection);
        if (propertiesPanel == null) {
            return false;
        }
        this.showCustomPropertiesPanel(propertiesPanel);
        return true;
    }

    private void showCustomPropertiesPanel(CustomPropertiesPanel propertiesPanel) {
        if (!Comparing.equal((Object)propertiesPanel, (Object)this.myCustomPropertiesPanel)) {
            if (this.myCustomPropertiesPanel != null) {
                this.myCustomPropertiesPanel.removeChangeListener(this.myCustomPropertiesChangeListener);
            }
            this.myCustomPropertiesPanel = propertiesPanel;
            this.myCustomPropertiesPanel.addChangeListener(this.myCustomPropertiesChangeListener);
            this.myCustomPropertiesScrollPane.getViewport().setView(this.myCustomPropertiesPanel.getComponent());
        }
        CardLayout cardLayout = (CardLayout)this.getLayout();
        cardLayout.show(this, CUSTOM_CARD);
    }

    public boolean isEditing() {
        return this.myInspectorTable.isEditing();
    }

    public void stopEditing() {
        this.myInspectorTable.editingStopped(null);
    }

    @Override
    public void requestFocus() {
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)((Object)this.myInspectorTable), true));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentTree", "com/intellij/uiDesigner/propertyInspector/PropertyInspector", "<init>"));
    }

    private final class MyComponentSelectionListener
    implements ComponentSelectionListener {
        private MyComponentSelectionListener() {
        }

        @Override
        public void selectedComponentChanged(GuiEditor source) {
            PropertyInspector.this.synchWithTree(false);
        }
    }
}

