/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GroovySuppressableInspectionTool;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrTraditionalForClause;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrUnnecessarySemicolonInspection
extends GroovySuppressableInspectionTool
implements CleanupLocalInspectionTool {
    private static final TokenSet NLS_SET = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mNLS});
    private static final TokenSet FORWARD_SET = TokenSet.andNot((TokenSet)TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSets.WHITE_SPACES_OR_COMMENTS, TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mSEMI})}), (TokenSet)NLS_SET);
    private static final TokenSet BACKWARD_SET = TokenSet.andNot((TokenSet)TokenSets.WHITE_SPACES_OR_COMMENTS, (TokenSet)NLS_SET);
    private static final LocalQuickFix FIX = new LocalQuickFix(){

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Remove semicolon" == null) {
                1.$$$reportNull$$$0(0);
            }
            return "Remove semicolon";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiElement element;
            if (project == null) {
                1.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                1.$$$reportNull$$$0(2);
            }
            if ((element = descriptor2.getPsiElement()) != null && element.getNode().getElementType() == GroovyTokenTypes.mSEMI) {
                CodeStyleManager.getInstance((Project)project).performActionWithFormatterDisabled(() -> ((PsiElement)element).delete());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/style/GrUnnecessarySemicolonInspection$1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/style/GrUnnecessarySemicolonInspection$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            GrUnnecessarySemicolonInspection.$$$reportNull$$$0(0);
        }
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                if (element.getNode().getElementType() != GroovyTokenTypes.mSEMI) {
                    return;
                }
                if (GrUnnecessarySemicolonInspection.isSemicolonNecessary(element)) {
                    return;
                }
                holder.registerProblem(element, "Semicolon is unnecessary", ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{FIX});
            }
        };
        if (psiElementVisitor == null) {
            GrUnnecessarySemicolonInspection.$$$reportNull$$$0(1);
        }
        return psiElementVisitor;
    }

    private static boolean isSemicolonNecessary(@NotNull PsiElement semicolon) {
        if (semicolon == null) {
            GrUnnecessarySemicolonInspection.$$$reportNull$$$0(2);
        }
        if (semicolon.getParent() instanceof GrTraditionalForClause) {
            return true;
        }
        PsiElement prevSibling = PsiUtil.skipSet(semicolon, false, BACKWARD_SET);
        PsiElement nextSibling = PsiUtil.skipSet(semicolon, true, FORWARD_SET);
        return prevSibling instanceof GrStatement && (nextSibling instanceof GrStatement || nextSibling != null && nextSibling.getNextSibling() instanceof GrClosableBlock);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/style/GrUnnecessarySemicolonInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "semicolon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/style/GrUnnecessarySemicolonInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSemicolonNecessary";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

