/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.debugger.fragments;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.IntentionFilterOwner;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnAmbiguousClosureContainer;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyFileImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyImportHelper;

public class GroovyCodeFragment
extends GroovyFileImpl
implements JavaCodeFragment,
IntentionFilterOwner,
GrUnAmbiguousClosureContainer {
    private PsiType myThisType;
    private PsiType mySuperType;
    private JavaCodeFragment.ExceptionHandler myExceptionChecker;
    private IntentionFilterOwner.IntentionActionsFilter myFilter;
    private GlobalSearchScope myResolveScope;
    private final LinkedHashMap<String, GrImportStatement> myPseudoImports = ContainerUtil.newLinkedHashMap();
    private final ArrayList<GrImportStatement> myOnDemandImports = ContainerUtil.newArrayList();
    private FileViewProvider myViewProvider = null;

    public GroovyCodeFragment(Project project, CharSequence text) {
        this(project, (VirtualFile)new LightVirtualFile("Dummy.groovy", (FileType)GroovyFileType.GROOVY_FILE_TYPE, text));
    }

    public GroovyCodeFragment(Project project, VirtualFile virtualFile) {
        super((FileViewProvider)new SingleRootFileViewProvider(PsiManager.getInstance((Project)project), virtualFile, true));
        ((SingleRootFileViewProvider)this.getViewProvider()).forceCachedPsi((PsiFile)this);
    }

    public void setThisType(PsiType thisType) {
        this.myThisType = thisType;
    }

    public PsiType getSuperType() {
        return this.mySuperType;
    }

    public void setSuperType(PsiType superType) {
        this.mySuperType = superType;
    }

    @NotNull
    public FileViewProvider getViewProvider() {
        if (this.myViewProvider != null) {
            FileViewProvider fileViewProvider = this.myViewProvider;
            if (fileViewProvider == null) {
                GroovyCodeFragment.$$$reportNull$$$0(0);
            }
            return fileViewProvider;
        }
        FileViewProvider fileViewProvider = super.getViewProvider();
        if (fileViewProvider == null) {
            GroovyCodeFragment.$$$reportNull$$$0(1);
        }
        return fileViewProvider;
    }

    public String importsToString() {
        if (this.myPseudoImports.isEmpty()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        for (Map.Entry<String, GrImportStatement> entry : this.myPseudoImports.entrySet()) {
            String importedName = entry.getKey();
            GrImportStatement anImport = entry.getValue();
            String qname = anImport.getImportReference().getClassNameText();
            buffer.append(qname);
            buffer.append(':').append(importedName);
            buffer.append(',');
        }
        for (GrImportStatement anImport : this.myOnDemandImports) {
            String packName = anImport.getImportReference().getClassNameText();
            buffer.append(packName);
            buffer.append(',');
        }
        buffer.deleteCharAt(buffer.length() - 1);
        return buffer.toString();
    }

    public void addImportsFromString(String imports2) {
        for (String anImport : imports2.split(",")) {
            int colon = anImport.indexOf(58);
            if (colon >= 0) {
                String qname = anImport.substring(0, colon);
                String importedName = anImport.substring(colon + 1);
                this.myPseudoImports.put(importedName, this.createSingleImport(qname, importedName));
                continue;
            }
            this.myOnDemandImports.add(this.createImportOnDemand(anImport));
        }
    }

    public void setVisibilityChecker(JavaCodeFragment.VisibilityChecker checker) {
    }

    public JavaCodeFragment.VisibilityChecker getVisibilityChecker() {
        return JavaCodeFragment.VisibilityChecker.EVERYTHING_VISIBLE;
    }

    public void setExceptionHandler(JavaCodeFragment.ExceptionHandler checker) {
        this.myExceptionChecker = checker;
    }

    public JavaCodeFragment.ExceptionHandler getExceptionHandler() {
        return this.myExceptionChecker;
    }

    public void setIntentionActionsFilter(@NotNull IntentionFilterOwner.IntentionActionsFilter filter) {
        if (filter == null) {
            GroovyCodeFragment.$$$reportNull$$$0(2);
        }
        this.myFilter = filter;
    }

    public IntentionFilterOwner.IntentionActionsFilter getIntentionActionsFilter() {
        return this.myFilter;
    }

    public void forceResolveScope(GlobalSearchScope scope) {
        this.myResolveScope = scope;
    }

    public GlobalSearchScope getForcedResolveScope() {
        return this.myResolveScope;
    }

    @Override
    public boolean importClass(PsiClass aClass) {
        return false;
    }

    public PsiType getThisType() {
        return this.myThisType;
    }

    @Override
    protected boolean processImports(PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place, @NotNull GrImportStatement[] importStatements, @NotNull GroovyImportHelper.ImportKind kind, @Nullable Boolean processStatic) {
        if (state == null) {
            GroovyCodeFragment.$$$reportNull$$$0(3);
        }
        if (place == null) {
            GroovyCodeFragment.$$$reportNull$$$0(4);
        }
        if (importStatements == null) {
            GroovyCodeFragment.$$$reportNull$$$0(5);
        }
        if (kind == null) {
            GroovyCodeFragment.$$$reportNull$$$0(6);
        }
        return super.processImports(processor, state, lastParent, place, importStatements, kind, processStatic) && (kind == GroovyImportHelper.ImportKind.ON_DEMAND ? this.processImportsOnDemand(processor, state, lastParent, place, processStatic) : kind != GroovyImportHelper.ImportKind.ALIAS || this.processSingleImports(processor, state, lastParent, place, processStatic));
    }

    @Override
    protected GroovyCodeFragment clone() {
        GroovyCodeFragment clone = (GroovyCodeFragment)this.cloneImpl((FileElement)this.calcTreeElement().clone());
        clone.myOriginalFile = this;
        clone.myPseudoImports.putAll(this.myPseudoImports);
        FileManager fileManager = ((PsiManagerEx)this.getManager()).getFileManager();
        SingleRootFileViewProvider cloneViewProvider = (SingleRootFileViewProvider)fileManager.createFileViewProvider((VirtualFile)new LightVirtualFile(this.getName(), this.getLanguage(), (CharSequence)this.getText()), false);
        cloneViewProvider.forceCachedPsi((PsiFile)clone);
        clone.myViewProvider = cloneViewProvider;
        return clone;
    }

    private boolean processImportsOnDemand(PsiScopeProcessor processor, ResolveState state, PsiElement parent, PsiElement place, Boolean processStatic) {
        if (processStatic == null) {
            return this.processImportsOnDemand(processor, state, parent, place, false) && this.processImportsOnDemand(processor, state, parent, place, true);
        }
        for (GrImportStatement anImport : this.myOnDemandImports) {
            if (processStatic.booleanValue() != anImport.isStatic() || anImport.processDeclarations(processor, state, parent, place)) continue;
            return false;
        }
        return true;
    }

    private boolean processSingleImports(PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, PsiElement place, Boolean processStatic) {
        String name;
        if (state == null) {
            GroovyCodeFragment.$$$reportNull$$$0(7);
        }
        if (processStatic == null) {
            return this.processSingleImports(processor, state, lastParent, place, false) && this.processSingleImports(processor, state, lastParent, place, true);
        }
        NameHint nameHint = (NameHint)processor.getHint(NameHint.KEY);
        String string = name = nameHint != null ? nameHint.getName(state) : null;
        if (name != null) {
            GrImportStatement anImport = this.myPseudoImports.get(name);
            if (anImport != null && processStatic.booleanValue() == anImport.isStatic() && !anImport.processDeclarations(processor, state, lastParent, place)) {
                return false;
            }
        } else {
            for (GrImportStatement anImport : this.myPseudoImports.values()) {
                if (processStatic.booleanValue() != anImport.isStatic() || anImport.processDeclarations(processor, state, lastParent, place)) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    private GrImportStatement createImportOnDemand(@NotNull String qname) {
        PsiClass aClass;
        if (qname == null) {
            GroovyCodeFragment.$$$reportNull$$$0(8);
        }
        boolean isStatic = (aClass = JavaPsiFacade.getInstance((Project)this.getProject()).findClass(qname, this.getResolveScope())) != null;
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.getProject());
        try {
            return factory.createImportStatement(qname, isStatic, true, null, this);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    @Nullable
    private GrImportStatement createSingleImport(@NotNull String qname, @Nullable String importedName) {
        PsiClass aClass;
        if (qname == null) {
            GroovyCodeFragment.$$$reportNull$$$0(9);
        }
        boolean isStatic = (aClass = JavaPsiFacade.getInstance((Project)this.getProject()).findClass(qname, this.getResolveScope())) == null;
        String className = PsiNameHelper.getShortClassName((String)qname);
        String alias = importedName == null || className.equals(importedName) ? null : importedName;
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.getProject());
        try {
            return factory.createImportStatement(qname, isStatic, false, alias, this);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    public void clearImports() {
        this.myPseudoImports.clear();
        this.myOnDemandImports.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/debugger/fragments/GroovyCodeFragment";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importStatements";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qname";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/debugger/fragments/GroovyCodeFragment";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setIntentionActionsFilter";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processImports";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processSingleImports";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createImportOnDemand";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createSingleImport";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

