/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.editor.actions;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J$\u0010\r\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/groovy/editor/actions/GroovyTripleQuoteBackspaceHandlerDelegate;", "Lcom/intellij/codeInsight/editorActions/BackspaceHandlerDelegate;", "()V", "myWithinTripleQuoted", "", "beforeCharDeleted", "", "c", "", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "charDeleted", "jetgroovy"})
public final class GroovyTripleQuoteBackspaceHandlerDelegate
extends BackspaceHandlerDelegate {
    private boolean myWithinTripleQuoted;

    public void beforeCharDeleted(char c, @Nullable PsiFile file, @Nullable Editor editor) {
        this.myWithinTripleQuoted = false;
        if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_QUOTE) {
            return;
        }
        if (c != '\'' && c != '\"') {
            return;
        }
        Editor editor2 = editor;
        if (!(editor2 instanceof EditorEx)) {
            editor2 = null;
        }
        if ((EditorEx)editor2 == null) {
            return;
        }
        int offset = ((EditorEx)editor).getCaretModel().getOffset();
        HighlighterIterator highlighterIterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
        Intrinsics.checkExpressionValueIsNotNull((Object)highlighterIterator, (String)"editor.highlighter.createIterator(offset)");
        HighlighterIterator iterator = highlighterIterator;
        IElementType tokenType = iterator.getTokenType();
        if (Intrinsics.areEqual((Object)tokenType, (Object)GroovyTokenTypes.mSTRING_LITERAL) || Intrinsics.areEqual((Object)tokenType, (Object)GroovyTokenTypes.mGSTRING_LITERAL)) {
            this.myWithinTripleQuoted = iterator.getStart() + 3 == offset && iterator.getEnd() - 3 == offset;
        }
    }

    public boolean charDeleted(char c, @Nullable PsiFile file, @Nullable Editor editor) {
        if (!this.myWithinTripleQuoted || editor == null) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        editor.getDocument().deleteString(offset, offset + 3);
        return true;
    }
}

