/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.codeInsight.JavaTargetElementEvaluator;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMirrorElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.compiled.ClsMethodImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.DefaultConstructor;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrRenameableLightElement;

public class GroovyTargetElementEvaluator
extends JavaTargetElementEvaluator {
    public static final Key<Object> NAVIGATION_ELEMENT_IS_NOT_TARGET = Key.create((String)"GroovyTargetElementEvaluator.DONT_FOLLOW_NAVIGATION_ELEMENT");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PsiElement getElementByReference(@NotNull PsiReference ref, int flags) {
        PsiElement sourceElement;
        if (ref == null) {
            GroovyTargetElementEvaluator.$$$reportNull$$$0(0);
        }
        if ((sourceElement = ref.getElement()) instanceof GrCodeReferenceElement) {
            GrNewExpression newExpr;
            PsiElement parent = sourceElement.getParent();
            if (parent instanceof GrNewExpression) {
                newExpr = (GrNewExpression)parent;
            } else {
                if (!(parent instanceof GrAnonymousClassDefinition)) return null;
                PsiElement grandParent = parent.getParent();
                if (!(grandParent instanceof GrNewExpression)) return null;
                newExpr = (GrNewExpression)grandParent;
            }
            PsiMethod constructor = newExpr.resolveMethod();
            if (constructor instanceof DefaultConstructor) {
                return constructor.getContainingClass();
            }
            GrArgumentList argumentList = newExpr.getArgumentList();
            if (constructor == null || argumentList == null || !PsiImplUtil.hasNamedArguments(argumentList) || PsiImplUtil.hasExpressionArguments(argumentList) || constructor.getParameterList().getParametersCount() != 0) return constructor;
            return constructor.getContainingClass();
        }
        if (!(sourceElement instanceof GrReferenceExpression)) return null;
        PsiElement resolved = ((GrReferenceExpression)sourceElement).resolve();
        if (!(resolved instanceof GrGdkMethod) && resolved instanceof GrRenameableLightElement) return resolved;
        return GroovyTargetElementEvaluator.correctSearchTargets(resolved);
    }

    @Nullable
    public static PsiElement correctSearchTargets(@Nullable PsiElement target) {
        PsiMethod mirror;
        if (target instanceof ClsMethodImpl && (mirror = ((ClsMethodImpl)target).getSourceMirrorMethod()) != null) {
            return mirror.getNavigationElement();
        }
        if (target != null && !(target instanceof GrAccessorMethod) && target.getUserData(NAVIGATION_ELEMENT_IS_NOT_TARGET) == null) {
            if (target instanceof PsiMirrorElement) {
                return ((PsiMirrorElement)target).getPrototype();
            }
            return target.getNavigationElement();
        }
        return target;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyTargetElementEvaluator", "getElementByReference"));
    }
}

