/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.util;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeMapper;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrAnnotationUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightField;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightModifierList;
import org.jetbrains.plugins.groovy.lang.resolve.GroovyTraitFieldsFileIndex;
import org.jetbrains.plugins.groovy.lang.resolve.GroovyTraitMethodsFileIndex;

public class GrTraitUtil {
    private static final Logger LOG = Logger.getInstance(GrTraitUtil.class);
    private static final PsiTypeMapper ID_MAPPER = new PsiTypeMapper(){

        public PsiType visitClassType(PsiClassType classType) {
            return classType;
        }
    };

    @Contract(value="null -> false")
    public static boolean isInterface(@Nullable PsiClass aClass) {
        return aClass != null && aClass.isInterface() && !GrTraitUtil.isTrait(aClass);
    }

    public static boolean isMethodAbstract(@NotNull PsiMethod method) {
        if (method == null) {
            GrTraitUtil.$$$reportNull$$$0(0);
        }
        return method.getModifierList().hasExplicitModifier("abstract") || GrTraitUtil.isInterface(method.getContainingClass());
    }

    public static List<PsiClass> getSelfTypeClasses(@NotNull PsiClass trait) {
        if (trait == null) {
            GrTraitUtil.$$$reportNull$$$0(1);
        }
        return (List)CachedValuesManager.getCachedValue((PsiElement)trait, () -> {
            if (trait == null) {
                GrTraitUtil.$$$reportNull$$$0(12);
            }
            ArrayList result = ContainerUtil.newArrayList();
            InheritanceUtil.processSupers((PsiClass)trait, (boolean)true, clazz -> {
                PsiAnnotation annotation;
                if (GrTraitUtil.isTrait(clazz) && (annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)clazz, (String[])new String[]{"groovy.transform.SelfType"})) != null) {
                    result.addAll(GrAnnotationUtil.getClassArrayValue(annotation, "value", false));
                }
                return true;
            });
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        });
    }

    @NotNull
    public static String getTraitFieldPrefix(@NotNull PsiClass aClass) {
        String qname;
        if (aClass == null) {
            GrTraitUtil.$$$reportNull$$$0(2);
        }
        LOG.assertTrue((qname = aClass.getQualifiedName()) != null, aClass.getClass());
        String[] identifiers = qname.split("\\.");
        StringBuilder buffer = new StringBuilder();
        for (String identifier : identifiers) {
            buffer.append(identifier).append('_');
        }
        buffer.append('_');
        String string = buffer.toString();
        if (string == null) {
            GrTraitUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Contract(value="null -> false")
    public static boolean isTrait(@Nullable PsiClass aClass) {
        return aClass instanceof GrTypeDefinition && ((GrTypeDefinition)aClass).isTrait() || aClass instanceof ClsClassImpl && aClass.isInterface() && AnnotationUtil.isAnnotated((PsiModifierListOwner)aClass, (String)"groovy.transform.Trait", (boolean)false);
    }

    @NotNull
    public static Collection<PsiMethod> getCompiledTraitConcreteMethods(@NotNull ClsClassImpl trait) {
        if (trait == null) {
            GrTraitUtil.$$$reportNull$$$0(4);
        }
        Collection collection = (Collection)CachedValuesManager.getCachedValue((PsiElement)trait, () -> {
            if (trait == null) {
                GrTraitUtil.$$$reportNull$$$0(11);
            }
            ArrayList result = ContainerUtil.newArrayList();
            GrTraitUtil.doCollectCompiledTraitMethods(trait, result);
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{trait});
        });
        if (collection == null) {
            GrTraitUtil.$$$reportNull$$$0(5);
        }
        return collection;
    }

    private static void doCollectCompiledTraitMethods(ClsClassImpl trait, Collection<PsiMethod> result) {
        for (PsiMethod method : trait.getMethods()) {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"org.codehaus.groovy.transform.trait.Traits.Implemented", (boolean)false)) continue;
            result.add(method);
        }
        for (PsiMethod staticMethod : GroovyTraitMethodsFileIndex.getStaticTraitMethods(trait)) {
            result.add(GrTraitUtil.createTraitMethodFromCompiledHelperMethod(staticMethod, trait));
        }
    }

    private static PsiMethod createTraitMethodFromCompiledHelperMethod(PsiMethod compiledMethod, ClsClassImpl trait) {
        GrLightMethodBuilder result = new GrLightMethodBuilder(trait.getManager(), compiledMethod.getName());
        result.setOriginInfo("via @Trait");
        result.addModifier("static");
        for (PsiTypeParameter parameter : compiledMethod.getTypeParameters()) {
            result.getTypeParameterList().addParameter(parameter);
        }
        PsiTypeMapper corrector = GrTraitUtil.createCorrector(compiledMethod, (PsiClass)trait);
        PsiParameter[] methodParameters = compiledMethod.getParameterList().getParameters();
        for (int i = 1; i < methodParameters.length; ++i) {
            PsiParameter originalParameter = methodParameters[i];
            PsiType correctedType = (PsiType)originalParameter.getType().accept((PsiTypeVisitor)corrector);
            String name = originalParameter.getName();
            assert (name != null) : compiledMethod;
            result.addParameter(name, correctedType, false);
        }
        for (PsiClassType type : compiledMethod.getThrowsList().getReferencedTypes()) {
            PsiType correctedType = (PsiType)type.accept((PsiTypeVisitor)corrector);
            result.getThrowsList().addReference(correctedType instanceof PsiClassType ? (PsiClassType)correctedType : type);
        }
        PsiType originalType = compiledMethod.getReturnType();
        result.setReturnType(originalType == null ? null : (PsiType)originalType.accept((PsiTypeVisitor)corrector));
        PsiClass traitSource = trait.getSourceMirrorClass();
        PsiMethod sourceMethod = traitSource == null ? null : traitSource.findMethodBySignature((PsiMethod)result, false);
        result.setNavigationElement((PsiElement)(sourceMethod != null ? sourceMethod : compiledMethod));
        return result;
    }

    @NotNull
    private static PsiTypeMapper createCorrector(final PsiMethod compiledMethod, PsiClass trait) {
        PsiTypeParameter[] traitTypeParameters = trait.getTypeParameters();
        if (traitTypeParameters.length == 0) {
            PsiTypeMapper psiTypeMapper = ID_MAPPER;
            if (psiTypeMapper == null) {
                GrTraitUtil.$$$reportNull$$$0(6);
            }
            return psiTypeMapper;
        }
        THashMap substitutionMap = ContainerUtil.newTroveMap();
        for (PsiTypeParameter parameter : traitTypeParameters) {
            substitutionMap.put(parameter.getName(), parameter);
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)trait.getProject()).getElementFactory();
        PsiTypeMapper psiTypeMapper = new PsiTypeMapper((Map)substitutionMap, elementFactory){
            final /* synthetic */ Map val$substitutionMap;
            final /* synthetic */ PsiElementFactory val$elementFactory;
            {
                this.val$substitutionMap = map2;
                this.val$elementFactory = psiElementFactory;
            }

            public PsiType visitClassType(PsiClassType originalType) {
                PsiClass resolved = originalType.resolve();
                if (resolved instanceof PsiTypeParameter && compiledMethod.equals(((PsiTypeParameter)resolved).getOwner())) {
                    return originalType;
                }
                Object[] typeParameters = originalType.getParameters();
                PsiTypeParameter byName = (PsiTypeParameter)this.val$substitutionMap.get(originalType.getCanonicalText());
                if (byName != null) {
                    assert (typeParameters.length == 0);
                    return this.val$elementFactory.createType((PsiClass)byName);
                }
                if (resolved == null) {
                    return originalType;
                }
                if (typeParameters.length == 0) {
                    return originalType;
                }
                Ref hasChanges = Ref.create((Object)false);
                2 $this = this;
                PsiType[] substitutes = (PsiType[])ContainerUtil.map2Array((Object[])typeParameters, PsiType.class, arg_0 -> 2.lambda$visitClassType$0((PsiTypeVisitor)$this, hasChanges, arg_0));
                return (Boolean)hasChanges.get() != false ? this.val$elementFactory.createType(resolved, substitutes) : originalType;
            }

            private static /* synthetic */ PsiType lambda$visitClassType$0(PsiTypeVisitor $this, Ref hasChanges, PsiType type) {
                PsiType mapped = (PsiType)type.accept($this);
                hasChanges.set((Object)(mapped != type ? 1 : 0));
                return mapped;
            }
        };
        if (psiTypeMapper == null) {
            GrTraitUtil.$$$reportNull$$$0(7);
        }
        return psiTypeMapper;
    }

    @NotNull
    public static Collection<GrField> getCompiledTraitFields(@NotNull ClsClassImpl trait) {
        if (trait == null) {
            GrTraitUtil.$$$reportNull$$$0(8);
        }
        Collection collection = (Collection)CachedValuesManager.getCachedValue((PsiElement)trait, () -> {
            if (trait == null) {
                GrTraitUtil.$$$reportNull$$$0(10);
            }
            ArrayList result = ContainerUtil.newArrayList();
            GrTraitUtil.doCollectCompiledTraitFields(trait, result);
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{trait});
        });
        if (collection == null) {
            GrTraitUtil.$$$reportNull$$$0(9);
        }
        return collection;
    }

    private static void doCollectCompiledTraitFields(ClsClassImpl trait, Collection<GrField> result) {
        VirtualFile traitFile = trait.getContainingFile().getVirtualFile();
        if (traitFile == null) {
            return;
        }
        VirtualFile helperFile = traitFile.getParent().findChild(trait.getName() + "$Trait$FieldHelper.class");
        if (helperFile == null) {
            return;
        }
        int key = FileBasedIndex.getFileId((VirtualFile)helperFile);
        List values = FileBasedIndex.getInstance().getValues(GroovyTraitFieldsFileIndex.INDEX_ID, (Object)key, trait.getResolveScope());
        values.forEach(descriptors -> descriptors.forEach(descriptor2 -> result.add(GrTraitUtil.createTraitField(descriptor2, (PsiClass)trait))));
    }

    private static GrLightField createTraitField(GroovyTraitFieldsFileIndex.TraitFieldDescriptor descriptor2, PsiClass trait) {
        GrLightField field = new GrLightField(trait, descriptor2.name, descriptor2.typeString);
        if ((descriptor2.flags & 2) != 0) {
            ((GrLightModifierList)field.getModifierList()).addModifier(8);
        }
        ((GrLightModifierList)field.getModifierList()).addModifier((descriptor2.flags & 1) != 0 ? 1 : 2);
        return field;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trait";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/util/GrTraitUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/util/GrTraitUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTraitFieldPrefix";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompiledTraitConcreteMethods";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createCorrector";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompiledTraitFields";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isMethodAbstract";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSelfTypeClasses";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTraitFieldPrefix";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCompiledTraitConcreteMethods";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCompiledTraitFields";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getCompiledTraitFields$3";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getCompiledTraitConcreteMethods$2";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getSelfTypeClasses$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

