/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;
import org.jetbrains.plugins.groovy.transformations.TransformationUtilKt;

public class CollectClassMembersUtil {
    private static final Key<CachedValue<ClassMembers>> CACHED_MEMBERS = Key.create((String)"CACHED_CLASS_MEMBERS");
    private static final Key<CachedValue<ClassMembers>> CACHED_MEMBERS_INCLUDING_SYNTHETIC = Key.create((String)"CACHED_MEMBERS_INCLUDING_SYNTHETIC");

    private CollectClassMembersUtil() {
    }

    public static Map<String, List<CandidateInfo>> getAllMethods(PsiClass aClass, boolean includeSynthetic) {
        return CollectClassMembersUtil.getCachedMembers(aClass, includeSynthetic).getMethods();
    }

    @NotNull
    private static ClassMembers getCachedMembers(@NotNull PsiClass aClass, boolean includeSynthetic) {
        CachedValue cached;
        if (aClass == null) {
            CollectClassMembersUtil.$$$reportNull$$$0(0);
        }
        if ((cached = (CachedValue)aClass.getUserData(CollectClassMembersUtil.getMemberCacheKey(includeSynthetic))) != null && cached.hasUpToDateValue()) {
            ClassMembers classMembers = (ClassMembers)cached.getValue();
            if (classMembers == null) {
                CollectClassMembersUtil.$$$reportNull$$$0(1);
            }
            return classMembers;
        }
        ClassMembers classMembers = CollectClassMembersUtil.buildCache(aClass, includeSynthetic && CollectClassMembersUtil.checkClass(aClass));
        if (classMembers == null) {
            CollectClassMembersUtil.$$$reportNull$$$0(2);
        }
        return classMembers;
    }

    private static boolean checkClass(PsiClass aClass) {
        java.util.HashSet visited = ContainerUtil.newHashSet();
        LinkedList queue = ContainerUtil.newLinkedList((Object[])new PsiClass[]{aClass});
        while (!queue.isEmpty()) {
            PsiClass current = (PsiClass)queue.poll();
            if (current instanceof ClsClassImpl) continue;
            if (visited.add(current)) {
                if (TransformationUtilKt.isUnderTransformation(current)) {
                    return false;
                }
                for (PsiClass superClass : CollectClassMembersUtil.getSupers(current, false)) {
                    queue.offer(superClass);
                }
                continue;
            }
            if (current.isInterface() || "java.lang.Object".equals(current.getQualifiedName())) continue;
            return false;
        }
        return true;
    }

    public static Map<String, CandidateInfo> getAllInnerClasses(@NotNull PsiClass aClass, boolean includeSynthetic) {
        if (aClass == null) {
            CollectClassMembersUtil.$$$reportNull$$$0(3);
        }
        return CollectClassMembersUtil.getCachedMembers(aClass, includeSynthetic).getInnerClasses();
    }

    public static Map<String, CandidateInfo> getAllFields(@NotNull PsiClass aClass, boolean includeSynthetic) {
        if (aClass == null) {
            CollectClassMembersUtil.$$$reportNull$$$0(4);
        }
        return CollectClassMembersUtil.getCachedMembers(aClass, includeSynthetic).getFields();
    }

    public static Map<String, CandidateInfo> getAllFields(@NotNull PsiClass aClass) {
        if (aClass == null) {
            CollectClassMembersUtil.$$$reportNull$$$0(5);
        }
        return CollectClassMembersUtil.getAllFields(aClass, true);
    }

    private static ClassMembers buildCache(@NotNull PsiClass aClass, boolean includeSynthetic) {
        if (aClass == null) {
            CollectClassMembersUtil.$$$reportNull$$$0(6);
        }
        return (ClassMembers)CachedValuesManager.getManager((Project)aClass.getProject()).getCachedValue((UserDataHolder)aClass, CollectClassMembersUtil.getMemberCacheKey(includeSynthetic), () -> {
            if (aClass == null) {
                CollectClassMembersUtil.$$$reportNull$$$0(21);
            }
            LinkedHashMap allFields = ContainerUtil.newLinkedHashMap();
            LinkedHashMap allMethods = ContainerUtil.newLinkedHashMap();
            LinkedHashMap allInnerClasses = ContainerUtil.newLinkedHashMap();
            CollectClassMembersUtil.processClass(aClass, allFields, allMethods, allInnerClasses, (Set<PsiClass>)new HashSet(), PsiSubstitutor.EMPTY, includeSynthetic);
            return CachedValueProvider.Result.create((Object)ClassMembers.create(allFields, allMethods, allInnerClasses), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
        }, false);
    }

    private static Key<CachedValue<ClassMembers>> getMemberCacheKey(boolean includeSynthetic) {
        return includeSynthetic ? CACHED_MEMBERS_INCLUDING_SYNTHETIC : CACHED_MEMBERS;
    }

    private static void processClass(@NotNull PsiClass aClass, @NotNull Map<String, CandidateInfo> allFields, @NotNull Map<String, List<CandidateInfo>> allMethods, @NotNull Map<String, CandidateInfo> allInnerClasses, @NotNull Set<PsiClass> visitedClasses, @NotNull PsiSubstitutor substitutor, boolean includeSynthetic) {
        String name;
        if (aClass == null) {
            CollectClassMembersUtil.$$$reportNull$$$0(7);
        }
        if (allFields == null) {
            CollectClassMembersUtil.$$$reportNull$$$0(8);
        }
        if (allMethods == null) {
            CollectClassMembersUtil.$$$reportNull$$$0(9);
        }
        if (allInnerClasses == null) {
            CollectClassMembersUtil.$$$reportNull$$$0(10);
        }
        if (visitedClasses == null) {
            CollectClassMembersUtil.$$$reportNull$$$0(11);
        }
        if (substitutor == null) {
            CollectClassMembersUtil.$$$reportNull$$$0(12);
        }
        PsiUtilCore.ensureValid((PsiElement)aClass);
        if (!visitedClasses.add(aClass)) {
            return;
        }
        if (visitedClasses.size() == 1 || !GrTraitUtil.isTrait(aClass)) {
            for (PsiField psiField : CollectClassMembersUtil.getFields(aClass, includeSynthetic)) {
                GrModifierList modifierList;
                CandidateInfo candidateInfo;
                PsiElement element;
                name = psiField.getName();
                if (!allFields.containsKey(name)) {
                    allFields.put(name, new CandidateInfo((PsiElement)psiField, substitutor));
                    continue;
                }
                if (!CollectClassMembersUtil.hasExplicitVisibilityModifiers(psiField) || !((element = (candidateInfo = allFields.get(name)).getElement()) instanceof GrField) || (modifierList = ((GrField)element).getModifierList()) != null && modifierList.hasExplicitVisibilityModifiers() || aClass != ((GrField)element).getContainingClass()) continue;
                allFields.put(name, new CandidateInfo((PsiElement)psiField, substitutor));
            }
        }
        for (PsiField psiField : CollectClassMembersUtil.getMethods(aClass, includeSynthetic)) {
            CollectClassMembersUtil.addMethod(allMethods, (PsiMethod)psiField, substitutor);
        }
        for (PsiField psiField : CollectClassMembersUtil.getInnerClasses(aClass, includeSynthetic)) {
            name = psiField.getName();
            if (name == null || allInnerClasses.containsKey(name)) continue;
            allInnerClasses.put(name, new CandidateInfo((PsiElement)psiField, substitutor));
        }
        for (PsiField psiField : CollectClassMembersUtil.getSupers(aClass, includeSynthetic)) {
            PsiSubstitutor superSubstitutor = includeSynthetic ? TypeConversionUtil.getSuperClassSubstitutor((PsiClass)psiField, (PsiClass)aClass, (PsiSubstitutor)substitutor) : PsiSubstitutor.EMPTY;
            CollectClassMembersUtil.processClass((PsiClass)psiField, allFields, allMethods, allInnerClasses, visitedClasses, superSubstitutor, includeSynthetic);
        }
    }

    public static PsiField[] getFields(@NotNull PsiClass aClass, boolean includeSynthetic) {
        if (aClass == null) {
            CollectClassMembersUtil.$$$reportNull$$$0(13);
        }
        return includeSynthetic || !(aClass instanceof GrTypeDefinition) ? aClass.getFields() : ((GrTypeDefinition)aClass).getCodeFields();
    }

    public static PsiMethod[] getMethods(@NotNull PsiClass aClass, boolean includeSynthetic) {
        if (aClass == null) {
            CollectClassMembersUtil.$$$reportNull$$$0(14);
        }
        return includeSynthetic || !(aClass instanceof GrTypeDefinition) ? aClass.getMethods() : ((GrTypeDefinition)aClass).getCodeMethods();
    }

    public static PsiClass[] getInnerClasses(@NotNull PsiClass aClass, boolean includeSynthetic) {
        if (aClass == null) {
            CollectClassMembersUtil.$$$reportNull$$$0(15);
        }
        return includeSynthetic || !(aClass instanceof GrTypeDefinition) ? aClass.getInnerClasses() : ((GrTypeDefinition)aClass).getCodeInnerClasses();
    }

    public static PsiClass[] getSupers(@NotNull PsiClass aClass, boolean includeSynthetic) {
        if (aClass == null) {
            CollectClassMembersUtil.$$$reportNull$$$0(16);
        }
        return aClass instanceof GrTypeDefinition ? ((GrTypeDefinition)aClass).getSupers(includeSynthetic) : aClass.getSupers();
    }

    private static boolean hasExplicitVisibilityModifiers(@NotNull PsiField field) {
        if (field == null) {
            CollectClassMembersUtil.$$$reportNull$$$0(17);
        }
        if (field instanceof GrField) {
            GrModifierList list = (GrModifierList)field.getModifierList();
            return list == null || list.hasExplicitVisibilityModifiers();
        }
        return true;
    }

    private static void addMethod(@NotNull Map<String, List<CandidateInfo>> allMethods, @NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor) {
        String name;
        List<CandidateInfo> methods;
        if (allMethods == null) {
            CollectClassMembersUtil.$$$reportNull$$$0(18);
        }
        if (method == null) {
            CollectClassMembersUtil.$$$reportNull$$$0(19);
        }
        if (substitutor == null) {
            CollectClassMembersUtil.$$$reportNull$$$0(20);
        }
        if ((methods = allMethods.get(name = method.getName())) == null) {
            methods = new ArrayList<CandidateInfo>();
            allMethods.put(name, methods);
        }
        methods.add(new CandidateInfo((PsiElement)method, substitutor));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/resolve/CollectClassMembersUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allFields";
                break;
            }
            case 9: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allMethods";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allInnerClasses";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitedClasses";
                break;
            }
            case 12: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/resolve/CollectClassMembersUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedMembers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCachedMembers";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAllInnerClasses";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAllFields";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildCache";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processClass";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getFields";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getMethods";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getInnerClasses";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getSupers";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "hasExplicitVisibilityModifiers";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addMethod";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$buildCache$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ClassMembers {
        private final Map<String, CandidateInfo> myFields;
        private final Map<String, List<CandidateInfo>> myMethods;
        private final Map<String, CandidateInfo> myInnerClasses;

        private ClassMembers(@NotNull Map<String, CandidateInfo> fields, @NotNull Map<String, List<CandidateInfo>> methods, @NotNull Map<String, CandidateInfo> innerClasses) {
            if (fields == null) {
                ClassMembers.$$$reportNull$$$0(0);
            }
            if (methods == null) {
                ClassMembers.$$$reportNull$$$0(1);
            }
            if (innerClasses == null) {
                ClassMembers.$$$reportNull$$$0(2);
            }
            this.myFields = fields;
            this.myMethods = methods;
            this.myInnerClasses = innerClasses;
        }

        public static ClassMembers create(@NotNull LinkedHashMap<String, CandidateInfo> first, @NotNull LinkedHashMap<String, List<CandidateInfo>> second, @NotNull LinkedHashMap<String, CandidateInfo> third) {
            if (first == null) {
                ClassMembers.$$$reportNull$$$0(3);
            }
            if (second == null) {
                ClassMembers.$$$reportNull$$$0(4);
            }
            if (third == null) {
                ClassMembers.$$$reportNull$$$0(5);
            }
            return new ClassMembers(first, second, third);
        }

        private Map<String, CandidateInfo> getFields() {
            return this.myFields;
        }

        private Map<String, List<CandidateInfo>> getMethods() {
            return this.myMethods;
        }

        private Map<String, CandidateInfo> getInnerClasses() {
            return this.myInnerClasses;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fields";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methods";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "innerClasses";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "first";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "second";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "third";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/groovy/lang/resolve/CollectClassMembersUtil$ClassMembers";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

