/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.util;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.EmptyIcon;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiTypeCanonicalLookupElement
extends LookupElement {
    private static final Icon EMPTY_ICON = EmptyIcon.create((int)(PlatformIcons.CLASS_ICON.getIconWidth() * 2), (int)PlatformIcons.CLASS_ICON.getIconHeight());
    private final PsiType myType;
    private final String myPresentableText;

    public PsiTypeCanonicalLookupElement(@NotNull PsiType type) {
        if (type == null) {
            PsiTypeCanonicalLookupElement.$$$reportNull$$$0(0);
        }
        this.myType = type;
        this.myPresentableText = this.myType.getPresentableText();
    }

    @Override
    @NotNull
    public Object getObject() {
        PsiClass psiClass = this.getPsiClass();
        if (psiClass != null) {
            PsiClass psiClass2 = psiClass;
            if (psiClass2 == null) {
                PsiTypeCanonicalLookupElement.$$$reportNull$$$0(1);
            }
            return psiClass2;
        }
        Object object = super.getObject();
        if (object == null) {
            PsiTypeCanonicalLookupElement.$$$reportNull$$$0(2);
        }
        return object;
    }

    @Nullable
    public PsiClass getPsiClass() {
        return PsiUtil.resolveClassInType(this.myType);
    }

    @Override
    public boolean isValid() {
        return this.myType.isValid() && super.isValid();
    }

    public PsiType getPsiType() {
        return this.myType;
    }

    @Override
    @NotNull
    public String getLookupString() {
        String string = this.myPresentableText;
        if (string == null) {
            PsiTypeCanonicalLookupElement.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public void handleInsert(InsertionContext context) {
        context.getEditor().getDocument().replaceString(context.getStartOffset(), context.getStartOffset() + this.getLookupString().length(), this.getPsiType().getCanonicalText());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PsiTypeCanonicalLookupElement)) {
            return false;
        }
        PsiTypeCanonicalLookupElement that = (PsiTypeCanonicalLookupElement)((Object)o);
        return this.myType.equals(that.myType);
    }

    public int hashCode() {
        return this.myType.hashCode();
    }

    @Override
    public void renderElement(LookupElementPresentation presentation) {
        PsiClass psiClass = this.getPsiClass();
        if (psiClass != null) {
            presentation.setIcon(presentation.isReal() ? psiClass.getIcon(1) : EMPTY_ICON);
            presentation.setTailText(" (" + PsiFormatUtil.getPackageDisplayName(psiClass) + ")", true);
        }
        PsiType type = this.getPsiType();
        presentation.setItemText(type.getPresentableText());
        presentation.setItemTextBold(type instanceof PsiPrimitiveType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/util/PsiTypeCanonicalLookupElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/util/PsiTypeCanonicalLookupElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getObject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

