/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.ex.PathManagerEx;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.testFramework.IdeaTestUtil;
import com.intellij.testFramework.ModuleTestCase;
import com.intellij.testFramework.PsiTestData;
import com.intellij.testFramework.PsiTestUtil;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.JdomKt;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.StringTokenizer;
import junit.framework.TestCase;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class PsiTestCase
extends ModuleTestCase {
    protected PsiManagerImpl myPsiManager;
    protected PsiFile myFile;
    protected PsiTestData myTestDataBefore;
    protected PsiTestData myTestDataAfter;
    private String myDataRoot;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.myPsiManager = (PsiManagerImpl)PsiManager.getInstance(this.myProject);
    }

    @Override
    protected void tearDown() throws Exception {
        this.myPsiManager = null;
        this.myFile = null;
        this.myTestDataBefore = null;
        this.myTestDataAfter = null;
        super.tearDown();
    }

    @NotNull
    protected PsiFile createDummyFile(@NotNull String fileName, @NotNull String text) throws IncorrectOperationException {
        if (fileName == null) {
            PsiTestCase.$$$reportNull$$$0(0);
        }
        if (text == null) {
            PsiTestCase.$$$reportNull$$$0(1);
        }
        FileType type = FileTypeRegistry.getInstance().getFileTypeByFileName(fileName);
        PsiFile psiFile = PsiFileFactory.getInstance(this.myProject).createFileFromText(fileName, type, (CharSequence)text);
        if (psiFile == null) {
            PsiTestCase.$$$reportNull$$$0(2);
        }
        return psiFile;
    }

    @NotNull
    protected PsiFile createFile(@NonNls @NotNull String fileName, @NotNull String text) throws Exception {
        if (fileName == null) {
            PsiTestCase.$$$reportNull$$$0(3);
        }
        if (text == null) {
            PsiTestCase.$$$reportNull$$$0(4);
        }
        PsiFile psiFile = this.createFile(this.myModule, fileName, text);
        if (psiFile == null) {
            PsiTestCase.$$$reportNull$$$0(5);
        }
        return psiFile;
    }

    @NotNull
    protected PsiFile createFile(@NotNull Module module, @NotNull String fileName, @NotNull String text) throws Exception {
        if (module == null) {
            PsiTestCase.$$$reportNull$$$0(6);
        }
        if (fileName == null) {
            PsiTestCase.$$$reportNull$$$0(7);
        }
        if (text == null) {
            PsiTestCase.$$$reportNull$$$0(8);
        }
        VirtualFile vDir = this.createTempVfsDirectory();
        PsiFile psiFile = this.createFile(module, vDir, fileName, text);
        if (psiFile == null) {
            PsiTestCase.$$$reportNull$$$0(9);
        }
        return psiFile;
    }

    @NotNull
    protected VirtualFile createTempVfsDirectory() throws IOException {
        File dir = this.createTempDirectory();
        VirtualFile vDir = LocalFileSystem.getInstance().refreshAndFindFileByPath(dir.getCanonicalPath().replace(File.separatorChar, '/'));
        assert (vDir != null) : dir;
        VirtualFile virtualFile2 = vDir;
        if (virtualFile2 == null) {
            PsiTestCase.$$$reportNull$$$0(10);
        }
        return virtualFile2;
    }

    @NotNull
    protected PsiFile createFile(final @NotNull Module module, final @NotNull VirtualFile vDir, final @NotNull String fileName, final @NotNull String text) throws IOException {
        if (module == null) {
            PsiTestCase.$$$reportNull$$$0(11);
        }
        if (vDir == null) {
            PsiTestCase.$$$reportNull$$$0(12);
        }
        if (fileName == null) {
            PsiTestCase.$$$reportNull$$$0(13);
        }
        if (text == null) {
            PsiTestCase.$$$reportNull$$$0(14);
        }
        PsiFile psiFile = (PsiFile)new WriteAction<PsiFile>(){

            @Override
            protected void run(@NotNull Result<PsiFile> result) throws Throwable {
                if (result == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!ModuleRootManager.getInstance(module).getFileIndex().isInSourceContent(vDir)) {
                    PsiTestCase.this.addSourceContentToRoots(module, vDir);
                }
                VirtualFile vFile = vDir.createChildData(vDir, fileName);
                VfsUtil.saveText(vFile, text);
                TestCase.assertNotNull((Object)vFile);
                PsiFile file = PsiTestCase.this.myPsiManager.findFile(vFile);
                TestCase.assertNotNull((Object)file);
                result.setResult(file);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/PsiTestCase$1", "run"));
            }
        }.execute().getResultObject();
        if (psiFile == null) {
            PsiTestCase.$$$reportNull$$$0(15);
        }
        return psiFile;
    }

    protected void addSourceContentToRoots(Module module, VirtualFile vDir) {
        PsiTestUtil.addSourceContentToRoots((Module)module, (VirtualFile)vDir);
    }

    protected PsiElement configureByFileWithMarker(String filePath2, String marker) throws Exception {
        VirtualFile vFile = VfsTestUtil.findFileByCaseSensitivePath((String)filePath2);
        String fileText = VfsUtilCore.loadText(vFile);
        int offset = (fileText = StringUtil.convertLineSeparators((String)fileText)).indexOf(marker);
        PsiTestCase.assertTrue((offset >= 0 ? 1 : 0) != 0);
        fileText = fileText.substring(0, offset) + fileText.substring(offset + marker.length());
        this.myFile = this.createFile(vFile.getName(), fileText);
        return this.myFile.findElementAt(offset);
    }

    protected void configure(@NotNull String path2, String dataName) throws Exception {
        if (path2 == null) {
            PsiTestCase.$$$reportNull$$$0(16);
        }
        this.myDataRoot = this.getTestDataPath() + path2;
        this.myTestDataBefore = this.loadData(dataName);
        PsiTestUtil.removeAllRoots((Module)this.myModule, (Sdk)IdeaTestUtil.getMockJdk17());
        VirtualFile vDir = PsiTestUtil.createTestProjectStructure((Project)this.myProject, (Module)this.myModule, (String)this.myDataRoot, (Collection)myFilesToDelete);
        VirtualFile vFile = vDir.findChild(this.myTestDataBefore.getTextFile());
        this.myFile = this.myPsiManager.findFile(vFile);
    }

    protected String getTestDataPath() {
        return PathManagerEx.getTestDataPath();
    }

    protected String loadFile(String name) throws Exception {
        String result = FileUtil.loadFile((File)new File(this.getTestDataPath() + File.separatorChar + name));
        return StringUtil.convertLineSeparators((String)result);
    }

    private PsiTestData loadData(String dataName) throws Exception {
        PsiTestData data = this.createData();
        Element documentElement = JdomKt.loadElement(Paths.get(this.myDataRoot, "data.xml"));
        for (Element node : documentElement.getChildren("data")) {
            String value = node.getAttributeValue("name");
            if (!value.equals(dataName)) continue;
            DefaultJDOMExternalizer.readExternal((Object)data, (Element)node);
            data.loadText(this.myDataRoot);
            return data;
        }
        throw new IllegalArgumentException("Cannot find data chunk '" + dataName + "'");
    }

    protected PsiTestData createData() {
        return new PsiTestData();
    }

    protected void checkResult(String dataName) throws Exception {
        String actualText;
        this.myTestDataAfter = this.loadData(dataName);
        String textExpected = this.myTestDataAfter.getText();
        if (!textExpected.equals(actualText = this.myFile.getText())) {
            System.out.println("Text mismatch: " + this.getName() + "(" + ((Object)((Object)this)).getClass().getName() + ")");
            System.out.println("Text expected:");
            PsiTestCase.printText(textExpected);
            System.out.println("Text found:");
            PsiTestCase.printText(actualText);
            PsiTestCase.fail((String)"text");
        }
    }

    protected static void printText(String text) {
        String q = "\"";
        System.out.print("\"");
        text = StringUtil.convertLineSeparators((String)text);
        StringTokenizer tokenizer = new StringTokenizer(text, "\n", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("\n")) {
                System.out.print("\"");
                System.out.println();
                System.out.print("\"");
                continue;
            }
            System.out.print(token);
        }
        System.out.print("\"");
        System.out.println();
    }

    protected void addLibraryToRoots(VirtualFile jarFile, OrderRootType rootType) {
        PsiTestCase.addLibraryToRoots(this.myModule, jarFile, rootType);
    }

    protected static void addLibraryToRoots(Module module, VirtualFile root, OrderRootType rootType) {
        PsiTestCase.assertEquals((Object)OrderRootType.CLASSES, (Object)rootType);
        ModuleRootModificationUtil.addModuleLibrary(module, root.getUrl());
    }

    public PsiFile getFile() {
        return this.myFile;
    }

    public Document getDocument(PsiFile file) {
        return PsiDocumentManager.getInstance(this.getProject()).getDocument(file);
    }

    public Document getDocument(VirtualFile file) {
        return FileDocumentManager.getInstance().getDocument(file);
    }

    public void commitDocument(Document document) {
        PsiDocumentManager.getInstance(this.getProject()).commitDocument(document);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 10: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 10: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/PsiTestCase";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vDir";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/PsiTestCase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createDummyFile";
                break;
            }
            case 5: 
            case 9: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createFile";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempVfsDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDummyFile";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 10: 
            case 15: {
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "configure";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 10: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

