/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.references;

import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.TestDataFile;
import com.intellij.util.PathUtil;
import com.intellij.util.ProcessingContext;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.testAssistant.TestDataNavigationHandler;

public class TestDataFilesReferencesContributor
extends PsiReferenceContributor {
    private static final String TEST_DATA_FILE_ANNOTATION_QUALIFIED_NAME = TestDataFile.class.getCanonicalName();

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            TestDataFilesReferencesContributor.$$$reportNull$$$0(0);
        }
        PsiJavaElementPattern.Capture capture = (PsiJavaElementPattern.Capture)PsiJavaPatterns.literalExpression().methodCallParameter((ElementPattern)PsiJavaPatterns.psiMethod());
        registrar.registerReferenceProvider((ElementPattern)capture, new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                PsiLiteralExpression expression;
                PsiElement expressionParent;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!((expressionParent = (expression = (PsiLiteralExpression)element).getParent()) instanceof PsiExpressionList)) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                PsiExpressionList expressionList = (PsiExpressionList)expressionParent;
                PsiExpression[] expressions = expressionList.getExpressions();
                int index = TestDataFilesReferencesContributor.getExpressionIndex(expression, expressions);
                if (index < 0) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                PsiMethodCallExpression methodCallExpression = TestDataFilesReferencesContributor.getMethodCallExpression(expression);
                PsiParameter targetParameter = TestDataFilesReferencesContributor.getTargetParameter(index, methodCallExpression);
                if (!TestDataFilesReferencesContributor.checkTestDataFileAnnotationPresent(targetParameter)) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                String testDataFilePath = TestDataFilesReferencesContributor.getTestDataFilePath(expression, methodCallExpression);
                if (testDataFilePath == null) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        1.$$$reportNull$$$0(5);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                String directory = PathUtil.getParentPath((String)testDataFilePath);
                FileReferenceSet fileReferenceSet = new FileReferenceSet(element);
                fileReferenceSet.addCustomization(FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION, ignore -> {
                    VirtualFile file;
                    if (element == null) {
                        1.$$$reportNull$$$0(7);
                    }
                    return (file = LocalFileSystem.getInstance().findFileByPath(directory)) == null ? null : Collections.singleton(element.getManager().findDirectory(file));
                });
                FileReference[] fileReferenceArray = fileReferenceSet.getAllReferences();
                if (fileReferenceArray == null) {
                    1.$$$reportNull$$$0(6);
                }
                return fileReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/idea/devkit/references/TestDataFilesReferencesContributor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/idea/devkit/references/TestDataFilesReferencesContributor$1";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        break;
                    }
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "lambda$getReferencesByElement$0";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    private static int getExpressionIndex(@NotNull PsiLiteralExpression expression, @NotNull PsiExpression[] expressions) {
        if (expression == null) {
            TestDataFilesReferencesContributor.$$$reportNull$$$0(1);
        }
        if (expressions == null) {
            TestDataFilesReferencesContributor.$$$reportNull$$$0(2);
        }
        int index = -1;
        for (int i = 0; i < expressions.length; ++i) {
            PsiExpression e = expressions[i];
            if (!expression.equals(e)) continue;
            index = i;
            break;
        }
        return index;
    }

    @Nullable
    private static PsiMethodCallExpression getMethodCallExpression(@NotNull PsiLiteralExpression expression) {
        PsiElement expressionContext;
        if (expression == null) {
            TestDataFilesReferencesContributor.$$$reportNull$$$0(3);
        }
        if ((expressionContext = expression.getContext()) == null) {
            return null;
        }
        PsiElement methodCallExpression = expressionContext.getContext();
        if (!(methodCallExpression instanceof PsiMethodCallExpression)) {
            return null;
        }
        return (PsiMethodCallExpression)methodCallExpression;
    }

    @Nullable
    private static PsiParameter getTargetParameter(int index, @Nullable PsiMethodCallExpression methodCallExpression) {
        if (methodCallExpression == null) {
            return null;
        }
        PsiMethod callMethod = methodCallExpression.resolveMethod();
        if (callMethod == null) {
            return null;
        }
        PsiParameter[] parameters = callMethod.getParameterList().getParameters();
        if (parameters.length == 0) {
            return null;
        }
        return index >= parameters.length ? parameters[parameters.length - 1] : parameters[index];
    }

    private static boolean checkTestDataFileAnnotationPresent(@Nullable PsiParameter targetParameter) {
        PsiAnnotation[] annotations;
        if (targetParameter == null) {
            return false;
        }
        for (PsiAnnotation annotation : annotations = targetParameter.getAnnotations()) {
            if (!TEST_DATA_FILE_ANNOTATION_QUALIFIED_NAME.equals(annotation.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static String getTestDataFilePath(@NotNull PsiLiteralExpression expression, @NotNull PsiMethodCallExpression methodCallExpression) {
        Object value;
        if (expression == null) {
            TestDataFilesReferencesContributor.$$$reportNull$$$0(4);
        }
        if (methodCallExpression == null) {
            TestDataFilesReferencesContributor.$$$reportNull$$$0(5);
        }
        if (!((value = expression.getValue()) instanceof String)) {
            return null;
        }
        String relativePath = (String)value;
        PsiMethod testMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)methodCallExpression, PsiMethod.class);
        if (testMethod == null) {
            return null;
        }
        List<String> filePaths = TestDataNavigationHandler.fastGetTestDataPathsByRelativePath(relativePath, testMethod);
        if (filePaths.size() != 1) {
            return null;
        }
        return filePaths.get(0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCallExpression";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/devkit/references/TestDataFilesReferencesContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerReferenceProviders";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getExpressionIndex";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getMethodCallExpression";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getTestDataFilePath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

