/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.testAssistant;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.testAssistant.TestDataHighlightingPass;

public class TestDataHighlightingPassFactory
implements ProjectComponent,
TextEditorHighlightingPassFactory {
    public static final List<String> SUPPORTED_FILE_TYPES = Arrays.asList(StdFileTypes.JAVA.getDefaultExtension());
    public static final List<String> SUPPORTED_IN_TEST_DATA_FILE_TYPES = Arrays.asList("js", "php", "css", "html", "xhtml", "jsp", "test", "py", "aj");
    private static final int MAX_HOPES = 3;
    private static final String TEST_DATA = "testdata";
    private final Project myProject;

    public TestDataHighlightingPassFactory(Project project, TextEditorHighlightingPassRegistrar highlightingPassRegistrar) {
        this.myProject = project;
        highlightingPassRegistrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, null, true, -1);
    }

    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file, @NotNull Editor editor) {
        VirtualFile virtualFile;
        if (file == null) {
            TestDataHighlightingPassFactory.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            TestDataHighlightingPassFactory.$$$reportNull$$$0(1);
        }
        if ((virtualFile = file.getVirtualFile()) != null && this.isSupported(virtualFile)) {
            return new TestDataHighlightingPass(this.myProject, PsiDocumentManager.getInstance((Project)this.myProject).getDocument(file));
        }
        return null;
    }

    public boolean isSupported(@NotNull VirtualFile file) {
        String ext;
        if (file == null) {
            TestDataHighlightingPassFactory.$$$reportNull$$$0(2);
        }
        if (SUPPORTED_FILE_TYPES.contains(ext = file.getExtension())) {
            return ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getSourceRootForFile(file) == null;
        }
        if (SUPPORTED_IN_TEST_DATA_FILE_TYPES.contains(ext)) {
            int i = 0;
            for (VirtualFile parent = file.getParent(); parent != null && i < 3; ++i, parent = parent.getParent()) {
                if (!parent.getName().toLowerCase().contains(TEST_DATA)) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/devkit/testAssistant/TestDataHighlightingPassFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createHighlightingPass";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupported";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

