/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.inspection;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.android.AndroidUtilKt;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.quickfix.RenameIdentifierFix;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtVisitorVoid;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/android/inspection/IllegalIdentifierInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "idea-android"})
public final class IllegalIdentifierInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        return new KtVisitorVoid(holder){
            final /* synthetic */ ProblemsHolder $holder;

            public void visitElement(@NotNull PsiElement element3) {
                boolean bl;
                block5: {
                    CharSequence $receiver$iv;
                    String unquotedName;
                    String text2;
                    Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                    ASTNode aSTNode = element3.getNode();
                    if (Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)((Object)KtTokens.IDENTIFIER)) ^ true) {
                        return;
                    }
                    String string = text2 = element3.getText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"text");
                    if (!StringsKt.startsWith$default((CharSequence)string, (char)'`', (boolean)false, (int)2, null) || !StringsKt.endsWith$default((CharSequence)text2, (char)'`', (boolean)false, (int)2, null)) {
                        return;
                    }
                    String string2 = unquotedName = KtPsiUtil.unquoteIdentifier(text2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"unquotedName");
                    CharSequence charSequence = string2;
                    if (charSequence.length() == 0) {
                        return;
                    }
                    CharSequence charSequence2 = $receiver$iv = (CharSequence)unquotedName;
                    for (int i = 0; i < charSequence2.length(); ++i) {
                        char element$iv = charSequence2.charAt(i);
                        char it = element$iv;
                        if (this.isValidDalvikCharacter(it)) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
                if (!bl && this.checkAndroidFacet(element3)) {
                    this.$holder.registerProblem(element3, "Identifier not allowed in Android projects", ProblemHighlightType.GENERIC_ERROR, new LocalQuickFix[]{new RenameIdentifierFix()});
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private final boolean checkAndroidFacet(PsiElement element3) {
                if (AndroidUtilKt.getAndroidFacetForFile(element3) != null) return true;
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                if (!application.isUnitTestMode()) return false;
                return true;
            }

            private final boolean isValidDalvikCharacter(char c) {
                boolean bl;
                char c2;
                char c3 = c2 = c;
                if ('A' <= c3 && 'Z' >= c3) {
                    bl = true;
                } else {
                    char c4 = c2;
                    if ('a' <= c4 && 'z' >= c4) {
                        bl = true;
                    } else {
                        char c5 = c2;
                        if ('0' <= c5 && '9' >= c5) {
                            bl = true;
                        } else if (c2 == '$' || c2 == '-' || c2 == '_') {
                            bl = true;
                        } else {
                            char c6 = c2;
                            if ('\u00a1' <= c6 && '\u1fff' >= c6) {
                                bl = true;
                            } else {
                                char c7 = c2;
                                if ('\u2010' <= c7 && '\u2027' >= c7) {
                                    bl = true;
                                } else {
                                    char c8 = c2;
                                    if ('\u2030' <= c8 && '\ud7ff' >= c8) {
                                        bl = true;
                                    } else {
                                        char c9 = c2;
                                        bl = '\ue000' <= c9 && '\uffef' >= c9;
                                    }
                                }
                            }
                        }
                    }
                }
                return bl;
            }
            {
                this.$holder = $captured_local_variable$0;
            }
        };
    }
}

