/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.inline.CallSiteMarker;
import org.jetbrains.kotlin.codegen.inline.FileMapping;
import org.jetbrains.kotlin.codegen.inline.RangeMapping;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0007J\u001e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0007J(\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00102\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\u0006\u0010 \u001a\u00020!R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/codegen/inline/RawFileMapping;", "", "name", "", "path", "(Ljava/lang/String;Ljava/lang/String;)V", "lastMappedWithNewIndex", "", "getName", "()Ljava/lang/String;", "getPath", "rangeMappings", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/codegen/inline/RangeMapping;", "Lkotlin/collections/ArrayList;", "couldFoldInRange", "", "first", "second", "initRange", "", "start", "end", "mapNewInterval", "source", "dest", "range", "mapNewLineNumber", "currentIndex", "isLastMapped", "callSiteMarker", "Lorg/jetbrains/kotlin/codegen/inline/CallSiteMarker;", "toFileMapping", "Lorg/jetbrains/kotlin/codegen/inline/FileMapping;", "backend"})
public final class RawFileMapping {
    private final ArrayList<RangeMapping> rangeMappings;
    private int lastMappedWithNewIndex;
    @NotNull
    private final String name;
    @NotNull
    private final String path;

    @NotNull
    public final FileMapping toFileMapping() {
        FileMapping fileMapping;
        FileMapping $receiver = fileMapping = new FileMapping(this.name, this.path);
        Iterator<RangeMapping> iterator2 = this.rangeMappings.iterator();
        while (iterator2.hasNext()) {
            RangeMapping range;
            RangeMapping rangeMapping = range = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)rangeMapping, (String)"range");
            $receiver.addRangeMapping(rangeMapping);
        }
        return fileMapping;
    }

    public final void initRange(int start, int end) {
        boolean bl = this.rangeMappings.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "initRange should only be called for empty mapping";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.rangeMappings.add(new RangeMapping(start, start, end - start + 1, null, 8, null));
        this.lastMappedWithNewIndex = end;
    }

    public final int mapNewLineNumber(int source, int currentIndex, boolean isLastMapped, @Nullable CallSiteMarker callSiteMarker) {
        int dest;
        Collection collection = this.rangeMappings;
        if (!collection.isEmpty() && isLastMapped && this.couldFoldInRange(this.lastMappedWithNewIndex, source)) {
            RangeMapping rangeMapping;
            RangeMapping rangeMapping2 = rangeMapping = (RangeMapping)CollectionsKt.last((List)this.rangeMappings);
            rangeMapping2.setRange(rangeMapping2.getRange() + (source - this.lastMappedWithNewIndex));
            dest = rangeMapping.mapSourceToDest(source);
        } else {
            dest = currentIndex + 1;
            RangeMapping rangeMapping = new RangeMapping(source, dest, 0, callSiteMarker, 4, null);
            this.rangeMappings.add(rangeMapping);
        }
        this.lastMappedWithNewIndex = source;
        return dest;
    }

    public final void mapNewInterval(int source, int dest, int range) {
        RangeMapping rangeMapping = new RangeMapping(source, dest, range, null, 8, null);
        this.rangeMappings.add(rangeMapping);
    }

    private final boolean couldFoldInRange(int first, int second) {
        int delta = second - first;
        return delta > 0 && delta <= 10;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    public RawFileMapping(@NotNull String name2, @NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this.name = name2;
        this.path = path;
        this.rangeMappings = new ArrayList();
        this.lastMappedWithNewIndex = -1000;
    }
}

