/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.resolve;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.caches.resolve.LibraryModificationTrackerKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J+\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\t0\u0012H\u0082\bR\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/caches/resolve/LibraryModificationTracker;", "Lcom/intellij/openapi/util/SimpleModificationTracker;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "projectFileIndex", "Lcom/intellij/openapi/roots/ProjectFileIndex;", "kotlin.jvm.PlatformType", "isLibraryArchiveRoot", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "processBulk", "", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "check", "Lkotlin/Function1;", "Companion", "idea-core"})
public final class LibraryModificationTracker
extends SimpleModificationTracker {
    private final ProjectFileIndex projectFileIndex;
    public static final Companion Companion = new Companion(null);

    private final void processBulk(List<? extends VFileEvent> events, Function1<? super VirtualFile, Boolean> check2) {
        Iterable $receiver$iv = events;
        for (Object element$iv : $receiver$iv) {
            VirtualFile file2;
            VFileEvent event = (VFileEvent)element$iv;
            if (!event.isValid() || (file2 = event.getFile()) == null || !((Boolean)check2.invoke((Object)file2)).booleanValue()) continue;
            this.incModificationCount();
            return;
        }
    }

    private final boolean isLibraryArchiveRoot(VirtualFile virtualFile2) {
        if (Intrinsics.areEqual((Object)virtualFile2.getFileType(), (Object)ArchiveFileType.INSTANCE) ^ true) {
            return false;
        }
        VirtualFile virtualFile3 = StandardFileSystems.getJarRootForLocalFile((VirtualFile)virtualFile2);
        if (virtualFile3 == null) {
            return false;
        }
        VirtualFile archiveRoot = virtualFile3;
        return this.projectFileIndex.isInLibraryClasses(archiveRoot);
    }

    public LibraryModificationTracker(final @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener.Adapter(){

            /*
             * WARNING - void declaration
             */
            public void after(@NotNull List<? extends VFileEvent> events) {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Intrinsics.checkParameterIsNotNull(events, (String)"events");
                Iterable iterable = $receiver$iv = (Iterable)events;
                Collection destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    VFileEvent p1 = (VFileEvent)element$iv$iv;
                    if (!LibraryModificationTrackerKt.access$isRelevantEvent(p1)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List list2 = (List)destination$iv$iv;
                List createEvents = list2;
                Collection collection = createEvents;
                if (!collection.isEmpty()) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(createEvents, this){
                        final /* synthetic */ List $createEvents;
                        final /* synthetic */ 1 this$0;
                        {
                            this.$createEvents = list2;
                            this.this$0 = var2_2;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void run() {
                            if (!this.this$0.project.isDisposed()) {
                                LibraryModificationTracker libraryModificationTracker = this.this$0.this;
                                List events$iv = this.$createEvents;
                                Iterable $receiver$iv$iv = events$iv;
                                for (T element$iv$iv : $receiver$iv$iv) {
                                    void this_$iv;
                                    VirtualFile file$iv;
                                    VFileEvent event$iv = (VFileEvent)element$iv$iv;
                                    if (!event$iv.isValid() || (file$iv = event$iv.getFile()) == null) continue;
                                    VirtualFile it = file$iv;
                                    if (!(LibraryModificationTracker.access$getProjectFileIndex$p(this.this$0.this).isInLibraryClasses(it) || LibraryModificationTracker.access$isLibraryArchiveRoot(this.this$0.this, it))) continue;
                                    this_$iv.incModificationCount();
                                    break;
                                }
                            }
                        }
                    });
                }
            }

            public void before(@NotNull List<? extends VFileEvent> events) {
                Intrinsics.checkParameterIsNotNull(events, (String)"events");
                LibraryModificationTracker this_$iv = this;
                Iterable $receiver$iv$iv = events;
                for (Object element$iv$iv : $receiver$iv$iv) {
                    VirtualFile file$iv;
                    VFileEvent event$iv = (VFileEvent)element$iv$iv;
                    if (!event$iv.isValid() || (file$iv = event$iv.getFile()) == null) continue;
                    VirtualFile it = file$iv;
                    if (!projectFileIndex.isInLibraryClasses(it)) continue;
                    this_$iv.incModificationCount();
                    break;
                }
            }
        });
        connection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                this.incModificationCount();
            }

            public void exitDumbMode() {
                this.incModificationCount();
            }
        });
        connection.subscribe(FileTypeManager.TOPIC, (Object)new FileTypeListener(){

            public void beforeFileTypesChanged(@NotNull FileTypeEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                this.incModificationCount();
            }

            public void fileTypesChanged(@NotNull FileTypeEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                this.incModificationCount();
            }
        });
        this.projectFileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project);
    }

    public static final /* synthetic */ void access$processBulk(LibraryModificationTracker $this, @NotNull List events, @NotNull Function1 check2) {
        $this.processBulk(events, (Function1<? super VirtualFile, Boolean>)check2);
    }

    public static final /* synthetic */ boolean access$isLibraryArchiveRoot(LibraryModificationTracker $this, @NotNull VirtualFile virtualFile2) {
        return $this.isLibraryArchiveRoot(virtualFile2);
    }

    @JvmStatic
    @NotNull
    public static final LibraryModificationTracker getInstance(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/caches/resolve/LibraryModificationTracker$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/kotlin/idea/caches/resolve/LibraryModificationTracker;", "project", "Lcom/intellij/openapi/project/Project;", "idea-core"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final LibraryModificationTracker getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Object object = ServiceManager.getService((Project)project, LibraryModificationTracker.class);
            if (object == null) {
                Intrinsics.throwNpe();
            }
            return (LibraryModificationTracker)((Object)object);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

