/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.framework.ui;

import com.google.common.collect.ImmutableMap;
import com.intellij.ide.util.projectWizard.ProjectWizardUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileUIUtils {
    private FileUIUtils() {
    }

    @Nullable
    public static File copyWithOverwriteDialog(@NotNull String messagesTitle, @NotNull String destinationFolder, @NotNull File file2) {
        Map<File, File> copiedFiles;
        if (messagesTitle == null) {
            FileUIUtils.$$$reportNull$$$0(0);
        }
        if (destinationFolder == null) {
            FileUIUtils.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            FileUIUtils.$$$reportNull$$$0(2);
        }
        if ((copiedFiles = FileUIUtils.copyWithOverwriteDialog(messagesTitle, (Map<File, String>)ImmutableMap.of((Object)file2, (Object)destinationFolder))) == null) {
            return null;
        }
        File copy = copiedFiles.get(file2);
        assert (copy != null);
        return copy;
    }

    @Nullable
    public static Map<File, File> copyWithOverwriteDialog(@NotNull String messagesTitle, @NotNull Map<File, String> filesWithDestinations) {
        String destinationPath;
        if (messagesTitle == null) {
            FileUIUtils.$$$reportNull$$$0(3);
        }
        if (filesWithDestinations == null) {
            FileUIUtils.$$$reportNull$$$0(4);
        }
        HashSet<String> fileNames = new HashSet<String>();
        LinkedHashMap<File, File> targetFiles = new LinkedHashMap<File, File>(filesWithDestinations.size());
        for (Map.Entry<File, String> sourceToDestination : filesWithDestinations.entrySet()) {
            File file2 = sourceToDestination.getKey();
            destinationPath = sourceToDestination.getValue();
            String fileName = file2.getName();
            if (!fileNames.add(fileName)) {
                throw new IllegalArgumentException("There are several files with the same name: " + fileName);
            }
            targetFiles.put(file2, new File(destinationPath, fileName));
        }
        List existentFiles = CollectionsKt.filter(targetFiles.entrySet(), sourceToTarget -> ((File)sourceToTarget.getValue()).exists());
        if (!existentFiles.isEmpty()) {
            String message2;
            if (existentFiles.size() == 1) {
                File conflictingFile = (File)((Map.Entry)existentFiles.iterator().next()).getValue();
                message2 = String.format("File \"%s\" already exists in %s.\nDo you want to overwrite it?", conflictingFile.getName(), conflictingFile.getParentFile().getAbsolutePath());
            } else {
                List conflictFiles = CollectionsKt.map((Iterable)existentFiles, Map.Entry::getValue);
                message2 = String.format("Files already exist:\n%s\nDo you want to overwrite them?", StringUtil.join((Iterable)conflictFiles, (String)"\n"));
            }
            int replaceIfExist = Messages.showYesNoDialog(null, (String)message2, (String)(messagesTitle + ". Replace File"), (String)"Overwrite", (String)"Cancel", (Icon)Messages.getWarningIcon());
            if (replaceIfExist != 0) {
                return null;
            }
        }
        for (Map.Entry sourceToTarget2 : targetFiles.entrySet()) {
            try {
                destinationPath = ((File)sourceToTarget2.getValue()).getParentFile().getAbsolutePath();
                if (!ProjectWizardUtil.createDirectoryIfNotExists((String)"Destination folder", (String)destinationPath, (boolean)false)) {
                    Messages.showErrorDialog((String)String.format("Error during folder creating '%s'", destinationPath), (String)(messagesTitle + ". Error"));
                    return null;
                }
                FileUtil.copy((File)((File)sourceToTarget2.getKey()), (File)((File)sourceToTarget2.getValue()));
                LocalFileSystem.getInstance().refreshAndFindFileByIoFile((File)sourceToTarget2.getValue());
            }
            catch (IOException e) {
                Messages.showErrorDialog((String)("Error with copy file " + ((File)sourceToTarget2.getKey()).getName()), (String)(messagesTitle + ". Error"));
                return null;
            }
        }
        return targetFiles;
    }

    @NotNull
    public static String createRelativePath(@Nullable Project project, @Nullable VirtualFile contextDirectory, String relativePath) {
        String path = null;
        if (contextDirectory != null) {
            path = PathUtil.getLocalPath((VirtualFile)contextDirectory);
        } else if (project != null) {
            path = PathUtil.getLocalPath((VirtualFile)project.getBaseDir());
        }
        path = path != null ? new File(path, relativePath).getAbsolutePath() : "";
        String string = path;
        if (string == null) {
            FileUIUtils.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messagesTitle";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destinationFolder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesWithDestinations";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/framework/ui/FileUIUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/framework/ui/FileUIUtils";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createRelativePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "copyWithOverwriteDialog";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

