/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.intentions.ReplaceUntilWithRangeToIntentionKt;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingOffsetIndependentIntention;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.CommonUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.resolve.CompileTimeConstantUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u0006\u001a\u0004\u0018\u00010\u000bH\u0002J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0015\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u000fJ\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J \u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\u001d\u0010\u0017\u001a\u00020\n*\u00020\u000b2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\nH\u0002\u00a2\u0006\u0002\u0010\u0019J\f\u0010\u001a\u001a\u00020\n*\u00020\u000bH\u0002J\f\u0010\u001b\u001a\u00020\n*\u00020\u000bH\u0002J\u000e\u0010\u001c\u001a\u00020\n*\u0004\u0018\u00010\u000bH\u0002\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/SimplifyBooleanWithConstantsIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingOffsetIndependentIntention;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "areThereExpressionsToBeSimplified", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isApplicableTo", "removeRedundantAssertion", "expression", "removeRedundantAssertion$idea", "simplifyExpression", "toSimplifiedBooleanBinaryExpressionWithConstantOperand", "constantOperand", "otherOperand", "operation", "Lcom/intellij/psi/tree/IElementType;", "toSimplifiedExpression", "canBeReducedToBooleanConstant", "constant", "(Lorg/jetbrains/kotlin/psi/KtExpression;Ljava/lang/Boolean;)Z", "canBeReducedToFalse", "canBeReducedToTrue", "hasBooleanType", "idea"})
public final class SimplifyBooleanWithConstantsIntention
extends SelfTargetingOffsetIndependentIntention<KtBinaryExpression> {
    @Override
    public boolean isApplicableTo(@NotNull KtBinaryExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)PsiTreeUtil.getTopmostParentOfType((PsiElement)((PsiElement)element3), KtBinaryExpression.class);
        if (ktBinaryExpression == null) {
            ktBinaryExpression = element3;
        }
        KtBinaryExpression topBinary = ktBinaryExpression;
        return this.areThereExpressionsToBeSimplified(topBinary);
    }

    private final boolean areThereExpressionsToBeSimplified(KtExpression element3) {
        IElementType op;
        if (element3 == null) {
            return false;
        }
        KtExpression ktExpression = element3;
        if (ktExpression instanceof KtParenthesizedExpression) {
            return this.areThereExpressionsToBeSimplified(((KtParenthesizedExpression)element3).getExpression());
        }
        if (ktExpression instanceof KtBinaryExpression && (Intrinsics.areEqual((Object)(op = ((KtBinaryExpression)element3).getOperationToken()), (Object)((Object)KtTokens.ANDAND)) || Intrinsics.areEqual((Object)op, (Object)((Object)KtTokens.OROR)) || Intrinsics.areEqual((Object)op, (Object)((Object)KtTokens.EQEQ)) || Intrinsics.areEqual((Object)op, (Object)((Object)KtTokens.EXCLEQ)))) {
            if (this.areThereExpressionsToBeSimplified(((KtBinaryExpression)element3).getLeft()) && this.hasBooleanType(((KtBinaryExpression)element3).getRight())) {
                return true;
            }
            if (this.areThereExpressionsToBeSimplified(((KtBinaryExpression)element3).getRight()) && this.hasBooleanType(((KtBinaryExpression)element3).getLeft())) {
                return true;
            }
        }
        return SimplifyBooleanWithConstantsIntention.canBeReducedToBooleanConstant$default(this, element3, null, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void applyTo(@NotNull KtBinaryExpression element3, @Nullable Editor editor) {
        KtExpression result2;
        Object object;
        void $receiver$iv;
        KtBinaryExpression topBinary;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)PsiTreeUtil.getTopmostParentOfType((PsiElement)((PsiElement)element3), KtBinaryExpression.class);
        if (ktBinaryExpression == null) {
            ktBinaryExpression = element3;
        }
        KtBinaryExpression ktBinaryExpression2 = topBinary = ktBinaryExpression;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktBinaryExpression2, (String)"topBinary");
        KtExpression simplified = this.toSimplifiedExpression(ktBinaryExpression2);
        PsiElement psiElement2 = (PsiElement)topBinary;
        PsiElement newElement$iv = (PsiElement)KtPsiUtil.safeDeparenthesize(simplified, true);
        PsiElement result$iv = $receiver$iv.replace(newElement$iv);
        if (result$iv instanceof KtExpression) {
            object = result$iv;
        } else {
            PsiElement psiElement3 = result$iv;
            if (psiElement3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
            }
            object = ((KtParenthesizedExpression)psiElement3).getExpression();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
        }
        KtExpression ktExpression = result2 = (KtExpression)object;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"result");
        this.removeRedundantAssertion$idea(ktExpression);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void removeRedundantAssertion$idea(@NotNull KtExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        PsiElement $receiver$iv = (PsiElement)expression2;
        KtCallExpression ktCallExpression = (KtCallExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtCallExpression.class, (boolean)false);
        if (ktCallExpression == null) return;
        KtCallExpression callExpression2 = ktCallExpression;
        CallableDescriptor callableDescriptor = ReplaceUntilWithRangeToIntentionKt.getCallableDescriptor(callExpression2);
        FqName fqName2 = callableDescriptor != null ? DescriptorUtilsKt.fqNameOrNull(callableDescriptor) : null;
        List<KtValueArgument> valueArguments = callExpression2.getValueArguments();
        FqName fqName3 = fqName2;
        if (!Intrinsics.areEqual((Object)(fqName3 != null ? fqName3.asString() : null), (Object)"kotlin.assert")) return;
        List<KtValueArgument> list2 = valueArguments;
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"valueArguments");
        KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.singleOrNull(list2);
        if (!CommonUtilsKt.isTrueConstant(ktValueArgument != null ? ktValueArgument.getArgumentExpression() : null)) return;
        boolean bl = true;
        boolean isRedundant2 = bl;
        if (!isRedundant2) return;
        callExpression2.delete();
    }

    private final KtExpression toSimplifiedExpression(KtExpression expression2) {
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)expression2, false, 2, null);
        if (this.canBeReducedToTrue(expression2)) {
            return psiFactory.createExpression("true");
        }
        if (this.canBeReducedToFalse(expression2)) {
            return psiFactory.createExpression("false");
        }
        if (expression2 instanceof KtParenthesizedExpression) {
            KtExpression expr2 = ((KtParenthesizedExpression)expression2).getExpression();
            if (expr2 != null) {
                KtExpression simplified = this.toSimplifiedExpression(expr2);
                return simplified instanceof KtBinaryExpression ? CreateByPatternKt.createExpressionByPattern$default(psiFactory, "($0)", new Object[]{simplified}, false, 4, null) : simplified;
            }
        } else if (expression2 instanceof KtBinaryExpression) {
            KtExpression left = ((KtBinaryExpression)expression2).getLeft();
            KtExpression right = ((KtBinaryExpression)expression2).getRight();
            IElementType op = ((KtBinaryExpression)expression2).getOperationToken();
            if (left != null && right != null && (Intrinsics.areEqual((Object)op, (Object)((Object)KtTokens.ANDAND)) || Intrinsics.areEqual((Object)op, (Object)((Object)KtTokens.OROR)) || Intrinsics.areEqual((Object)op, (Object)((Object)KtTokens.EQEQ)) || Intrinsics.areEqual((Object)op, (Object)((Object)KtTokens.EXCLEQ)))) {
                KtExpression ktExpression;
                KtExpression simpleLeft = this.simplifyExpression(left);
                KtExpression simpleRight = this.simplifyExpression(right);
                if (this.canBeReducedToTrue(simpleLeft)) {
                    IElementType iElementType = op;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"op");
                    ktExpression = this.toSimplifiedBooleanBinaryExpressionWithConstantOperand(true, simpleRight, iElementType);
                } else if (this.canBeReducedToFalse(simpleLeft)) {
                    IElementType iElementType = op;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"op");
                    ktExpression = this.toSimplifiedBooleanBinaryExpressionWithConstantOperand(false, simpleRight, iElementType);
                } else if (this.canBeReducedToTrue(simpleRight)) {
                    IElementType iElementType = op;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"op");
                    ktExpression = this.toSimplifiedBooleanBinaryExpressionWithConstantOperand(true, simpleLeft, iElementType);
                } else if (this.canBeReducedToFalse(simpleRight)) {
                    IElementType iElementType = op;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"op");
                    ktExpression = this.toSimplifiedBooleanBinaryExpressionWithConstantOperand(false, simpleLeft, iElementType);
                } else {
                    KtOperationReferenceExpression ktOperationReferenceExpression = ((KtBinaryExpression)expression2).getOperationReference();
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktOperationReferenceExpression, (String)"expression.operationReference");
                    String opText = ktOperationReferenceExpression.getText();
                    ktExpression = CreateByPatternKt.createExpressionByPattern$default(psiFactory, "$0 " + opText + " $1", new Object[]{simpleLeft, simpleRight}, false, 4, null);
                }
                return ktExpression;
            }
        }
        return (KtExpression)PsiModificationUtilsKt.copied((PsiElement)expression2);
    }

    private final KtExpression toSimplifiedBooleanBinaryExpressionWithConstantOperand(boolean constantOperand, KtExpression otherOperand, IElementType operation) {
        KtPsiFactory factory2 = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)otherOperand, false, 2, null);
        IElementType iElementType = operation;
        if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.OROR))) {
            if (constantOperand) {
                return factory2.createExpression("true");
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.ANDAND))) {
            if (!constantOperand) {
                return factory2.createExpression("false");
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EQEQ)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EXCLEQ))) {
            KtExpression ktExpression;
            KtExpression it = ktExpression = this.toSimplifiedExpression(otherOperand);
            return constantOperand == Intrinsics.areEqual((Object)operation, (Object)((Object)KtTokens.EQEQ)) ? it : CreateByPatternKt.createExpressionByPattern$default(factory2, "!$0", new Object[]{it}, false, 4, null);
        }
        return this.toSimplifiedExpression(otherOperand);
    }

    /*
     * WARNING - void declaration
     */
    private final KtExpression simplifyExpression(KtExpression expression2) {
        Object object;
        void $receiver$iv;
        PsiElement psiElement2 = (PsiElement)expression2;
        PsiElement newElement$iv = (PsiElement)this.toSimplifiedExpression(expression2);
        PsiElement result$iv = $receiver$iv.replace(newElement$iv);
        if (result$iv instanceof KtExpression) {
            object = result$iv;
        } else {
            PsiElement psiElement3 = result$iv;
            if (psiElement3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
            }
            object = ((KtParenthesizedExpression)psiElement3).getExpression();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
        }
        return (KtExpression)object;
    }

    private final boolean hasBooleanType(@Nullable KtExpression $receiver) {
        Object object = $receiver;
        if (object == null || (object = CallUtilKt.getType((KtExpression)object, ResolutionUtils.analyze$default($receiver, null, 1, null))) == null) {
            return false;
        }
        Object type2 = object;
        return KotlinBuiltIns.isBoolean((KotlinType)type2) && !FlexibleTypesKt.isFlexible((KotlinType)type2);
    }

    private final boolean canBeReducedToBooleanConstant(@NotNull KtExpression $receiver, Boolean constant) {
        return CompileTimeConstantUtils.canBeReducedToBooleanConstant($receiver, ResolutionUtils.analyze$default($receiver, null, 1, null), constant);
    }

    static /* bridge */ /* synthetic */ boolean canBeReducedToBooleanConstant$default(SimplifyBooleanWithConstantsIntention simplifyBooleanWithConstantsIntention, KtExpression ktExpression, Boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = null;
        }
        return simplifyBooleanWithConstantsIntention.canBeReducedToBooleanConstant(ktExpression, bl);
    }

    private final boolean canBeReducedToTrue(@NotNull KtExpression $receiver) {
        return this.canBeReducedToBooleanConstant($receiver, true);
    }

    private final boolean canBeReducedToFalse(@NotNull KtExpression $receiver) {
        return this.canBeReducedToBooleanConstant($receiver, false);
    }

    public SimplifyBooleanWithConstantsIntention() {
        super(KtBinaryExpression.class, "Simplify boolean expression", null, 4, null);
    }
}

