/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.CollectionLiteralResolver;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000\u0098\u0001\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b\u001a\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f\u001a\n\u0010 \u001a\u00020\b*\u00020!\u001a\f\u0010\"\u001a\u0004\u0018\u00010\u0012*\u00020#\u001a\n\u0010$\u001a\u00020\b*\u00020!\u001a\f\u0010%\u001a\u00020\u0019*\u0004\u0018\u00010\b\u001a\u0014\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007*\u00020\bH\u0002\u001a\n\u0010'\u001a\u00020\u0019*\u00020\r\u001a\n\u0010(\u001a\u00020\u0019*\u00020\b\u001a \u0010)\u001a\u00020\u0019*\u00020\b2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020\u00190+H\u0002\u001a\f\u0010-\u001a\u00020\u0019*\u00020,H\u0000\u001a\u0012\u0010.\u001a\u00020\u0019*\u00020\r2\u0006\u0010/\u001a\u00020\u0012\u001a\f\u00100\u001a\u00020\u0019*\u0004\u0018\u000101\u001a\n\u00102\u001a\u00020\u0019*\u00020\u000e\u001a\f\u00103\u001a\u00020\u0019*\u0004\u0018\u000101\u001a\f\u00104\u001a\u00020\u0019*\u0004\u0018\u000101\u001a\n\u00105\u001a\u00020\b*\u00020\b\u001a$\u00106\u001a\u00020\b*\u00020!2\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\b2\b\b\u0002\u0010:\u001a\u00020\u0019\u001a\u0012\u0010;\u001a\u00020\u0019*\n\u0012\u0006\b\u0001\u0012\u00020=0<\u001a\u0010\u0010>\u001a\b\u0012\u0004\u0012\u00020?0\u0007*\u00020\b\u001a\u000e\u0010@\u001a\u0004\u0018\u00010\b*\u00020\bH\u0002\u001a\u001c\u0010A\u001a\f\u0012\u0006\b\u0001\u0012\u00020=\u0018\u00010<*\u00020\u000e2\u0006\u0010B\u001a\u00020C\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u00040\u00040\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001d\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\"\u0017\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\"\u0017\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006D"}, d2={"ARRAY_OF_METHODS", "", "Lorg/jetbrains/kotlin/name/Name;", "NEGATABLE_OPERATORS", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "kotlin.jvm.PlatformType", "branches", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "getBranches", "(Lorg/jetbrains/kotlin/psi/KtIfExpression;)Ljava/util/List;", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "getCallExpression", "(Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;)Lorg/jetbrains/kotlin/psi/KtCallExpression;", "calleeName", "", "getCalleeName", "(Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;)Ljava/lang/String;", "getNegatedOperatorText", "token", "Lcom/intellij/psi/tree/IElementType;", "isAutoCreatedItUsage", "", "expression", "Lorg/jetbrains/kotlin/psi/KtNameReferenceExpression;", "splitPropertyDeclaration", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "deleteFirstReceiver", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "description", "Lorg/jetbrains/kotlin/psi/KtContainerNode;", "getLeftMostReceiverExpression", "hasResultingIfWithoutElse", "ifBranchesOrThis", "isArrayOfMethod", "isExitStatement", "isExpressionOfTypeOrSubtype", "predicate", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/types/KotlinType;", "isFlexibleRecursive", "isMethodCall", "fqMethodName", "isOne", "Lorg/jetbrains/kotlin/psi/KtElement;", "isReceiverExpressionWithValue", "isSizeOrLength", "isZero", "negate", "replaceFirstReceiver", "factory", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "newReceiver", "safeAccess", "resolvedToArrayType", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "resultingWhens", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "specialNegation", "toResolvedCall", "bodyResolveMode", "Lorg/jetbrains/kotlin/resolve/lazy/BodyResolveMode;", "idea"})
public final class UtilsKt {
    private static final Set<KtSingleValueToken> NEGATABLE_OPERATORS = SetsKt.setOf((Object[])new KtSingleValueToken[]{KtTokens.EQEQ, KtTokens.EXCLEQ, KtTokens.EQEQEQ, KtTokens.EXCLEQEQEQ, KtTokens.IS_KEYWORD, KtTokens.NOT_IS, KtTokens.IN_KEYWORD, KtTokens.NOT_IN, KtTokens.LT, KtTokens.LTEQ, KtTokens.GT, KtTokens.GTEQ});
    private static final Set<Name> ARRAY_OF_METHODS = SetsKt.plus((Set)SetsKt.plus((Set)SetsKt.setOf((Object)CollectionLiteralResolver.Companion.getARRAY_OF_FUNCTION()), (Iterable)CollectionsKt.toSet((Iterable)CollectionLiteralResolver.Companion.getPRIMITIVE_TYPE_TO_ARRAY().values())), (Object)Name.identifier("emptyArray"));

    @Nullable
    public static final String description(@NotNull KtContainerNode $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ASTNode aSTNode = $receiver.getNode();
        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"node");
        IElementType iElementType = aSTNode.getElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtNodeTypes.THEN))) {
            return "if";
        }
        if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtNodeTypes.ELSE))) {
            return "else";
        }
        if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtNodeTypes.BODY))) {
            PsiElement psiElement2 = $receiver.getParent();
            if (psiElement2 instanceof KtWhileExpression) {
                return "while";
            }
            if (psiElement2 instanceof KtDoWhileExpression) {
                return "do...while";
            }
            if (psiElement2 instanceof KtForExpression) {
                return "for";
            }
        }
        return null;
    }

    public static final boolean isMethodCall(@NotNull KtCallExpression $receiver, @NotNull String fqMethodName) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)fqMethodName, (String)"fqMethodName");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall($receiver, ResolutionUtils.analyze$default($receiver, null, 1, null));
        if (resolvedCall2 == null) {
            return false;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        return Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameUnsafe(resolvedCall3.getResultingDescriptor()).asString(), (Object)fqMethodName);
    }

    public static final boolean isAutoCreatedItUsage(@NotNull KtNameReferenceExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        if (Intrinsics.areEqual((Object)expression2.getReferencedName(), (Object)"it") ^ true) {
            return false;
        }
        BindingContext context = ResolutionUtils.analyze(expression2, BodyResolveMode.PARTIAL);
        Object object = CollectionsKt.singleOrNull((Iterable)ReferenceUtilKt.getMainReference(expression2).resolveToDescriptors(context));
        if (!(object instanceof ValueParameterDescriptor)) {
            object = null;
        }
        ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)object;
        if (valueParameterDescriptor == null) {
            return false;
        }
        ValueParameterDescriptor target = valueParameterDescriptor;
        Object v = context.get(BindingContext.AUTO_CREATED_IT, target);
        if (v == null) {
            Intrinsics.throwNpe();
        }
        return (Boolean)v;
    }

    @NotNull
    public static final KtBinaryExpression splitPropertyDeclaration(@NotNull KtProperty property2) {
        KotlinType kotlinType;
        Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
        PsiElement parent2 = property2.getParent();
        KtExpression ktExpression = property2.getInitializer();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        KtExpression initializer2 = ktExpression;
        if (property2.getTypeReference() != null) {
            kotlinType = null;
        } else {
            KtExpression ktExpression2 = initializer2;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"initializer");
            kotlinType = ResolutionUtils.analyze$default(ktExpression2, null, 1, null).getType(initializer2);
        }
        KotlinType explicitTypeToSet = kotlinType;
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default(property2, false, 2, null);
        Object[] objectArray = new Object[2];
        Name name2 = property2.getNameAsName();
        if (name2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"property.nameAsName!!");
        objectArray[0] = name2;
        KtExpression ktExpression3 = initializer2;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression3, (String)"initializer");
        objectArray[1] = ktExpression3;
        KtExpression assignment = CreateByPatternKt.createExpressionByPattern$default(psiFactory, "$0 = $1", objectArray, false, 4, null);
        PsiElement psiElement2 = parent2.addAfter((PsiElement)assignment, (PsiElement)property2);
        if (psiElement2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
        }
        assignment = (KtBinaryExpression)psiElement2;
        parent2.addAfter(psiFactory.createNewLine(), (PsiElement)property2);
        property2.setInitializer(null);
        if (explicitTypeToSet != null) {
            PsiModificationUtilsKt.setType$default((KtCallableDeclaration)property2, explicitTypeToSet, false, 2, null);
        }
        return (KtBinaryExpression)assignment;
    }

    @Nullable
    public static final KtCallExpression getCallExpression(@NotNull KtQualifiedExpression $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        KtExpression ktExpression = $receiver.getSelectorExpression();
        if (!(ktExpression instanceof KtCallExpression)) {
            ktExpression = null;
        }
        return (KtCallExpression)ktExpression;
    }

    @Nullable
    public static final String getCalleeName(@NotNull KtQualifiedExpression $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        KtCallExpression ktCallExpression = UtilsKt.getCallExpression($receiver);
        KtExpression ktExpression = ktCallExpression != null ? ktCallExpression.getCalleeExpression() : null;
        if (!(ktExpression instanceof KtNameReferenceExpression)) {
            ktExpression = null;
        }
        KtNameReferenceExpression ktNameReferenceExpression = (KtNameReferenceExpression)ktExpression;
        return ktNameReferenceExpression != null ? ktNameReferenceExpression.getText() : null;
    }

    @Nullable
    public static final ResolvedCall<? extends CallableDescriptor> toResolvedCall(@NotNull KtQualifiedExpression $receiver, @NotNull BodyResolveMode bodyResolveMode) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)((Object)bodyResolveMode), (String)"bodyResolveMode");
        KtCallExpression ktCallExpression = UtilsKt.getCallExpression($receiver);
        if (ktCallExpression == null) {
            return null;
        }
        KtCallExpression callExpression2 = ktCallExpression;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(callExpression2, ResolutionUtils.analyze(callExpression2, bodyResolveMode));
        if (resolvedCall2 == null) {
            return null;
        }
        return resolvedCall2;
    }

    public static final boolean isExitStatement(@NotNull KtExpression $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        KtExpression ktExpression = $receiver;
        return ktExpression instanceof KtContinueExpression || ktExpression instanceof KtBreakExpression || ktExpression instanceof KtThrowExpression || ktExpression instanceof KtReturnExpression;
    }

    public static final boolean isReceiverExpressionWithValue(@NotNull KtQualifiedExpression $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        KtExpression receiver = $receiver.getReceiverExpression();
        if (receiver instanceof KtSuperExpression) {
            return false;
        }
        return ResolutionUtils.analyze$default($receiver, null, 1, null).getType(receiver) != null;
    }

    @NotNull
    public static final KtExpression negate(@NotNull KtExpression $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        KtExpression specialNegation = UtilsKt.specialNegation($receiver);
        if (specialNegation != null) {
            return specialNegation;
        }
        return CreateByPatternKt.createExpressionByPattern$default(KtPsiFactoryKt.KtPsiFactory$default((PsiElement)$receiver, false, 2, null), "!$0", new Object[]{$receiver}, false, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<KtWhenExpression> resultingWhens(@NotNull KtExpression $receiver) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        KtExpression ktExpression = $receiver;
        if (ktExpression instanceof KtWhenExpression) {
            Collection<Object> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            Collection collection2 = CollectionsKt.listOf((Object)$receiver);
            List<KtWhenEntry> list2 = ((KtWhenExpression)$receiver).getEntries();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"entries");
            Iterable iterable = list2;
            Collection collection3 = collection2;
            void var3_4 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                KtWhenEntry ktWhenEntry = (KtWhenEntry)item$iv$iv;
                collection = destination$iv$iv;
                void v2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
                Object object2 = v2.getExpression();
                if (object2 == null || (object2 = UtilsKt.resultingWhens((KtExpression)object2)) == null) {
                    object2 = CollectionsKt.emptyList();
                }
                Object object3 = object2;
                collection.add(object3);
            }
            collection = (List)destination$iv$iv;
            object = CollectionsKt.plus((Collection)collection3, (Iterable)CollectionsKt.flatten((Iterable)collection));
        } else if (ktExpression instanceof KtIfExpression) {
            Object object4;
            Object object5 = ((KtIfExpression)$receiver).getThen();
            if (object5 == null || (object5 = UtilsKt.resultingWhens((KtExpression)object5)) == null) {
                object5 = CollectionsKt.emptyList();
            }
            object = CollectionsKt.plus((Collection)((Collection)object5), (Iterable)((object4 = ((KtIfExpression)$receiver).getElse()) != null && (object4 = UtilsKt.resultingWhens((KtExpression)object4)) != null ? (Iterable)object4 : (Iterable)CollectionsKt.emptyList()));
        } else if (ktExpression instanceof KtBinaryExpression) {
            Object object6;
            Object object7 = ((KtBinaryExpression)$receiver).getLeft();
            if (object7 == null || (object7 = UtilsKt.resultingWhens((KtExpression)object7)) == null) {
                object7 = CollectionsKt.emptyList();
            }
            object = CollectionsKt.plus((Collection)((Collection)object7), (Iterable)((object6 = ((KtBinaryExpression)$receiver).getRight()) != null && (object6 = UtilsKt.resultingWhens((KtExpression)object6)) != null ? (Iterable)object6 : (Iterable)CollectionsKt.emptyList()));
        } else if (ktExpression instanceof KtUnaryExpression) {
            object = ((KtUnaryExpression)$receiver).getBaseExpression();
            if (object == null || (object = UtilsKt.resultingWhens((KtExpression)object)) == null) {
                object = CollectionsKt.emptyList();
            }
        } else if (ktExpression instanceof KtBlockExpression) {
            List<KtExpression> list3 = ((KtBlockExpression)$receiver).getStatements();
            Intrinsics.checkExpressionValueIsNotNull(list3, (String)"statements");
            object = (KtExpression)CollectionsKt.lastOrNull(list3);
            if (object == null || (object = UtilsKt.resultingWhens((KtExpression)object)) == null) {
                object = CollectionsKt.emptyList();
            }
        } else {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    public static final boolean hasResultingIfWithoutElse(@Nullable KtExpression $receiver) {
        boolean bl;
        block13: {
            KtExpression ktExpression = $receiver;
            if (ktExpression instanceof KtIfExpression) {
                bl = ((KtIfExpression)$receiver).getElse() == null || UtilsKt.hasResultingIfWithoutElse(((KtIfExpression)$receiver).getThen()) || UtilsKt.hasResultingIfWithoutElse(((KtIfExpression)$receiver).getElse());
            } else if (ktExpression instanceof KtWhenExpression) {
                List<KtWhenEntry> list2 = ((KtWhenExpression)$receiver).getEntries();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"entries");
                Iterable $receiver$iv = list2;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        KtWhenEntry it;
                        KtWhenEntry ktWhenEntry = it = (KtWhenEntry)element$iv;
                        Intrinsics.checkExpressionValueIsNotNull((Object)ktWhenEntry, (String)"it");
                        if (!UtilsKt.hasResultingIfWithoutElse(ktWhenEntry.getExpression())) continue;
                        bl = true;
                        break block13;
                    }
                    bl = false;
                }
            } else if (ktExpression instanceof KtBinaryExpression) {
                bl = UtilsKt.hasResultingIfWithoutElse(((KtBinaryExpression)$receiver).getLeft()) || UtilsKt.hasResultingIfWithoutElse(((KtBinaryExpression)$receiver).getRight());
            } else if (ktExpression instanceof KtUnaryExpression) {
                bl = UtilsKt.hasResultingIfWithoutElse(((KtUnaryExpression)$receiver).getBaseExpression());
            } else if (ktExpression instanceof KtBlockExpression) {
                List<KtExpression> list3 = ((KtBlockExpression)$receiver).getStatements();
                Intrinsics.checkExpressionValueIsNotNull(list3, (String)"statements");
                bl = UtilsKt.hasResultingIfWithoutElse((KtExpression)CollectionsKt.lastOrNull(list3));
            } else {
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final KtExpression specialNegation(@NotNull KtExpression $receiver) {
        block8: {
            KtExpression ktExpression;
            KtPsiFactory factory2;
            block9: {
                String string;
                factory2 = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)$receiver, false, 2, null);
                KtExpression ktExpression2 = $receiver;
                if (ktExpression2 instanceof KtPrefixExpression) {
                    if (!Intrinsics.areEqual((Object)((KtPrefixExpression)$receiver).getOperationReference().getReferencedName(), (Object)"!")) return null;
                    KtExpression baseExpression = ((KtPrefixExpression)$receiver).getBaseExpression();
                    if (baseExpression == null) return null;
                    BindingContext bindingContext2 = ResolutionUtils.analyze(baseExpression, BodyResolveMode.PARTIAL);
                    KotlinType type2 = bindingContext2.getType(baseExpression);
                    if (type2 == null) return null;
                    if (!KotlinBuiltIns.isBoolean(type2)) return null;
                    return KtPsiUtil.safeDeparenthesize(baseExpression);
                }
                if (ktExpression2 instanceof KtBinaryExpression) {
                    IElementType operator = ((KtBinaryExpression)$receiver).getOperationToken();
                    if (!CollectionsKt.contains((Iterable)NEGATABLE_OPERATORS, (Object)operator)) {
                        return null;
                    }
                    KtExpression ktExpression3 = ((KtBinaryExpression)$receiver).getLeft();
                    if (ktExpression3 == null) return null;
                    KtExpression left = ktExpression3;
                    KtExpression ktExpression4 = ((KtBinaryExpression)$receiver).getRight();
                    if (ktExpression4 == null) return null;
                    KtExpression right = ktExpression4;
                    Object[] objectArray = new Object[3];
                    KtExpression ktExpression5 = left;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression5, (String)"left");
                    objectArray[0] = ktExpression5;
                    IElementType iElementType = operator;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"operator");
                    objectArray[1] = UtilsKt.getNegatedOperatorText(iElementType);
                    KtExpression ktExpression6 = right;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression6, (String)"right");
                    objectArray[2] = ktExpression6;
                    return CreateByPatternKt.createExpressionByPattern$default(factory2, "$0 $1 $2", objectArray, false, 4, null);
                }
                if (ktExpression2 instanceof KtIsExpression) {
                    Object[] objectArray = new Object[3];
                    KtExpression ktExpression7 = ((KtIsExpression)$receiver).getLeftHandSide();
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression7, (String)"leftHandSide");
                    objectArray[0] = ktExpression7;
                    objectArray[1] = ((KtIsExpression)$receiver).isNegated() ? "is" : "!is";
                    KtTypeReference ktTypeReference = ((KtIsExpression)$receiver).getTypeReference();
                    if (ktTypeReference == null) return null;
                    objectArray[2] = ktTypeReference;
                    return CreateByPatternKt.createExpressionByPattern$default(factory2, "$0 $1 $2", objectArray, false, 4, null);
                }
                if (!(ktExpression2 instanceof KtConstantExpression)) return null;
                String string2 = string = ((KtConstantExpression)$receiver).getText();
                if (string2 == null) break block8;
                switch (string2.hashCode()) {
                    case 3569038: {
                        if (!string.equals("true")) return null;
                        break;
                    }
                    case 97196323: {
                        if (!string.equals("false")) return null;
                        break block9;
                    }
                }
                ktExpression = factory2.createExpression("false");
                return ktExpression;
            }
            ktExpression = factory2.createExpression("true");
            return ktExpression;
        }
        return null;
    }

    private static final String getNegatedOperatorText(IElementType token) {
        String string;
        IElementType iElementType = token;
        if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EQEQ))) {
            KtSingleValueToken ktSingleValueToken = KtTokens.EXCLEQ;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken), (String)"KtTokens.EXCLEQ");
            String string2 = ktSingleValueToken.getValue();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"KtTokens.EXCLEQ.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EXCLEQ))) {
            KtSingleValueToken ktSingleValueToken = KtTokens.EQEQ;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken), (String)"KtTokens.EQEQ");
            String string3 = ktSingleValueToken.getValue();
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"KtTokens.EQEQ.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EQEQEQ))) {
            KtSingleValueToken ktSingleValueToken = KtTokens.EXCLEQEQEQ;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken), (String)"KtTokens.EXCLEQEQEQ");
            String string4 = ktSingleValueToken.getValue();
            string = string4;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"KtTokens.EXCLEQEQEQ.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EXCLEQEQEQ))) {
            KtSingleValueToken ktSingleValueToken = KtTokens.EQEQEQ;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken), (String)"KtTokens.EQEQEQ");
            String string5 = ktSingleValueToken.getValue();
            string = string5;
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"KtTokens.EQEQEQ.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.IS_KEYWORD))) {
            KtKeywordToken ktKeywordToken = KtTokens.NOT_IS;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktKeywordToken), (String)"KtTokens.NOT_IS");
            String string6 = ktKeywordToken.getValue();
            string = string6;
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"KtTokens.NOT_IS.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.NOT_IS))) {
            KtKeywordToken ktKeywordToken = KtTokens.IS_KEYWORD;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktKeywordToken), (String)"KtTokens.IS_KEYWORD");
            String string7 = ktKeywordToken.getValue();
            string = string7;
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"KtTokens.IS_KEYWORD.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.IN_KEYWORD))) {
            KtKeywordToken ktKeywordToken = KtTokens.NOT_IN;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktKeywordToken), (String)"KtTokens.NOT_IN");
            String string8 = ktKeywordToken.getValue();
            string = string8;
            Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"KtTokens.NOT_IN.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.NOT_IN))) {
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.IN_KEYWORD;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken), (String)"KtTokens.IN_KEYWORD");
            String string9 = ktModifierKeywordToken.getValue();
            string = string9;
            Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"KtTokens.IN_KEYWORD.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.LT))) {
            KtSingleValueToken ktSingleValueToken = KtTokens.GTEQ;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken), (String)"KtTokens.GTEQ");
            String string10 = ktSingleValueToken.getValue();
            string = string10;
            Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"KtTokens.GTEQ.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.LTEQ))) {
            KtSingleValueToken ktSingleValueToken = KtTokens.GT;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken), (String)"KtTokens.GT");
            String string11 = ktSingleValueToken.getValue();
            string = string11;
            Intrinsics.checkExpressionValueIsNotNull((Object)string11, (String)"KtTokens.GT.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.GT))) {
            KtSingleValueToken ktSingleValueToken = KtTokens.LTEQ;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken), (String)"KtTokens.LTEQ");
            String string12 = ktSingleValueToken.getValue();
            string = string12;
            Intrinsics.checkExpressionValueIsNotNull((Object)string12, (String)"KtTokens.LTEQ.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.GTEQ))) {
            KtSingleValueToken ktSingleValueToken = KtTokens.LT;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken), (String)"KtTokens.LT");
            String string13 = ktSingleValueToken.getValue();
            string = string13;
            Intrinsics.checkExpressionValueIsNotNull((Object)string13, (String)"KtTokens.LT.value");
        } else {
            throw (Throwable)new IllegalArgumentException("The token " + token + " does not have a negated equivalent.");
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isFlexibleRecursive(@NotNull KotlinType $receiver) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (FlexibleTypesKt.isFlexible($receiver)) {
            return true;
        }
        Iterable $receiver$iv = $receiver.getArguments();
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $receiver$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            TypeProjection it = (TypeProjection)element$iv;
            if (!it.isStarProjection()) {
                KotlinType kotlinType = it.getType();
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"it.type");
                if (UtilsKt.isFlexibleRecursive(kotlinType)) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    @NotNull
    public static final List<KtExpression> getBranches(@NotNull KtIfExpression $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return UtilsKt.ifBranchesOrThis($receiver);
    }

    private static final List<KtExpression> ifBranchesOrThis(@NotNull KtExpression $receiver) {
        if (!($receiver instanceof KtIfExpression)) {
            return CollectionsKt.listOf((Object)$receiver);
        }
        Collection collection = CollectionsKt.listOf((Object)((KtIfExpression)$receiver).getThen());
        KtExpression ktExpression = ((KtIfExpression)$receiver).getElse();
        List list2 = ktExpression != null ? UtilsKt.ifBranchesOrThis(ktExpression) : null;
        List list3 = list2;
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)list3);
    }

    public static final boolean resolvedToArrayType(@NotNull ResolvedCall<? extends CallableDescriptor> $receiver) {
        KotlinType kotlinType;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        KotlinType type2 = kotlinType = $receiver.getResultingDescriptor().getReturnType();
        return type2 != null && (KotlinBuiltIns.isArray(type2) || KotlinBuiltIns.isPrimitiveArray(type2));
    }

    public static final boolean isZero(@Nullable KtElement $receiver) {
        KtElement ktElement = $receiver;
        return Intrinsics.areEqual((Object)(ktElement != null ? ktElement.getText() : null), (Object)"0");
    }

    public static final boolean isOne(@Nullable KtElement $receiver) {
        KtElement ktElement = $receiver;
        return Intrinsics.areEqual((Object)(ktElement != null ? ktElement.getText() : null), (Object)"1");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isExpressionOfTypeOrSubtype(@NotNull KtExpression $receiver, Function1<? super KotlinType, Boolean> predicate2) {
        Object element$iv;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall($receiver, ResolutionUtils.analyze$default($receiver, null, 1, null));
        Object object = resolvedCall2;
        if (resolvedCall2 == null) return false;
        CallableDescriptor callableDescriptor = object.getResultingDescriptor();
        object = callableDescriptor;
        if (callableDescriptor == null) return false;
        KotlinType kotlinType = object.getReturnType();
        KotlinType returnType2 = kotlinType;
        if (returnType2 == null) return false;
        Collection<KotlinType> collection = returnType2.getConstructor().getSupertypes();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"returnType.constructor.supertypes");
        Iterable $receiver$iv = CollectionsKt.plus(collection, (Object)returnType2);
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $receiver$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
        } while (!((Boolean)predicate2.invoke(element$iv = iterator2.next())).booleanValue());
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final boolean isSizeOrLength(@Nullable KtElement $receiver) {
        block5: {
            boolean bl;
            block6: {
                String string;
                if (!($receiver instanceof KtDotQualifiedExpression)) {
                    return false;
                }
                KtExpression ktExpression = ((KtDotQualifiedExpression)$receiver).getSelectorExpression();
                if (ktExpression == null) return false;
                String string2 = ktExpression.getText();
                String string3 = string = string2;
                if (string3 == null) break block5;
                switch (string3.hashCode()) {
                    case 3530753: {
                        if (!string.equals("size")) return false;
                        break;
                    }
                    case -1106363674: {
                        if (!string.equals("length")) return false;
                        break block6;
                    }
                }
                bl = UtilsKt.isExpressionOfTypeOrSubtype(((KtDotQualifiedExpression)$receiver).getReceiverExpression(), (Function1<? super KotlinType, Boolean>)((Function1)isSizeOrLength.1.INSTANCE));
                return bl;
            }
            bl = UtilsKt.isExpressionOfTypeOrSubtype(((KtDotQualifiedExpression)$receiver).getReceiverExpression(), (Function1<? super KotlinType, Boolean>)((Function1)isSizeOrLength.2.INSTANCE));
            return bl;
        }
        return false;
    }

    @NotNull
    public static final KtExpression getLeftMostReceiverExpression(@NotNull KtDotQualifiedExpression $receiver) {
        KtExpression ktExpression;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        KtExpression ktExpression2 = $receiver.getReceiverExpression();
        if (!(ktExpression2 instanceof KtDotQualifiedExpression)) {
            ktExpression2 = null;
        }
        if ((ktExpression = (KtDotQualifiedExpression)ktExpression2) == null || (ktExpression = UtilsKt.getLeftMostReceiverExpression(ktExpression)) == null) {
            ktExpression = $receiver.getReceiverExpression();
        }
        return ktExpression;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final KtExpression replaceFirstReceiver(@NotNull KtDotQualifiedExpression $receiver, @NotNull KtPsiFactory factory2, @NotNull KtExpression newReceiver, boolean safeAccess) {
        KtExpression ktExpression;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)factory2, (String)"factory");
        Intrinsics.checkParameterIsNotNull((Object)newReceiver, (String)"newReceiver");
        if (safeAccess) {
            Object object;
            void $receiver$iv;
            PsiElement psiElement2 = (PsiElement)$receiver;
            Object[] objectArray = new Object[2];
            objectArray[0] = $receiver.getReceiverExpression();
            KtExpression ktExpression2 = $receiver.getSelectorExpression();
            if (ktExpression2 == null) {
                Intrinsics.throwNpe();
            }
            objectArray[1] = ktExpression2;
            PsiElement newElement$iv = (PsiElement)CreateByPatternKt.createExpressionByPattern$default(factory2, "$0?.$1", objectArray, false, 4, null);
            PsiElement result$iv = $receiver$iv.replace(newElement$iv);
            if (result$iv instanceof KtExpression) {
                object = result$iv;
            } else {
                PsiElement psiElement3 = result$iv;
                if (psiElement3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                }
                object = ((KtParenthesizedExpression)psiElement3).getExpression();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                }
            }
            ktExpression = (KtExpression)object;
        } else {
            ktExpression = $receiver;
        }
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtQualifiedExpression");
        }
        KtQualifiedExpression replaced = (KtQualifiedExpression)ktExpression;
        KtExpression receiver = replaced.getReceiverExpression();
        KtExpression ktExpression3 = receiver;
        if (ktExpression3 instanceof KtDotQualifiedExpression) {
            ((KtDotQualifiedExpression)receiver).replace((PsiElement)UtilsKt.replaceFirstReceiver((KtDotQualifiedExpression)receiver, factory2, newReceiver, safeAccess));
        } else {
            receiver.replace((PsiElement)newReceiver);
        }
        return replaced;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ KtExpression replaceFirstReceiver$default(KtDotQualifiedExpression ktDotQualifiedExpression, KtPsiFactory ktPsiFactory, KtExpression ktExpression, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return UtilsKt.replaceFirstReceiver(ktDotQualifiedExpression, ktPsiFactory, ktExpression, bl);
    }

    @NotNull
    public static final KtExpression deleteFirstReceiver(@NotNull KtDotQualifiedExpression $receiver) {
        KtExpression receiver;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        KtExpression ktExpression = receiver = $receiver.getReceiverExpression();
        if (ktExpression instanceof KtDotQualifiedExpression) {
            UtilsKt.deleteFirstReceiver((KtDotQualifiedExpression)receiver);
        } else {
            KtExpression ktExpression2 = $receiver.getSelectorExpression();
            if (ktExpression2 != null) {
                KtExpression ktExpression3;
                KtExpression it = ktExpression3 = ktExpression2;
                PsiElement psiElement2 = $receiver.replace((PsiElement)it);
                if (psiElement2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                }
                return (KtExpression)psiElement2;
            }
        }
        return $receiver;
    }

    public static final boolean isArrayOfMethod(@NotNull KtCallExpression $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall($receiver, ResolutionUtils.analyze$default($receiver, null, 1, null));
        if (resolvedCall2 == null) {
            return false;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        CallableDescriptor descriptor2 = resolvedCall3.getCandidateDescriptor();
        DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
        if (!(declarationDescriptor instanceof PackageFragmentDescriptor)) {
            declarationDescriptor = null;
        }
        PackageFragmentDescriptor packageFragmentDescriptor = (PackageFragmentDescriptor)declarationDescriptor;
        return Intrinsics.areEqual((Object)(packageFragmentDescriptor != null ? packageFragmentDescriptor.getFqName() : null), (Object)KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME) && ARRAY_OF_METHODS.contains(descriptor2.getName());
    }
}

