/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix.expectactual;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.core.TemplateKind;
import org.jetbrains.kotlin.idea.core.TemplatesKt;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtClassOrObjectKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationStub;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a,\u0010\b\u001a\u00020\t*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a,\u0010\r\u001a\u00020\u000e*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0014\u0010\u0011\u001a\u00020\u0012*\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0014"}, d2={"generateClassOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "project", "Lcom/intellij/openapi/project/Project;", "expectedClass", "actualNeeded", "", "generateFunction", "Lorg/jetbrains/kotlin/psi/KtFunction;", "expectedFunction", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "generateProperty", "Lorg/jetbrains/kotlin/psi/KtProperty;", "expectedProperty", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "replaceExpectModifier", "", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "idea"})
public final class CreateActualFixKt {
    private static final void replaceExpectModifier(@NotNull KtModifierListOwner $receiver, boolean actualNeeded) {
        if (actualNeeded) {
            $receiver.addModifier(KtTokens.ACTUAL_KEYWORD);
        } else {
            $receiver.removeModifier(KtTokens.HEADER_KEYWORD);
            $receiver.removeModifier(KtTokens.EXPECT_KEYWORD);
        }
    }

    private static final KtClassOrObject generateClassOrObject(@NotNull KtPsiFactory $receiver, Project project, KtClassOrObject expectedClass, boolean actualNeeded) {
        KtDeclarationStub ktDeclarationStub;
        KtDeclaration ktDeclaration;
        KtClassOrObject ktClassOrObject;
        String expectedText = expectedClass.getText();
        if (expectedClass instanceof KtObjectDeclaration) {
            String string = expectedText;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"expectedText");
            ktClassOrObject = $receiver.createObject(string);
        } else {
            String string = expectedText;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"expectedText");
            ktClassOrObject = $receiver.createClass(string);
        }
        KtClassOrObject actualClass = ktClassOrObject;
        boolean isInterface = expectedClass instanceof KtClass && ((KtClass)expectedClass).isInterface();
        Iterable $receiver$iv = actualClass.getDeclarations();
        for (Object element$iv : $receiver$iv) {
            KtDeclaration it = (KtDeclaration)element$iv;
            ktDeclaration = it;
            if (ktDeclaration instanceof KtEnumEntry) continue;
            if (ktDeclaration instanceof KtClassOrObject) {
                it.delete();
                continue;
            }
            if (!(ktDeclaration instanceof KtCallableDeclaration)) continue;
            if (!isInterface && !it.hasModifier(KtTokens.ABSTRACT_KEYWORD)) {
                it.delete();
                continue;
            }
            it.addModifier(KtTokens.ACTUAL_KEYWORD);
        }
        for (KtDeclaration expectedDeclaration : expectedClass.getDeclarations()) {
            KtDeclaration ktDeclaration2;
            if (PsiModificationUtilsKt.toDescriptor(expectedDeclaration) == null) {
                continue;
            }
            ktDeclaration = expectedDeclaration;
            if (ktDeclaration instanceof KtClassOrObject) {
                if (expectedDeclaration instanceof KtEnumEntry) continue;
                ktDeclaration2 = CreateActualFixKt.generateClassOrObject($receiver, project, (KtClassOrObject)expectedDeclaration, true);
            } else {
                KtCallableDeclaration ktCallableDeclaration;
                Object descriptor2;
                if (!(ktDeclaration instanceof KtCallableDeclaration) || isInterface || expectedDeclaration.hasModifier(KtTokens.ABSTRACT_KEYWORD)) continue;
                KtDeclaration $i$a$1$forEach = expectedDeclaration;
                if ($i$a$1$forEach instanceof KtFunction) {
                    Object object = descriptor2;
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
                    }
                    ktCallableDeclaration = CreateActualFixKt.generateFunction($receiver, project, (KtFunction)expectedDeclaration, (FunctionDescriptor)object, true);
                } else {
                    if (!($i$a$1$forEach instanceof KtProperty)) continue;
                    Object object = descriptor2;
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.PropertyDescriptor");
                    }
                    ktCallableDeclaration = CreateActualFixKt.generateProperty($receiver, project, (KtProperty)expectedDeclaration, (PropertyDescriptor)object, true);
                }
                ktDeclaration2 = ktCallableDeclaration;
            }
            KtDeclaration actualDeclaration = ktDeclaration2;
            KtClassOrObject this_$iv = actualClass;
            KtClassBody body$iv = KtClassOrObjectKt.getOrCreateBody(this_$iv);
            PsiElement psiElement2 = body$iv.getRBrace();
            if (psiElement2 == null && (psiElement2 = body$iv.getLastChild()) == null) {
                Intrinsics.throwNpe();
            }
            PsiElement anchor$iv = PsiTreeUtil.skipSiblingsBackward((PsiElement)psiElement2, (Class[])new Class[]{PsiWhiteSpace.class});
            PsiElement psiElement3 = body$iv.addAfter(actualDeclaration, anchor$iv);
            if (psiElement3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDeclaration");
            }
            KtDeclaration cfr_ignored_0 = (KtDeclaration)psiElement3;
        }
        KtPrimaryConstructor ktPrimaryConstructor = actualClass.getPrimaryConstructor();
        if (ktPrimaryConstructor != null) {
            KtPrimaryConstructor it = ktDeclarationStub = ktPrimaryConstructor;
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.ACTUAL_KEYWORD;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken), (String)"KtTokens.ACTUAL_KEYWORD");
            it.addModifier(ktModifierKeywordToken);
            for (KtParameter parameter : it.getValueParameters()) {
                if (!parameter.hasValOrVar()) continue;
                parameter.addModifier(KtTokens.ACTUAL_KEYWORD);
            }
        }
        KtDeclarationStub $receiver2 = ktDeclarationStub = actualClass;
        CreateActualFixKt.replaceExpectModifier($receiver2, actualNeeded);
        return ktDeclarationStub;
    }

    private static final KtFunction generateFunction(@NotNull KtPsiFactory $receiver, Project project, KtFunction expectedFunction, FunctionDescriptor descriptor2, boolean actualNeeded) {
        String string;
        Object object;
        KotlinType returnType2 = descriptor2.getReturnType();
        Object $receiver2 = object = $receiver;
        if (returnType2 != null && !KotlinBuiltIns.isUnit(returnType2)) {
            String delegation = TemplatesKt.getFunctionBodyTextFromTemplate$default(project, TemplateKind.FUNCTION, descriptor2.getName().asString(), IdeDescriptorRenderers.SOURCE_CODE.renderType(returnType2), null, 16, null);
            string = '{' + delegation + "\n}";
        } else {
            string = "{}";
        }
        String body2 = string;
        KtDeclaration ktDeclaration = expectedFunction instanceof KtSecondaryConstructor ? (KtDeclaration)$receiver.createSecondaryConstructor(((KtSecondaryConstructor)expectedFunction).getText() + " " + body2) : (KtDeclaration)$receiver.createFunction(expectedFunction.getText() + " " + body2);
        if (ktDeclaration == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunction");
        }
        $receiver2 = object = (KtFunction)ktDeclaration;
        CreateActualFixKt.replaceExpectModifier((KtModifierListOwner)$receiver2, actualNeeded);
        if (returnType2 != null && KotlinBuiltIns.isUnit(returnType2)) {
            $receiver2.setTypeReference((KtTypeReference)null);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static final KtProperty generateProperty(@NotNull KtPsiFactory $receiver, Project project, KtProperty expectedProperty, PropertyDescriptor descriptor2, boolean actualNeeded) {
        Object object;
        String string;
        TemplateKind templateKind;
        Project project2;
        StringBuilder stringBuilder;
        Object $receiver2;
        Object object2;
        block5: {
            block4: {
                void it;
                KotlinType kotlinType;
                $receiver2 = object2 = new StringBuilder();
                ((StringBuilder)$receiver2).append("\nget()");
                ((StringBuilder)$receiver2).append(" = ");
                stringBuilder = $receiver2;
                project2 = project;
                templateKind = TemplateKind.FUNCTION;
                string = descriptor2.getName().asString();
                object = descriptor2.getReturnType();
                if (object == null) break block4;
                KotlinType kotlinType2 = kotlinType = object;
                String string2 = string;
                TemplateKind templateKind2 = templateKind;
                Project project3 = project2;
                StringBuilder stringBuilder2 = stringBuilder;
                void v5 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"it");
                String string3 = IdeDescriptorRenderers.SOURCE_CODE.renderType((KotlinType)v5);
                stringBuilder = stringBuilder2;
                project2 = project3;
                templateKind = templateKind2;
                string = string2;
                object = string3;
                if (object != null) break block5;
            }
            object = "";
        }
        stringBuilder.append(TemplatesKt.getFunctionBodyTextFromTemplate$default(project2, templateKind, string, (String)object, null, 16, null));
        if (descriptor2.isVar()) {
            ((StringBuilder)$receiver2).append("\nset(value) {}");
        }
        String string4 = ((StringBuilder)object2).toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"StringBuilder().apply(builderAction).toString()");
        String body2 = string4;
        $receiver2 = object2 = $receiver.createProperty(expectedProperty.getText() + " " + body2);
        CreateActualFixKt.replaceExpectModifier((KtModifierListOwner)$receiver2, actualNeeded);
        return object2;
    }

    @NotNull
    public static final /* synthetic */ KtClassOrObject access$generateClassOrObject(@NotNull KtPsiFactory $receiver, @NotNull Project project, @NotNull KtClassOrObject expectedClass, boolean actualNeeded) {
        return CreateActualFixKt.generateClassOrObject($receiver, project, expectedClass, actualNeeded);
    }

    @NotNull
    public static final /* synthetic */ KtProperty access$generateProperty(@NotNull KtPsiFactory $receiver, @NotNull Project project, @NotNull KtProperty expectedProperty, @NotNull PropertyDescriptor descriptor2, boolean actualNeeded) {
        return CreateActualFixKt.generateProperty($receiver, project, expectedProperty, descriptor2, actualNeeded);
    }

    @NotNull
    public static final /* synthetic */ KtFunction access$generateFunction(@NotNull KtPsiFactory $receiver, @NotNull Project project, @NotNull KtFunction expectedFunction, @NotNull FunctionDescriptor descriptor2, boolean actualNeeded) {
        return CreateActualFixKt.generateFunction($receiver, project, expectedFunction, descriptor2, actualNeeded);
    }
}

