/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring;

import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandAdapter;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavaProjectRootsUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.changeSignature.ChangeSignatureUtil;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.ui.components.JBList;
import com.intellij.usageView.UsageViewTypeLocation;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.lang.annotation.Retention;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.asJava.LightClassUtilKt;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.caches.resolve.JavaResolutionUtils;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.core.KotlinNameSuggester;
import org.jetbrains.kotlin.idea.core.PackageUtilsKt;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.core.UtilsKt;
import org.jetbrains.kotlin.idea.core.util.MessagesKt;
import org.jetbrains.kotlin.idea.highlighter.markers.HasActualMarkerKt;
import org.jetbrains.kotlin.idea.highlighter.markers.HasExpectedMarkerKt;
import org.jetbrains.kotlin.idea.intentions.RemoveCurlyBracesFromTemplateIntention;
import org.jetbrains.kotlin.idea.j2k.IdeaJavaToKotlinServices;
import org.jetbrains.kotlin.idea.refactoring.JavaElementFactoryUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt$WhenMappings;
import org.jetbrains.kotlin.idea.refactoring.SelectionAwareScopeHighlighter;
import org.jetbrains.kotlin.idea.refactoring.SeparateFileWrapper;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinValVar;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinValVarKt;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KtPsiClassWrapper;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.idea.util.string.StringUtilKt;
import org.jetbrains.kotlin.j2k.ConverterSettings;
import org.jetbrains.kotlin.j2k.JavaToKotlinConverter;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtBlockStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationStub;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtValVarKeywordOwner;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.codeFragmentUtil.CodeFragmentUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.AnalyzingUtils;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000\u00ce\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a&\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\r0\f\"\u0004\b\u0000\u0010\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u00020\u00100\u000f\u001a\u0016\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015\u001a,\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u0001\u001aF\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00172\u0006\u0010\u001c\u001a\u00020\u00012\u0006\u0010!\u001a\u00020\"2\u0018\u0010#\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u0017\u0012\u0004\u0012\u00020\u00100\u000f\u001aZ\u0010$\u001a\u00020\u0010\"\u0004\b\u0000\u0010\r2\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H\r0\u00172\u0006\u0010!\u001a\u00020\"2\u0006\u0010&\u001a\u00020\u00012\u0006\u0010'\u001a\u00020\u00052\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u00020\t0\u000f2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u00020\u00100\u000f\u001aZ\u0010*\u001a\u00020\u0010\"\u0004\b\u0000\u0010\r2\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H\r0\u00172\u0006\u0010!\u001a\u00020\"2\u0006\u0010&\u001a\u00020\u00012\u0006\u0010'\u001a\u00020\u00052\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u00020\t0\u000f2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u00020\u00100\u000f\u001a\"\u0010+\u001a\u00020\u00102\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-2\b\b\u0002\u0010/\u001a\u00020\u0005H\u0002\u001aE\u00100\u001a\u00020\u0010\"\f\b\u0000\u0010\r*\u000201*\u0002022\u0006\u0010,\u001a\u0002H\r2\u0006\u0010.\u001a\u0002H\r2\u0018\u00103\u001a\u0014\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020\u001004H\u0002\u00a2\u0006\u0002\u00106\u001a\"\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:2\b\u0010;\u001a\u0004\u0018\u0001082\b\b\u0002\u0010<\u001a\u00020\u0005\u001a\u0016\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020\u001e2\u0006\u0010;\u001a\u000208\u001a\u0016\u0010@\u001a\u00020 2\u0006\u0010A\u001a\u00020 2\u0006\u0010;\u001a\u000208\u001a\u0016\u0010@\u001a\u00020 2\u0006\u0010B\u001a\u00020C2\u0006\u0010;\u001a\u000208\u001a\"\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020\u00012\u0006\u0010G\u001a\u00020H2\n\b\u0002\u0010I\u001a\u0004\u0018\u00010\u0001\u001a\u000e\u0010J\u001a\u00020\u00102\u0006\u0010K\u001a\u00020\u001e\u001a&\u0010L\u001a\u0004\u0018\u00010E2\u0006\u0010F\u001a\u00020\u00012\u0006\u0010G\u001a\u00020H2\n\b\u0002\u0010I\u001a\u0004\u0018\u00010\u0001H\u0007\u001at\u0010M\u001a\u00020N\"\u0004\b\u0000\u0010\r\"\b\b\u0001\u0010O*\u00020\t2\u0006\u0010!\u001a\u00020\"2\f\u0010P\u001a\b\u0012\u0004\u0012\u0002H\r0\u00172\f\u0010Q\u001a\b\u0012\u0004\u0012\u0002HO0R2\b\u0010&\u001a\u0004\u0018\u00010\u00012\u0006\u0010'\u001a\u00020\u00052\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u0002HO0\u000f2\u0012\u0010S\u001a\u000e\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u00020\u00050\u000f\u001a\u001a\u0010T\u001a\u0004\u0018\u00010\u00152\u0006\u0010U\u001a\u00020\u00132\b\b\u0002\u0010V\u001a\u00020W\u001a\u0014\u0010X\u001a\u00020\u00102\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00100Y\u001ae\u0010Z\u001a\u0002H[\"\b\b\u0000\u0010[*\u00020\\2\u0006\u0010]\u001a\u0002H[2\u0006\u0010^\u001a\u0002H[2\u001f\b\u0003\u0010_\u001a\u0019\u0012\u0004\u0012\u0002H[\u0012\u0004\u0012\u0002H[\u0012\u0004\u0012\u0002H[04\u00a2\u0006\u0002\b`2\u001d\u0010a\u001a\u0019\u0012\u0004\u0012\u0002H[\u0012\n\u0012\b\u0012\u0004\u0012\u00020\\0\u00170\u000f\u00a2\u0006\u0002\b`\u00a2\u0006\u0002\u0010b\u001aE\u0010c\u001a\u00020\u00102\u0012\u0010d\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010e2\u0006\u0010\u0018\u001a\u00020\t2!\u0010f\u001a\u001d\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\bg\u0012\b\bh\u0012\u0004\b\b(i\u0012\u0004\u0012\u00020\u00010\u000f\u001a\n\u0010j\u001a\u00020\u0005*\u00020\t\u001a<\u0010k\u001a\u00020\u0010*\u00020l2\u0012\u0010d\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010e2\u000e\b\u0002\u0010m\u001a\b\u0012\u0004\u0012\u00020\u00100Y2\f\u0010n\u001a\b\u0012\u0004\u0012\u00020\u00100Y\u001a\u0016\u0010o\u001a\u00020E*\u00020E2\n\b\u0002\u0010p\u001a\u0004\u0018\u00010\u0001\u001a\f\u0010q\u001a\u00020\u0001*\u00020rH\u0000\u001a\f\u0010s\u001a\u00020\u0001*\u00020tH\u0000\u001a\u001a\u0010u\u001a\b\u0012\u0004\u0012\u00020\\0\u0017*\u00020\t2\b\b\u0002\u0010v\u001a\u00020\u0005\u001a$\u0010w\u001a\b\u0012\u0004\u0012\u00020\\0\u0017*\u00020\t2\b\b\u0002\u0010v\u001a\u00020\u00052\b\b\u0002\u0010x\u001a\u00020\u0005\u001a\n\u0010y\u001a\u00020z*\u00020\t\u001a\u0019\u0010{\u001a\u0004\u0018\u00010z*\u00020\u00062\u0006\u0010|\u001a\u00020z\u00a2\u0006\u0002\u0010}\u001a\u0014\u0010~\u001a\u00020z*\u00020\t2\b\b\u0002\u0010\u007f\u001a\u00020\u0005\u001a\u001a\u0010\u0080\u0001\u001a\u0004\u0018\u00010z*\u00020\u00062\u0006\u0010|\u001a\u00020z\u00a2\u0006\u0002\u0010}\u001a\r\u0010\u0081\u0001\u001a\u00020\u0001*\u00020tH\u0000\u001a\u000b\u0010\u0082\u0001\u001a\u00020\t*\u00020\t\u001a\f\u0010\u0083\u0001\u001a\u00020\u0005*\u00030\u0084\u0001\u001a\f\u0010\u0083\u0001\u001a\u00020\u0005*\u00030\u0085\u0001\u001a\u000b\u0010\u0086\u0001\u001a\u00020\u0005*\u00020\u001e\u001a\u0014\u0010\u0087\u0001\u001a\u00020\u0005*\u00020\u001e2\u0007\u00109\u001a\u00030\u0088\u0001\u001a\u000b\u0010\u0089\u0001\u001a\u00020\u0005*\u00020\u001e\u001a\u000b\u0010\u008a\u0001\u001a\u00020\u0005*\u00020\t\u001a\f\u0010\u008b\u0001\u001a\u00020\u0005*\u00030\u008c\u0001\u001a\u000b\u0010\u008d\u0001\u001a\u00020\u0005*\u00020\t\u001a\u000b\u0010\u008e\u0001\u001a\u00020\u0005*\u00020\t\u001a\u000e\u0010\u008f\u0001\u001a\u0004\u0018\u00010\u0013*\u00030\u0090\u0001\u001a\u000e\u0010\u008f\u0001\u001a\u0004\u0018\u00010\u001e*\u00030\u0091\u0001\u001a\r\u0010\u0092\u0001\u001a\u0004\u0018\u00010\u0001*\u00020\t\u001a\u000b\u0010\u0093\u0001\u001a\u00020\u0013*\u00020\u0013\u001a\r\u0010\u0094\u0001\u001a\u00020t*\u00020\u0019H\u0000\u001a3\u0010\u0095\u0001\u001a\u00020\u0010*\t\u0012\u0005\u0012\u00030\u0096\u00010Y2\u0007\u0010\u0097\u0001\u001a\u00020l2\u0007\u0010\u0098\u0001\u001a\u00020\u00012\r\u0010\u0099\u0001\u001a\b\u0012\u0004\u0012\u00020\u00100Y\u001a\u0017\u0010\u009a\u0001\u001a\u0004\u0018\u00010H*\u00030\u009b\u00012\u0007\u0010\u0097\u0001\u001a\u00020l\u001a\u0017\u0010\u009a\u0001\u001a\u0004\u0018\u00010H*\u00030\u009c\u00012\u0007\u0010\u0097\u0001\u001a\u00020l\u001a\u0017\u0010\u009d\u0001\u001a\u0004\u0018\u00010\u0006*\u00030\u009b\u00012\u0007\u0010\u0097\u0001\u001a\u00020l\u001a\u0017\u0010\u009d\u0001\u001a\u0004\u0018\u00010\u0006*\u00030\u009c\u00012\u0007\u0010\u0097\u0001\u001a\u00020l\u001a\u0018\u0010\u009e\u0001\u001a\u0005\u0018\u00010\u009f\u0001*\u00030\u009b\u00012\u0007\u0010\u0097\u0001\u001a\u00020l\u001a\u000f\u0010\u00a0\u0001\u001a\u0005\u0018\u00010\u009b\u0001*\u00030\u009c\u0001\u001a\u0018\u0010\u00a1\u0001\u001a\u00020\u0010*\u0004\u0018\u00010\\2\u0007\u0010\u00a2\u0001\u001a\u00020\u0001H\u0007\u001a\u0013\u0010\u00a3\u0001\u001a\b\u0012\u0004\u0012\u00020\u00190\u0017*\u00020\u0019H\u0000\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0015\u0010\u0004\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0007\"\u0015\u0010\b\u001a\u00020\u0005*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\n\u00a8\u0006\u00a4\u0001"}, d2={"CHECK_SUPER_METHODS_YES_NO_DIALOG", "", "getCHECK_SUPER_METHODS_YES_NO_DIALOG", "()Ljava/lang/String;", "isInjectedFragment", "", "Lcom/intellij/psi/PsiFile;", "(Lcom/intellij/psi/PsiFile;)Z", "isInsideInjectedFragment", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)Z", "Pass", "Lcom/intellij/openapi/util/Pass;", "T", "body", "Lkotlin/Function1;", "", "addTypeArgumentsIfNeeded", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "typeArgumentList", "Lorg/jetbrains/kotlin/psi/KtTypeArgumentList;", "checkSuperMethods", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "ignore", "", "actionString", "checkSuperMethodsWithPopup", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "deepestSuperMethods", "Lcom/intellij/psi/PsiMethod;", "editor", "Lcom/intellij/openapi/editor/Editor;", "action", "chooseContainerElement", "containers", "title", "highlightSelection", "toPsi", "onSelect", "chooseContainerElementIfNecessary", "copyModifierListItems", "from", "Lcom/intellij/psi/PsiModifierList;", "to", "withPsiModifiers", "copyTypeParameters", "Lcom/intellij/psi/PsiTypeParameterListOwner;", "Lcom/intellij/psi/PsiNameIdentifierOwner;", "inserter", "Lkotlin/Function2;", "Lcom/intellij/psi/PsiTypeParameterList;", "(Lcom/intellij/psi/PsiTypeParameterListOwner;Lcom/intellij/psi/PsiTypeParameterListOwner;Lkotlin/jvm/functions/Function2;)V", "createJavaClass", "Lcom/intellij/psi/PsiClass;", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "targetClass", "forcePlainClass", "createJavaField", "Lcom/intellij/psi/PsiField;", "property", "createJavaMethod", "template", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "createKotlinFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "fileName", "targetDir", "Lcom/intellij/psi/PsiDirectory;", "packageName", "dropOverrideKeywordIfNecessary", "element", "getOrCreateKotlinFile", "getPsiElementPopup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "E", "elements", "renderer", "Lcom/intellij/ide/util/PsiElementListCellRenderer;", "processor", "getQualifiedTypeArgumentList", "initializer", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "invokeOnceOnCommandFinish", "Lkotlin/Function0;", "replaceListPsiAndKeepDelimiters", "ListType", "Lorg/jetbrains/kotlin/psi/KtElement;", "originalList", "newList", "listReplacer", "Lkotlin/ExtensionFunctionType;", "itemsFun", "(Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/psi/KtElement;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/psi/KtElement;", "reportDeclarationConflict", "conflicts", "Lcom/intellij/util/containers/MultiMap;", "message", "Lkotlin/ParameterName;", "name", "renderedDeclaration", "canRefactor", "checkConflictsInteractively", "Lcom/intellij/openapi/project/Project;", "onShowConflicts", "onAccept", "createTempCopy", "text", "explicateAsText", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ImplicitReceiver;", "explicateAsTextForReceiver", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getAllExtractionContainers", "strict", "getExtractionContainers", "includeAll", "getLineCount", "", "getLineEndOffset", "line", "(Lcom/intellij/psi/PsiFile;I)Ljava/lang/Integer;", "getLineNumber", "start", "getLineStartOffset", "getThisLabelName", "getUsageContext", "hasIdentifiersOnly", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "isAbstract", "isCompanionMemberOf", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "isConstructorDeclaredProperty", "isInJavaSourceRoot", "isInterfaceClass", "Lcom/intellij/psi/PsiNamedElement;", "isMultiLine", "isTrueJavaMethod", "j2k", "Lcom/intellij/psi/PsiExpression;", "Lcom/intellij/psi/PsiMember;", "j2kText", "removeTemplateEntryBracesIfPossible", "resolveToExpectedDescriptorIfPossible", "runRefactoringWithPostprocessing", "", "project", "targetRefactoringId", "finishAction", "toPsiDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "Ljava/io/File;", "toPsiFile", "toPsiFileOrDirectory", "Lcom/intellij/psi/PsiFileSystemItem;", "toVirtualFile", "validateElement", "errorMessage", "withExpectedActuals", "idea"})
public final class KotlinRefactoringUtilKt {
    @NotNull
    private static final String CHECK_SUPER_METHODS_YES_NO_DIALOG = "CHECK_SUPER_METHODS_YES_NO_DIALOG";

    @NotNull
    public static final String getCHECK_SUPER_METHODS_YES_NO_DIALOG() {
        return CHECK_SUPER_METHODS_YES_NO_DIALOG;
    }

    @JvmOverloads
    @Nullable
    public static final KtFile getOrCreateKotlinFile(@NotNull String fileName, @NotNull PsiDirectory targetDir, @Nullable String packageName) {
        PsiFile psiFile;
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        Intrinsics.checkParameterIsNotNull((Object)targetDir, (String)"targetDir");
        PsiFile psiFile2 = targetDir.findFile(fileName);
        if (psiFile2 == null) {
            psiFile2 = psiFile = (PsiFile)KotlinRefactoringUtilKt.createKotlinFile(fileName, targetDir, packageName);
        }
        if (!(psiFile2 instanceof KtFile)) {
            psiFile = null;
        }
        return (KtFile)psiFile;
    }

    @JvmOverloads
    @Nullable
    public static /* bridge */ /* synthetic */ KtFile getOrCreateKotlinFile$default(String string, PsiDirectory psiDirectory, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            PsiPackage psiPackage = PackageUtilsKt.getPackage(psiDirectory);
            string2 = psiPackage != null ? psiPackage.getQualifiedName() : null;
        }
        return KotlinRefactoringUtilKt.getOrCreateKotlinFile(string, psiDirectory, string2);
    }

    @JvmOverloads
    @Nullable
    public static final KtFile getOrCreateKotlinFile(@NotNull String fileName, @NotNull PsiDirectory targetDir) {
        return KotlinRefactoringUtilKt.getOrCreateKotlinFile$default(fileName, targetDir, null, 4, null);
    }

    @NotNull
    public static final KtFile createKotlinFile(@NotNull String fileName, @NotNull PsiDirectory targetDir, @Nullable String packageName) {
        FqName fqName2;
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        Intrinsics.checkParameterIsNotNull((Object)targetDir, (String)"targetDir");
        targetDir.checkCreateFile(fileName);
        String string = packageName;
        if (string != null) {
            String string2;
            String p1 = string2 = string;
            fqName2 = new FqName(p1);
        } else {
            fqName2 = FqName.ROOT;
        }
        FqName packageFqName = fqName2;
        PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)targetDir.getProject());
        FileType fileType = (FileType)KotlinFileType.INSTANCE;
        FqName fqName3 = packageFqName;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"packageFqName");
        PsiFile file2 = psiFileFactory.createFileFromText(fileName, fileType, (CharSequence)(!fqName3.isRoot() ? "package " + UtilsKt.quoteSegmentsIfNeeded(packageFqName) + " \n\n" : ""));
        PsiElement psiElement2 = targetDir.add((PsiElement)file2);
        if (psiElement2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        }
        return (KtFile)psiElement2;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ KtFile createKotlinFile$default(String string, PsiDirectory psiDirectory, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            PsiPackage psiPackage = PackageUtilsKt.getPackage(psiDirectory);
            string2 = psiPackage != null ? psiPackage.getQualifiedName() : null;
        }
        return KotlinRefactoringUtilKt.createKotlinFile(string, psiDirectory, string2);
    }

    @Nullable
    public static final VirtualFile toVirtualFile(@NotNull File $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return LocalFileSystem.getInstance().findFileByIoFile($receiver);
    }

    @Nullable
    public static final PsiFile toPsiFile(@NotNull File $receiver, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        VirtualFile virtualFile2 = KotlinRefactoringUtilKt.toVirtualFile($receiver);
        return virtualFile2 != null ? KotlinRefactoringUtilKt.toPsiFile(virtualFile2, project) : null;
    }

    @Nullable
    public static final PsiDirectory toPsiDirectory(@NotNull File $receiver, @NotNull Project project) {
        PsiDirectory psiDirectory;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        VirtualFile virtualFile2 = KotlinRefactoringUtilKt.toVirtualFile($receiver);
        if (virtualFile2 != null) {
            VirtualFile virtualFile3;
            VirtualFile vfile = virtualFile3 = virtualFile2;
            psiDirectory = PsiManager.getInstance((Project)project).findDirectory(vfile);
        } else {
            psiDirectory = null;
        }
        return psiDirectory;
    }

    @Nullable
    public static final PsiFile toPsiFile(@NotNull VirtualFile $receiver, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return PsiManager.getInstance((Project)project).findFile($receiver);
    }

    @Nullable
    public static final PsiDirectory toPsiDirectory(@NotNull VirtualFile $receiver, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return PsiManager.getInstance((Project)project).findDirectory($receiver);
    }

    @Nullable
    public static final PsiFileSystemItem toPsiFileOrDirectory(@NotNull VirtualFile $receiver, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return $receiver.isDirectory() ? (PsiFileSystemItem)KotlinRefactoringUtilKt.toPsiDirectory($receiver, project) : (PsiFileSystemItem)KotlinRefactoringUtilKt.toPsiFile($receiver, project);
    }

    @NotNull
    public static final PsiElement getUsageContext(@NotNull PsiElement $receiver) {
        PsiElement psiElement2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        PsiElement psiElement3 = $receiver;
        if (psiElement3 instanceof KtElement) {
            KtDeclarationStub ktDeclarationStub = (KtDeclarationStub)PsiTreeUtil.getParentOfType((PsiElement)$receiver, (Class[])new Class[]{KtPropertyAccessor.class, KtProperty.class, KtNamedFunction.class, KtConstructor.class, KtClassOrObject.class});
            if (ktDeclarationStub != null) {
                psiElement2 = ktDeclarationStub;
            } else {
                PsiFile psiFile = ((KtElement)$receiver).getContainingFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"containingFile");
                psiElement2 = (PsiElement)psiFile;
            }
        } else {
            PsiElement psiElement4 = ConflictsUtil.getContainer((PsiElement)$receiver);
            psiElement2 = psiElement4;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement4, (String)"ConflictsUtil.getContainer(this)");
        }
        return psiElement2;
    }

    public static final boolean isInJavaSourceRoot(@NotNull PsiElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return !JavaProjectRootsUtil.isOutsideJavaSourceRoot((PsiFile)$receiver.getContainingFile());
    }

    @NotNull
    public static final KtFile createTempCopy(@NotNull KtFile $receiver, @Nullable String text2) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        KtPsiFactory ktPsiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)$receiver, false, 2, null);
        String string2 = $receiver.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"name");
        String string3 = text2;
        if (string3 == null) {
            string3 = string = $receiver.getText();
        }
        if (string3 == null) {
            string = "";
        }
        KtFile tmpFile = ktPsiFactory.createAnalyzableFile(string2, string, (PsiElement)$receiver);
        tmpFile.setOriginalFile((PsiFile)$receiver);
        CodeFragmentUtilKt.setSuppressDiagnosticsInDebugMode(tmpFile, CodeFragmentUtilKt.getSuppressDiagnosticsInDebugMode($receiver));
        return tmpFile;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ KtFile createTempCopy$default(KtFile ktFile, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return KotlinRefactoringUtilKt.createTempCopy(ktFile, string);
    }

    @NotNull
    public static final List<KtElement> getAllExtractionContainers(@NotNull PsiElement $receiver, boolean strict) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ArrayList<KtElement> containers = new ArrayList<KtElement>();
        boolean objectOrNonInnerNestedClassFound = false;
        Sequence<PsiElement> parents2 = strict ? PsiUtilsKt.getParents($receiver) : PsiUtilsKt.getParentsWithSelf($receiver);
        for (PsiElement element3 : parents2) {
            boolean isValidContainer;
            PsiElement psiElement2 = element3;
            boolean bl = psiElement2 instanceof KtFile ? true : (psiElement2 instanceof KtClassBody ? !objectOrNonInnerNestedClassFound || ((KtClassBody)element3).getParent() instanceof KtObjectDeclaration : (psiElement2 instanceof KtBlockExpression ? !objectOrNonInnerNestedClassFound : (isValidContainer = false)));
            if (!isValidContainer) continue;
            PsiElement psiElement3 = element3;
            if (psiElement3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
            }
            containers.add((KtElement)psiElement3);
            if (objectOrNonInnerNestedClassFound) continue;
            PsiElement psiElement4 = element3;
            if (!(psiElement4 instanceof KtClassBody)) {
                psiElement4 = null;
            }
            KtClassBody ktClassBody = (KtClassBody)psiElement4;
            PsiElement bodyParent = ktClassBody != null ? ktClassBody.getParent() : null;
            objectOrNonInnerNestedClassFound = bodyParent instanceof KtObjectDeclaration && !((KtObjectDeclaration)bodyParent).isObjectLiteral() || bodyParent instanceof KtClass && !((KtClass)bodyParent).isInner();
        }
        return containers;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ List getAllExtractionContainers$default(PsiElement psiElement2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return KotlinRefactoringUtilKt.getAllExtractionContainers(psiElement2, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<KtElement> getExtractionContainers(@NotNull PsiElement $receiver, boolean strict, boolean includeAll) {
        List<Object> list2;
        PsiElement psiElement2;
        PsiElement it;
        PsiElement enclosingDeclaration;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        getExtractionContainers.1 getEnclosingDeclaration$ = getExtractionContainers.1.INSTANCE;
        if (includeAll) {
            return KotlinRefactoringUtilKt.getAllExtractionContainers($receiver, strict);
        }
        PsiElement psiElement3 = getEnclosingDeclaration$.invoke($receiver, strict);
        psiElement2 = enclosingDeclaration = psiElement3 != null ? ((it = (psiElement2 = psiElement3)) instanceof KtDeclarationWithBody || it instanceof KtAnonymousInitializer ? getExtractionContainers.1.INSTANCE.invoke(it, true) : it) : null;
        if (psiElement2 instanceof KtFile) {
            List<PsiElement> list3 = Collections.singletonList(enclosingDeclaration);
            list2 = list3;
            Intrinsics.checkExpressionValueIsNotNull(list3, (String)"Collections.singletonList(enclosingDeclaration)");
        } else if (psiElement2 instanceof KtClassBody) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable $i$a$1$let = $receiver$iv = (Iterable)KotlinRefactoringUtilKt.getAllExtractionContainers($receiver, strict);
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                if (!(element$iv$iv instanceof KtClassBody)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            PsiElement psiElement4 = enclosingDeclaration;
            KtExpression targetContainer = psiElement4 instanceof KtDeclarationWithBody ? ((KtDeclarationWithBody)enclosingDeclaration).getBodyExpression() : (psiElement4 instanceof KtAnonymousInitializer ? ((KtAnonymousInitializer)enclosingDeclaration).getBody() : null);
            List<Object> list4 = targetContainer instanceof KtBlockExpression ? Collections.singletonList(targetContainer) : Collections.emptyList();
            list2 = list4;
            Intrinsics.checkExpressionValueIsNotNull(list4, (String)"if (targetContainer is K\u2026e Collections.emptyList()");
        }
        return list2;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ List getExtractionContainers$default(PsiElement psiElement2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        return KotlinRefactoringUtilKt.getExtractionContainers(psiElement2, bl, bl2);
    }

    public static final void checkConflictsInteractively(@NotNull Project $receiver, @NotNull MultiMap<PsiElement, String> conflicts2, @NotNull Function0<Unit> onShowConflicts, @NotNull Function0<Unit> onAccept) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(conflicts2, (String)"conflicts");
        Intrinsics.checkParameterIsNotNull(onShowConflicts, (String)"onShowConflicts");
        Intrinsics.checkParameterIsNotNull(onAccept, (String)"onAccept");
        if (!conflicts2.isEmpty()) {
            Application application = ApplicationManager.getApplication();
            if (application == null) {
                Intrinsics.throwNpe();
            }
            if (application.isUnitTestMode()) {
                throw (Throwable)new BaseRefactoringProcessor.ConflictsInTestsException(conflicts2.values());
            }
            ConflictsDialog dialog2 = new ConflictsDialog($receiver, conflicts2, new Runnable(onAccept){
                final /* synthetic */ Function0 $onAccept;

                public final void run() {
                    this.$onAccept.invoke();
                }
                {
                    this.$onAccept = function0;
                }
            });
            dialog2.show();
            if (!dialog2.isOK()) {
                if (dialog2.isShowConflicts()) {
                    onShowConflicts.invoke();
                }
                return;
            }
        }
        onAccept.invoke();
    }

    public static /* bridge */ /* synthetic */ void checkConflictsInteractively$default(Project project, MultiMap multiMap, Function0 function0, Function0 function02, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = checkConflictsInteractively.1.INSTANCE;
        }
        KotlinRefactoringUtilKt.checkConflictsInteractively(project, (MultiMap<PsiElement, String>)multiMap, (Function0<Unit>)function0, (Function0<Unit>)function02);
    }

    public static final void reportDeclarationConflict(@NotNull MultiMap<PsiElement, String> conflicts2, @NotNull PsiElement declaration2, @NotNull Function1<? super String, String> message2) {
        Intrinsics.checkParameterIsNotNull(conflicts2, (String)"conflicts");
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        Intrinsics.checkParameterIsNotNull(message2, (String)"message");
        String string = RefactoringUIUtil.getDescription((PsiElement)declaration2, (boolean)true);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"RefactoringUIUtil.getDes\u2026iption(declaration, true)");
        conflicts2.putValue((Object)declaration2, message2.invoke((Object)StringsKt.capitalize((String)string)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T, E extends PsiElement> JBPopup getPsiElementPopup(@NotNull Editor editor, @NotNull List<? extends T> elements2, @NotNull PsiElementListCellRenderer<E> renderer2, @Nullable String title, boolean highlightSelection, @NotNull Function1<? super T, ? extends E> toPsi, @NotNull Function1<? super T, Boolean> processor2) {
        PopupChooserBuilder popupChooserBuilder;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull(elements2, (String)"elements");
        Intrinsics.checkParameterIsNotNull(renderer2, (String)"renderer");
        Intrinsics.checkParameterIsNotNull(toPsi, (String)"toPsi");
        Intrinsics.checkParameterIsNotNull(processor2, (String)"processor");
        SelectionAwareScopeHighlighter highlighter = highlightSelection ? new SelectionAwareScopeHighlighter(editor) : null;
        Iterable iterable = $receiver$iv = (Iterable)elements2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            destination$iv$iv.add(toPsi.invoke(item$iv$iv));
        }
        List list2 = (List)destination$iv$iv;
        Collection collection = list2;
        JBList list3 = new JBList(collection);
        list3.setCellRenderer((ListCellRenderer)renderer2);
        list3.addListSelectionListener(new ListSelectionListener(highlighter, list3){
            final /* synthetic */ SelectionAwareScopeHighlighter $highlighter;
            final /* synthetic */ JBList $list;

            public final void valueChanged(ListSelectionEvent it) {
                block4: {
                    SelectionAwareScopeHighlighter selectionAwareScopeHighlighter = this.$highlighter;
                    if (selectionAwareScopeHighlighter != null) {
                        selectionAwareScopeHighlighter.dropHighlight();
                    }
                    int index2 = this.$list.getSelectedIndex();
                    if (index2 < 0) break block4;
                    SelectionAwareScopeHighlighter selectionAwareScopeHighlighter2 = this.$highlighter;
                    if (selectionAwareScopeHighlighter2 != null) {
                        ListModel listModel = this.$list.getModel();
                        if (listModel == null) {
                            Intrinsics.throwNpe();
                        }
                        E e = listModel.getElementAt(index2);
                        if (e == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiElement");
                        }
                        selectionAwareScopeHighlighter2.highlight((PsiElement)e);
                    }
                }
            }
            {
                this.$highlighter = selectionAwareScopeHighlighter;
                this.$list = jBList;
            }
        });
        PopupChooserBuilder $receiver = popupChooserBuilder = new PopupChooserBuilder((JList)list3);
        String string = title;
        if (string != null) {
            String string2;
            String it = string2 = string;
            $receiver.setTitle(it);
        }
        renderer2.installSpeedSearch($receiver, true);
        $receiver.setItemChoosenCallback(new Runnable(title, renderer2, list3, processor2, elements2, highlighter){
            final /* synthetic */ String $title$inlined;
            final /* synthetic */ PsiElementListCellRenderer $renderer$inlined;
            final /* synthetic */ JBList $list$inlined;
            final /* synthetic */ Function1 $processor$inlined;
            final /* synthetic */ List $elements$inlined;
            final /* synthetic */ SelectionAwareScopeHighlighter $highlighter$inlined;
            {
                this.$title$inlined = string;
                this.$renderer$inlined = psiElementListCellRenderer;
                this.$list$inlined = jBList;
                this.$processor$inlined = function1;
                this.$elements$inlined = list2;
                this.$highlighter$inlined = selectionAwareScopeHighlighter;
            }

            public final void run() {
                int index2 = this.$list$inlined.getSelectedIndex();
                if (index2 >= 0) {
                    this.$processor$inlined.invoke(this.$elements$inlined.get(index2));
                }
            }
        });
        $receiver.addListener((JBPopupListener)new JBPopupAdapter(title, renderer2, list3, processor2, elements2, highlighter){
            final /* synthetic */ String $title$inlined;
            final /* synthetic */ PsiElementListCellRenderer $renderer$inlined;
            final /* synthetic */ JBList $list$inlined;
            final /* synthetic */ Function1 $processor$inlined;
            final /* synthetic */ List $elements$inlined;
            final /* synthetic */ SelectionAwareScopeHighlighter $highlighter$inlined;
            {
                this.$title$inlined = string;
                this.$renderer$inlined = psiElementListCellRenderer;
                this.$list$inlined = jBList;
                this.$processor$inlined = function1;
                this.$elements$inlined = list2;
                this.$highlighter$inlined = selectionAwareScopeHighlighter;
            }

            public void onClosed(@Nullable LightweightWindowEvent event) {
                block0: {
                    SelectionAwareScopeHighlighter selectionAwareScopeHighlighter = this.$highlighter$inlined;
                    if (selectionAwareScopeHighlighter == null) break block0;
                    selectionAwareScopeHighlighter.dropHighlight();
                }
            }
        });
        JBPopup jBPopup = $receiver.createPopup();
        Intrinsics.checkExpressionValueIsNotNull((Object)jBPopup, (String)"createPopup()");
        Intrinsics.checkExpressionValueIsNotNull((Object)jBPopup, (String)"with(PopupChooserBuilder\u2026      createPopup()\n    }");
        return jBPopup;
    }

    @Nullable
    public static final Integer getLineStartOffset(@NotNull PsiFile $receiver, int line) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Document doc = PsiDocumentManager.getInstance((Project)$receiver.getProject()).getDocument($receiver);
        if (doc != null && line >= 0 && line < doc.getLineCount()) {
            int startOffset = doc.getLineStartOffset(line);
            PsiElement psiElement2 = $receiver.findElementAt(startOffset);
            if (psiElement2 == null) {
                return startOffset;
            }
            PsiElement element3 = psiElement2;
            PsiElement psiElement3 = PsiTreeUtil.skipSiblingsForward((PsiElement)element3, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class});
            return psiElement3 != null ? PsiUtilsKt.getStartOffset(psiElement3) : startOffset;
        }
        return null;
    }

    @Nullable
    public static final Integer getLineEndOffset(@NotNull PsiFile $receiver, int line) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Document document = PsiDocumentManager.getInstance((Project)$receiver.getProject()).getDocument($receiver);
        return document != null ? Integer.valueOf(document.getLineEndOffset(line)) : null;
    }

    public static final int getLineNumber(@NotNull PsiElement $receiver, boolean start) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Document document = PsiDocumentManager.getInstance((Project)$receiver.getProject()).getDocument($receiver.getContainingFile());
        return document != null ? document.getLineNumber(start ? PsiUtilsKt.getStartOffset($receiver) : PsiUtilsKt.getEndOffset($receiver)) : 0;
    }

    public static /* bridge */ /* synthetic */ int getLineNumber$default(PsiElement psiElement2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return KotlinRefactoringUtilKt.getLineNumber(psiElement2, bl);
    }

    /*
     * WARNING - void declaration
     */
    public static final int getLineCount(@NotNull PsiElement $receiver) {
        void var3_4;
        String string;
        Document doc;
        Document document;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        PsiFile psiFile = $receiver.getContainingFile();
        if (psiFile != null) {
            PsiFile psiFile2;
            PsiFile file2 = psiFile2 = psiFile;
            document = PsiDocumentManager.getInstance((Project)$receiver.getProject()).getDocument(file2);
        } else {
            document = doc = null;
        }
        if (doc != null) {
            TextRange spaceRange;
            TextRange textRange = $receiver.getTextRange();
            if (textRange == null) {
                textRange = TextRange.EMPTY_RANGE;
            }
            TextRange textRange2 = spaceRange = textRange;
            Intrinsics.checkExpressionValueIsNotNull((Object)textRange2, (String)"spaceRange");
            if (textRange2.getEndOffset() <= doc.getTextLength()) {
                int startLine = doc.getLineNumber(spaceRange.getStartOffset());
                int endLine = doc.getLineNumber(spaceRange.getEndOffset());
                return endLine - startLine;
            }
        }
        if ((string = $receiver.getText()) == null) {
            string = "";
        }
        CharSequence $receiver$iv = string;
        int count$iv = 0;
        CharSequence charSequence = $receiver$iv;
        for (int i = 0; i < charSequence.length(); ++i) {
            char element$iv = charSequence.charAt(i);
            char it = element$iv;
            if (!(it == '\n')) continue;
            ++count$iv;
        }
        return (int)(var3_4 + true);
    }

    public static final boolean isMultiLine(@NotNull PsiElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return KotlinRefactoringUtilKt.getLineCount($receiver) > 1;
    }

    public static final <T> void chooseContainerElement(@NotNull List<? extends T> containers, @NotNull Editor editor, @NotNull String title, boolean highlightSelection, @NotNull Function1<? super T, ? extends PsiElement> toPsi, @NotNull Function1<? super T, Unit> onSelect) {
        Intrinsics.checkParameterIsNotNull(containers, (String)"containers");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        Intrinsics.checkParameterIsNotNull(toPsi, (String)"toPsi");
        Intrinsics.checkParameterIsNotNull(onSelect, (String)"onSelect");
        KotlinRefactoringUtilKt.getPsiElementPopup(editor, containers, (PsiElementListCellRenderer)new PsiElementListCellRenderer<PsiElement>(){

            private final String renderName(@NotNull PsiElement $receiver) {
                Object object;
                if ($receiver instanceof KtPropertyAccessor) {
                    StringBuilder stringBuilder = new StringBuilder();
                    KtProperty ktProperty = ((KtPropertyAccessor)$receiver).getProperty();
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktProperty, (String)"property");
                    return stringBuilder.append(this.renderName(ktProperty)).append(((KtPropertyAccessor)$receiver).isGetter() ? ".get" : ".set").toString();
                }
                if ($receiver instanceof KtObjectDeclaration && ((KtObjectDeclaration)$receiver).isCompanion()) {
                    StringBuilder stringBuilder = new StringBuilder().append("Companion object of ");
                    PsiElement $receiver$iv = $receiver;
                    Object object2 = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtClassOrObject.class, (boolean)true);
                    if (object2 == null || (object2 = this.renderName((PsiElement)object2)) == null) {
                        object2 = "<anonymous>";
                    }
                    return stringBuilder.append((String)object2).toString();
                }
                PsiElement psiElement2 = $receiver;
                if (!(psiElement2 instanceof PsiNamedElement)) {
                    psiElement2 = null;
                }
                if ((object = (PsiNamedElement)psiElement2) == null || (object = object.getName()) == null) {
                    object = "<anonymous>";
                }
                return object;
            }

            /*
             * WARNING - void declaration
             */
            private final String renderDeclaration(@NotNull PsiElement $receiver) {
                Object object;
                String name2;
                block8: {
                    block7: {
                        void $receiver$iv$iv;
                        void $receiver$iv;
                        if ($receiver instanceof KtFunctionLiteral || KtPsiUtilKt.isFunctionalExpression($receiver)) {
                            return this.renderText($receiver);
                        }
                        Object object2 = $receiver instanceof KtFile ? ((KtFile)$receiver).getName() : ($receiver instanceof KtElement ? ResolutionUtils.analyze$default((KtElement)$receiver, null, 1, null).get(BindingContext.DECLARATION_TO_DESCRIPTOR, $receiver) : ($receiver instanceof PsiMember ? JavaResolutionUtils.getJavaMemberDescriptor$default((PsiMember)$receiver, null, 1, null) : null));
                        if (object2 == null) {
                            return null;
                        }
                        String descriptor2 = object2;
                        name2 = this.renderName($receiver);
                        String string = descriptor2;
                        if (!(string instanceof FunctionDescriptor)) {
                            string = null;
                        }
                        if ((object = (FunctionDescriptor)((Object)string)) == null || (object = object.getValueParameters()) == null) break block7;
                        Iterable iterable = (Iterable)object;
                        void var6_5 = $receiver$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                        for (T item$iv$iv : $receiver$iv$iv) {
                            void it;
                            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            void v3 = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"it");
                            KotlinType kotlinType = v3.getType();
                            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"it.type");
                            String string2 = DescriptorRenderer.SHORT_NAMES_IN_TYPES.renderType(kotlinType);
                            collection.add(string2);
                        }
                        object = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)", ", (CharSequence)"(", (CharSequence)")", (int)0, null, null, (int)56, null);
                        if (object != null) break block8;
                    }
                    object = "";
                }
                Object params2 = object;
                return "" + name2 + "" + (String)params2;
            }

            private final String renderText(@NotNull PsiElement $receiver) {
                if ($receiver instanceof SeparateFileWrapper) {
                    return "Extract to separate file";
                }
                String string = $receiver.getText();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                String string2 = StringUtil.shortenTextWithEllipsis((String)StringUtilKt.collapseSpaces(string), (int)53, (int)0);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"StringUtil.shortenTextWi\u2026.collapseSpaces(), 53, 0)");
                return string2;
            }

            private final PsiElement getRepresentativeElement(@NotNull PsiElement $receiver) {
                PsiElement psiElement2;
                PsiElement psiElement3 = $receiver;
                if (psiElement3 instanceof KtBlockExpression) {
                    PsiElement psiElement4 = ((KtBlockExpression)$receiver).getParent();
                    if (!(psiElement4 instanceof KtDeclarationWithBody)) {
                        psiElement4 = null;
                    }
                    KtDeclarationWithBody ktDeclarationWithBody = (KtDeclarationWithBody)psiElement4;
                    psiElement2 = ktDeclarationWithBody != null ? (PsiElement)ktDeclarationWithBody : $receiver;
                } else if (psiElement3 instanceof KtClassBody) {
                    PsiElement psiElement5 = ((KtClassBody)$receiver).getParent();
                    if (psiElement5 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClassOrObject");
                    }
                    psiElement2 = (KtClassOrObject)psiElement5;
                } else {
                    psiElement2 = $receiver;
                }
                return psiElement2;
            }

            @Nullable
            public String getElementText(@NotNull PsiElement element3) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                PsiElement representativeElement = this.getRepresentativeElement(element3);
                String string = this.renderDeclaration(representativeElement);
                if (string == null) {
                    string = this.renderText(representativeElement);
                }
                return string;
            }

            @Nullable
            protected String getContainerText(@NotNull PsiElement element3, @Nullable String name2) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                return null;
            }

            protected int getIconFlags() {
                return 0;
            }

            @Nullable
            protected Icon getIcon(@NotNull PsiElement element3) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                return super.getIcon(this.getRepresentativeElement(element3));
            }
        }, title, highlightSelection, toPsi, (Function1)new Function1<T, Boolean>(onSelect){
            final /* synthetic */ Function1 $onSelect;

            public final boolean invoke(T it) {
                this.$onSelect.invoke(it);
                return true;
            }
            {
                this.$onSelect = function1;
                super(1);
            }
        }).showInBestPositionFor(editor);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final <T> void chooseContainerElementIfNecessary(@NotNull List<? extends T> containers, @NotNull Editor editor, @NotNull String title, boolean highlightSelection, @NotNull Function1<? super T, ? extends PsiElement> toPsi, @NotNull Function1<? super T, Unit> onSelect) {
        Intrinsics.checkParameterIsNotNull(containers, (String)"containers");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        Intrinsics.checkParameterIsNotNull(toPsi, (String)"toPsi");
        Intrinsics.checkParameterIsNotNull(onSelect, (String)"onSelect");
        if (containers.isEmpty()) {
            return;
        }
        if (containers.size() != 1) {
            Application application = ApplicationManager.getApplication();
            if (application == null) {
                Intrinsics.throwNpe();
            }
            if (!application.isUnitTestMode()) {
                KotlinRefactoringUtilKt.chooseContainerElement(containers, editor, title, highlightSelection, toPsi, onSelect);
                return;
            }
        }
        onSelect.invoke(CollectionsKt.first(containers));
    }

    public static final boolean isTrueJavaMethod(@NotNull PsiElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver instanceof PsiMethod && !($receiver instanceof KtLightMethod);
    }

    public static final boolean canRefactor(@NotNull PsiElement $receiver) {
        boolean bl;
        block4: {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            if (!$receiver.isValid()) {
                return false;
            }
            if ($receiver instanceof PsiPackage) {
                PsiDirectory[] psiDirectoryArray = ((PsiPackage)$receiver).getDirectories();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiDirectoryArray, (String)"directories");
                Object[] $receiver$iv = psiDirectoryArray;
                for (int i = 0; i < $receiver$iv.length; ++i) {
                    PsiDirectory it;
                    Object element$iv = $receiver$iv[i];
                    PsiDirectory psiDirectory = it = (PsiDirectory)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiDirectory, (String)"it");
                    if (!KotlinRefactoringUtilKt.canRefactor((PsiElement)psiDirectory)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            } else {
                bl = $receiver instanceof KtElement || $receiver instanceof PsiMember && Intrinsics.areEqual((Object)((PsiMember)$receiver).getLanguage(), (Object)JavaLanguage.INSTANCE) || $receiver instanceof PsiDirectory ? ProjectRootsUtil.isInProjectSource($receiver) : false;
            }
        }
        return bl;
    }

    private static final void copyModifierListItems(PsiModifierList from, PsiModifierList to, boolean withPsiModifiers) {
        int n;
        String[] stringArray;
        if (withPsiModifiers) {
            stringArray = PsiModifier.MODIFIERS;
            for (n = 0; n < stringArray.length; ++n) {
                String modifier = stringArray[n];
                if (!from.hasExplicitModifier(modifier)) continue;
                to.setModifierProperty(modifier, true);
            }
        }
        stringArray = from.getAnnotations();
        for (n = 0; n < stringArray.length; ++n) {
            String annotationName;
            String annotation2;
            String string = annotation2 = stringArray[n];
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"annotation");
            if (string.getQualifiedName() == null) {
                continue;
            }
            if (!(Intrinsics.areEqual((Object)Retention.class.getName(), (Object)annotationName) ^ true)) continue;
            to.addAnnotation(annotationName);
        }
    }

    static /* bridge */ /* synthetic */ void copyModifierListItems$default(PsiModifierList psiModifierList, PsiModifierList psiModifierList2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        KotlinRefactoringUtilKt.copyModifierListItems(psiModifierList, psiModifierList2, bl);
    }

    /*
     * WARNING - void declaration
     */
    private static final <T extends PsiTypeParameterListOwner & PsiNameIdentifierOwner> void copyTypeParameters(T from, T to, Function2<? super T, ? super PsiTypeParameterList, Unit> inserter) {
        Object[] objectArray;
        T t = from;
        if (t == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiElement");
        }
        PsiElementFactory factory2 = PsiElementFactory.SERVICE.getInstance((Project)((PsiElement)t).getProject());
        PsiTypeParameter[] psiTypeParameterArray = from.getTypeParameterList();
        if (psiTypeParameterArray == null || (psiTypeParameterArray = psiTypeParameterArray.getTypeParameters()) == null) {
            psiTypeParameterArray = PsiTypeParameter.EMPTY_ARRAY;
        }
        PsiTypeParameter[] templateTypeParams = psiTypeParameterArray;
        Intrinsics.checkExpressionValueIsNotNull((Object)templateTypeParams, (String)"templateTypeParams");
        Object[] objectArray2 = objectArray = (Object[])templateTypeParams;
        if (!(objectArray2.length == 0)) {
            void $receiver$iv$iv;
            Object[] $receiver$iv;
            PsiTypeParameterList psiTypeParameterList = factory2.createTypeParameterList();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiTypeParameterList, (String)"factory.createTypeParameterList()");
            inserter.invoke(to, (Object)psiTypeParameterList);
            PsiTypeParameterList targetTypeParamList = to.getTypeParameterList();
            Object[] objectArray3 = $receiver$iv = (Object[])templateTypeParams;
            Collection destination$iv$iv = new ArrayList($receiver$iv.length);
            for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
                void it;
                void item$iv$iv = $receiver$iv$iv[i];
                PsiTypeParameter psiTypeParameter = (PsiTypeParameter)item$iv$iv;
                Collection collection = destination$iv$iv;
                void v3 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"it");
                String string = v3.getName();
                PsiReferenceList psiReferenceList = it.getExtendsList();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiReferenceList, (String)"it.extendsList");
                PsiTypeParameter psiTypeParameter2 = factory2.createTypeParameter(string, psiReferenceList.getReferencedTypes());
                collection.add(psiTypeParameter2);
            }
            List newTypeParams = (List)destination$iv$iv;
            ChangeSignatureUtil.synchronizeList((PsiElement)((PsiElement)targetTypeParamList), (List)newTypeParams, (ChangeSignatureUtil.ChildrenGenerator)copyTypeParameters.1.INSTANCE, (boolean[])new boolean[newTypeParams.size()]);
        }
    }

    @NotNull
    public static final PsiMethod createJavaMethod(@NotNull KtFunction function2, @NotNull PsiClass targetClass) {
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        Intrinsics.checkParameterIsNotNull((Object)targetClass, (String)"targetClass");
        PsiMethod psiMethod = LightClassUtil.INSTANCE.getLightClassMethod(function2);
        if (psiMethod == null) {
            throw (Throwable)((Object)new AssertionError((Object)("Can't generate light method: " + PsiUtilsKt.getElementTextWithContext(function2))));
        }
        PsiMethod template2 = psiMethod;
        return KotlinRefactoringUtilKt.createJavaMethod(template2, targetClass);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final PsiMethod createJavaMethod(@NotNull PsiMethod template2, @NotNull PsiClass targetClass) {
        void $receiver$iv$iv;
        Object[] $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)template2, (String)"template");
        Intrinsics.checkParameterIsNotNull((Object)targetClass, (String)"targetClass");
        PsiElementFactory factory2 = PsiElementFactory.SERVICE.getInstance((Project)template2.getProject());
        PsiMethod methodToAdd = template2.isConstructor() ? factory2.createConstructor(template2.getName()) : factory2.createMethod(template2.getName(), template2.getReturnType());
        PsiElement psiElement2 = targetClass.add((PsiElement)methodToAdd);
        if (psiElement2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiMethod");
        }
        PsiMethod method = (PsiMethod)psiElement2;
        PsiModifierList psiModifierList = template2.getModifierList();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiModifierList, (String)"template.modifierList");
        PsiModifierList psiModifierList2 = method.getModifierList();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiModifierList2, (String)"method.modifierList");
        KotlinRefactoringUtilKt.copyModifierListItems$default(psiModifierList, psiModifierList2, false, 4, null);
        if (targetClass.isInterface()) {
            method.getModifierList().setModifierProperty("final", false);
        }
        KotlinRefactoringUtilKt.copyTypeParameters((PsiTypeParameterListOwner)template2, (PsiTypeParameterListOwner)method, createJavaMethod.1.INSTANCE);
        PsiParameterList targetParamList = method.getParameterList();
        PsiParameterList psiParameterList = template2.getParameterList();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"template.parameterList");
        PsiParameter[] psiParameterArray = psiParameterList.getParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterArray, (String)"template.parameterList.parameters");
        Object[] objectArray = $receiver$iv = (Object[])psiParameterArray;
        Collection destination$iv$iv = new ArrayList($receiver$iv.length);
        for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
            void it;
            void item$iv$iv = $receiver$iv$iv[i];
            PsiParameter psiParameter = (PsiParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            void v5 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"it");
            String string = v5.getName();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            PsiParameter param = factory2.createParameter(string, it.getType());
            PsiModifierList psiModifierList3 = it.getModifierList();
            if (psiModifierList3 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)psiModifierList3, (String)"it.modifierList!!");
            PsiParameter psiParameter2 = param;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiParameter2, (String)"param");
            PsiModifierList psiModifierList4 = psiParameter2.getModifierList();
            if (psiModifierList4 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)psiModifierList4, (String)"param.modifierList!!");
            KotlinRefactoringUtilKt.copyModifierListItems$default(psiModifierList3, psiModifierList4, false, 4, null);
            PsiParameter psiParameter3 = param;
            collection.add(psiParameter3);
        }
        List newParams = (List)destination$iv$iv;
        ChangeSignatureUtil.synchronizeList((PsiElement)((PsiElement)targetParamList), (List)newParams, (ChangeSignatureUtil.ChildrenGenerator)createJavaMethod.2.INSTANCE, (boolean[])new boolean[newParams.size()]);
        if (template2.getModifierList().hasModifierProperty("abstract") || targetClass.isInterface()) {
            PsiCodeBlock psiCodeBlock = method.getBody();
            if (psiCodeBlock == null) {
                Intrinsics.throwNpe();
            }
            psiCodeBlock.delete();
        } else if (!template2.isConstructor()) {
            CreateFromUsageUtils.setupMethodBody((PsiMethod)method);
        }
        return method;
    }

    @NotNull
    public static final PsiField createJavaField(@NotNull KtNamedDeclaration property2, @NotNull PsiClass targetClass) {
        PsiModifierList psiModifierList;
        Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
        Intrinsics.checkParameterIsNotNull((Object)targetClass, (String)"targetClass");
        LightClassUtil.PropertyAccessorsPsiMethods accessorLightMethods = LightClassUtilKt.getAccessorLightMethods(property2);
        PsiMethod psiMethod = accessorLightMethods.getGetter();
        if (psiMethod == null) {
            throw (Throwable)((Object)new AssertionError((Object)("Can't generate light method: " + PsiUtilsKt.getElementTextWithContext(property2))));
        }
        PsiMethod template2 = psiMethod;
        PsiElementFactory factory2 = PsiElementFactory.SERVICE.getInstance((Project)template2.getProject());
        String string = property2.getName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        PsiType psiType = template2.getReturnType();
        if (psiType == null) {
            Intrinsics.throwNpe();
        }
        PsiElement psiElement2 = targetClass.add((PsiElement)factory2.createField(string, psiType));
        if (psiElement2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiField");
        }
        PsiField field2 = (PsiField)psiElement2;
        PsiModifierList psiModifierList2 = field2.getModifierList();
        if (psiModifierList2 == null) {
            Intrinsics.throwNpe();
        }
        PsiModifierList $receiver = psiModifierList = psiModifierList2;
        PsiModifierList templateModifiers = template2.getModifierList();
        $receiver.setModifierProperty(VisibilityUtil.getVisibilityModifier((PsiModifierList)templateModifiers), true);
        if (Intrinsics.areEqual((Object)((Object)KotlinValVarKt.toValVar(((KtValVarKeywordOwner)((Object)property2)).getValOrVarKeyword())), (Object)((Object)KotlinValVar.Var)) ^ true || targetClass.isInterface()) {
            $receiver.setModifierProperty("final", true);
        }
        PsiModifierList psiModifierList3 = templateModifiers;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiModifierList3, (String)"templateModifiers");
        PsiModifierList psiModifierList4 = $receiver;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiModifierList4, (String)"this");
        KotlinRefactoringUtilKt.copyModifierListItems(psiModifierList3, psiModifierList4, false);
        return field2;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final PsiClass createJavaClass(@NotNull KtClass klass, @Nullable PsiClass targetClass, boolean forcePlainClass) {
        Intrinsics.checkParameterIsNotNull((Object)klass, (String)"klass");
        if (forcePlainClass) {
            v0 = ClassKind.CLASS;
        } else {
            v1 = ResolutionUtils.unsafeResolveToDescriptor$default(klass, null, 1, null);
            if (v1 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            }
            v2 = ((ClassDescriptor)v1).getKind();
            v0 = v2;
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"(klass.unsafeResolveToDe\u2026 as ClassDescriptor).kind");
        }
        kind = v0;
        factory = PsiElementFactory.SERVICE.getInstance((Project)klass.getProject());
        v3 = klass.getName();
        if (v3 == null) {
            Intrinsics.throwNpe();
        }
        className = v3;
        switch (KotlinRefactoringUtilKt$WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
            case 1: {
                v4 = factory.createClass(className);
                break;
            }
            case 2: {
                v4 = factory.createInterface(className);
                break;
            }
            case 3: {
                v4 = factory.createAnnotationType(className);
                break;
            }
            case 4: {
                v4 = factory.createEnum(className);
                break;
            }
            default: {
                throw (Throwable)new AssertionError((Object)("Unexpected class kind: " + PsiUtilsKt.getElementTextWithContext(klass)));
            }
        }
        javaClassToAdd = v4;
        v5 = targetClass;
        if (v5 == null || (v5 = v5.add((PsiElement)javaClassToAdd)) == null) {
            v6 = javaClassToAdd;
            Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"javaClassToAdd");
            v5 = (PsiElement)v6;
        }
        if (v5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiClass");
        }
        javaClass = v5;
        v7 = LightClassUtilsKt.toLightClass(klass);
        if (v7 == null) {
            throw (Throwable)new AssertionError((Object)("Can't generate light class: " + PsiUtilsKt.getElementTextWithContext(klass)));
        }
        template = v7;
        v8 = template.getModifierList();
        if (v8 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"template.modifierList!!");
        v9 = javaClass.getModifierList();
        if (v9 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)v9, (String)"javaClass.modifierList!!");
        KotlinRefactoringUtilKt.copyModifierListItems$default(v8, v9, false, 4, null);
        if (template.isInterface()) {
            v10 = javaClass.getModifierList();
            if (v10 == null) {
                Intrinsics.throwNpe();
            }
            v10.setModifierProperty("abstract", false);
        }
        KotlinRefactoringUtilKt.copyTypeParameters((PsiTypeParameterListOwner)template, (PsiTypeParameterListOwner)javaClass, createJavaClass.1.INSTANCE);
        if (!javaClass.isInterface() && template.isInterface()) {
            v11 = factory;
            Intrinsics.checkExpressionValueIsNotNull((Object)v11, (String)"factory");
            v12 = template.getExtendsList();
            if (v12 == null || (v12 = v12.getReferenceElements()) == null) {
                v12 = PsiJavaCodeReferenceElement.EMPTY_ARRAY;
                Intrinsics.checkExpressionValueIsNotNull((Object)PsiJavaCodeReferenceElement.EMPTY_ARRAY, (String)"PsiJavaCodeReferenceElement.EMPTY_ARRAY");
            }
            v13 = implementsList = JavaElementFactoryUtilsKt.createReferenceListWithRole(v11, v12, PsiReferenceList.Role.IMPLEMENTS_LIST);
            if (v13 != null) {
                it = var10_10 = v13;
                v14 = javaClass.getImplementsList();
                if (v14 != null) {
                    v14.replace((PsiElement)it);
                }
            }
        } else {
            v15 = factory;
            Intrinsics.checkExpressionValueIsNotNull((Object)v15, (String)"factory");
            v16 = template.getExtendsList();
            if (v16 == null || (v16 = v16.getReferenceElements()) == null) {
                v16 = PsiJavaCodeReferenceElement.EMPTY_ARRAY;
                Intrinsics.checkExpressionValueIsNotNull((Object)PsiJavaCodeReferenceElement.EMPTY_ARRAY, (String)"PsiJavaCodeReferenceElement.EMPTY_ARRAY");
            }
            v17 = extendsList = JavaElementFactoryUtilsKt.createReferenceListWithRole(v15, v16, PsiReferenceList.Role.EXTENDS_LIST);
            if (v17 != null) {
                it = var10_10 = v17;
                v18 = javaClass.getExtendsList();
                if (v18 != null) {
                    v18.replace((PsiElement)it);
                }
            }
            if ((v19 = template.getImplementsList()) == null || (v19 = v19.getReferenceElements()) == null) {
                v19 = PsiJavaCodeReferenceElement.EMPTY_ARRAY;
                Intrinsics.checkExpressionValueIsNotNull((Object)PsiJavaCodeReferenceElement.EMPTY_ARRAY, (String)"PsiJavaCodeReferenceElement.EMPTY_ARRAY");
            }
            v20 = implementsList = JavaElementFactoryUtilsKt.createReferenceListWithRole(factory, v19, PsiReferenceList.Role.IMPLEMENTS_LIST);
            if (v20 != null) {
                it = var11_12 = v20;
                v21 = javaClass.getImplementsList();
                if (v21 != null) {
                    v21.replace((PsiElement)it);
                }
            }
        }
        var11_12 = template.getMethods();
        for (var10_11 = 0; var10_11 < ((PsiMethod[])var11_12).length; ++var10_11) {
            block34: {
                v22 = method = var11_12[var10_11];
                Intrinsics.checkExpressionValueIsNotNull((Object)v22, (String)"method");
                v23 = v22.getParameterList();
                Intrinsics.checkExpressionValueIsNotNull((Object)v23, (String)"method.parameterList");
                v24 = hasParams = v23.getParametersCount() > 0;
                if (template.isEnum()) ** GOTO lbl-1000
                v25 = template.getSuperClass();
                if (v25 == null || (v25 = v25.getConstructors()) == null) {
                    v25 = PsiMethod.EMPTY_ARRAY;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)v25, (String)"(template.superClass?.co\u2026?: PsiMethod.EMPTY_ARRAY)");
                $receiver$iv = v25;
                for (var15_17 = 0; var15_17 < $receiver$iv.length; ++var15_17) {
                    element$iv = $receiver$iv[var15_17];
                    v26 = it = (PsiMethod)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v26, (String)"it");
                    v27 = v26.getParameterList();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v27, (String)"it.parameterList");
                    if (v27.getParametersCount() > 0) continue;
                    v28 = false;
                    break block34;
                }
                v28 = true;
            }
            if (v28) {
                v29 = true;
            } else lbl-1000:
            // 2 sources

            {
                v29 = needSuperCall = false;
            }
            if (method.isConstructor() && !hasParams && !needSuperCall || !($receiver = (var14_16 = KotlinRefactoringUtilKt.createJavaMethod(method, javaClass))).isConstructor() || !needSuperCall) continue;
            v30 = $receiver.getBody();
            if (v30 == null) {
                Intrinsics.throwNpe();
            }
            v30.add((PsiElement)factory.createStatementFromText("super();", (PsiElement)$receiver));
        }
        return javaClass;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ PsiClass createJavaClass$default(KtClass ktClass2, PsiClass psiClass2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return KotlinRefactoringUtilKt.createJavaClass(ktClass2, psiClass2, bl);
    }

    @Nullable
    public static final String j2kText(@NotNull PsiElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (Intrinsics.areEqual((Object)$receiver.getLanguage(), (Object)JavaLanguage.INSTANCE) ^ true) {
            return null;
        }
        Project project = $receiver.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        JavaToKotlinConverter j2kConverter = new JavaToKotlinConverter(project, ConverterSettings.Companion.getDefaultSettings(), IdeaJavaToKotlinServices.INSTANCE);
        Object object = (JavaToKotlinConverter.ElementResult)CollectionsKt.single(j2kConverter.elementsToKotlin(CollectionsKt.listOf((Object)$receiver)).getResults());
        if (object == null || (object = ((JavaToKotlinConverter.ElementResult)object).getText()) == null) {
            return null;
        }
        return object;
    }

    @Nullable
    public static final KtExpression j2k(@NotNull PsiExpression $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = KotlinRefactoringUtilKt.j2kText((PsiElement)$receiver);
        if (string == null) {
            return null;
        }
        String text2 = string;
        Project project = $receiver.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        return new KtPsiFactory(project, false, 2, null).createExpression(text2);
    }

    @Nullable
    public static final KtNamedDeclaration j2k(@NotNull PsiMember $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = KotlinRefactoringUtilKt.j2kText((PsiElement)$receiver);
        if (string == null) {
            return null;
        }
        String text2 = string;
        Project project = $receiver.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        return (KtNamedDeclaration)new KtPsiFactory(project, false, 2, null).createDeclaration(text2);
    }

    public static final void runRefactoringWithPostprocessing(@NotNull Function0<? extends Object> $receiver, @NotNull Project project, @NotNull String targetRefactoringId, @NotNull Function0<Unit> finishAction) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)targetRefactoringId, (String)"targetRefactoringId");
        Intrinsics.checkParameterIsNotNull(finishAction, (String)"finishAction");
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(RefactoringEventListener.REFACTORING_EVENT_TOPIC, (Object)new RefactoringEventListener(targetRefactoringId, finishAction, connection){
            final /* synthetic */ String $targetRefactoringId;
            final /* synthetic */ Function0 $finishAction;
            final /* synthetic */ MessageBusConnection $connection;

            public void undoRefactoring(@NotNull String refactoringId) {
                Intrinsics.checkParameterIsNotNull((Object)refactoringId, (String)"refactoringId");
            }

            public void refactoringStarted(@NotNull String refactoringId, @Nullable RefactoringEventData beforeData) {
                Intrinsics.checkParameterIsNotNull((Object)refactoringId, (String)"refactoringId");
            }

            public void conflictsDetected(@NotNull String refactoringId, @NotNull RefactoringEventData conflictsData) {
                Intrinsics.checkParameterIsNotNull((Object)refactoringId, (String)"refactoringId");
                Intrinsics.checkParameterIsNotNull((Object)conflictsData, (String)"conflictsData");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void refactoringDone(@NotNull String refactoringId, @Nullable RefactoringEventData afterData) {
                Intrinsics.checkParameterIsNotNull((Object)refactoringId, (String)"refactoringId");
                if (Intrinsics.areEqual((Object)refactoringId, (Object)this.$targetRefactoringId)) {
                    try {
                        this.$finishAction.invoke();
                    }
                    finally {
                        this.$connection.disconnect();
                    }
                }
            }
            {
                this.$targetRefactoringId = $captured_local_variable$0;
                this.$finishAction = $captured_local_variable$1;
                this.$connection = $captured_local_variable$2;
            }
        });
        $receiver.invoke();
    }

    public static final void validateElement(@Nullable KtElement $receiver, @NotNull String errorMessage) throws ConfigurationException {
        Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
        if ($receiver == null) {
            throw (Throwable)new ConfigurationException(errorMessage);
        }
        try {
            AnalyzingUtils.checkForSyntacticErrors((PsiElement)$receiver);
        }
        catch (Exception e) {
            throw (Throwable)new ConfigurationException(errorMessage);
        }
    }

    public static final void invokeOnceOnCommandFinish(@NotNull Function0<Unit> action2) {
        Intrinsics.checkParameterIsNotNull(action2, (String)"action");
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        CommandAdapter listener2 = new CommandAdapter(action2, commandProcessor){
            final /* synthetic */ Function0 $action;
            final /* synthetic */ CommandProcessor $commandProcessor;

            public void beforeCommandFinished(@Nullable CommandEvent event) {
                this.$action.invoke();
                this.$commandProcessor.removeCommandListener((CommandListener)this);
            }
            {
                this.$action = $captured_local_variable$0;
                this.$commandProcessor = $captured_local_variable$1;
            }
        };
        commandProcessor.addCommandListener((CommandListener)listener2);
    }

    public static final boolean hasIdentifiersOnly(@NotNull FqNameUnsafe $receiver) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            List<Name> list2 = $receiver.pathSegments();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"pathSegments()");
            Iterable $receiver$iv = list2;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    Name it = (Name)element$iv;
                    String string = it.asString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.asString()");
                    if (KotlinNameSuggester.INSTANCE.isIdentifier(UtilsKt.quoteIfNeeded(string))) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public static final boolean hasIdentifiersOnly(@NotNull FqName $receiver) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            List<Name> list2 = $receiver.pathSegments();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"pathSegments()");
            Iterable $receiver$iv = list2;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    Name it = (Name)element$iv;
                    String string = it.asString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.asString()");
                    if (KotlinNameSuggester.INSTANCE.isIdentifier(UtilsKt.quoteIfNeeded(string))) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public static final boolean isInterfaceClass(@NotNull PsiNamedElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        PsiNamedElement psiNamedElement = $receiver;
        return psiNamedElement instanceof KtClass ? ((KtClass)$receiver).isInterface() : (psiNamedElement instanceof PsiClass ? ((PsiClass)$receiver).isInterface() : (psiNamedElement instanceof KtPsiClassWrapper ? ((KtPsiClassWrapper)$receiver).getPsiClass().isInterface() : false));
    }

    public static final boolean isAbstract(@NotNull KtNamedDeclaration $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver.hasModifier(KtTokens.ABSTRACT_KEYWORD)) {
            return true;
        }
        KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject($receiver);
        if (!(ktClassOrObject != null ? KotlinRefactoringUtilKt.isInterfaceClass((PsiNamedElement)ktClassOrObject) : false)) {
            return false;
        }
        KtNamedDeclaration ktNamedDeclaration = $receiver;
        return ktNamedDeclaration instanceof KtProperty ? ((KtProperty)$receiver).getInitializer() == null && ((KtProperty)$receiver).getDelegate() == null && ((KtProperty)$receiver).getAccessors().isEmpty() : (ktNamedDeclaration instanceof KtNamedFunction ? !((KtNamedFunction)$receiver).hasBody() : false);
    }

    public static final boolean isConstructorDeclaredProperty(@NotNull KtNamedDeclaration $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver instanceof KtParameter && ((KtParameter)$receiver).getOwnerFunction() instanceof KtPrimaryConstructor && ((KtParameter)$receiver).hasValOrVar();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <ListType extends KtElement> ListType replaceListPsiAndKeepDelimiters(@NotNull ListType originalList, @NotNull ListType newList, @NotNull Function2<? super ListType, ? super ListType, ? extends ListType> listReplacer, @NotNull Function1<? super ListType, ? extends List<? extends KtElement>> itemsFun) {
        int newCount;
        Object item$iv;
        PsiElement it;
        Intrinsics.checkParameterIsNotNull(originalList, (String)"originalList");
        Intrinsics.checkParameterIsNotNull(newList, (String)"newList");
        Intrinsics.checkParameterIsNotNull(listReplacer, (String)"listReplacer");
        Intrinsics.checkParameterIsNotNull(itemsFun, (String)"itemsFun");
        PsiElement[] psiElementArray = originalList.getChildren();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElementArray, (String)"originalList.children");
        Object $receiver$iv = psiElementArray;
        Object list$iv = new ArrayList();
        for (int i = 0; i < ((Object[])$receiver$iv).length && (it = (PsiElement)(item$iv = $receiver$iv[i])) instanceof PsiErrorElement; ++i) {
            ((ArrayList)list$iv).add(item$iv);
        }
        $receiver$iv = (List)list$iv;
        list$iv = $receiver$iv.iterator();
        while (list$iv.hasNext()) {
            Object element$iv = list$iv.next();
            PsiElement it2 = (PsiElement)element$iv;
            it2.delete();
        }
        List oldParameters = CollectionsKt.toMutableList((Collection)((Collection)itemsFun.invoke(originalList)));
        List newParameters = (List)itemsFun.invoke(newList);
        int $i$f$forEach = 0;
        int oldCount = oldParameters.size();
        int commonCount = Math.min(oldCount, newCount = newParameters.size());
        int n = commonCount - 1;
        if ($i$f$forEach <= n) {
            while (true) {
                void i;
                PsiElement psiElement2 = ((KtElement)oldParameters.get((int)i)).replace((PsiElement)newParameters.get((int)i));
                if (psiElement2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
                }
                oldParameters.set((int)i, (KtElement)psiElement2);
                if (i == n) break;
                ++i;
            }
        }
        if (commonCount == 0) {
            return (ListType)((KtElement)listReplacer.invoke(originalList, newList));
        }
        if (oldCount > commonCount) {
            originalList.deleteChildRange(((KtElement)oldParameters.get(commonCount - 1)).getNextSibling(), (PsiElement)CollectionsKt.last((List)oldParameters));
        } else if (newCount > commonCount) {
            originalList.addRangeAfter(((KtElement)newParameters.get(commonCount - 1)).getNextSibling(), (PsiElement)CollectionsKt.last((List)newParameters), (PsiElement)CollectionsKt.last((List)oldParameters));
        }
        return originalList;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ KtElement replaceListPsiAndKeepDelimiters$default(KtElement ktElement, KtElement ktElement2, Function2 function2, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function2 = replaceListPsiAndKeepDelimiters.1.INSTANCE;
        }
        return KotlinRefactoringUtilKt.replaceListPsiAndKeepDelimiters(ktElement, ktElement2, function2, function1);
    }

    @NotNull
    public static final <T> Pass<T> Pass(@NotNull Function1<? super T, Unit> body2) {
        Intrinsics.checkParameterIsNotNull(body2, (String)"body");
        return new Pass<T>(body2){
            final /* synthetic */ Function1 $body;

            public void pass(T t) {
                this.$body.invoke(t);
            }
            {
                this.$body = $captured_local_variable$0;
            }
        };
    }

    @NotNull
    public static final KtExpression removeTemplateEntryBracesIfPossible(@NotNull KtExpression $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        PsiElement parent2 = $receiver.getParent();
        if (!(parent2 instanceof KtBlockStringTemplateEntry)) {
            return $receiver;
        }
        RemoveCurlyBracesFromTemplateIntention intention = new RemoveCurlyBracesFromTemplateIntention();
        KtStringTemplateEntryWithExpression newEntry = intention.isApplicableTo((KtBlockStringTemplateEntry)parent2) ? (KtStringTemplateEntryWithExpression)intention.applyTo((KtBlockStringTemplateEntry)parent2) : (KtStringTemplateEntryWithExpression)parent2;
        KtExpression ktExpression = newEntry.getExpression();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        return ktExpression;
    }

    public static final void dropOverrideKeywordIfNecessary(@NotNull KtNamedDeclaration element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptorIfAny$default(element3, null, 1, null);
        if (!(declarationDescriptor instanceof CallableDescriptor)) {
            declarationDescriptor = null;
        }
        CallableDescriptor callableDescriptor = (CallableDescriptor)declarationDescriptor;
        if (callableDescriptor == null) {
            return;
        }
        CallableDescriptor callableDescriptor2 = callableDescriptor;
        if (callableDescriptor2.getOverriddenDescriptors().isEmpty()) {
            element3.removeModifier(KtTokens.OVERRIDE_KEYWORD);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final KtTypeArgumentList getQualifiedTypeArgumentList(@NotNull KtExpression initializer2, @NotNull BindingContext context) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)initializer2, (String)"initializer");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(initializer2, context);
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> call2 = resolvedCall2;
        Map<TypeParameterDescriptor, KotlinType> typeArgumentMap = call2.getTypeArguments();
        List<TypeParameterDescriptor> list2 = call2.getCandidateDescriptor().getTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"call.candidateDescriptor.typeParameters");
        Iterable iterable = $receiver$iv = (Iterable)list2;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            KotlinType kotlinType;
            Object element$iv$iv = element$iv$iv$iv;
            TypeParameterDescriptor it = (TypeParameterDescriptor)element$iv$iv;
            if (typeArgumentMap.get(it) == null) continue;
            KotlinType it$iv$iv = kotlinType;
            destination$iv$iv.add(it$iv$iv);
        }
        List typeArguments2 = (List)destination$iv$iv;
        String renderedList2 = CollectionsKt.joinToString$default((Iterable)typeArguments2, null, (CharSequence)"<", (CharSequence)">", (int)0, null, (Function1)getQualifiedTypeArgumentList.renderedList.1.INSTANCE, (int)25, null);
        return KtPsiFactoryKt.KtPsiFactory$default((PsiElement)initializer2, false, 2, null).createTypeArguments(renderedList2);
    }

    @Nullable
    public static /* bridge */ /* synthetic */ KtTypeArgumentList getQualifiedTypeArgumentList$default(KtExpression ktExpression, BindingContext bindingContext2, int n, Object object) {
        if ((n & 2) != 0) {
            bindingContext2 = ResolutionUtils.analyze(ktExpression, BodyResolveMode.PARTIAL);
        }
        return KotlinRefactoringUtilKt.getQualifiedTypeArgumentList(ktExpression, bindingContext2);
    }

    public static final void addTypeArgumentsIfNeeded(@NotNull KtExpression expression2, @NotNull KtTypeArgumentList typeArgumentList) {
        boolean bl;
        KtCallExpression callElement2;
        block9: {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)typeArgumentList, (String)"typeArgumentList");
            BindingContext context = ResolutionUtils.analyze(expression2, BodyResolveMode.PARTIAL_WITH_DIAGNOSTICS);
            Call call2 = CallUtilKt.getCallWithAssert(expression2, context);
            KtElement ktElement = call2.getCallElement();
            if (!(ktElement instanceof KtCallExpression)) {
                ktElement = null;
            }
            KtCallExpression ktCallExpression = (KtCallExpression)ktElement;
            if (ktCallExpression == null) {
                return;
            }
            callElement2 = ktCallExpression;
            if (call2.getTypeArgumentList() != null) {
                return;
            }
            KtExpression ktExpression = call2.getCalleeExpression();
            if (ktExpression == null) {
                return;
            }
            KtExpression callee = ktExpression;
            Diagnostics diagnostics = context.getDiagnostics();
            KtExpression ktExpression2 = callee;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"callee");
            Iterable $receiver$iv = diagnostics.forElement((PsiElement)ktExpression2);
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    Diagnostic it = (Diagnostic)element$iv;
                    if (Intrinsics.areEqual(it.getFactory(), Errors.TYPE_INFERENCE_NO_INFORMATION_FOR_PARAMETER) ^ true) continue;
                    bl = false;
                    break block9;
                }
                bl = true;
            }
        }
        if (bl) {
            return;
        }
        callElement2.addAfter((PsiElement)typeArgumentList, (PsiElement)callElement2.getCalleeExpression());
        KtTypeArgumentList ktTypeArgumentList = callElement2.getTypeArgumentList();
        if (ktTypeArgumentList == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeArgumentList, (String)"callElement.typeArgumentList!!");
        ShortenReferences.process$default(ShortenReferences.DEFAULT, ktTypeArgumentList, null, 2, null);
    }

    @NotNull
    public static final String getThisLabelName(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Name name2 = $receiver.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"name");
        if (!name2.isSpecial()) {
            String string = $receiver.getName().asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name.asString()");
            return string;
        }
        if ($receiver instanceof AnonymousFunctionDescriptor) {
            KtSimpleNameExpression callee;
            KtCallElement callElement2;
            KtCallElement ktCallElement;
            KtValueArgument argument2;
            KtFunction function2;
            SourceElement sourceElement = ((AnonymousFunctionDescriptor)$receiver).getSource();
            Intrinsics.checkExpressionValueIsNotNull((Object)sourceElement, (String)"source");
            PsiElement psiElement2 = KotlinSourceElementKt.getPsi(sourceElement);
            if (!(psiElement2 instanceof KtFunction)) {
                psiElement2 = null;
            }
            KtFunction ktFunction = function2 = (KtFunction)psiElement2;
            Object object = ktFunction != null ? ktFunction.getParent() : null;
            if (!(object instanceof KtValueArgument)) {
                object = null;
            }
            KtValueArgument ktValueArgument = argument2 = (KtValueArgument)object;
            if (ktValueArgument != null) {
                PsiElement $receiver$iv = (PsiElement)ktValueArgument;
                ktCallElement = (KtCallElement)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtCallElement.class, (boolean)true);
            } else {
                ktCallElement = null;
            }
            KtCallElement ktCallElement2 = callElement2 = ktCallElement;
            KtExpression ktExpression = ktCallElement2 != null ? ktCallElement2.getCalleeExpression() : null;
            if (!(ktExpression instanceof KtSimpleNameExpression)) {
                ktExpression = null;
            }
            if ((callee = (KtSimpleNameExpression)ktExpression) != null) {
                String string = callee.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"callee.text");
                return string;
            }
        }
        return "";
    }

    @NotNull
    public static final String explicateAsTextForReceiver(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String labelName = KotlinRefactoringUtilKt.getThisLabelName($receiver);
        CharSequence charSequence = labelName;
        return charSequence.length() == 0 ? "this" : "this@" + labelName;
    }

    @NotNull
    public static final String explicateAsText(@NotNull ImplicitReceiver $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return KotlinRefactoringUtilKt.explicateAsTextForReceiver($receiver.getDeclarationDescriptor());
    }

    public static final boolean isInjectedFragment(@NotNull PsiFile $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return InjectedLanguageManager.getInstance((Project)$receiver.getProject()).isInjectedFragment($receiver);
    }

    public static final boolean isInsideInjectedFragment(@NotNull PsiElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        PsiFile psiFile = $receiver.getContainingFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"containingFile");
        return KotlinRefactoringUtilKt.isInjectedFragment(psiFile);
    }

    @NotNull
    public static final List<PsiElement> checkSuperMethods(@NotNull KtDeclaration declaration2, @Nullable Collection<? extends PsiElement> ignore, @NotNull String actionString) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)actionString, (String)"actionString");
        checkSuperMethods.1 getClassDescriptions$ = checkSuperMethods.1.INSTANCE;
        Function2<CallableDescriptor, Map<PsiElement, ? extends CallableDescriptor>, List<? extends PsiElement>> askUserForMethodsToSearch$ = new Function2<CallableDescriptor, Map<PsiElement, ? extends CallableDescriptor>, List<? extends PsiElement>>(actionString, declaration2){
            final /* synthetic */ String $actionString;
            final /* synthetic */ KtDeclaration $declaration;

            @NotNull
            public final List<PsiElement> invoke(@NotNull CallableDescriptor declarationDescriptor, @NotNull Map<PsiElement, ? extends CallableDescriptor> overriddenElementsToDescriptor) {
                List list2;
                Intrinsics.checkParameterIsNotNull((Object)declarationDescriptor, (String)"declarationDescriptor");
                Intrinsics.checkParameterIsNotNull(overriddenElementsToDescriptor, (String)"overriddenElementsToDescriptor");
                List<String> superClassDescriptions = checkSuperMethods.1.INSTANCE.invoke(overriddenElementsToDescriptor);
                String message2 = KotlinBundle.message("x.overrides.y.in.class.list", DescriptorRenderer.COMPACT_WITH_SHORT_TYPES.render(declarationDescriptor), '\n' + CollectionsKt.joinToString$default((Iterable)superClassDescriptions, (CharSequence)"", null, null, (int)0, null, null, (int)62, null), this.$actionString);
                String string = KotlinRefactoringUtilKt.getCHECK_SUPER_METHODS_YES_NO_DIALOG();
                Project project = this.$declaration.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"declaration.project");
                String string2 = message2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"message");
                String string3 = IdeBundle.message((String)"title.warning", (Object[])new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"IdeBundle.message(\"title.warning\")");
                Icon icon = Messages.getQuestionIcon();
                Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"Messages.getQuestionIcon()");
                int exitCode = MessagesKt.showYesNoCancelDialog(string, project, string2, string3, icon, 0);
                switch (exitCode) {
                    case 0: {
                        list2 = CollectionsKt.toList((Iterable)overriddenElementsToDescriptor.keySet());
                        break;
                    }
                    case 1: {
                        list2 = CollectionsKt.listOf((Object)this.$declaration);
                        break;
                    }
                    default: {
                        list2 = CollectionsKt.emptyList();
                    }
                }
                return list2;
            }
            {
                this.$actionString = string;
                this.$declaration = ktDeclaration;
                super(2);
            }
        };
        DeclarationDescriptor declarationDescriptor = ResolutionUtils.unsafeResolveToDescriptor$default(declaration2, null, 1, null);
        if (declarationDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.CallableDescriptor");
        }
        CallableDescriptor declarationDescriptor2 = (CallableDescriptor)declarationDescriptor;
        if (declarationDescriptor2 instanceof LocalVariableDescriptor) {
            return CollectionsKt.listOf((Object)declaration2);
        }
        Project project = declaration2.getProject();
        HashMap overriddenElementsToDescriptor = new HashMap();
        for (CallableDescriptor overriddenDescriptor2 : DescriptorUtils.getAllOverriddenDescriptors(declarationDescriptor2)) {
            PsiElement overriddenDeclaration;
            Project project2 = project;
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
            CallableDescriptor callableDescriptor = overriddenDescriptor2;
            Intrinsics.checkExpressionValueIsNotNull((Object)callableDescriptor, (String)"overriddenDescriptor");
            if (DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(project2, callableDescriptor) == null) {
                continue;
            }
            if (!(overriddenDeclaration instanceof KtNamedFunction) && !(overriddenDeclaration instanceof KtProperty) && !(overriddenDeclaration instanceof PsiMethod) && !(overriddenDeclaration instanceof KtParameter)) continue;
            Map map2 = overriddenElementsToDescriptor;
            CallableDescriptor callableDescriptor2 = overriddenDescriptor2;
            map2.put(overriddenDeclaration, callableDescriptor2);
        }
        if (ignore != null) {
            overriddenElementsToDescriptor.keySet().removeAll(ignore);
        }
        if (overriddenElementsToDescriptor.isEmpty()) {
            return CollectionsKt.listOf((Object)declaration2);
        }
        return askUserForMethodsToSearch$.invoke(declarationDescriptor2, (Map<PsiElement, ? extends CallableDescriptor>)overriddenElementsToDescriptor);
    }

    /*
     * WARNING - void declaration
     */
    public static final void checkSuperMethodsWithPopup(@NotNull KtNamedDeclaration declaration2, @NotNull List<? extends PsiMethod> deepestSuperMethods, @NotNull String actionString, @NotNull Editor editor, @NotNull Function1<? super List<? extends PsiElement>, Unit> action2) {
        StringBuilder $i$a$1$any;
        boolean hasKtMembers;
        boolean hasJavaMethods;
        String kind2;
        PsiClass superClass;
        PsiMethod superMethod;
        block15: {
            boolean bl;
            boolean bl2;
            List unwrappedSupers;
            block14: {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                String string;
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                Intrinsics.checkParameterIsNotNull(deepestSuperMethods, (String)"deepestSuperMethods");
                Intrinsics.checkParameterIsNotNull((Object)actionString, (String)"actionString");
                Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
                Intrinsics.checkParameterIsNotNull(action2, (String)"action");
                if (deepestSuperMethods.isEmpty()) {
                    action2.invoke((Object)CollectionsKt.listOf((Object)declaration2));
                    return;
                }
                superMethod = (PsiMethod)CollectionsKt.first(deepestSuperMethods);
                PsiClass psiClass2 = superMethod.getContainingClass();
                if (psiClass2 == null) {
                    action2.invoke((Object)CollectionsKt.listOf((Object)declaration2));
                    return;
                }
                superClass = psiClass2;
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                if (application.isUnitTestMode()) {
                    action2.invoke(deepestSuperMethods);
                    return;
                }
                KtNamedDeclaration ktNamedDeclaration = declaration2;
                if (ktNamedDeclaration instanceof KtNamedFunction) {
                    string = "function";
                } else if (ktNamedDeclaration instanceof KtProperty || ktNamedDeclaration instanceof KtParameter) {
                    string = "property";
                } else {
                    return;
                }
                kind2 = string;
                Iterable iterable = $receiver$iv = (Iterable)deepestSuperMethods;
                Collection destination$iv$iv = new ArrayList();
                void $receiver$iv$iv$iv = $receiver$iv$iv;
                for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                    PsiNamedElement psiNamedElement;
                    Object element$iv$iv = element$iv$iv$iv;
                    PsiMethod it = (PsiMethod)element$iv$iv;
                    if (LightClassUtilsKt.getNamedUnwrappedElement((PsiElement)it) == null) continue;
                    PsiNamedElement it$iv$iv = psiNamedElement;
                    destination$iv$iv.add(it$iv$iv);
                }
                unwrappedSupers = (List)destination$iv$iv;
                Iterable $receiver$iv2 = unwrappedSupers;
                if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $receiver$iv2) {
                        PsiNamedElement it = (PsiNamedElement)element$iv;
                        if (!(it instanceof PsiMethod)) continue;
                        bl2 = true;
                        break block14;
                    }
                    bl2 = false;
                }
            }
            hasJavaMethods = bl2;
            Iterable $receiver$iv = unwrappedSupers;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    PsiNamedElement it = (PsiNamedElement)element$iv;
                    if (!(it instanceof KtNamedDeclaration)) continue;
                    bl = true;
                    break block15;
                }
                bl = hasKtMembers = false;
            }
        }
        String superKind = hasJavaMethods && hasKtMembers ? "member" : (hasJavaMethods ? "method" : kind2);
        String renameBase = actionString + " base " + superKind + (deepestSuperMethods.size() > 1 ? "s" : "");
        String renameCurrent = actionString + " only current " + kind2;
        StringBuilder $receiver = $i$a$1$any = new StringBuilder();
        $receiver.append(declaration2.getName());
        $receiver.append(superMethod.hasModifierProperty("abstract") ? " implements " : " overrides ");
        $receiver.append(ElementDescriptionUtil.getElementDescription((PsiElement)((PsiElement)superMethod), (ElementDescriptionLocation)((ElementDescriptionLocation)UsageViewTypeLocation.INSTANCE)));
        $receiver.append(" of ");
        $receiver.append(SymbolPresentationUtil.getSymbolPresentableText((PsiElement)((PsiElement)superClass)));
        String string = $i$a$1$any.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        String title = string;
        JBList list2 = new JBList((Object[])new String[]{renameBase, renameCurrent});
        JBPopupFactory.getInstance().createListPopupBuilder((JList)list2).setTitle(title).setMovable(false).setResizable(false).setRequestFocus(true).setItemChoosenCallback(new Runnable(list2, renameBase, deepestSuperMethods, declaration2, action2){
            final /* synthetic */ JBList $list;
            final /* synthetic */ String $renameBase;
            final /* synthetic */ List $deepestSuperMethods;
            final /* synthetic */ KtNamedDeclaration $declaration;
            final /* synthetic */ Function1 $action;

            public final void run() {
                String string = (String)this.$list.getSelectedValue();
                if (string == null) {
                    return;
                }
                String value2 = string;
                List chosenElements = Intrinsics.areEqual((Object)value2, (Object)this.$renameBase) ? CollectionsKt.plus((Collection)this.$deepestSuperMethods, (Object)this.$declaration) : CollectionsKt.listOf((Object)this.$declaration);
                this.$action.invoke((Object)chosenElements);
            }
            {
                this.$list = jBList;
                this.$renameBase = string;
                this.$deepestSuperMethods = list2;
                this.$declaration = ktNamedDeclaration;
                this.$action = function1;
            }
        }).createPopup().showInBestPositionFor(editor);
    }

    public static final boolean isCompanionMemberOf(@NotNull KtNamedDeclaration $receiver, @NotNull KtClassOrObject klass2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)klass2, (String)"klass");
        KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject($receiver);
        if (!(ktClassOrObject instanceof KtObjectDeclaration)) {
            ktClassOrObject = null;
        }
        KtObjectDeclaration ktObjectDeclaration = (KtObjectDeclaration)ktClassOrObject;
        if (ktObjectDeclaration == null) {
            return false;
        }
        KtObjectDeclaration containingObject = ktObjectDeclaration;
        return containingObject.isCompanion() && Intrinsics.areEqual((Object)KtPsiUtilKt.getContainingClassOrObject(containingObject), (Object)klass2);
    }

    @NotNull
    public static final List<KtDeclaration> withExpectedActuals(@NotNull KtDeclaration $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        KtDeclaration ktDeclaration = HasExpectedMarkerKt.liftToExpected($receiver);
        if (ktDeclaration == null) {
            return CollectionsKt.listOf((Object)$receiver);
        }
        KtDeclaration expect = ktDeclaration;
        Set<KtDeclaration> actuals = HasActualMarkerKt.actualsForExpected(expect);
        return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)expect), (Iterable)actuals);
    }

    @NotNull
    public static final DeclarationDescriptor resolveToExpectedDescriptorIfPossible(@NotNull KtDeclaration $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DeclarationDescriptor descriptor2 = ResolutionUtils.unsafeResolveToDescriptor$default($receiver, null, 1, null);
        DeclarationDescriptor declarationDescriptor = HasExpectedMarkerKt.liftToExpected(descriptor2);
        if (declarationDescriptor == null) {
            declarationDescriptor = descriptor2;
        }
        return declarationDescriptor;
    }

    static {
        CHECK_SUPER_METHODS_YES_NO_DIALOG = CHECK_SUPER_METHODS_YES_NO_DIALOG;
    }
}

