/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.inline;

import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.inline.InlineOptionsDialog;
import javax.swing.JRadioButton;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.codeInliner.UsageReplacementStrategy;
import org.jetbrains.kotlin.idea.refactoring.inline.KotlinInlineCallableProcessor;
import org.jetbrains.kotlin.idea.references.KtSimpleNameReference;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtProperty;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0015\u001a\u00020\u000bH\u0014J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u000bH\u0002J\b\u0010\u0019\u001a\u00020\u000eH\u0014J\b\u0010\u001a\u001a\u00020\u000eH\u0014J\b\u0010\u001b\u001a\u00020\u000eH\u0014J\n\u0010\u001c\u001a\u0004\u0018\u00010\u000eH\u0014J\b\u0010\u001d\u001a\u00020\u000eH\u0014J\b\u0010\u001e\u001a\u00020\u000bH\u0014J\u0006\u0010\u001f\u001a\u00020\u000bR\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/inline/KotlinInlineValDialog;", "Lcom/intellij/refactoring/inline/InlineOptionsDialog;", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "reference", "Lorg/jetbrains/kotlin/idea/references/KtSimpleNameReference;", "replacementStrategy", "Lorg/jetbrains/kotlin/idea/codeInliner/UsageReplacementStrategy;", "assignmentToDelete", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "withPreview", "", "(Lorg/jetbrains/kotlin/psi/KtProperty;Lorg/jetbrains/kotlin/idea/references/KtSimpleNameReference;Lorg/jetbrains/kotlin/idea/codeInliner/UsageReplacementStrategy;Lorg/jetbrains/kotlin/psi/KtBinaryExpression;Z)V", "kind", "", "occurrenceCount", "", "occurrencesString", "getOccurrencesString", "()Ljava/lang/String;", "refactoringName", "allowInlineAll", "doAction", "", "forSimpleLocal", "getBorderTitle", "getInlineAllText", "getInlineThisText", "getKeepTheDeclarationText", "getNameLabelText", "isInlineThis", "shouldBeShown", "idea"})
public final class KotlinInlineValDialog
extends InlineOptionsDialog {
    private int occurrenceCount;
    private final String kind;
    private final String refactoringName;
    private final KtProperty property;
    private final KtSimpleNameReference reference;
    private final UsageReplacementStrategy replacementStrategy;
    private final KtBinaryExpression assignmentToDelete;

    private final boolean forSimpleLocal() {
        return this.property.isLocal() && (this.reference == null || this.occurrenceCount == 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean shouldBeShown() {
        if (!this.forSimpleLocal()) return true;
        EditorSettingsExternalizable editorSettingsExternalizable = EditorSettingsExternalizable.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorSettingsExternalizable, (String)"EditorSettingsExternalizable.getInstance()");
        if (!editorSettingsExternalizable.isShowInlineLocalDialog()) return false;
        return true;
    }

    protected boolean allowInlineAll() {
        return true;
    }

    @NotNull
    protected String getBorderTitle() {
        return this.refactoringName;
    }

    @NotNull
    protected String getNameLabelText() {
        return "" + StringsKt.capitalize((String)this.kind) + ' ' + this.property.getName();
    }

    private final String getOccurrencesString() {
        return this.occurrenceCount >= 0 ? " (" + this.occurrenceCount + " occurrence" + (this.occurrenceCount == 1 ? ")" : "s)") : "";
    }

    @NotNull
    protected String getInlineAllText() {
        return "Inline all references and remove the " + this.kind + this.getOccurrencesString();
    }

    @Nullable
    protected String getKeepTheDeclarationText() {
        return this.property.isWritable() ? "Inline all references and keep the " + this.kind + this.getOccurrencesString() : super.getKeepTheDeclarationText();
    }

    protected boolean isInlineThis() {
        return JavaRefactoringSettings.getInstance().INLINE_LOCAL_THIS;
    }

    @NotNull
    protected String getInlineThisText() {
        return "Inline this occurrence and leave the " + this.kind;
    }

    public void doAction() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        this.invokeRefactoring(new KotlinInlineCallableProcessor(project, this.replacementStrategy, this.property, this.reference, this.isInlineThisOnly(), !this.isInlineThisOnly() && !this.isKeepTheDeclaration(), this.assignmentToDelete));
        JavaRefactoringSettings settings2 = JavaRefactoringSettings.getInstance();
        JRadioButton jRadioButton = this.myRbInlineThisOnly;
        Intrinsics.checkExpressionValueIsNotNull((Object)jRadioButton, (String)"myRbInlineThisOnly");
        if (jRadioButton.isEnabled()) {
            JRadioButton jRadioButton2 = this.myRbInlineAll;
            Intrinsics.checkExpressionValueIsNotNull((Object)jRadioButton2, (String)"myRbInlineAll");
            if (jRadioButton2.isEnabled()) {
                settings2.INLINE_LOCAL_THIS = this.isInlineThisOnly();
            }
        }
    }

    public KotlinInlineValDialog(@NotNull KtProperty property2, @Nullable KtSimpleNameReference reference2, @NotNull UsageReplacementStrategy replacementStrategy, @Nullable KtBinaryExpression assignmentToDelete, boolean withPreview) {
        Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
        Intrinsics.checkParameterIsNotNull((Object)replacementStrategy, (String)"replacementStrategy");
        super(property2.getProject(), true, (PsiElement)property2);
        this.property = property2;
        this.reference = reference2;
        this.replacementStrategy = replacementStrategy;
        this.assignmentToDelete = assignmentToDelete;
        this.occurrenceCount = KotlinInlineValDialog.access$initOccurrencesNumber$s759928653(this.property);
        this.kind = this.property.isLocal() ? "local variable" : "property";
        this.refactoringName = "Inline " + StringUtil.capitalizeWords((String)this.kind, (boolean)true);
        this.myInvokedOnReference = this.reference != null;
        this.setTitle(this.refactoringName);
        this.setPreviewResults(withPreview && this.shouldBeShown());
        if (this.forSimpleLocal()) {
            this.setDoNotAskOption(new DialogWrapper.DoNotAskOption(){

                public boolean isToBeShown() {
                    EditorSettingsExternalizable editorSettingsExternalizable = EditorSettingsExternalizable.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)editorSettingsExternalizable, (String)"EditorSettingsExternalizable.getInstance()");
                    return editorSettingsExternalizable.isShowInlineLocalDialog();
                }

                public void setToBeShown(boolean value2, int exitCode) {
                    EditorSettingsExternalizable editorSettingsExternalizable = EditorSettingsExternalizable.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)editorSettingsExternalizable, (String)"EditorSettingsExternalizable.getInstance()");
                    editorSettingsExternalizable.setShowInlineLocalDialog(value2);
                }

                public boolean canBeHidden() {
                    return true;
                }

                public boolean shouldSaveOptionsOnCancel() {
                    return false;
                }

                @NotNull
                public String getDoNotShowMessage() {
                    return "Do not show for local variables in future";
                }
            });
        }
        this.init();
    }

    public /* synthetic */ KotlinInlineValDialog(KtProperty ktProperty, KtSimpleNameReference ktSimpleNameReference, UsageReplacementStrategy usageReplacementStrategy, KtBinaryExpression ktBinaryExpression, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        this(ktProperty, ktSimpleNameReference, usageReplacementStrategy, ktBinaryExpression, bl);
    }

    public static final /* synthetic */ int access$initOccurrencesNumber$s759928653(PsiNameIdentifierOwner p0) {
        return InlineOptionsDialog.initOccurrencesNumber((PsiNameIdentifierOwner)p0);
    }
}

