/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.structure.impl;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.java.structure.JavaClassifier;
import org.jetbrains.kotlin.load.java.structure.JavaClassifierType;
import org.jetbrains.kotlin.load.java.structure.JavaType;
import org.jetbrains.kotlin.load.java.structure.impl.ClassNamesUtilKt;
import org.jetbrains.kotlin.load.java.structure.impl.JavaClassImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaClassifierImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaElementImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaTypeImpl;

public class JavaClassifierTypeImpl
extends JavaTypeImpl<PsiClassType>
implements JavaClassifierType {
    private ResolutionResult resolutionResult;

    public JavaClassifierTypeImpl(@NotNull PsiClassType psiClassType) {
        super(psiClassType);
    }

    @Override
    @Nullable
    public JavaClassifierImpl<?> getClassifier() {
        this.resolve();
        return this.resolutionResult.classifier;
    }

    @NotNull
    public PsiSubstitutor getSubstitutor() {
        this.resolve();
        return this.resolutionResult.substitutor;
    }

    private void resolve() {
        if (this.resolutionResult == null) {
            PsiClassType.ClassResolveResult result2 = ((PsiClassType)this.getPsi()).resolveGenerics();
            PsiClass psiClass2 = result2.getElement();
            PsiSubstitutor substitutor3 = result2.getSubstitutor();
            this.resolutionResult = new ResolutionResult(psiClass2 == null ? null : JavaClassifierImpl.create(psiClass2), substitutor3, PsiClassType.isRaw((PsiClassType.ClassResolveResult)result2));
        }
    }

    @Override
    @NotNull
    public String getClassifierQualifiedName() {
        return ClassNamesUtilKt.convertCanonicalNameToQName(((PsiClassType)this.getPsi()).getCanonicalText());
    }

    @Override
    @NotNull
    public String getPresentableText() {
        return ((PsiClassType)this.getPsi()).getPresentableText();
    }

    @Override
    public boolean isRaw() {
        this.resolve();
        return this.resolutionResult.isRaw;
    }

    @Override
    @NotNull
    public List<JavaType> getTypeArguments() {
        JavaClassifier classifier = this.getClassifier();
        if (!(classifier instanceof JavaClassImpl)) {
            return Collections.emptyList();
        }
        List<PsiTypeParameter> parameters2 = JavaClassifierTypeImpl.getTypeParameters((PsiClass)((JavaElementImpl)((Object)classifier)).getPsi());
        PsiSubstitutor substitutor3 = this.getSubstitutor();
        ArrayList<JavaType> result2 = new ArrayList<JavaType>(parameters2.size());
        for (PsiTypeParameter typeParameter : parameters2) {
            PsiType substitutedType = substitutor3.substitute(typeParameter);
            result2.add(substitutedType == null ? null : JavaTypeImpl.create(substitutedType));
        }
        return result2;
    }

    @NotNull
    private static List<PsiTypeParameter> getTypeParameters(@NotNull PsiClass owner) {
        ArrayList result2 = null;
        for (PsiClass currentOwner = owner; currentOwner != null; currentOwner = currentOwner.getContainingClass()) {
            PsiTypeParameter[] typeParameters = currentOwner.getTypeParameters();
            if (typeParameters.length > 0) {
                if (result2 == null) {
                    result2 = new ArrayList(typeParameters.length);
                }
                Collections.addAll(result2, typeParameters);
            }
            if (currentOwner.hasModifierProperty("static")) break;
        }
        if (result2 == null) {
            return Collections.emptyList();
        }
        return result2;
    }

    private static class ResolutionResult {
        private final JavaClassifierImpl<?> classifier;
        private final PsiSubstitutor substitutor;
        private final boolean isRaw;

        private ResolutionResult(@Nullable JavaClassifierImpl<?> classifier, @NotNull PsiSubstitutor substitutor3, boolean isRaw) {
            this.classifier = classifier;
            this.substitutor = substitutor3;
            this.isRaw = isRaw;
        }
    }
}

