/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.stubs.KotlinAnnotationEntryStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementType;
import org.jetbrains.kotlin.psi.stubs.elements.StubIndexService;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinAnnotationEntryStubImpl;

public class KtAnnotationEntryElementType
extends KtStubElementType<KotlinAnnotationEntryStub, KtAnnotationEntry> {
    public KtAnnotationEntryElementType(@NotNull @NonNls String debugName) {
        super(debugName, KtAnnotationEntry.class, KotlinAnnotationEntryStub.class);
    }

    public KotlinAnnotationEntryStub createStub(@NotNull KtAnnotationEntry psi2, StubElement parentStub) {
        Name shortName = KtPsiUtil.getShortName(psi2);
        String resultName = shortName != null ? shortName.asString() : psi2.getText();
        KtValueArgumentList valueArgumentList = psi2.getValueArgumentList();
        boolean hasValueArguments = valueArgumentList != null && !valueArgumentList.getArguments().isEmpty();
        return new KotlinAnnotationEntryStubImpl((StubElement<? extends PsiElement>)parentStub, StringRef.fromString((String)resultName), hasValueArguments);
    }

    public void serialize(@NotNull KotlinAnnotationEntryStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        dataStream.writeName(stub.getShortName());
        dataStream.writeBoolean(stub.hasValueArguments());
    }

    @NotNull
    public KotlinAnnotationEntryStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        StringRef text2 = dataStream.readName();
        boolean hasValueArguments = dataStream.readBoolean();
        return new KotlinAnnotationEntryStubImpl((StubElement<? extends PsiElement>)parentStub, text2, hasValueArguments);
    }

    @Override
    public void indexStub(@NotNull KotlinAnnotationEntryStub stub, @NotNull IndexSink sink) {
        StubIndexService.getInstance().indexAnnotation(stub, sink);
    }
}

