/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.script;

import com.intellij.openapi.fileTypes.LanguageFileType;
import java.lang.annotation.Annotation;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.script.experimental.dependencies.DependenciesResolver;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.NameUtils;
import org.jetbrains.kotlin.parsing.KotlinParserDefinition;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtScript;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u001b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000bH\u0016R\"\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00030\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\tR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0019\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/script/KotlinScriptDefinition;", "", "template", "Lkotlin/reflect/KClass;", "(Lkotlin/reflect/KClass;)V", "acceptedAnnotations", "", "", "getAcceptedAnnotations", "()Ljava/util/List;", "annotationsForSamWithReceivers", "", "getAnnotationsForSamWithReceivers", "dependencyResolver", "Lkotlin/script/experimental/dependencies/DependenciesResolver;", "getDependencyResolver", "()Lkotlin/script/experimental/dependencies/DependenciesResolver;", "fileType", "Lcom/intellij/openapi/fileTypes/LanguageFileType;", "getFileType", "()Lcom/intellij/openapi/fileTypes/LanguageFileType;", "name", "getName", "()Ljava/lang/String;", "getTemplate", "()Lkotlin/reflect/KClass;", "getScriptName", "Lorg/jetbrains/kotlin/name/Name;", "script", "Lorg/jetbrains/kotlin/psi/KtScript;", "isScript", "", "fileName", "frontend"})
public class KotlinScriptDefinition {
    @NotNull
    private final String name = "Kotlin Script";
    @NotNull
    private final LanguageFileType fileType;
    @NotNull
    private final KClass<? extends Object> template;

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public LanguageFileType getFileType() {
        return this.fileType;
    }

    @NotNull
    public List<String> getAnnotationsForSamWithReceivers() {
        return CollectionsKt.emptyList();
    }

    public boolean isScript(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        return StringsKt.endsWith$default((String)fileName, (String)KotlinParserDefinition.STD_SCRIPT_EXT, (boolean)false, (int)2, null);
    }

    @NotNull
    public Name getScriptName(@NotNull KtScript script) {
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        KtFile ktFile = script.getContainingKtFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktFile, (String)"script.containingKtFile");
        String string = ktFile.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"script.containingKtFile.name");
        return NameUtils.getScriptNameForFile(string);
    }

    @NotNull
    public DependenciesResolver getDependencyResolver() {
        return (DependenciesResolver)DependenciesResolver.NoDependencies.INSTANCE;
    }

    @NotNull
    public List<KClass<? extends Annotation>> getAcceptedAnnotations() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public final KClass<? extends Object> getTemplate() {
        return this.template;
    }

    public KotlinScriptDefinition(@NotNull KClass<? extends Object> template2) {
        Intrinsics.checkParameterIsNotNull(template2, (String)"template");
        this.template = template2;
        this.name = "Kotlin Script";
        KotlinFileType kotlinFileType = KotlinFileType.INSTANCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)kotlinFileType), (String)"KotlinFileType.INSTANCE");
        this.fileType = kotlinFileType;
    }
}

