/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.resolve;

import com.intellij.debugger.streams.resolve.PairMapResolver;
import com.intellij.debugger.streams.resolve.ValuesOrderResolver;
import com.intellij.debugger.streams.trace.TraceElement;
import com.intellij.debugger.streams.trace.TraceInfo;
import com.intellij.debugger.streams.wrapper.TraceUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010!\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J=\u0010\u0007\u001a\u00020\b\"\u0004\b\u0000\u0010\t\"\u0004\b\u0001\u0010\n*\u0014\u0012\u0004\u0012\u0002H\t\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\n0\f0\u000b2\u0006\u0010\r\u001a\u0002H\t2\u0006\u0010\u000e\u001a\u0002H\n\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/debugger/streams/resolve/PairMapResolver;", "Lcom/intellij/debugger/streams/resolve/ValuesOrderResolver;", "()V", "resolve", "Lcom/intellij/debugger/streams/resolve/ValuesOrderResolver$Result;", "info", "Lcom/intellij/debugger/streams/trace/TraceInfo;", "add", "", "K", "V", "", "", "key", "value", "(Ljava/util/Map;Ljava/lang/Object;Ljava/lang/Object;)V", "stream-debugger"})
public final class PairMapResolver
implements ValuesOrderResolver {
    @Override
    @NotNull
    public ValuesOrderResolver.Result resolve(@NotNull TraceInfo info) {
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        Map direct = new LinkedHashMap();
        Map reverse = new LinkedHashMap();
        List<TraceElement> valuesBefore = TraceUtil.sortedByTime(info.getValuesOrderBefore().values());
        List<TraceElement> valuesAfter = TraceUtil.sortedByTime(info.getValuesOrderAfter().values());
        Iterator<TraceElement> beforeIterator = valuesBefore.iterator();
        Iterator<TraceElement> afterIterator = valuesAfter.iterator();
        TraceElement after = null;
        while (beforeIterator.hasNext()) {
            TraceElement before = beforeIterator.next();
            if (after != null) {
                TraceElement traceElement = before;
                Intrinsics.checkExpressionValueIsNotNull((Object)traceElement, (String)"before");
                this.add(direct, traceElement, after);
                this.add(reverse, after, before);
            }
            if (!afterIterator.hasNext()) continue;
            after = afterIterator.next();
            TraceElement traceElement = before;
            Intrinsics.checkExpressionValueIsNotNull((Object)traceElement, (String)"before");
            TraceElement traceElement2 = after;
            Intrinsics.checkExpressionValueIsNotNull((Object)traceElement2, (String)"after");
            this.add(direct, traceElement, traceElement2);
            this.add(reverse, after, before);
        }
        ValuesOrderResolver.Result result = ValuesOrderResolver.Result.of(direct, reverse);
        Intrinsics.checkExpressionValueIsNotNull((Object)result, (String)"of(direct, reverse)");
        return result;
    }

    public final <K, V> void add(@NotNull Map<K, List<V>> $receiver, K key, V value) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Collection collection = $receiver.computeIfAbsent(key, add.1.INSTANCE);
        collection.add(value);
    }
}

